/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wtp.releng.tools.component.api;

import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.eclipse.wtp.releng.tools.component.CommandOptionParser;
import org.eclipse.wtp.releng.tools.component.IClazz;
import org.eclipse.wtp.releng.tools.component.IClazzVisitor;
import org.eclipse.wtp.releng.tools.component.ILocation;
import org.eclipse.wtp.releng.tools.component.IPluginXML;
import org.eclipse.wtp.releng.tools.component.api.ClassUse;
import org.eclipse.wtp.releng.tools.component.api.ComponentUse;
import org.eclipse.wtp.releng.tools.component.api.FieldUse;
import org.eclipse.wtp.releng.tools.component.api.MethodUse;
import org.eclipse.wtp.releng.tools.component.api.Source;
import org.eclipse.wtp.releng.tools.component.internal.AbstractEmitter;
import org.eclipse.wtp.releng.tools.component.internal.ComponentXML;
import org.eclipse.wtp.releng.tools.component.internal.FieldRef;
import org.eclipse.wtp.releng.tools.component.internal.FileLocation;
import org.eclipse.wtp.releng.tools.component.internal.MethodRef;
import org.eclipse.wtp.releng.tools.component.internal.Plugin;

public class ComponentUseEmitter
extends AbstractEmitter
implements IClazzVisitor {
    public static final String OPTION_ECLIPSE_DIR = "eclipseDir";
    public static final String OPTION_COMPONENT_XML_DIR = "compXMLDir";
    public static final String OPTION_COMPONENT_USE_DIR = "compUseDir";
    public static final String OPTION_INCLUDE = "include";
    public static final String OPTION_EXCLUDE = "exclude";
    public static final String OPTION_CLASS_REF_ONLY = "classRefOnly";
    public static final String OPTION_DEBUG = "debug";
    private String compUseDir;
    private Map pluginId2Plugin;
    private Map fragmentId2Fragment;
    private Map compLoc2CompXML;
    private List classUseIncludes;
    private List classUseIncludesMatch;
    private List classUseExcludes;
    private List classUseExcludesMatch;
    private boolean classRefOnly;
    private boolean debug;
    private ComponentUse compUse;

    public ComponentUseEmitter(String compUseDir) {
        this.compUseDir = this.addTrailingSeperator(compUseDir);
        this.classRefOnly = false;
        this.debug = false;
    }

    public void init(List eclipseDirs, List compXMLDirs) {
        this.compLoc2CompXML = new HashMap();
        this.pluginId2Plugin = new HashMap();
        this.fragmentId2Fragment = new HashMap();
        Iterator it = eclipseDirs.iterator();
        while (it.hasNext()) {
            File eclipseFile = new File(this.addTrailingSeperator((String)it.next()));
            if (!eclipseFile.exists()) continue;
            this.harvestPlugins(eclipseFile, this.pluginId2Plugin, this.fragmentId2Fragment);
        }
        this.linkPluginsAndFragments(this.pluginId2Plugin, this.fragmentId2Fragment);
        it = compXMLDirs.iterator();
        while (it.hasNext()) {
            File compXMLFile = new File(this.addTrailingSeperator((String)it.next()));
            if (!compXMLFile.exists()) continue;
            this.harvestComponents(compXMLFile, this.compLoc2CompXML);
        }
    }

    public void init(Map compLoc2CompXML, Map pluginId2Plugin, Map fragmentId2Fragment) {
        this.compLoc2CompXML = compLoc2CompXML;
        this.pluginId2Plugin = pluginId2Plugin;
        this.fragmentId2Fragment = fragmentId2Fragment;
    }

    public boolean isClassRefOnly() {
        return this.classRefOnly;
    }

    public void setClassRefOnly(boolean classRefOnly) {
        this.classRefOnly = classRefOnly;
    }

    public boolean isDebug() {
        return this.debug;
    }

    public void setDebug(boolean debug) {
        this.debug = debug;
    }

    public List getClassUseIncludes() {
        return this.classUseIncludes;
    }

    public void setClassUseIncludes(List includes) {
        this.classUseIncludes = includes;
    }

    public List getClassUseIncludesMatch() {
        return this.classUseIncludesMatch;
    }

    public void setClassUseIncludesMatch(List includesMatch) {
        this.classUseIncludesMatch = includesMatch;
    }

    public List getClassUseExcludes() {
        return this.classUseExcludes;
    }

    public void setClassUseExcludes(List excludes) {
        this.classUseExcludes = excludes;
    }

    public List getClassUseExcludesMatch() {
        return this.classUseExcludesMatch;
    }

    public void setClassUseExcludesMatch(List excludesMatch) {
        this.classUseExcludesMatch = excludesMatch;
    }

    public void genComponentUseXML() throws IOException {
        Iterator it = this.compLoc2CompXML.keySet().iterator();
        while (it.hasNext()) {
            this.genComponentUseXML((String)it.next());
        }
    }

    public ComponentUse genComponentUseXML(String compLoc) throws IOException {
        ComponentXML compXML = (ComponentXML)this.compLoc2CompXML.get(compLoc);
        if (compXML != null) {
            compXML.load();
            String compName = compXML.getName();
            this.compUse = this.newComponentUse(compXML);
            Iterator pluginsIt = compXML.getPlugins().iterator();
            while (pluginsIt.hasNext()) {
                IPluginXML pluginXML = (IPluginXML)this.pluginId2Plugin.get(((Plugin)pluginsIt.next()).getId());
                if (pluginXML == null) continue;
                pluginXML.accept(this);
            }
            compXML = null;
            if (this.compUseDir != null) {
                System.out.println("Writing component-use.xml for " + compName);
            }
            this.compUse.save();
            return this.compUse;
        }
        return null;
    }

    public ComponentUse genAll() throws IOException {
        this.compUse = new ComponentUse();
        Iterator it = this.pluginId2Plugin.values().iterator();
        while (it.hasNext()) {
            ((IPluginXML)it.next()).accept(this);
        }
        return this.compUse;
    }

    public Source genUse(IClazz clazz) {
        return this.newSource(clazz);
    }

    public boolean visit(IClazz clazz) {
        if (this.compUse == null) {
            return false;
        }
        Source source = this.newSource(clazz);
        this.addSource(this.compUse, source);
        return true;
    }

    private Source newSource(IClazz clazz) {
        String className = clazz.getName();
        Source source = this.newSource(clazz.getName());
        if (!this.classRefOnly) {
            String superClass;
            ClassUse classUse;
            List methodRefs = clazz.getMethodRefs(this.combineFilters(this.classUseIncludes, this.classUseIncludesMatch), this.combineFilters(this.classUseExcludes, this.classUseExcludesMatch), this.debug);
            Iterator it = methodRefs.iterator();
            while (it.hasNext()) {
                MethodRef methodRef = (MethodRef)it.next();
                String refClassName = methodRef.getClassName();
                String methodName = methodRef.getMethodName();
                classUse = this.isConstructor(methodName) ? this.addUniqueClassUse(source, refClassName, null, null, null, Boolean.TRUE, methodRef.getLines()) : this.addUniqueClassUse(source, refClassName, Boolean.TRUE, null, null, null, null);
                MethodUse methodUse = this.newMethodUse(methodName, methodRef.getMethodDescriptor(), methodRef.getLines());
                classUse.getMethodUses().add(methodUse);
            }
            clazz.resetMethodRefs();
            methodRefs = null;
            List fieldRefs = clazz.getFieldRefs(this.combineFilters(this.classUseIncludes, this.classUseIncludesMatch), this.combineFilters(this.classUseExcludes, this.classUseExcludesMatch), this.debug);
            Iterator it2 = fieldRefs.iterator();
            while (it2.hasNext()) {
                FieldRef fieldRef = (FieldRef)it2.next();
                String refClassName = fieldRef.getClassName();
                classUse = this.addUniqueClassUse(source, refClassName, Boolean.TRUE, null, null, null, null);
                FieldUse fieldUse = this.newFieldUse(fieldRef.getFieldName(), fieldRef.getFieldDescriptor(), fieldRef.getLines());
                classUse.getFieldAPIs().add(fieldUse);
            }
            clazz.resetFieldRefs();
            fieldRefs = null;
            if (!clazz.isInterface() && (superClass = clazz.getSuperClass()) != null && this.isReportClassUse(className, superClass)) {
                this.addUniqueClassUse(source, superClass, null, Boolean.TRUE, null, null, null);
            }
            String[] interfaces = clazz.getInterfaces();
            int i = 0;
            while (i < interfaces.length) {
                if (this.isReportClassUse(className, interfaces[i])) {
                    this.addUniqueClassUse(source, interfaces[i], null, null, Boolean.TRUE, null, null);
                }
                ++i;
            }
        }
        Set refClasses = clazz.getReferencedTypes();
        Iterator refClassesIt = refClasses.iterator();
        while (refClassesIt.hasNext()) {
            String refClassName = (String)refClassesIt.next();
            if (!this.isReportClassUse(className, refClassName)) continue;
            this.addUniqueClassUse(source, refClassName, Boolean.TRUE, null, null, null, null);
        }
        return source;
    }

    private List combineFilters(List filtersStart, List filtersMatch) {
        ArrayList<String> filters = new ArrayList<String>();
        if (filtersStart != null) {
            filters.addAll(filtersStart);
        }
        if (filtersMatch != null) {
            Iterator it = filtersMatch.iterator();
            while (it.hasNext()) {
                filters.add("*" + (String)it.next() + "*");
            }
        }
        if (filters.size() > 0) {
            return filters;
        }
        return null;
    }

    private boolean isReportClassUse(String sourceClassName, String classUseName) {
        Iterator it;
        if (sourceClassName != null && sourceClassName.equals(classUseName)) {
            return false;
        }
        if (this.classUseExcludes != null) {
            it = this.classUseExcludes.iterator();
            while (it.hasNext()) {
                if (!classUseName.startsWith((String)it.next())) continue;
                return false;
            }
        }
        if (this.classUseExcludesMatch != null) {
            it = this.classUseExcludesMatch.iterator();
            while (it.hasNext()) {
                if (classUseName.indexOf((String)it.next()) == -1) continue;
                return false;
            }
        }
        if (this.classUseIncludes != null && this.classUseIncludes.size() > 0 || this.classUseIncludesMatch != null && this.classUseIncludesMatch.size() > 0) {
            if (this.classUseIncludes != null) {
                it = this.classUseIncludes.iterator();
                while (it.hasNext()) {
                    if (!classUseName.startsWith((String)it.next())) continue;
                    return true;
                }
            }
            if (this.classUseIncludesMatch != null) {
                it = this.classUseIncludesMatch.iterator();
                while (it.hasNext()) {
                    if (classUseName.indexOf((String)it.next()) == -1) continue;
                    return true;
                }
            }
            return false;
        }
        return true;
    }

    private boolean isConstructor(String methodName) {
        return methodName.equals("<init>");
    }

    private void addSource(ComponentUse compUse, Source source) {
        if (source.getClassUses().size() > 0) {
            compUse.getSources().add(source);
        }
    }

    private ClassUse addUniqueClassUse(Source source, String className, Boolean ref, Boolean subclass, Boolean implement, Boolean instantiate, List lines) {
        Iterator it = source.getClassUses().iterator();
        while (it.hasNext()) {
            ClassUse classUse = (ClassUse)it.next();
            if (!classUse.getName().equals(className) || ref != null && (classUse.getReference() == null || ref.booleanValue() != classUse.isReference()) || subclass != null && (classUse.getSubclass() == null || subclass.booleanValue() != classUse.isSubclass()) || implement != null && (classUse.getImplement() == null || implement.booleanValue() != classUse.isImplement()) || instantiate != null && (classUse.getInstantiate() == null || instantiate.booleanValue() != classUse.isInstantiate())) continue;
            if (lines != null) {
                classUse.getLines().addAll(lines);
            }
            return classUse;
        }
        ClassUse classUse = this.newClassUse(className, ref, subclass, implement, instantiate, lines);
        source.addClassUse(classUse);
        return classUse;
    }

    private ClassUse newClassUse(String className, Boolean ref, Boolean subclass, Boolean implement, Boolean instantiate, List lines) {
        ClassUse classUse = new ClassUse();
        classUse.setName(className);
        classUse.setReference(ref);
        classUse.setSubclass(subclass);
        classUse.setImplement(implement);
        classUse.setInstantiate(instantiate);
        if (lines != null) {
            classUse.getLines().addAll(lines);
        }
        return classUse;
    }

    private MethodUse newMethodUse(String methodName, String descriptor, List lines) {
        MethodUse methodUse = new MethodUse();
        methodUse.setName(methodName);
        methodUse.setDescriptor(descriptor);
        if (lines != null) {
            methodUse.getLines().addAll(lines);
        }
        return methodUse;
    }

    private FieldUse newFieldUse(String fieldName, String descriptor, List lines) {
        FieldUse fieldUse = new FieldUse();
        fieldUse.setName(fieldName);
        fieldUse.setDescriptor(descriptor);
        if (lines != null) {
            fieldUse.getLines().addAll(lines);
        }
        return fieldUse;
    }

    private ComponentUse newComponentUse(ComponentXML compXML) {
        String compName = compXML.getName();
        FileLocation location = null;
        if (this.compUseDir != null) {
            StringBuffer sb = new StringBuffer(this.compUseDir);
            sb.append(compName);
            sb.append('/');
            sb.append("component-use.xml");
            location = new FileLocation(new File(sb.toString()));
        }
        return this.newComponentUse(compName, location);
    }

    private ComponentUse newComponentUse(String name, ILocation location) {
        ComponentUse compUse = new ComponentUse();
        compUse.setName(name);
        compUse.setLocation(location);
        return compUse;
    }

    private Source newSource(String className) {
        Source source = new Source();
        source.setName(className);
        return source;
    }

    public static void main(String[] args) {
        CommandOptionParser optionParser = new CommandOptionParser(args);
        Map options = optionParser.getOptions();
        List eclipseDir = (List)options.get(OPTION_ECLIPSE_DIR);
        List compXMLDir = (List)options.get(OPTION_COMPONENT_XML_DIR);
        List compUseDir = (List)options.get(OPTION_COMPONENT_USE_DIR);
        List includes = (List)options.get(OPTION_INCLUDE);
        List excludes = (List)options.get(OPTION_EXCLUDE);
        List classRefOnly = (List)options.get(OPTION_CLASS_REF_ONLY);
        List debug = (List)options.get(OPTION_DEBUG);
        if (eclipseDir == null || compXMLDir == null || compUseDir == null || eclipseDir.size() < 1 || compXMLDir.size() < 1 || compUseDir.size() < 1) {
            ComponentUseEmitter.printUsage();
            System.exit(-1);
        }
        ArrayList<String> includesStart = null;
        ArrayList<String> includesMatch = null;
        if (includes != null) {
            Iterator it = includes.iterator();
            while (it.hasNext()) {
                String s = (String)it.next();
                if (s.charAt(0) == '*' && s.charAt(s.length() - 1) == '*') {
                    if (includesMatch == null) {
                        includesMatch = new ArrayList<String>(1);
                    }
                    includesMatch.add(s.substring(1, s.length() - 1));
                    continue;
                }
                if (includesStart == null) {
                    includesStart = new ArrayList<String>(1);
                }
                includesStart.add(s);
            }
        }
        ArrayList<String> excludesStart = null;
        ArrayList<String> excludesMatch = null;
        if (excludes != null) {
            Iterator it = excludes.iterator();
            while (it.hasNext()) {
                String s = (String)it.next();
                if (s.charAt(0) == '*' && s.charAt(s.length() - 1) == '*') {
                    if (excludesMatch == null) {
                        excludesMatch = new ArrayList<String>(1);
                    }
                    excludesMatch.add(s.substring(1, s.length() - 1));
                    continue;
                }
                if (excludesStart == null) {
                    excludesStart = new ArrayList<String>(1);
                }
                excludesStart.add(s);
            }
        }
        ComponentUseEmitter compUseEmitter = new ComponentUseEmitter((String)compUseDir.get(0));
        compUseEmitter.setClassUseIncludes(includesStart);
        compUseEmitter.setClassUseIncludesMatch(includesMatch);
        compUseEmitter.setClassUseExcludes(excludesStart);
        compUseEmitter.setClassUseExcludesMatch(excludesMatch);
        compUseEmitter.setClassRefOnly(classRefOnly != null);
        compUseEmitter.setDebug(debug != null);
        compUseEmitter.init(eclipseDir, compXMLDir);
        try {
            compUseEmitter.genComponentUseXML();
        }
        catch (IOException ioe) {
            ioe.printStackTrace();
        }
    }

    private static void printUsage() {
        System.out.println("Usage: java org.eclipse.wtp.releng.tools.component.use.ComponentUseEmitter -eclipseDir <eclipseDir> -compXMLDir <compDir> [-options]");
        System.out.println("");
        System.out.println("\t-eclipseDir\t<eclipseDir>\tspace seperated list of directories containing Eclipse plugins");
        System.out.println("\t-compXMLDir\t<compXMLDir>\tdirectory containing component.xml");
        System.out.println("\t-compUseDir\t<compUseDir>\toutput directory of component-use.xml");
        System.out.println("");
        System.out.println("where options include:");
        System.out.println("");
        System.out.println("\t-include\t<include>\tspace seperated packages to include");
        System.out.println("\t-exclude\t<exclude>\tspace seperated packages to exclude");
        System.out.println("\t-classRefOnly\t\t\ttreat all violations as class reference");
        System.out.println("\t-debug\t\t\t\tgenerate debug information (ex. line numbers)");
    }
}

