/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.callisto.tools.versionchecker;

import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStream;
import java.io.Writer;
import java.net.URL;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import java.util.SortedMap;
import java.util.TreeMap;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.FactoryConfigurationError;
import javax.xml.parsers.ParserConfigurationException;
import org.eclipse.callisto.tools.versionchecker.ClassPathResolver;
import org.eclipse.core.runtime.IPlatformRunnable;
import org.eclipse.core.runtime.Platform;
import org.eclipse.osgi.service.datalocation.Location;
import org.eclipse.osgi.service.resolver.BundleDescription;
import org.eclipse.update.configurator.ConfiguratorUtils;
import org.eclipse.update.configurator.IPlatformConfiguration;
import org.osgi.framework.Bundle;
import org.osgi.framework.Version;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;

public class VersionLister
implements IPlatformRunnable {
    private static final String REFERENCE_VERSIONING_DATA_XML = "referenceVersioningData.xml";
    private static final String VERSION_CHECKER_BUNDLE_NAME = "org.eclipse.callisto.tools.versionchecker";
    private static final String EOL = System.getProperty("line.separator");
    private static final String[] alwaysExclude = new String[]{"org.eclipse.releng.tools", "org.tigris.mm.ui", "org.eclipse.core.resources.spysupport", "com.yourkit.profiler", "org.eclipse.core.tools.resources", "org.eclipse.core.tools", "org.eclipse.callisto.tools.versionchecker"};
    private static final String[] alwaysExcludeFeatures = new String[]{"org.eclipse.releng.tools", "org.eclipse.test"};
    private static final String[] interestingPatterns = new String[]{"org.eclipse.wst.", "org.eclipse.jst."};
    private static final int HELP = 0;
    private static final String HELP_ARG = "-help";
    private static final int LIST_TO_CONSOLE = 1;
    private static final String LIST_TO_CONSOLE_ARG = "-listToReferenceFile";
    private static final int TEST_TO_REFERENCE = 2;
    private static final String TEST_TO_REFERENCE_ARG = "-testToReference";
    private static final int MAJOR = 0;
    private static final int MINOR = 1;
    private static final int SERVICE = 2;
    private static final int QUALIFIER = 3;
    private static final String BUNDLE_DATA = "bundleData";
    private static final String FEATURE_DATA = "featureData";
    private static final int ERROR_BASE_CODE = 90000;
    private static final int ERROR_BUNDLE_DECREASE = 1;
    private static final int ERROR_FEATURE_DECREASE = 16;
    private static final int ERROR_EXCEPTION_OCCURRED = 256;
    private static final Object OK_EXIT = IPlatformRunnable.EXIT_OK;

    public static void main(String[] args) {
        VersionLister versionLister = new VersionLister();
        versionLister.clean("M-testing-123");
    }

    public Object run(Object o) throws Exception {
        int exitResult = 90000;
        String[] args = null;
        if (!(o instanceof String[])) {
            this.doPrintHelp();
            return OK_EXIT;
        }
        args = (String[])o;
        this.printArgs(args);
        if (args == null) {
            exitResult |= this.doPrintHelp();
        } else if (args != null && args.length == 0) {
            exitResult |= this.doPrintHelp();
        } else {
            boolean someCommandExecuted = false;
            int i = 0;
            while (i < args.length) {
                String arg = args[i].trim();
                System.out.println("command: " + arg);
                switch (this.getCommand(arg)) {
                    case 1: {
                        String possibleId;
                        String xmlId = null;
                        int idPos = i + 1;
                        xmlId = idPos < args.length ? (!(possibleId = args[idPos]).startsWith("-") ? possibleId : this.getDefaultID()) : this.getDefaultID();
                        exitResult |= this.doListCurrentToConsole(xmlId);
                        someCommandExecuted = true;
                        break;
                    }
                    case 2: {
                        String buildLabel;
                        String possibleFilename;
                        String possibleId;
                        String referenceId = "WTPSDK";
                        String referenceFilename = REFERENCE_VERSIONING_DATA_XML;
                        int idPos = i + 1;
                        if (idPos < args.length && !(possibleId = args[idPos]).startsWith("-")) {
                            referenceId = possibleId;
                        }
                        if (++idPos < args.length && !(possibleFilename = args[idPos]).startsWith("-")) {
                            referenceFilename = possibleFilename;
                        }
                        if ((buildLabel = System.getProperty("buildLabel")) == null || buildLabel.length() == 0) {
                            buildLabel = "NoBuildLabel";
                        }
                        someCommandExecuted = true;
                        exitResult |= this.doTestToReference(referenceId, referenceFilename, buildLabel);
                        if (someCommandExecuted) break;
                        exitResult |= this.doPrintHelp();
                        break;
                    }
                    case 0: {
                        exitResult |= this.doPrintHelp();
                        someCommandExecuted = true;
                        break;
                    }
                }
                ++i;
            }
            if (!someCommandExecuted) {
                exitResult |= this.doPrintHelp();
            }
        }
        Integer result = IPlatformRunnable.EXIT_OK;
        if (exitResult > 90000) {
            result = new Integer(exitResult);
        }
        return result;
    }

    void printArgs(String[] args) {
        System.out.println("\t Program Arguments: ");
        int i = 0;
        while (i < args.length) {
            System.out.println("\t\t" + args[i]);
            ++i;
        }
    }

    void printProperties() {
        Properties properties = System.getProperties();
        properties.list(System.out);
    }

    private int doTestToReference(String id, String referenceFileName, String currentId) {
        int exit_code = 90000;
        try {
            Map refMap = this.getReferenceBundleMap(id, referenceFileName);
            if (refMap != null) {
                String outputFileName = "versioningReport";
                File outfile = this.createOutputFile(outputFileName);
                FileWriter reportWriter = new FileWriter(outfile);
                reportWriter.write("<?xml version=\"1.0\" encoding=\"UTF-8\"?>" + EOL);
                reportWriter.write("<versioningReport>" + EOL);
                reportWriter.write("<versioningReportData id=\"" + id + "\"" + " current=\"" + this.clean(currentId) + "\"" + ">" + EOL);
                Map currMap = this.makeBundleMap();
                String checkingType = "bundle";
                int bundle_return = this._compareReferenceAndCurrent(currMap, refMap, checkingType, 1, reportWriter);
                exit_code |= bundle_return;
                refMap = this.getReferenceFeatureMap(id, referenceFileName);
                currMap = this.makeFeatureMap();
                checkingType = "feature";
                int feature_return = this._compareReferenceAndCurrent(currMap, refMap, checkingType, 16, reportWriter);
                exit_code |= feature_return;
                reportWriter.write("</versioningReportData>" + EOL);
                reportWriter.write("</versioningReport>" + EOL);
                System.out.println("Note: versioning report written to " + outfile.getAbsolutePath());
                ((Writer)reportWriter).close();
            } else {
                System.out.println("No reference ID found named " + id);
            }
        }
        catch (ParserConfigurationException e) {
            e.printStackTrace();
            exit_code &= 0x100;
        }
        catch (FileNotFoundException e) {
            e.printStackTrace();
            exit_code &= 0x100;
        }
        catch (SAXException e) {
            e.printStackTrace();
            exit_code &= 0x100;
        }
        catch (IOException e) {
            e.printStackTrace();
            exit_code &= 0x100;
        }
        return exit_code;
    }

    private File createOutputFile(String outputFileName) throws IOException {
        File outputDirectory = null;
        String outputDirName = System.getProperty("buildDirectory");
        String dirLabel = System.getProperty("buildLabel");
        if (outputDirName != null && outputDirName.length() > 0 && dirLabel != null && dirLabel.length() > 0) {
            outputDirectory = new File(String.valueOf(outputDirName) + "/" + dirLabel);
        }
        String localOutputFilename = null;
        String outputFileNameSuffix = System.getProperty("buildLabel");
        localOutputFilename = outputFileNameSuffix != null ? String.valueOf(outputFileName) + "_" + this.clean(outputFileNameSuffix) + ".xml" : String.valueOf(outputFileName) + ".xml";
        File outfile = new File(outputDirectory, localOutputFilename);
        return outfile;
    }

    private int _compareReferenceAndCurrent(Map currMap, Map refMap, String checkingType, int errorExitCode, Writer reportWriter) throws IOException {
        Version curVersion;
        List extrasInReferences;
        Version refVersion;
        String key;
        String reportExtraInCurrentResult = "extraInCurrent";
        String reportExtraInReferenceResult = "extraInReference";
        int result = 0;
        List extrasInCurrent = this.compareKeys(currMap, refMap);
        if (extrasInCurrent.size() > 0) {
            Object[] extras = extrasInCurrent.toArray();
            int i = 0;
            while (i < extras.length) {
                key = (String)extras[i];
                refVersion = (Version)refMap.get(key);
                this._printExtra(key, refVersion, checkingType, reportExtraInCurrentResult, reportWriter);
                ++i;
            }
        }
        if ((extrasInReferences = this.compareKeys(refMap, currMap)).size() > 0) {
            Object[] extras = extrasInReferences.toArray();
            int i = 0;
            while (i < extras.length) {
                String key2 = (String)extras[i];
                curVersion = (Version)currMap.get(key2);
                this._printExtra(key2, curVersion, checkingType, reportExtraInReferenceResult, reportWriter);
                ++i;
            }
        }
        Iterator currentIterator = currMap.keySet().iterator();
        while (currentIterator.hasNext()) {
            int comp;
            key = (String)currentIterator.next();
            refVersion = (Version)refMap.get(key);
            curVersion = (Version)currMap.get(key);
            if (refVersion == null || curVersion == null || (comp = refVersion.compareTo((Object)curVersion)) <= 0) continue;
            this._printError(key, refVersion, curVersion, checkingType, reportWriter);
            if (!this.isInteresting(key)) continue;
            result = errorExitCode;
        }
        Iterator currentIterator2 = currMap.keySet().iterator();
        while (currentIterator2.hasNext()) {
            this.checkDifference(refMap, currMap, currentIterator2, 0, checkingType, reportWriter);
        }
        Iterator currentIterator2a = currMap.keySet().iterator();
        while (currentIterator2a.hasNext()) {
            this.checkDifference(refMap, currMap, currentIterator2a, 1, checkingType, reportWriter);
        }
        Iterator currentIterator2b = currMap.keySet().iterator();
        while (currentIterator2b.hasNext()) {
            this.checkDifference(refMap, currMap, currentIterator2b, 2, checkingType, reportWriter);
        }
        Iterator currentIterator2c = currMap.keySet().iterator();
        while (currentIterator2c.hasNext()) {
            this.checkDifference(refMap, currMap, currentIterator2c, 3, checkingType, reportWriter);
        }
        Iterator currentIterator3 = currMap.keySet().iterator();
        while (currentIterator3.hasNext()) {
            int comp;
            String key3 = (String)currentIterator3.next();
            Version refVersion2 = (Version)refMap.get(key3);
            Version curVersion2 = (Version)currMap.get(key3);
            if (refVersion2 == null || curVersion2 == null || (comp = refVersion2.compareTo((Object)curVersion2)) != 0) continue;
            this._printNoChange(key3, refVersion2, curVersion2, checkingType, reportWriter);
        }
        return result;
    }

    private boolean isInteresting(String key) {
        boolean result = false;
        int i = 0;
        while (i < interestingPatterns.length) {
            if (key.startsWith(interestingPatterns[i])) {
                result = true;
                break;
            }
            ++i;
        }
        return result;
    }

    private void checkDifference(Map refMap, Map currMap, Iterator iterator, int fieldToCheck, String checkingType, Writer reportWriter) throws IOException {
        int comp;
        String key = (String)iterator.next();
        Version refVersion = (Version)refMap.get(key);
        Version curVersion = (Version)currMap.get(key);
        if (refVersion != null && curVersion != null && (comp = refVersion.compareTo((Object)curVersion)) < 0) {
            if (fieldToCheck == 0) {
                if (refVersion.getMajor() < curVersion.getMajor()) {
                    this._printIncrease(key, refVersion, curVersion, "major", checkingType, reportWriter);
                    iterator.remove();
                }
            } else if (fieldToCheck == 1) {
                if (refVersion.getMinor() < curVersion.getMinor()) {
                    this._printIncrease(key, refVersion, curVersion, "minor", checkingType, reportWriter);
                    iterator.remove();
                }
            } else if (fieldToCheck == 2) {
                if (refVersion.getMicro() < curVersion.getMicro()) {
                    this._printIncrease(key, refVersion, curVersion, "service", checkingType, reportWriter);
                    iterator.remove();
                }
            } else if (fieldToCheck == 3 && refVersion.compareTo((Object)curVersion) < 0) {
                this._printIncrease(key, refVersion, curVersion, "qualifier", checkingType, reportWriter);
                iterator.remove();
            }
        }
    }

    private void _printIncrease(String key, Version refVersion, Version curVersion, String field, String codePackageType, Writer reportWriter) throws IOException {
        String name = key.trim();
        String reportResult = "increase";
        reportWriter.write("<versioningCompare kind=\"" + reportResult + "\"" + " field=\"" + field + "\"" + " codePackageType=\"" + codePackageType + "\"" + ">" + EOL);
        reportWriter.write("\t<entry>" + EOL + "\t\t" + name + EOL + "\t" + "</entry>" + EOL);
        reportWriter.write("\t<reference>" + EOL + "\t\t" + refVersion + EOL + "\t" + "</reference>" + EOL);
        reportWriter.write("\t<current>" + EOL + "\t\t" + curVersion + EOL + "\t" + "</current>" + EOL);
        reportWriter.write("</versioningCompare>" + EOL);
    }

    private void _printNoChange(String key, Version refVersion, Version curVersion, String codePackageType, Writer reportWriter) throws IOException {
        String name = key.trim();
        String reportResult = "noChange";
        reportWriter.write("<versioningCompare kind=\"" + reportResult + "\"" + " codePackageType=\"" + codePackageType + "\"" + ">" + EOL);
        reportWriter.write("\t<entry>" + EOL + "\t\t" + name + EOL + "\t" + "</entry>" + EOL);
        reportWriter.write("\t<reference>" + EOL + "\t\t" + refVersion + EOL + "\t" + "</reference>" + EOL);
        reportWriter.write("\t<current>" + EOL + "\t\t" + curVersion + EOL + "\t" + "</current>" + EOL);
        reportWriter.write("</versioningCompare>" + EOL);
    }

    private void _printError(String key, Version refVersion, Version curVersion, String codePackageType, Writer reportWriter) throws IOException {
        String name = key.trim();
        String reportResult = "error";
        reportWriter.write("<versioningCompare kind=\"" + reportResult + "\" codePackageType=\"" + codePackageType + "\"" + ">" + EOL);
        reportWriter.write("\t<entry>" + EOL + "\t\t" + name + EOL + "\t" + "</entry>" + EOL);
        reportWriter.write("\t<reference>" + EOL + "\t\t" + refVersion + EOL + "\t" + "</reference>" + EOL);
        reportWriter.write("\t<current>" + EOL + "\t\t" + curVersion + EOL + "\t" + "</current>" + EOL);
        reportWriter.write("</versioningCompare>" + EOL);
    }

    private void _printExtra(String key, Version version, String codePackageType, String reportResult, Writer reportWriter) throws IOException {
        String name = key.trim();
        reportWriter.write("<versioningCompare kind=\"" + reportResult + "\" codePackageType=\"" + codePackageType + "\"" + ">" + EOL);
        reportWriter.write("\t<entry>" + EOL + "\t\t" + name + EOL + "\t" + "</entry>" + EOL);
        reportWriter.write("\t<reference>" + EOL + "\t\t" + version + EOL + "\t" + "</reference>" + EOL);
        reportWriter.write("</versioningCompare>" + EOL);
    }

    private List compareKeys(Map baseMap, Map compareMap) {
        ArrayList<String> extras = new ArrayList<String>();
        Iterator iterator = compareMap.keySet().iterator();
        while (iterator.hasNext()) {
            String key = (String)iterator.next();
            if (baseMap.containsKey(key)) continue;
            extras.add(key);
        }
        return extras;
    }

    private Map getReferenceBundleMap(String id, String referenceFileName) throws FactoryConfigurationError, ParserConfigurationException, FileNotFoundException, SAXException, IOException {
        TreeMap refSortedMap = null;
        Document dom = this.getReferenceDataDOM(referenceFileName);
        Element refereneDataElement = dom.getElementById(id);
        if (refereneDataElement != null) {
            NodeList childNodes = refereneDataElement.getElementsByTagName(BUNDLE_DATA);
            Element bundleElement = (Element)childNodes.item(0);
            childNodes = bundleElement.getChildNodes();
            refSortedMap = new TreeMap();
            this._extractEntryList(refSortedMap, childNodes);
        }
        return refSortedMap;
    }

    private Map getReferenceFeatureMap(String id, String referenceFileName) throws FactoryConfigurationError, ParserConfigurationException, FileNotFoundException, SAXException, IOException {
        Document dom = this.getReferenceDataDOM(referenceFileName);
        Element refereneDataElement = dom.getElementById(id);
        NodeList childNodes = refereneDataElement.getElementsByTagName(FEATURE_DATA);
        Element bundleElement = (Element)childNodes.item(0);
        childNodes = bundleElement.getChildNodes();
        TreeMap refSortedMap = new TreeMap();
        this._extractEntryList(refSortedMap, childNodes);
        return refSortedMap;
    }

    private Document getReferenceDataDOM(String referenceFileName) throws ParserConfigurationException, IOException, SAXException {
        Document dom = null;
        DocumentBuilderFactory documentBuilderFactory = DocumentBuilderFactory.newInstance();
        documentBuilderFactory.setValidating(true);
        documentBuilderFactory.setIgnoringElementContentWhitespace(true);
        documentBuilderFactory.setIgnoringComments(true);
        DocumentBuilder documentBuilder = documentBuilderFactory.newDocumentBuilder();
        Bundle versionCheckerBundle = Platform.getBundle((String)VERSION_CHECKER_BUNDLE_NAME);
        URL referenceDataURL = versionCheckerBundle.getResource(referenceFileName);
        if (referenceDataURL != null) {
            InputStream inStream = referenceDataURL.openStream();
            InputSource is = new InputSource(inStream);
            documentBuilder.setEntityResolver(new ClassPathResolver());
            dom = documentBuilder.parse(is);
        } else {
            System.out.println("Program Error: Could not find reference file: " + referenceFileName);
        }
        return dom;
    }

    private void _extractEntryList(SortedMap refSortedMap, NodeList childNodes) {
        int nNodes = childNodes.getLength();
        int i = 0;
        while (i < nNodes) {
            Element entry = (Element)childNodes.item(i);
            Node name = entry.getElementsByTagName("name").item(0);
            Node version = entry.getElementsByTagName("version").item(0);
            String bundleNmae = this.getTextContent(name);
            String versionString = this.getTextContent(version);
            refSortedMap.put(bundleNmae, new Version(versionString));
            ++i;
        }
    }

    private String getTextContent(Node node) {
        StringBuffer buffer = new StringBuffer();
        NodeList childNodes = node.getChildNodes();
        int i = 0;
        while (i < childNodes.getLength()) {
            Node textNode = childNodes.item(i);
            if (textNode.getNodeType() != 3) break;
            buffer.append(textNode.getNodeValue());
            ++i;
        }
        return buffer.toString();
    }

    private int doPrintHelp() {
        int exitCode = 90000;
        System.out.println();
        System.out.println("\tto use VersionChecker, include one of the following commands: ");
        System.out.println("\t\t-listToReferenceFile");
        System.out.println("\t\t-testToReference refId [referenceDataFilename]");
        System.out.println();
        return exitCode;
    }

    private int getCommand(String arg) {
        int result = -1;
        if (HELP_ARG.equalsIgnoreCase(arg)) {
            result = 0;
        } else if (LIST_TO_CONSOLE_ARG.equalsIgnoreCase(arg)) {
            result = 1;
        } else if (TEST_TO_REFERENCE_ARG.equalsIgnoreCase(arg)) {
            result = 2;
        }
        return result;
    }

    private Map makeFeatureMap() {
        IPlatformConfiguration config = ConfiguratorUtils.getCurrentPlatformConfiguration();
        IPlatformConfiguration.IFeatureEntry[] features = config.getConfiguredFeatureEntries();
        TreeMap<String, Version> sortedMap = new TreeMap<String, Version>();
        int i = 0;
        while (i < features.length) {
            String name = features[i].getFeatureIdentifier();
            name = name.trim();
            String versionString = features[i].getFeatureVersion();
            Version version = new Version(versionString);
            if (!this.contains(name, alwaysExcludeFeatures)) {
                sortedMap.put(name, version);
            }
            ++i;
        }
        return sortedMap;
    }

    private int doListCurrentToConsole(String xmlId) throws IOException {
        int exitResult = 90000;
        String outputFileName = "versioningReference";
        File outputFile = this.createOutputFile(outputFileName);
        FileWriter referenceWriter = new FileWriter(outputFile);
        referenceWriter.write("<?xml version=\"1.0\" encoding=\"UTF-8\"?>" + EOL);
        referenceWriter.write("<versioningData>" + EOL);
        referenceWriter.write("<referenceData id=\"" + xmlId + "\">" + EOL);
        Map featureMap = this.makeFeatureMap();
        referenceWriter.write("<featureData>" + EOL);
        referenceWriter.write("<!-- Number of features: " + featureMap.size() + " -->" + EOL);
        referenceWriter.write(EOL);
        this._producePrintedPairs(featureMap, referenceWriter);
        referenceWriter.write("</featureData>" + EOL);
        Map bundleMap = this.makeBundleMap();
        referenceWriter.write("<bundleData>" + EOL);
        referenceWriter.write("<!-- Number of bundles: " + bundleMap.size() + " -->" + EOL);
        referenceWriter.write(EOL);
        this._producePrintedPairs(bundleMap, referenceWriter);
        referenceWriter.write("</bundleData>" + EOL);
        referenceWriter.write("</referenceData>" + EOL);
        referenceWriter.write("</versioningData>" + EOL);
        System.out.println("Note: versioning reference data written to " + outputFile.getAbsolutePath());
        ((Writer)referenceWriter).close();
        return exitResult;
    }

    private String getCurrentInstallPath() {
        Location installLocation = Platform.getInstallLocation();
        URL installLoc = installLocation.getURL();
        String installLocationString = "no install location!?";
        if (installLoc != null) {
            installLocationString = installLoc.getPath();
        }
        return installLocationString;
    }

    private String getDefaultID() {
        String defaultID = null;
        String buildLabel = System.getProperty("buildLabel");
        defaultID = buildLabel != null && buildLabel.length() != 0 ? this.clean(buildLabel) : this.getCurrentInstallPath();
        return defaultID;
    }

    private void _producePrintedPairs(Map map, Writer referenceWriter) throws IOException {
        Set referenceKeySet = map.keySet();
        Iterator refIterator = referenceKeySet.iterator();
        while (refIterator.hasNext()) {
            String name = (String)refIterator.next();
            Version version = (Version)map.get(name);
            referenceWriter.write("<entry>" + EOL);
            referenceWriter.write("\t<name>" + name + "</name>" + EOL);
            referenceWriter.write("\t<version>" + version + "</version>" + EOL);
            referenceWriter.write("</entry>" + EOL);
        }
    }

    private Map makeBundleMap() {
        BundleDescription[] bundles = Platform.getPlatformAdmin().getState().getBundles();
        TreeMap<String, Version> sortedMap = new TreeMap<String, Version>();
        int i = 0;
        while (i < bundles.length) {
            String bundleName = bundles[i].getName();
            Version bundleVersion = bundles[i].getVersion();
            if (!this.contains(bundleName = bundleName.trim(), alwaysExclude)) {
                sortedMap.put(bundleName, bundleVersion);
            }
            ++i;
        }
        return sortedMap;
    }

    private boolean contains(String needle, String[] haystack) {
        boolean result = false;
        int i = 0;
        while (i < haystack.length) {
            if (needle.equals(haystack[i])) {
                result = true;
                break;
            }
            ++i;
        }
        return result;
    }

    private String clean(String label) {
        String result = label;
        String possibleResult = null;
        int hPos = label.indexOf(45);
        if (hPos > -1 && (hPos = (possibleResult = label.substring(hPos + 1)).indexOf(45)) > -1) {
            result = possibleResult = possibleResult.substring(0, hPos);
        }
        return result;
    }
}

