/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jst.ws.jaxws.core.annotation.validation.tests;

import java.util.ArrayList;
import javax.jws.WebParam;
import org.eclipse.core.resources.IMarker;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.OperationCanceledException;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.jdt.core.ICompilationUnit;
import org.eclipse.jdt.core.IMethod;
import org.eclipse.jdt.core.dom.AST;
import org.eclipse.jdt.core.dom.Annotation;
import org.eclipse.jdt.core.dom.CompilationUnit;
import org.eclipse.jdt.core.dom.MemberValuePair;
import org.eclipse.jdt.core.dom.SingleVariableDeclaration;
import org.eclipse.jdt.core.dom.rewrite.ASTRewrite;
import org.eclipse.jst.ws.annotations.core.AnnotationsCore;
import org.eclipse.jst.ws.annotations.core.utils.AnnotationUtils;
import org.eclipse.jst.ws.internal.jaxws.core.JAXWSCoreMessages;
import org.eclipse.jst.ws.jaxws.core.annotation.validation.tests.AbstractAnnotationValidationTest;
import org.eclipse.ltk.core.refactoring.Change;
import org.eclipse.ltk.core.refactoring.TextFileChange;

public class WebParamModeHolderTypeRuleTest
extends AbstractAnnotationValidationTest {
    public Annotation getAnnotation() {
        ArrayList<MemberValuePair> memberValuePairs = new ArrayList<MemberValuePair>();
        MemberValuePair modeValuePair = AnnotationsCore.createEnumMemberValuePair((AST)this.ast, (String)WebParam.class.getCanonicalName(), (String)"mode", (Object)WebParam.Mode.OUT);
        memberValuePairs.add(modeValuePair);
        return AnnotationsCore.createAnnotation((AST)this.ast, WebParam.class, (String)WebParam.class.getSimpleName(), memberValuePairs);
    }

    public String getPackageName() {
        return "com.example";
    }

    public String getClassName() {
        return "MyClass.java";
    }

    public String getClassContents() {
        StringBuilder classContents = new StringBuilder("package com.example;\n\n");
        classContents.append("import javax.jws.WebService;\n\n");
        classContents.append("@WebService(name=\"MyClass\")\n");
        classContents.append("public class MyClass {\n\n\tpublic String myMethod(String param) {");
        classContents.append("\n\t\treturn \"txt\";\n\t}\n}");
        return classContents.toString();
    }

    public void testWebParamModeHolderTypeRule() {
        try {
            WebParamModeHolderTypeRuleTest.assertNotNull((Object)this.annotation);
            WebParamModeHolderTypeRuleTest.assertEquals((String)WebParam.class.getSimpleName(), (String)AnnotationUtils.getAnnotationName((Annotation)this.annotation));
            IMethod method = this.source.findPrimaryType().getMethod("myMethod", new String[]{"QString;"});
            WebParamModeHolderTypeRuleTest.assertNotNull((Object)method);
            AnnotationUtils.addImportEdit((CompilationUnit)this.compilationUnit, WebParam.class, (TextFileChange)this.textFileChange, (boolean)true);
            SingleVariableDeclaration parameter = AnnotationUtils.getMethodParameter((CompilationUnit)this.compilationUnit, (IMethod)method, (int)128);
            AnnotationUtils.addAnnotationToMethodParameter((ICompilationUnit)this.source, (CompilationUnit)this.compilationUnit, (ASTRewrite)this.rewriter, (SingleVariableDeclaration)parameter, (IMethod)method, (Annotation)this.annotation, (TextFileChange)this.textFileChange);
            WebParamModeHolderTypeRuleTest.assertTrue((boolean)this.executeChange((IProgressMonitor)new NullProgressMonitor(), (Change)this.textFileChange));
            parameter = AnnotationUtils.getMethodParameter((CompilationUnit)AnnotationUtils.getASTParser((ICompilationUnit)method.getCompilationUnit(), (boolean)false), (IMethod)method, (int)156);
            WebParamModeHolderTypeRuleTest.assertTrue((boolean)AnnotationUtils.isAnnotationPresent((SingleVariableDeclaration)parameter, (Annotation)this.annotation));
            Job.getJobManager().join(ResourcesPlugin.FAMILY_AUTO_BUILD, null);
            IMarker[] allmarkers = this.source.getResource().findMarkers("org.eclipse.core.resources.problemmarker", true, 2);
            WebParamModeHolderTypeRuleTest.assertEquals((int)1, (int)allmarkers.length);
            IMarker annotationProblemMarker = allmarkers[0];
            WebParamModeHolderTypeRuleTest.assertEquals((Object)this.source.getResource(), (Object)annotationProblemMarker.getResource());
            WebParamModeHolderTypeRuleTest.assertEquals((Object)JAXWSCoreMessages.WEBPARAM_MODE_OUT_INOUT_HOLDER_TYPE, (Object)annotationProblemMarker.getAttribute("message"));
        }
        catch (CoreException ce) {
            WebParamModeHolderTypeRuleTest.fail((String)ce.getLocalizedMessage());
        }
        catch (OperationCanceledException oce) {
            WebParamModeHolderTypeRuleTest.fail((String)oce.getLocalizedMessage());
        }
        catch (InterruptedException ie) {
            WebParamModeHolderTypeRuleTest.fail((String)ie.getLocalizedMessage());
        }
    }
}

