/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jst.ws.jaxws.core.annotation.validation.tests;

import javax.jws.WebService;
import org.eclipse.core.resources.IMarker;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.OperationCanceledException;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.jdt.core.ICompilationUnit;
import org.eclipse.jdt.core.IJavaElement;
import org.eclipse.jdt.core.IType;
import org.eclipse.jdt.core.dom.AST;
import org.eclipse.jdt.core.dom.Annotation;
import org.eclipse.jdt.core.dom.CompilationUnit;
import org.eclipse.jdt.core.dom.rewrite.ASTRewrite;
import org.eclipse.jst.ws.annotations.core.AnnotationsCore;
import org.eclipse.jst.ws.annotations.core.utils.AnnotationUtils;
import org.eclipse.jst.ws.internal.jaxws.core.JAXWSCoreMessages;
import org.eclipse.jst.ws.jaxws.core.annotation.validation.tests.AbstractAnnotationValidationTest;
import org.eclipse.ltk.core.refactoring.Change;
import org.eclipse.ltk.core.refactoring.TextFileChange;

public class HolderTypeParameterRuleTest
extends AbstractAnnotationValidationTest {
    public Annotation getAnnotation() {
        return AnnotationsCore.createAnnotation((AST)this.ast, WebService.class, (String)WebService.class.getSimpleName(), null);
    }

    public String getPackageName() {
        return "com.example";
    }

    public String getClassName() {
        return "MyClass.java";
    }

    public String getClassContents() {
        StringBuilder classContents = new StringBuilder("package com.example;\n\n");
        classContents.append("import javax.jws.WebParam;\n");
        classContents.append("import javax.xml.ws.Holder;\n\n");
        classContents.append("public class MyClass {\n\n\tpublic void myMethod(");
        classContents.append("@WebParam(mode=WebParam.Mode.IN) Holder<java.lang.String> param) {\n\n\t}\n}");
        return classContents.toString();
    }

    public void testHolderTypeParameterRule() {
        try {
            HolderTypeParameterRuleTest.assertNotNull((Object)this.annotation);
            HolderTypeParameterRuleTest.assertEquals((String)WebService.class.getSimpleName(), (String)AnnotationUtils.getAnnotationName((Annotation)this.annotation));
            AnnotationUtils.addImportEdit((CompilationUnit)this.compilationUnit, WebService.class, (TextFileChange)this.textFileChange, (boolean)true);
            AnnotationUtils.addAnnotationToType((ICompilationUnit)this.source, (CompilationUnit)this.compilationUnit, (ASTRewrite)this.rewriter, (IType)this.source.findPrimaryType(), (Annotation)this.annotation, (TextFileChange)this.textFileChange);
            HolderTypeParameterRuleTest.assertTrue((boolean)this.executeChange((IProgressMonitor)new NullProgressMonitor(), (Change)this.textFileChange));
            HolderTypeParameterRuleTest.assertTrue((boolean)AnnotationUtils.isAnnotationPresent((IJavaElement)this.source, (String)AnnotationUtils.getAnnotationName((Annotation)this.annotation)));
            Job.getJobManager().join(ResourcesPlugin.FAMILY_AUTO_BUILD, null);
            IMarker[] allmarkers = this.source.getResource().findMarkers("org.eclipse.core.resources.problemmarker", true, 2);
            HolderTypeParameterRuleTest.assertEquals((int)1, (int)allmarkers.length);
            IMarker annotationProblemMarker = allmarkers[0];
            HolderTypeParameterRuleTest.assertEquals((Object)this.source.getResource(), (Object)annotationProblemMarker.getResource());
            HolderTypeParameterRuleTest.assertEquals((Object)JAXWSCoreMessages.HOLDER_TYPE_MUST_BE_OUT_INOUT, (Object)annotationProblemMarker.getAttribute("message"));
        }
        catch (CoreException ce) {
            HolderTypeParameterRuleTest.fail((String)ce.getLocalizedMessage());
        }
        catch (OperationCanceledException oce) {
            HolderTypeParameterRuleTest.fail((String)oce.getLocalizedMessage());
        }
        catch (InterruptedException ie) {
            HolderTypeParameterRuleTest.fail((String)ie.getLocalizedMessage());
        }
    }
}

