/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jst.ws.internal.cxf.creation.core.commands;

import java.io.IOException;
import java.util.ArrayList;
import org.eclipse.core.commands.ExecutionException;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IResourceChangeListener;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jst.ws.internal.cxf.core.model.CXFDataModel;
import org.eclipse.jst.ws.internal.cxf.core.model.WSDL2JavaDataModel;
import org.eclipse.jst.ws.internal.cxf.core.resources.JavaResourceChangeListener;
import org.eclipse.jst.ws.internal.cxf.core.resources.WebContentChangeListener;
import org.eclipse.jst.ws.internal.cxf.core.utils.CommandLineUtils;
import org.eclipse.jst.ws.internal.cxf.core.utils.FileUtils;
import org.eclipse.jst.ws.internal.cxf.core.utils.LaunchUtils;
import org.eclipse.jst.ws.internal.cxf.core.utils.SpringUtils;
import org.eclipse.jst.ws.internal.cxf.creation.core.CXFCreationCorePlugin;
import org.eclipse.jst.ws.jaxws.core.utils.JDTUtils;
import org.eclipse.wst.common.frameworks.datamodel.AbstractDataModelOperation;
import org.eclipse.wst.ws.internal.wsrt.IWebService;

public class WSDL2JavaCommand
extends AbstractDataModelOperation {
    public static final String CXF_TOOL_CLASS_NAME = "org.apache.cxf.tools.wsdlto.WSDLToJava";
    private WSDL2JavaDataModel model;
    private IWebService ws;
    private JavaResourceChangeListener javaResourceChangeListener;
    private WebContentChangeListener webContentChangeListener;

    public WSDL2JavaCommand(WSDL2JavaDataModel model, IWebService ws) {
        this.model = model;
        this.ws = ws;
    }

    public IStatus execute(IProgressMonitor monitor, IAdaptable info) throws ExecutionException {
        IStatus status = Status.OK_STATUS;
        this.javaResourceChangeListener = new JavaResourceChangeListener(this.model.getJavaSourceFolder());
        this.webContentChangeListener = new WebContentChangeListener(this.model.getProjectName());
        ResourcesPlugin.getWorkspace().addResourceChangeListener((IResourceChangeListener)this.javaResourceChangeListener, 1);
        ResourcesPlugin.getWorkspace().addResourceChangeListener((IResourceChangeListener)this.webContentChangeListener, 1);
        String projectName = this.model.getProjectName();
        this.ws.getWebServiceInfo().setImplURLs(new String[]{String.valueOf(projectName) + "/Impl.java"});
        String[] progArgs = CommandLineUtils.getWSDL2JavaProgramArguments((WSDL2JavaDataModel)this.model);
        try {
            try {
                IJavaProject javaProject = JDTUtils.getJavaProject((String)projectName);
                LaunchUtils.launch((IJavaProject)javaProject, (String)CXF_TOOL_CLASS_NAME, (String[])progArgs);
                FileUtils.copyW2JFilesFromTmp((WSDL2JavaDataModel)this.model);
                if (this.model.isGenerateImplementation()) {
                    SpringUtils.createConfigurationFromWSDL((WSDL2JavaDataModel)this.model);
                }
            }
            catch (CoreException ce) {
                status = ce.getStatus();
                CXFCreationCorePlugin.log(status);
                ResourcesPlugin.getWorkspace().removeResourceChangeListener((IResourceChangeListener)this.javaResourceChangeListener);
                ResourcesPlugin.getWorkspace().removeResourceChangeListener((IResourceChangeListener)this.webContentChangeListener);
                FileUtils.refreshProject((String)projectName, (IProgressMonitor)monitor);
            }
            catch (IOException ioe) {
                status = new Status(4, "org.eclipse.jst.ws.cxf.creation.core", ioe.getLocalizedMessage());
                CXFCreationCorePlugin.log(status);
                ResourcesPlugin.getWorkspace().removeResourceChangeListener((IResourceChangeListener)this.javaResourceChangeListener);
                ResourcesPlugin.getWorkspace().removeResourceChangeListener((IResourceChangeListener)this.webContentChangeListener);
                FileUtils.refreshProject((String)projectName, (IProgressMonitor)monitor);
            }
        }
        finally {
            ResourcesPlugin.getWorkspace().removeResourceChangeListener((IResourceChangeListener)this.javaResourceChangeListener);
            ResourcesPlugin.getWorkspace().removeResourceChangeListener((IResourceChangeListener)this.webContentChangeListener);
            FileUtils.refreshProject((String)projectName, (IProgressMonitor)monitor);
        }
        return status;
    }

    public IStatus undo(IProgressMonitor monitor, IAdaptable info) throws ExecutionException {
        IStatus status = Status.OK_STATUS;
        ArrayList changedResources = new ArrayList();
        changedResources.addAll(this.javaResourceChangeListener.getChangedResources());
        changedResources.addAll(this.webContentChangeListener.getChangedResources());
        if (changedResources.size() > 0) {
            for (IResource resource : changedResources) {
                try {
                    resource.delete(true, monitor);
                }
                catch (CoreException ce) {
                    status = ce.getStatus();
                    CXFCreationCorePlugin.log(status);
                }
            }
        }
        return status;
    }

    public CXFDataModel getCXFDataModel() {
        return this.model;
    }
}

