/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jst.ws.internal.cxf.core;

import java.io.File;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.List;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.eclipse.jdt.core.IClasspathContainer;
import org.eclipse.jdt.core.IClasspathEntry;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.JavaCore;
import org.eclipse.jst.ws.internal.cxf.core.CXFCoreMessages;
import org.eclipse.jst.ws.internal.cxf.core.CXFCorePlugin;

public class CXFClasspathContainer
implements IClasspathContainer {
    private IPath path;
    private List<IClasspathEntry> classpathEntries;
    private String cxfLibraryEdition;
    private String cxfLibraryVersion;
    private String cxfLibraryLocation;

    public CXFClasspathContainer(IPath path, IJavaProject javaProject) {
        this.path = path;
        this.classpathEntries = new ArrayList<IClasspathEntry>();
        this.cxfLibraryLocation = this.getCxfRuntimeLocation();
        this.cxfLibraryVersion = this.getCxfRuntimeVersion();
        this.cxfLibraryEdition = this.getCxfRuntimeEdition();
    }

    public IClasspathEntry[] getClasspathEntries() {
        File cxfLibDirectory;
        if (!this.cxfLibraryVersion.equals(this.getCxfRuntimeVersion())) {
            this.classpathEntries = new ArrayList<IClasspathEntry>();
            this.cxfLibraryLocation = this.getCxfRuntimeLocation();
            this.cxfLibraryVersion = this.getCxfRuntimeVersion();
            this.cxfLibraryEdition = this.getCxfRuntimeEdition();
        }
        if (this.classpathEntries.size() == 0 && (cxfLibDirectory = this.getCXFLibraryDirectory()).exists() && cxfLibDirectory.isDirectory()) {
            String[] files = cxfLibDirectory.list();
            int i = 0;
            while (i < files.length) {
                File file = new File(String.valueOf(cxfLibDirectory.getPath()) + File.separator + files[i]);
                String fileName = file.getName();
                if (fileName.indexOf(".") != -1 && fileName.substring(fileName.lastIndexOf("."), fileName.length()).equals(".jar")) {
                    this.classpathEntries.add(JavaCore.newLibraryEntry((IPath)new Path(file.getAbsolutePath()), null, (IPath)new Path("/")));
                }
                ++i;
            }
        }
        return this.classpathEntries.toArray(new IClasspathEntry[this.classpathEntries.size()]);
    }

    public boolean isValid() {
        if (this.getCxfRuntimeLocation().length() > 0) {
            File cxfLibDirectory = this.getCXFLibraryDirectory();
            return cxfLibDirectory.exists() && cxfLibDirectory.isDirectory();
        }
        return false;
    }

    public String getDescription() {
        return MessageFormat.format(CXFCoreMessages.CXF_CONTAINER_LIBRARY, this.cxfLibraryEdition, this.cxfLibraryVersion);
    }

    public int getKind() {
        return 1;
    }

    public IPath getPath() {
        return this.path;
    }

    private String getCxfRuntimeLocation() {
        return CXFCorePlugin.getDefault().getJava2WSContext().getCxfRuntimeLocation();
    }

    private String getCxfRuntimeVersion() {
        return CXFCorePlugin.getDefault().getJava2WSContext().getCxfRuntimeVersion();
    }

    private String getCxfRuntimeEdition() {
        return CXFCorePlugin.getDefault().getJava2WSContext().getCxfRuntimeEdition();
    }

    private File getCXFLibraryDirectory() {
        Path cxfLibPath = new Path(this.cxfLibraryLocation);
        if (!cxfLibPath.hasTrailingSeparator()) {
            cxfLibPath = cxfLibPath.addTrailingSeparator();
        }
        cxfLibPath = cxfLibPath.append("lib");
        File cxfLibDirectory = new File(cxfLibPath.toOSString());
        return cxfLibDirectory;
    }
}

