/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jpt.ui.internal.orm.details;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.ListIterator;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.jpt.core.context.orm.EntityMappings;
import org.eclipse.jpt.core.context.orm.OrmGenerator;
import org.eclipse.jpt.core.context.orm.OrmSequenceGenerator;
import org.eclipse.jpt.core.context.orm.OrmTableGenerator;
import org.eclipse.jpt.ui.internal.orm.JptUiOrmMessages;
import org.eclipse.jpt.ui.internal.orm.details.AddGeneratorDialog;
import org.eclipse.jpt.ui.internal.orm.details.OrmSequenceGeneratorComposite;
import org.eclipse.jpt.ui.internal.orm.details.OrmTableGeneratorComposite;
import org.eclipse.jpt.ui.internal.util.ControlSwitcher;
import org.eclipse.jpt.ui.internal.util.PaneEnabler;
import org.eclipse.jpt.ui.internal.widgets.AddRemoveListPane;
import org.eclipse.jpt.ui.internal.widgets.AddRemovePane;
import org.eclipse.jpt.ui.internal.widgets.Pane;
import org.eclipse.jpt.utility.internal.CollectionTools;
import org.eclipse.jpt.utility.internal.Transformer;
import org.eclipse.jpt.utility.internal.model.value.CompositeListValueModel;
import org.eclipse.jpt.utility.internal.model.value.ItemPropertyListValueModelAdapter;
import org.eclipse.jpt.utility.internal.model.value.ListAspectAdapter;
import org.eclipse.jpt.utility.internal.model.value.SimplePropertyValueModel;
import org.eclipse.jpt.utility.internal.model.value.TransformationPropertyValueModel;
import org.eclipse.jpt.utility.internal.model.value.swing.ObjectListSelectionModel;
import org.eclipse.jpt.utility.model.value.ListValueModel;
import org.eclipse.jpt.utility.model.value.PropertyValueModel;
import org.eclipse.jpt.utility.model.value.WritablePropertyValueModel;
import org.eclipse.osgi.util.NLS;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.ui.part.PageBook;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class OrmGeneratorsComposite
extends Pane<EntityMappings> {
    private WritablePropertyValueModel<OrmGenerator> generatorHolder;
    private OrmSequenceGeneratorComposite sequenceGeneratorPane;
    private OrmTableGeneratorComposite tableGeneratorPane;
    private AddRemoveListPane<EntityMappings> listPane;

    public OrmGeneratorsComposite(Pane<? extends EntityMappings> parentPane, Composite parent) {
        super(parentPane, parent, false);
    }

    private void addGenerator(ObjectListSelectionModel listSelectionModel) {
        this.addGeneratorFromDialog(listSelectionModel, this.buildAddGeneratorDialog());
    }

    protected AddGeneratorDialog buildAddGeneratorDialog() {
        return new AddGeneratorDialog(this.getControl().getShell());
    }

    protected void addGeneratorFromDialog(ObjectListSelectionModel listSelectionModel, AddGeneratorDialog dialog) {
        OrmTableGenerator generator;
        if (dialog.open() != 0) {
            return;
        }
        String generatorType = dialog.getGeneratorType();
        if (generatorType == "tableGenerator") {
            generator = ((EntityMappings)this.getSubject()).addTableGenerator(((EntityMappings)this.getSubject()).tableGeneratorsSize());
        } else if (generatorType == "sequenceGenerator") {
            generator = ((EntityMappings)this.getSubject()).addSequenceGenerator(((EntityMappings)this.getSubject()).sequenceGeneratorsSize());
        } else {
            throw new IllegalArgumentException();
        }
        generator.setName(dialog.getName());
        this.generatorHolder.setValue((Object)generator);
        listSelectionModel.setSelectedValue((Object)generator);
    }

    private ListValueModel<OrmGenerator> buildDisplayableGeneratorListHolder() {
        return new ItemPropertyListValueModelAdapter(this.buildGeneratorsListHolder(), new String[]{"name"});
    }

    private AddRemovePane.Adapter buildGeneratorAdapter() {
        return new AddRemovePane.AbstractAdapter(){

            @Override
            public void addNewItem(ObjectListSelectionModel listSelectionModel) {
                OrmGeneratorsComposite.this.addGenerator(listSelectionModel);
            }

            @Override
            public void removeSelectedItems(ObjectListSelectionModel listSelectionModel) {
                Object[] objectArray = listSelectionModel.selectedValues();
                int n = objectArray.length;
                int n2 = 0;
                while (n2 < n) {
                    Object item = objectArray[n2];
                    if (item instanceof OrmSequenceGenerator) {
                        ((EntityMappings)OrmGeneratorsComposite.this.getSubject()).removeSequenceGenerator((OrmSequenceGenerator)item);
                    } else {
                        ((EntityMappings)OrmGeneratorsComposite.this.getSubject()).removeTableGenerator((OrmTableGenerator)item);
                    }
                    ++n2;
                }
            }
        };
    }

    private WritablePropertyValueModel<OrmGenerator> buildGeneratorHolder() {
        return new SimplePropertyValueModel();
    }

    private ILabelProvider buildGeneratorLabelProvider() {
        return new LabelProvider(){

            public String getText(Object element) {
                OrmGenerator generator = (OrmGenerator)element;
                String name = generator.getName();
                if (name == null) {
                    int index = -1;
                    index = generator instanceof OrmSequenceGenerator ? CollectionTools.indexOf((Iterator)((EntityMappings)OrmGeneratorsComposite.this.getSubject()).sequenceGenerators(), (Object)generator) : CollectionTools.indexOf((Iterator)((EntityMappings)OrmGeneratorsComposite.this.getSubject()).tableGenerators(), (Object)generator);
                    name = NLS.bind((String)JptUiOrmMessages.OrmGeneratorsComposite_displayString, (Object)index);
                }
                return name;
            }
        };
    }

    private ListValueModel<OrmGenerator> buildGeneratorsListHolder() {
        ArrayList<Object> list = new ArrayList<Object>();
        list.add(this.buildSequenceGeneratorListHolder());
        list.add(this.buildTableGeneratorListHolder());
        return new CompositeListValueModel(list);
    }

    private PropertyValueModel<Boolean> buildPaneEnablerHolder() {
        return new TransformationPropertyValueModel<EntityMappings, Boolean>(this.getSubjectHolder()){

            protected Boolean transform(EntityMappings value) {
                if (value != null) {
                    return true;
                }
                return false;
            }
        };
    }

    private Transformer<OrmGenerator, Control> buildPaneTransformer() {
        return new Transformer<OrmGenerator, Control>(){

            public Control transform(OrmGenerator generator) {
                if (generator == null) {
                    return null;
                }
                if (generator instanceof OrmSequenceGenerator) {
                    return OrmGeneratorsComposite.this.sequenceGeneratorPane.getControl();
                }
                return OrmGeneratorsComposite.this.tableGeneratorPane.getControl();
            }
        };
    }

    private PropertyValueModel<OrmSequenceGenerator> buildSequenceGeneratorHolder() {
        return new TransformationPropertyValueModel<OrmGenerator, OrmSequenceGenerator>(this.generatorHolder){

            protected OrmSequenceGenerator transform_(OrmGenerator value) {
                return value instanceof OrmSequenceGenerator ? (OrmSequenceGenerator)value : null;
            }
        };
    }

    private ListValueModel<OrmSequenceGenerator> buildSequenceGeneratorListHolder() {
        return new ListAspectAdapter<EntityMappings, OrmSequenceGenerator>(this.getSubjectHolder(), new String[]{"sequenceGenerators"}){

            protected ListIterator<OrmSequenceGenerator> listIterator_() {
                return ((EntityMappings)this.subject).sequenceGenerators();
            }

            protected int size_() {
                return ((EntityMappings)this.subject).sequenceGeneratorsSize();
            }
        };
    }

    private PropertyValueModel<OrmTableGenerator> buildTableGeneratorHolder() {
        return new TransformationPropertyValueModel<OrmGenerator, OrmTableGenerator>(this.generatorHolder){

            protected OrmTableGenerator transform_(OrmGenerator value) {
                return value instanceof OrmTableGenerator ? (OrmTableGenerator)value : null;
            }
        };
    }

    private ListValueModel<OrmTableGenerator> buildTableGeneratorListHolder() {
        return new ListAspectAdapter<EntityMappings, OrmTableGenerator>(this.getSubjectHolder(), new String[]{"tableGenerators"}){

            protected ListIterator<OrmTableGenerator> listIterator_() {
                return ((EntityMappings)this.subject).tableGenerators();
            }

            protected int size_() {
                return ((EntityMappings)this.subject).tableGeneratorsSize();
            }
        };
    }

    @Override
    protected void initialize() {
        super.initialize();
        this.generatorHolder = this.buildGeneratorHolder();
    }

    @Override
    protected void initializeLayout(Composite container) {
        container = this.addCollapsableSection(container, JptUiOrmMessages.OrmGeneratorsComposite_groupBox);
        this.listPane = this.addListPane(container);
        this.installPaneEnabler();
        PropertyValueModel<OrmSequenceGenerator> sequenceGeneratorHolder = this.buildSequenceGeneratorHolder();
        PropertyValueModel<OrmTableGenerator> tableGeneratorHolder = this.buildTableGeneratorHolder();
        PageBook pageBook = new PageBook(container, 0);
        pageBook.setLayoutData((Object)new GridData(768));
        this.sequenceGeneratorPane = new OrmSequenceGeneratorComposite((Pane<?>)this, sequenceGeneratorHolder, (Composite)pageBook);
        this.tableGeneratorPane = new OrmTableGeneratorComposite((Pane<?>)this, tableGeneratorHolder, (Composite)pageBook);
        this.addAlignRight(this.sequenceGeneratorPane);
        this.addAlignRight(this.tableGeneratorPane);
        this.installPaneSwitcher(pageBook);
    }

    private AddRemoveListPane<EntityMappings> addListPane(Composite container) {
        return new AddRemoveListPane<EntityMappings>(this, container, this.buildGeneratorAdapter(), this.buildDisplayableGeneratorListHolder(), this.generatorHolder, this.buildGeneratorLabelProvider());
    }

    private void installPaneEnabler() {
        new PaneEnabler(this.buildPaneEnablerHolder(), (Pane<?>)this.listPane);
    }

    private void installPaneSwitcher(PageBook pageBook) {
        new ControlSwitcher(this.generatorHolder, this.buildPaneTransformer(), pageBook);
    }
}

