/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jpt.ui.internal.mappings.details;

import org.eclipse.jpt.core.context.Column;
import org.eclipse.jpt.core.context.Converter;
import org.eclipse.jpt.core.context.TemporalConverter;
import org.eclipse.jpt.core.context.VersionMapping;
import org.eclipse.jpt.ui.WidgetFactory;
import org.eclipse.jpt.ui.details.JpaComposite;
import org.eclipse.jpt.ui.internal.mappings.JptUiMappingsMessages;
import org.eclipse.jpt.ui.internal.mappings.details.ColumnComposite;
import org.eclipse.jpt.ui.internal.mappings.details.TemporalTypeComposite;
import org.eclipse.jpt.ui.internal.widgets.FormPane;
import org.eclipse.jpt.utility.internal.model.value.PropertyAspectAdapter;
import org.eclipse.jpt.utility.internal.model.value.TransformationPropertyValueModel;
import org.eclipse.jpt.utility.model.value.PropertyValueModel;
import org.eclipse.jpt.utility.model.value.WritablePropertyValueModel;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class VersionMappingComposite
extends FormPane<VersionMapping>
implements JpaComposite {
    public VersionMappingComposite(PropertyValueModel<? extends VersionMapping> subjectHolder, Composite parent, WidgetFactory widgetFactory) {
        super(subjectHolder, parent, widgetFactory);
    }

    private PropertyValueModel<Column> buildColumnHolder() {
        return new TransformationPropertyValueModel<VersionMapping, Column>(this.getSubjectHolder()){

            protected Column transform_(VersionMapping value) {
                return value.getColumn();
            }
        };
    }

    @Override
    protected void initializeLayout(Composite container) {
        new ColumnComposite((FormPane<?>)this, (PropertyValueModel<? extends Column>)this.buildColumnHolder(), container);
        this.initializeConversionPane(container);
    }

    private void initializeConversionPane(Composite container) {
        container = this.addCollapsableSection(container, JptUiMappingsMessages.TypeSection_type);
        ((GridLayout)container.getLayout()).numColumns = 2;
        Button noConverterButton = this.addRadioButton(container, JptUiMappingsMessages.TypeSection_default, this.buildNoConverterHolder(), null);
        ((GridData)noConverterButton.getLayoutData()).horizontalSpan = 2;
        PropertyValueModel<Converter> specifiedConverterHolder = this.buildSpecifiedConverterHolder();
        this.addRadioButton(container, JptUiMappingsMessages.TypeSection_temporal, this.buildTemporalBooleanHolder(), null);
        this.registerSubPane(new TemporalTypeComposite((PropertyValueModel<? extends TemporalConverter>)this.buildTemporalConverterHolder(specifiedConverterHolder), container, this.getWidgetFactory()));
    }

    private WritablePropertyValueModel<Boolean> buildNoConverterHolder() {
        return new PropertyAspectAdapter<VersionMapping, Boolean>(this.getSubjectHolder(), new String[]{"specifiedConverter"}){

            protected Boolean buildValue_() {
                return ((VersionMapping)this.subject).getSpecifiedConverter() == null;
            }

            protected void setValue_(Boolean value) {
                if (value.booleanValue()) {
                    ((VersionMapping)this.subject).setSpecifiedConverter("noConverter");
                }
            }
        };
    }

    private WritablePropertyValueModel<Boolean> buildTemporalBooleanHolder() {
        return new PropertyAspectAdapter<VersionMapping, Boolean>(this.getSubjectHolder(), new String[]{"specifiedConverter"}){

            protected Boolean buildValue_() {
                Converter converter = ((VersionMapping)this.subject).getSpecifiedConverter();
                if (converter == null) {
                    return Boolean.FALSE;
                }
                return converter.getType() == "temporalConverter";
            }

            protected void setValue_(Boolean value) {
                if (value.booleanValue()) {
                    ((VersionMapping)this.subject).setSpecifiedConverter("temporalConverter");
                }
            }
        };
    }

    private PropertyValueModel<Converter> buildSpecifiedConverterHolder() {
        return new PropertyAspectAdapter<VersionMapping, Converter>(this.getSubjectHolder(), new String[]{"specifiedConverter"}){

            protected Converter buildValue_() {
                return ((VersionMapping)this.subject).getSpecifiedConverter();
            }
        };
    }

    private PropertyValueModel<TemporalConverter> buildTemporalConverterHolder(PropertyValueModel<Converter> converterHolder) {
        return new TransformationPropertyValueModel<Converter, TemporalConverter>(converterHolder){

            protected TemporalConverter transform_(Converter converter) {
                return converter != null && converter.getType() == "temporalConverter" ? (TemporalConverter)converter : null;
            }
        };
    }
}

