/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jpt.core.resource.xml;

import java.io.IOException;
import java.util.Collections;
import java.util.EventListener;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.content.IContentType;
import org.eclipse.emf.common.notify.Adapter;
import org.eclipse.emf.common.notify.Notification;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.jem.util.emf.workbench.WorkbenchResourceHelperBase;
import org.eclipse.jpt.core.JpaResourceModel;
import org.eclipse.jpt.core.JpaResourceModelListener;
import org.eclipse.jpt.core.JptCorePlugin;
import org.eclipse.jpt.utility.internal.ListenerList;
import org.eclipse.jpt.utility.internal.StringTools;
import org.eclipse.wst.common.internal.emf.resource.Renderer;
import org.eclipse.wst.common.internal.emf.resource.Translator;
import org.eclipse.wst.common.internal.emf.resource.TranslatorResourceImpl;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class JpaXmlResource
extends TranslatorResourceImpl
implements JpaResourceModel {
    protected final IContentType contentType;
    protected final Translator rootTranslator;
    protected final ListenerList<JpaResourceModelListener> resourceModelListenerList;

    public JpaXmlResource(URI uri, Renderer renderer, IContentType contentType, Translator rootTranslator) {
        super(uri, renderer);
        this.contentType = contentType;
        this.rootTranslator = rootTranslator;
        this.resourceModelListenerList = new ListenerList(JpaResourceModelListener.class);
    }

    public IContentType getContentType() {
        return this.contentType;
    }

    public void eNotify(Notification notification) {
        if (!notification.isTouch() && this.isLoaded()) {
            super.eNotify(notification);
            this.resourceModelChanged();
        }
    }

    public Translator getRootTranslator() {
        return this.rootTranslator;
    }

    protected String getDefaultPublicId() {
        return null;
    }

    protected String getDefaultSystemId() {
        return null;
    }

    protected int getDefaultVersionID() {
        return 10;
    }

    public String getDoctype() {
        return null;
    }

    public boolean fileExists() {
        return this.getFile().exists();
    }

    public IFile getFile() {
        IFile file = JpaXmlResource.getFile(this.uri);
        return file != null ? file : this.getConvertedURIFile();
    }

    protected IFile getConvertedURIFile() {
        if (this.resourceSet == null) {
            return null;
        }
        URI convertedURI = this.resourceSet.getURIConverter().normalize(this.uri);
        return this.uri.equals((Object)convertedURI) ? null : JpaXmlResource.getFile(convertedURI);
    }

    protected static IFile getFile(URI uri) {
        if (!WorkbenchResourceHelperBase.isPlatformResourceURI((URI)uri)) {
            return null;
        }
        String fileName = URI.decode((String)uri.path()).substring("resource".length() + 1);
        return ResourcesPlugin.getWorkspace().getRoot().getFile((IPath)new Path(fileName));
    }

    public void modify(Runnable runnable) {
        try {
            runnable.run();
            try {
                this.save(Collections.EMPTY_MAP);
            }
            catch (IOException ioe) {
                JptCorePlugin.log(ioe);
            }
        }
        catch (Exception e) {
            JptCorePlugin.log(e);
        }
    }

    public String toString() {
        return StringTools.buildToStringFor((Object)this, (Object)this.getURI());
    }

    @Override
    public void addResourceModelListener(JpaResourceModelListener listener) {
        this.resourceModelListenerList.add((EventListener)listener);
    }

    @Override
    public void removeResourceModelListener(JpaResourceModelListener listener) {
        this.resourceModelListenerList.remove((EventListener)listener);
    }

    protected void resourceModelChanged() {
        JpaResourceModelListener[] jpaResourceModelListenerArray = (JpaResourceModelListener[])this.resourceModelListenerList.getListeners();
        int n = jpaResourceModelListenerArray.length;
        int n2 = 0;
        while (n2 < n) {
            JpaResourceModelListener listener = jpaResourceModelListenerArray[n2];
            listener.resourceModelChanged();
            ++n2;
        }
    }

    public EList<Adapter> eAdapters() {
        return super.eAdapters();
    }

    public EList<EObject> getContents() {
        return super.getContents();
    }
}

