/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jpt.core.internal.context.orm;

import org.eclipse.jpt.core.context.AccessType;
import org.eclipse.jpt.core.context.orm.OrmPersistenceUnitDefaults;
import org.eclipse.jpt.core.context.orm.PersistenceUnitMetadata;
import org.eclipse.jpt.core.internal.context.AbstractXmlContextNode;
import org.eclipse.jpt.core.resource.orm.OrmFactory;
import org.eclipse.jpt.core.resource.orm.XmlEntityMappings;
import org.eclipse.jpt.core.resource.orm.XmlPersistenceUnitDefaults;
import org.eclipse.jpt.core.resource.orm.XmlPersistenceUnitMetadata;
import org.eclipse.jpt.core.utility.TextRange;
import org.eclipse.jpt.db.Catalog;
import org.eclipse.jpt.db.Schema;
import org.eclipse.jpt.db.SchemaContainer;

public class GenericPersistenceUnitDefaults
extends AbstractXmlContextNode
implements OrmPersistenceUnitDefaults {
    protected final XmlEntityMappings xmlEntityMappings;
    protected AccessType access;
    protected String specifiedCatalog;
    protected String defaultCatalog;
    protected String specifiedSchema;
    protected String defaultSchema;
    protected boolean cascadePersist;

    public GenericPersistenceUnitDefaults(PersistenceUnitMetadata parent, XmlEntityMappings xmlEntityMappings) {
        super(parent);
        this.xmlEntityMappings = xmlEntityMappings;
        XmlPersistenceUnitDefaults resourceDefaults = this.getResourceDefaults();
        if (resourceDefaults != null) {
            this.access = AccessType.fromOrmResourceModel(resourceDefaults.getAccess());
            this.specifiedCatalog = resourceDefaults.getCatalog();
            this.specifiedSchema = resourceDefaults.getSchema();
            this.cascadePersist = resourceDefaults.isCascadePersist();
        }
        this.defaultCatalog = this.getJpaProject().getDefaultCatalog();
        this.defaultSchema = this.getJpaProject().getDefaultSchema();
    }

    public boolean resourceExists() {
        return this.getResourceDefaults() != null;
    }

    public PersistenceUnitMetadata getParent() {
        return (PersistenceUnitMetadata)super.getParent();
    }

    protected XmlPersistenceUnitMetadata getResourcePersistenceUnitMetadata() {
        return this.getParent().getResourcePersistenceUnitMetadata();
    }

    protected XmlPersistenceUnitMetadata createResourcePersistenceUnitMetadata() {
        return this.getParent().createResourcePersistenceUnitMetadata();
    }

    public AccessType getAccess() {
        return this.access;
    }

    public void setAccess(AccessType access) {
        AccessType old = this.access;
        this.access = access;
        if (access != old) {
            XmlPersistenceUnitDefaults resourceDefaults = this.getResourceDefaults();
            if (resourceDefaults == null) {
                resourceDefaults = this.buildResourceDefaults();
            }
            resourceDefaults.setAccess(AccessType.toOrmResourceModel(access));
            this.checkResourceDefaults(resourceDefaults);
            this.firePropertyChanged("access", (Object)old, (Object)access);
        }
    }

    protected void setAccess_(AccessType access) {
        AccessType old = this.access;
        this.access = access;
        this.firePropertyChanged("access", (Object)old, (Object)access);
    }

    public SchemaContainer getDbSchemaContainer() {
        String catalog = this.getCatalog();
        return catalog != null ? this.getDbCatalog(catalog) : this.getDatabase();
    }

    public String getCatalog() {
        return this.specifiedCatalog != null ? this.specifiedCatalog : this.defaultCatalog;
    }

    public String getSpecifiedCatalog() {
        return this.specifiedCatalog;
    }

    public void setSpecifiedCatalog(String catalog) {
        String old = this.specifiedCatalog;
        this.specifiedCatalog = catalog;
        if (this.attributeValueHasChanged(old, catalog)) {
            XmlPersistenceUnitDefaults resourceDefaults = this.getResourceDefaults();
            if (resourceDefaults == null) {
                resourceDefaults = this.buildResourceDefaults();
            }
            resourceDefaults.setCatalog(catalog);
            this.checkResourceDefaults(resourceDefaults);
            this.firePropertyChanged("specifiedCatalog", old, catalog);
        }
    }

    protected void setSpecifiedCatalog_(String catalog) {
        String old = this.specifiedCatalog;
        this.specifiedCatalog = catalog;
        this.firePropertyChanged("specifiedCatalog", old, catalog);
    }

    public String getDefaultCatalog() {
        return this.defaultCatalog;
    }

    protected void setDefaultCatalog(String catalog) {
        String old = this.defaultCatalog;
        this.defaultCatalog = catalog;
        this.firePropertyChanged("defaultCatalog", old, catalog);
    }

    public Catalog getDbCatalog() {
        String catalog = this.getCatalog();
        if (catalog == null) {
            return null;
        }
        return this.getDbCatalog(catalog);
    }

    public String getSchema() {
        return this.specifiedSchema != null ? this.specifiedSchema : this.defaultSchema;
    }

    public String getSpecifiedSchema() {
        return this.specifiedSchema;
    }

    public void setSpecifiedSchema(String schema) {
        String old = this.specifiedSchema;
        this.specifiedSchema = schema;
        if (this.attributeValueHasChanged(old, schema)) {
            XmlPersistenceUnitDefaults resourceDefaults = this.getResourceDefaults();
            if (resourceDefaults == null) {
                resourceDefaults = this.buildResourceDefaults();
            }
            resourceDefaults.setSchema(schema);
            this.checkResourceDefaults(resourceDefaults);
            this.firePropertyChanged("specifiedSchema", old, schema);
        }
    }

    protected void setSpecifiedSchema_(String schema) {
        String old = this.specifiedSchema;
        this.specifiedSchema = schema;
        this.firePropertyChanged("specifiedSchema", old, schema);
    }

    public String getDefaultSchema() {
        return this.defaultSchema;
    }

    protected void setDefaultSchema(String schema) {
        String old = this.defaultSchema;
        this.defaultSchema = schema;
        this.firePropertyChanged("defaultSchema", old, schema);
    }

    public Schema getDbSchema() {
        SchemaContainer dbSchemaContainer = this.getDbSchemaContainer();
        return dbSchemaContainer == null ? null : dbSchemaContainer.getSchemaForIdentifier(this.getSchema());
    }

    public boolean isCascadePersist() {
        return this.cascadePersist;
    }

    public void setCascadePersist(boolean cascadePersist) {
        boolean old = this.cascadePersist;
        this.cascadePersist = cascadePersist;
        if (cascadePersist != old) {
            XmlPersistenceUnitDefaults resourceDefaults = this.getResourceDefaults();
            if (resourceDefaults == null) {
                resourceDefaults = this.buildResourceDefaults();
            }
            resourceDefaults.setCascadePersist(cascadePersist);
            this.checkResourceDefaults(resourceDefaults);
            this.firePropertyChanged("cascadePersist", old, cascadePersist);
        }
    }

    protected void setCascadePersist_(boolean cp) {
        boolean old = this.cascadePersist;
        this.cascadePersist = cp;
        this.firePropertyChanged("cascadePersist", old, cp);
    }

    protected XmlPersistenceUnitDefaults buildResourceDefaults() {
        XmlPersistenceUnitMetadata resourceMetadata = this.getResourcePersistenceUnitMetadata();
        if (resourceMetadata == null) {
            resourceMetadata = this.createResourcePersistenceUnitMetadata();
            this.xmlEntityMappings.setPersistenceUnitMetadata(resourceMetadata);
        }
        XmlPersistenceUnitDefaults resourceDefaults = OrmFactory.eINSTANCE.createXmlPersistenceUnitDefaults();
        resourceMetadata.setPersistenceUnitDefaults(resourceDefaults);
        return resourceDefaults;
    }

    protected void checkResourceDefaults(XmlPersistenceUnitDefaults resourceDefaults) {
        if (resourceDefaults.isUnset()) {
            XmlPersistenceUnitMetadata metadata = this.xmlEntityMappings.getPersistenceUnitMetadata();
            metadata.setPersistenceUnitDefaults(null);
            if (metadata.isUnset()) {
                this.xmlEntityMappings.setPersistenceUnitMetadata(null);
            }
        }
    }

    public void update() {
        XmlPersistenceUnitDefaults resourceDefaults = this.getResourceDefaults();
        if (resourceDefaults == null) {
            this.setAccess_(null);
            this.setSpecifiedCatalog_(null);
            this.setSpecifiedSchema_(null);
            this.setCascadePersist_(false);
        } else {
            this.setAccess_(AccessType.fromOrmResourceModel(resourceDefaults.getAccess()));
            this.setSpecifiedCatalog_(resourceDefaults.getCatalog());
            this.setSpecifiedSchema_(resourceDefaults.getSchema());
            this.setCascadePersist_(resourceDefaults.isCascadePersist());
        }
        this.setDefaultCatalog(this.getJpaProject().getDefaultCatalog());
        this.setDefaultSchema(this.getJpaProject().getDefaultSchema());
    }

    public TextRange getValidationTextRange() {
        XmlPersistenceUnitDefaults resourceDefaults = this.getResourceDefaults();
        return resourceDefaults != null ? resourceDefaults.getValidationTextRange() : this.xmlEntityMappings.getValidationTextRange();
    }

    protected XmlPersistenceUnitDefaults getResourceDefaults() {
        XmlPersistenceUnitMetadata metadata = this.getResourcePersistenceUnitMetadata();
        return metadata == null ? null : metadata.getPersistenceUnitDefaults();
    }
}

