/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jpt.core.internal.context.orm;

import java.util.ArrayList;
import java.util.List;
import java.util.ListIterator;
import org.eclipse.jpt.core.context.BaseJoinColumn;
import org.eclipse.jpt.core.context.PrimaryKeyJoinColumn;
import org.eclipse.jpt.core.context.SecondaryTable;
import org.eclipse.jpt.core.context.TypeMapping;
import org.eclipse.jpt.core.context.orm.OrmBaseJoinColumn;
import org.eclipse.jpt.core.context.orm.OrmEntity;
import org.eclipse.jpt.core.context.orm.OrmPrimaryKeyJoinColumn;
import org.eclipse.jpt.core.context.orm.OrmSecondaryTable;
import org.eclipse.jpt.core.internal.context.orm.AbstractOrmTable;
import org.eclipse.jpt.core.internal.validation.DefaultJpaValidationMessages;
import org.eclipse.jpt.core.resource.orm.OrmFactory;
import org.eclipse.jpt.core.resource.orm.XmlPrimaryKeyJoinColumn;
import org.eclipse.jpt.core.resource.orm.XmlPrimaryKeyJoinColumnImpl;
import org.eclipse.jpt.core.resource.orm.XmlSecondaryTable;
import org.eclipse.jpt.core.utility.TextRange;
import org.eclipse.jpt.db.Table;
import org.eclipse.jpt.utility.internal.CollectionTools;
import org.eclipse.jpt.utility.internal.iterators.CloneIterator;
import org.eclipse.jpt.utility.internal.iterators.CloneListIterator;
import org.eclipse.jpt.utility.internal.iterators.EmptyListIterator;
import org.eclipse.jpt.utility.internal.iterators.SingleElementListIterator;
import org.eclipse.wst.validation.internal.provisional.core.IMessage;
import org.eclipse.wst.validation.internal.provisional.core.IReporter;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class GenericOrmSecondaryTable
extends AbstractOrmTable
implements OrmSecondaryTable {
    protected XmlSecondaryTable secondaryTable;
    protected final List<OrmPrimaryKeyJoinColumn> specifiedPrimaryKeyJoinColumns = new ArrayList<OrmPrimaryKeyJoinColumn>();
    protected OrmPrimaryKeyJoinColumn defaultPrimaryKeyJoinColumn;

    public GenericOrmSecondaryTable(OrmEntity parent, XmlSecondaryTable xmlSecondaryTable) {
        super(parent);
        this.initialize(xmlSecondaryTable);
    }

    @Override
    public void initializeFrom(SecondaryTable oldSecondaryTable) {
        super.initializeFrom(oldSecondaryTable);
        for (PrimaryKeyJoinColumn oldPkJoinColumn : CollectionTools.iterable(oldSecondaryTable.specifiedPrimaryKeyJoinColumns())) {
            OrmPrimaryKeyJoinColumn newPkJoinColumn = this.addSpecifiedPrimaryKeyJoinColumn(this.specifiedPrimaryKeyJoinColumnsSize());
            newPkJoinColumn.initializeFrom(oldPkJoinColumn);
        }
    }

    @Override
    public OrmEntity getParent() {
        return (OrmEntity)super.getParent();
    }

    public OrmEntity getOrmEntity() {
        return this.getParent();
    }

    @Override
    public OrmPrimaryKeyJoinColumn getDefaultPrimaryKeyJoinColumn() {
        return this.defaultPrimaryKeyJoinColumn;
    }

    protected void setDefaultPrimaryKeyJoinColumn(OrmPrimaryKeyJoinColumn newPkJoinColumn) {
        OrmPrimaryKeyJoinColumn oldPkJoinColumn = this.defaultPrimaryKeyJoinColumn;
        this.defaultPrimaryKeyJoinColumn = newPkJoinColumn;
        this.firePropertyChanged("defaultPrimaryKeyJoinColumn", oldPkJoinColumn, newPkJoinColumn);
    }

    @Override
    public ListIterator<OrmPrimaryKeyJoinColumn> primaryKeyJoinColumns() {
        return this.containsSpecifiedPrimaryKeyJoinColumns() ? this.specifiedPrimaryKeyJoinColumns() : this.defaultPrimaryKeyJoinColumns();
    }

    @Override
    public int primaryKeyJoinColumnsSize() {
        return this.containsSpecifiedPrimaryKeyJoinColumns() ? this.specifiedPrimaryKeyJoinColumnsSize() : this.defaultPrimaryKeyJoinColumnsSize();
    }

    @Override
    public ListIterator<OrmPrimaryKeyJoinColumn> specifiedPrimaryKeyJoinColumns() {
        return new CloneListIterator(this.specifiedPrimaryKeyJoinColumns);
    }

    @Override
    public int specifiedPrimaryKeyJoinColumnsSize() {
        return this.specifiedPrimaryKeyJoinColumns.size();
    }

    protected ListIterator<OrmPrimaryKeyJoinColumn> defaultPrimaryKeyJoinColumns() {
        if (this.defaultPrimaryKeyJoinColumn != null) {
            return new SingleElementListIterator((Object)this.defaultPrimaryKeyJoinColumn);
        }
        return EmptyListIterator.instance();
    }

    protected int defaultPrimaryKeyJoinColumnsSize() {
        return this.defaultPrimaryKeyJoinColumn == null ? 0 : 1;
    }

    public boolean containsSpecifiedPrimaryKeyJoinColumns() {
        return !this.specifiedPrimaryKeyJoinColumns.isEmpty();
    }

    @Override
    public OrmPrimaryKeyJoinColumn addSpecifiedPrimaryKeyJoinColumn(int index) {
        OrmPrimaryKeyJoinColumn oldDefaultPkJoinColumn = this.getDefaultPrimaryKeyJoinColumn();
        if (oldDefaultPkJoinColumn != null) {
            this.defaultPrimaryKeyJoinColumn = null;
        }
        XmlPrimaryKeyJoinColumnImpl resourcePkJoinColumn = OrmFactory.eINSTANCE.createXmlPrimaryKeyJoinColumnImpl();
        OrmPrimaryKeyJoinColumn contextPkJoinColumn = this.buildPrimaryKeyJoinColumn(resourcePkJoinColumn);
        this.specifiedPrimaryKeyJoinColumns.add(index, contextPkJoinColumn);
        this.secondaryTable.getPrimaryKeyJoinColumns().add(index, (Object)resourcePkJoinColumn);
        this.fireItemAdded("specifiedPrimaryKeyJoinColumns", index, contextPkJoinColumn);
        if (oldDefaultPkJoinColumn != null) {
            this.firePropertyChanged("defaultPrimaryKeyJoinColumn", oldDefaultPkJoinColumn, null);
        }
        return contextPkJoinColumn;
    }

    protected OrmBaseJoinColumn.Owner createPrimaryKeyJoinColumnOwner() {
        return new PrimaryKeyJoinColumnOwner();
    }

    protected void addSpecifiedPrimaryKeyJoinColumn(int index, OrmPrimaryKeyJoinColumn primaryKeyJoinColumn) {
        this.addItemToList(index, primaryKeyJoinColumn, this.specifiedPrimaryKeyJoinColumns, "specifiedPrimaryKeyJoinColumns");
    }

    protected void addSpecifiedPrimaryKeyJoinColumn(OrmPrimaryKeyJoinColumn primaryKeyJoinColumn) {
        this.addSpecifiedPrimaryKeyJoinColumn(this.specifiedPrimaryKeyJoinColumns.size(), primaryKeyJoinColumn);
    }

    @Override
    public void removeSpecifiedPrimaryKeyJoinColumn(PrimaryKeyJoinColumn pkJoinColumn) {
        this.removeSpecifiedPrimaryKeyJoinColumn(this.specifiedPrimaryKeyJoinColumns.indexOf(pkJoinColumn));
    }

    @Override
    public void removeSpecifiedPrimaryKeyJoinColumn(int index) {
        OrmPrimaryKeyJoinColumn removedPrimaryKeyJoinColumn = this.specifiedPrimaryKeyJoinColumns.remove(index);
        if (!this.containsSpecifiedPrimaryKeyJoinColumns()) {
            this.defaultPrimaryKeyJoinColumn = this.buildPrimaryKeyJoinColumn(null);
        }
        this.secondaryTable.getPrimaryKeyJoinColumns().remove(index);
        this.fireItemRemoved("specifiedPrimaryKeyJoinColumns", index, removedPrimaryKeyJoinColumn);
        if (this.defaultPrimaryKeyJoinColumn != null) {
            this.firePropertyChanged("defaultPrimaryKeyJoinColumn", null, this.defaultPrimaryKeyJoinColumn);
        }
    }

    protected void removeSpecifiedPrimaryKeyJoinColumn_(OrmPrimaryKeyJoinColumn primaryKeyJoinColumn) {
        this.removeItemFromList(primaryKeyJoinColumn, this.specifiedPrimaryKeyJoinColumns, "specifiedPrimaryKeyJoinColumns");
    }

    @Override
    public void moveSpecifiedPrimaryKeyJoinColumn(int targetIndex, int sourceIndex) {
        CollectionTools.move(this.specifiedPrimaryKeyJoinColumns, (int)targetIndex, (int)sourceIndex);
        this.secondaryTable.getPrimaryKeyJoinColumns().move(targetIndex, sourceIndex);
        this.fireItemMoved("specifiedPrimaryKeyJoinColumns", targetIndex, sourceIndex);
    }

    @Override
    public boolean isVirtual() {
        return this.getOrmEntity().containsVirtualSecondaryTable(this);
    }

    @Override
    protected XmlSecondaryTable getResourceTable() {
        return this.secondaryTable;
    }

    @Override
    protected XmlSecondaryTable addResourceTable() {
        throw new IllegalStateException("resource table is missing");
    }

    @Override
    protected void removeResourceTable() {
    }

    protected void initialize(XmlSecondaryTable xst) {
        this.secondaryTable = xst;
        super.initialize(xst);
        this.initializeSpecifiedPrimaryKeyJoinColumns();
        this.initializeDefaultPrimaryKeyJoinColumn();
    }

    protected void initializeSpecifiedPrimaryKeyJoinColumns() {
        for (XmlPrimaryKeyJoinColumn resourcePkJoinColumn : this.secondaryTable.getPrimaryKeyJoinColumns()) {
            this.specifiedPrimaryKeyJoinColumns.add(this.buildPrimaryKeyJoinColumn(resourcePkJoinColumn));
        }
    }

    protected boolean shouldBuildDefaultPrimaryKeyJoinColumn() {
        return !this.containsSpecifiedPrimaryKeyJoinColumns();
    }

    protected void initializeDefaultPrimaryKeyJoinColumn() {
        if (!this.shouldBuildDefaultPrimaryKeyJoinColumn()) {
            return;
        }
        this.defaultPrimaryKeyJoinColumn = this.buildPrimaryKeyJoinColumn(null);
    }

    @Override
    public void update(XmlSecondaryTable xst) {
        this.secondaryTable = xst;
        super.update(xst);
        this.updateSpecifiedPrimaryKeyJoinColumns();
        this.updateDefaultPrimaryKeyJoinColumn();
    }

    protected void updateSpecifiedPrimaryKeyJoinColumns() {
        CloneIterator xmlPkJoinColumns = new CloneIterator(this.secondaryTable.getPrimaryKeyJoinColumns());
        ListIterator<OrmPrimaryKeyJoinColumn> contextPkJoinColumns = this.specifiedPrimaryKeyJoinColumns();
        while (contextPkJoinColumns.hasNext()) {
            OrmPrimaryKeyJoinColumn contextPkJoinColumn = (OrmPrimaryKeyJoinColumn)contextPkJoinColumns.next();
            if (xmlPkJoinColumns.hasNext()) {
                contextPkJoinColumn.update((XmlPrimaryKeyJoinColumn)xmlPkJoinColumns.next());
                continue;
            }
            this.removeSpecifiedPrimaryKeyJoinColumn_(contextPkJoinColumn);
        }
        while (xmlPkJoinColumns.hasNext()) {
            this.addSpecifiedPrimaryKeyJoinColumn(this.buildPrimaryKeyJoinColumn((XmlPrimaryKeyJoinColumn)xmlPkJoinColumns.next()));
        }
    }

    protected void updateDefaultPrimaryKeyJoinColumn() {
        if (!this.shouldBuildDefaultPrimaryKeyJoinColumn()) {
            this.setDefaultPrimaryKeyJoinColumn(null);
            return;
        }
        if (this.getDefaultPrimaryKeyJoinColumn() == null) {
            this.setDefaultPrimaryKeyJoinColumn(this.buildPrimaryKeyJoinColumn(null));
        } else {
            this.defaultPrimaryKeyJoinColumn.update(null);
        }
    }

    protected OrmPrimaryKeyJoinColumn buildPrimaryKeyJoinColumn(XmlPrimaryKeyJoinColumn resourcePkJoinColumn) {
        return this.getJpaFactory().buildOrmPrimaryKeyJoinColumn(this, this.createPrimaryKeyJoinColumnOwner(), resourcePkJoinColumn);
    }

    @Override
    protected String buildDefaultName() {
        return null;
    }

    @Override
    protected String buildDefaultSchema() {
        return this.getContextDefaultSchema();
    }

    @Override
    protected String buildDefaultCatalog() {
        return this.getContextDefaultCatalog();
    }

    @Override
    public void validate(List<IMessage> messages, IReporter reporter) {
        super.validate(messages, reporter);
        if (this.connectionProfileIsActive()) {
            this.validateAgainstDatabase(messages);
        }
        ListIterator<OrmPrimaryKeyJoinColumn> stream = this.primaryKeyJoinColumns();
        while (stream.hasNext()) {
            ((OrmPrimaryKeyJoinColumn)stream.next()).validate(messages, reporter);
        }
    }

    protected void validateAgainstDatabase(List<IMessage> messages) {
        if (!this.hasResolvedCatalog()) {
            messages.add(DefaultJpaValidationMessages.buildMessage(1, "SECONDARY_TABLE_UNRESOLVED_CATALOG", new String[]{this.getCatalog(), this.getName()}, this, this.getCatalogTextRange()));
            return;
        }
        if (!this.hasResolvedSchema()) {
            messages.add(DefaultJpaValidationMessages.buildMessage(1, "SECONDARY_TABLE_UNRESOLVED_SCHEMA", new String[]{this.getSchema(), this.getName()}, this, this.getSchemaTextRange()));
            return;
        }
        if (!this.isResolved()) {
            messages.add(DefaultJpaValidationMessages.buildMessage(1, "SECONDARY_TABLE_UNRESOLVED_NAME", new String[]{this.getName()}, this, this.getNameTextRange()));
            return;
        }
    }

    class PrimaryKeyJoinColumnOwner
    implements OrmBaseJoinColumn.Owner {
        PrimaryKeyJoinColumnOwner() {
        }

        public TypeMapping getTypeMapping() {
            return GenericOrmSecondaryTable.this.getOrmEntity();
        }

        public Table getDbTable(String tableName) {
            return GenericOrmSecondaryTable.this.getDbTable();
        }

        public Table getReferencedColumnDbTable() {
            return this.getTypeMapping().getPrimaryDbTable();
        }

        public int joinColumnsSize() {
            return GenericOrmSecondaryTable.this.primaryKeyJoinColumnsSize();
        }

        public boolean isVirtual(BaseJoinColumn joinColumn) {
            return GenericOrmSecondaryTable.this.defaultPrimaryKeyJoinColumn == joinColumn;
        }

        public String getDefaultColumnName() {
            if (this.joinColumnsSize() != 1) {
                return null;
            }
            return GenericOrmSecondaryTable.this.getOrmEntity().getParentEntity().getPrimaryKeyColumnName();
        }

        public TextRange getValidationTextRange() {
            return null;
        }
    }
}

