/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jpt.core.internal.context.orm;

import java.util.List;
import org.eclipse.jpt.core.context.AttributeMapping;
import org.eclipse.jpt.core.context.JoinColumn;
import org.eclipse.jpt.core.context.JoiningStrategy;
import org.eclipse.jpt.core.context.RelationshipMapping;
import org.eclipse.jpt.core.context.orm.OrmJoinColumn;
import org.eclipse.jpt.core.context.orm.OrmJoinColumnEnabledRelationshipReference;
import org.eclipse.jpt.core.context.orm.OrmJoinColumnJoiningStrategy;
import org.eclipse.jpt.core.context.orm.OrmJoinTableEnabledRelationshipReference;
import org.eclipse.jpt.core.context.orm.OrmMappedByJoiningStrategy;
import org.eclipse.jpt.core.context.orm.OrmOneToOneMapping;
import org.eclipse.jpt.core.context.orm.OrmOneToOneRelationshipReference;
import org.eclipse.jpt.core.context.orm.OrmOwnableRelationshipReference;
import org.eclipse.jpt.core.context.orm.OrmPrimaryKeyJoinColumnJoiningStrategy;
import org.eclipse.jpt.core.context.orm.OrmRelationshipReference;
import org.eclipse.jpt.core.internal.context.orm.AbstractOrmRelationshipReference;
import org.eclipse.jpt.core.internal.context.orm.GenericOrmJoinColumnJoiningStrategy;
import org.eclipse.jpt.core.internal.context.orm.GenericOrmMappedByJoiningStrategy;
import org.eclipse.jpt.core.internal.context.orm.GenericOrmPrimaryKeyJoinColumnJoiningStrategy;
import org.eclipse.jpt.core.resource.orm.XmlOneToOne;
import org.eclipse.jpt.utility.internal.CollectionTools;
import org.eclipse.wst.validation.internal.provisional.core.IMessage;
import org.eclipse.wst.validation.internal.provisional.core.IReporter;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class GenericOrmOneToOneRelationshipReference
extends AbstractOrmRelationshipReference
implements OrmOneToOneRelationshipReference {
    protected OrmMappedByJoiningStrategy mappedByJoiningStrategy;
    protected OrmJoinColumnJoiningStrategy joinColumnJoiningStrategy;
    protected OrmPrimaryKeyJoinColumnJoiningStrategy primaryKeyJoinColumnJoiningStrategy;

    public GenericOrmOneToOneRelationshipReference(OrmOneToOneMapping parent, XmlOneToOne resource) {
        super(parent, resource);
    }

    @Override
    protected void initializeJoiningStrategies() {
        this.mappedByJoiningStrategy = this.buildMappedByJoiningStrategy();
        this.primaryKeyJoinColumnJoiningStrategy = this.buildPrimaryKeyJoinColumnJoiningStrategy();
        this.joinColumnJoiningStrategy = this.buildJoinColumnJoiningStrategy();
    }

    protected OrmMappedByJoiningStrategy buildMappedByJoiningStrategy() {
        return new GenericOrmMappedByJoiningStrategy(this, this.getResourceMapping());
    }

    protected OrmJoinColumnJoiningStrategy buildJoinColumnJoiningStrategy() {
        return new GenericOrmJoinColumnJoiningStrategy(this, this.getResourceMapping());
    }

    protected OrmPrimaryKeyJoinColumnJoiningStrategy buildPrimaryKeyJoinColumnJoiningStrategy() {
        return new GenericOrmPrimaryKeyJoinColumnJoiningStrategy(this, this.getResourceMapping());
    }

    @Override
    public void initializeOn(OrmRelationshipReference newRelationshipReference) {
        newRelationshipReference.initializeFromOwnableRelationshipReference(this);
        newRelationshipReference.initializeFromJoinColumnEnabledRelationshipReference(this);
    }

    @Override
    public void initializeFromOwnableRelationshipReference(OrmOwnableRelationshipReference oldRelationshipReference) {
        this.mappedByJoiningStrategy.setMappedByAttribute(oldRelationshipReference.getMappedByJoiningStrategy().getMappedByAttribute());
    }

    @Override
    public void initializeFromJoinColumnEnabledRelationshipReference(OrmJoinColumnEnabledRelationshipReference oldRelationshipReference) {
        int index = 0;
        for (JoinColumn joinColumn : CollectionTools.iterable(oldRelationshipReference.getJoinColumnJoiningStrategy().specifiedJoinColumns())) {
            OrmJoinColumn newJoinColumn = this.getJoinColumnJoiningStrategy().addSpecifiedJoinColumn(index++);
            newJoinColumn.initializeFrom(joinColumn);
        }
    }

    @Override
    public void initializeFromJoinTableEnabledRelationshipReference(OrmJoinTableEnabledRelationshipReference oldRelationshipReference) {
    }

    @Override
    public OrmOneToOneMapping getRelationshipMapping() {
        return (OrmOneToOneMapping)this.getParent();
    }

    @Override
    public XmlOneToOne getResourceMapping() {
        return this.getRelationshipMapping().getResourceAttributeMapping();
    }

    @Override
    public boolean isRelationshipOwner() {
        return this.mappedByJoiningStrategy.getMappedByAttribute() == null;
    }

    @Override
    public boolean isOwnedBy(RelationshipMapping mapping) {
        return this.mappedByJoiningStrategy.relationshipIsOwnedBy(mapping);
    }

    @Override
    protected JoiningStrategy calculatePredominantJoiningStrategy() {
        if (this.mappedByJoiningStrategy.getMappedByAttribute() != null) {
            return this.mappedByJoiningStrategy;
        }
        if (this.primaryKeyJoinColumnJoiningStrategy.primaryKeyJoinColumnsSize() > 0) {
            return this.primaryKeyJoinColumnJoiningStrategy;
        }
        return this.joinColumnJoiningStrategy;
    }

    @Override
    public OrmMappedByJoiningStrategy getMappedByJoiningStrategy() {
        return this.mappedByJoiningStrategy;
    }

    @Override
    public boolean usesMappedByJoiningStrategy() {
        return this.getPredominantJoiningStrategy() == this.mappedByJoiningStrategy;
    }

    @Override
    public void setMappedByJoiningStrategy() {
        this.mappedByJoiningStrategy.addStrategy();
        this.joinColumnJoiningStrategy.removeStrategy();
        this.primaryKeyJoinColumnJoiningStrategy.removeStrategy();
    }

    @Override
    public void unsetMappedByJoiningStrategy() {
        this.mappedByJoiningStrategy.removeStrategy();
    }

    @Override
    public boolean mayBeMappedBy(AttributeMapping mappedByMapping) {
        return mappedByMapping.getKey() == "oneToOne";
    }

    @Override
    public OrmJoinColumnJoiningStrategy getJoinColumnJoiningStrategy() {
        return this.joinColumnJoiningStrategy;
    }

    @Override
    public boolean usesJoinColumnJoiningStrategy() {
        return this.getPredominantJoiningStrategy() == this.joinColumnJoiningStrategy;
    }

    @Override
    public void setJoinColumnJoiningStrategy() {
        this.mappedByJoiningStrategy.removeStrategy();
        this.primaryKeyJoinColumnJoiningStrategy.removeStrategy();
    }

    @Override
    public void unsetJoinColumnJoiningStrategy() {
        this.joinColumnJoiningStrategy.removeStrategy();
    }

    @Override
    public boolean mayHaveDefaultJoinColumn() {
        return this.getMappedByJoiningStrategy().getMappedByAttribute() == null && this.getPrimaryKeyJoinColumnJoiningStrategy().primaryKeyJoinColumnsSize() == 0;
    }

    @Override
    public OrmPrimaryKeyJoinColumnJoiningStrategy getPrimaryKeyJoinColumnJoiningStrategy() {
        return this.primaryKeyJoinColumnJoiningStrategy;
    }

    @Override
    public boolean usesPrimaryKeyJoinColumnJoiningStrategy() {
        return this.getPredominantJoiningStrategy() == this.primaryKeyJoinColumnJoiningStrategy;
    }

    @Override
    public void setPrimaryKeyJoinColumnJoiningStrategy() {
        this.primaryKeyJoinColumnJoiningStrategy.addStrategy();
        this.mappedByJoiningStrategy.removeStrategy();
        this.joinColumnJoiningStrategy.removeStrategy();
    }

    @Override
    public void unsetPrimaryKeyJoinColumnJoiningStrategy() {
        this.primaryKeyJoinColumnJoiningStrategy.removeStrategy();
    }

    @Override
    public boolean mayHaveDefaultPrimaryKeyJoinColumn() {
        return false;
    }

    @Override
    protected void updateJoiningStrategies() {
        this.mappedByJoiningStrategy.update();
        this.primaryKeyJoinColumnJoiningStrategy.update();
        this.joinColumnJoiningStrategy.update();
    }

    @Override
    public void validate(List<IMessage> messages, IReporter reporter) {
        super.validate(messages, reporter);
        this.mappedByJoiningStrategy.validate(messages, reporter);
        this.primaryKeyJoinColumnJoiningStrategy.validate(messages, reporter);
        this.joinColumnJoiningStrategy.validate(messages, reporter);
    }
}

