/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jpt.core.internal.context.orm;

import java.util.List;
import org.eclipse.jpt.core.context.DiscriminatorType;
import org.eclipse.jpt.core.context.XmlContextNode;
import org.eclipse.jpt.core.context.orm.OrmDiscriminatorColumn;
import org.eclipse.jpt.core.internal.context.orm.AbstractOrmNamedColumn;
import org.eclipse.jpt.core.internal.validation.DefaultJpaValidationMessages;
import org.eclipse.jpt.core.resource.orm.OrmFactory;
import org.eclipse.jpt.core.resource.orm.XmlDiscriminatorColumn;
import org.eclipse.jpt.core.resource.orm.XmlEntity;
import org.eclipse.wst.validation.internal.provisional.core.IMessage;
import org.eclipse.wst.validation.internal.provisional.core.IReporter;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class GenericOrmDiscriminatorColumn
extends AbstractOrmNamedColumn<XmlDiscriminatorColumn>
implements OrmDiscriminatorColumn {
    protected DiscriminatorType specifiedDiscriminatorType;
    protected DiscriminatorType defaultDiscriminatorType;
    protected Integer specifiedLength;
    protected int defaultLength;
    protected XmlEntity entity;

    public GenericOrmDiscriminatorColumn(XmlContextNode parent, OrmDiscriminatorColumn.Owner owner) {
        super(parent, owner);
    }

    @Override
    public OrmDiscriminatorColumn.Owner getOwner() {
        return (OrmDiscriminatorColumn.Owner)super.getOwner();
    }

    @Override
    public DiscriminatorType getDiscriminatorType() {
        return this.getSpecifiedDiscriminatorType() == null ? this.getDefaultDiscriminatorType() : this.getSpecifiedDiscriminatorType();
    }

    @Override
    public DiscriminatorType getDefaultDiscriminatorType() {
        return this.defaultDiscriminatorType;
    }

    protected void setDefaultDiscriminatorType(DiscriminatorType discriminatorType) {
        DiscriminatorType old = this.defaultDiscriminatorType;
        this.defaultDiscriminatorType = discriminatorType;
        this.firePropertyChanged("defaultDiscriminatorType", (Object)old, (Object)discriminatorType);
    }

    @Override
    public DiscriminatorType getSpecifiedDiscriminatorType() {
        return this.specifiedDiscriminatorType;
    }

    @Override
    public void setSpecifiedDiscriminatorType(DiscriminatorType newSpecifiedDiscriminatorType) {
        DiscriminatorType oldDiscriminatorType = this.specifiedDiscriminatorType;
        this.specifiedDiscriminatorType = newSpecifiedDiscriminatorType;
        if (oldDiscriminatorType != newSpecifiedDiscriminatorType) {
            if (this.getResourceColumn() != null) {
                this.getResourceColumn().setDiscriminatorType(DiscriminatorType.toOrmResourceModel(newSpecifiedDiscriminatorType));
                if (this.getResourceColumn().isUnset()) {
                    this.removeResourceColumn();
                }
            } else if (newSpecifiedDiscriminatorType != null) {
                this.addResourceColumn();
                this.getResourceColumn().setDiscriminatorType(DiscriminatorType.toOrmResourceModel(newSpecifiedDiscriminatorType));
            }
        }
        this.firePropertyChanged("specifiedDiscriminatorType", (Object)oldDiscriminatorType, (Object)newSpecifiedDiscriminatorType);
    }

    protected void setSpecifiedDiscriminatorType_(DiscriminatorType newSpecifiedDiscriminatorType) {
        DiscriminatorType oldDiscriminatorType = this.specifiedDiscriminatorType;
        this.specifiedDiscriminatorType = newSpecifiedDiscriminatorType;
        this.firePropertyChanged("specifiedDiscriminatorType", (Object)oldDiscriminatorType, (Object)newSpecifiedDiscriminatorType);
    }

    @Override
    public int getLength() {
        return this.getSpecifiedLength() == null ? this.getDefaultLength() : this.getSpecifiedLength().intValue();
    }

    @Override
    public int getDefaultLength() {
        return this.defaultLength;
    }

    protected void setDefaultLength(int defaultLength) {
        int old = this.defaultLength;
        this.defaultLength = defaultLength;
        this.firePropertyChanged("defaultLength", old, defaultLength);
    }

    @Override
    public Integer getSpecifiedLength() {
        return this.specifiedLength;
    }

    @Override
    public void setSpecifiedLength(Integer newSpecifiedLength) {
        Integer oldSpecifiedLength = this.specifiedLength;
        this.specifiedLength = newSpecifiedLength;
        if (oldSpecifiedLength != newSpecifiedLength) {
            if (this.getResourceColumn() != null) {
                this.getResourceColumn().setLength(newSpecifiedLength);
                if (this.getResourceColumn().isUnset()) {
                    this.removeResourceColumn();
                }
            } else if (newSpecifiedLength != null) {
                this.addResourceColumn();
                this.getResourceColumn().setLength(newSpecifiedLength);
            }
        }
        this.firePropertyChanged("specifiedLength", oldSpecifiedLength, newSpecifiedLength);
    }

    protected void setSpecifiedLength_(Integer newSpecifiedLength) {
        Integer oldSpecifiedLength = this.specifiedLength;
        this.specifiedLength = newSpecifiedLength;
        this.firePropertyChanged("specifiedLength", oldSpecifiedLength, newSpecifiedLength);
    }

    @Override
    protected String getOwningTableName() {
        return this.getOwner().getTypeMapping().getPrimaryTableName();
    }

    @Override
    public XmlDiscriminatorColumn getResourceColumn() {
        return this.entity.getDiscriminatorColumn();
    }

    @Override
    protected void addResourceColumn() {
        this.entity.setDiscriminatorColumn(OrmFactory.eINSTANCE.createXmlDiscriminatorColumn());
    }

    @Override
    protected void removeResourceColumn() {
        this.entity.setDiscriminatorColumn(null);
    }

    @Override
    public boolean isResourceSpecified() {
        return this.getResourceColumn() != null;
    }

    @Override
    public void initialize(XmlEntity entity) {
        this.entity = entity;
        this.initialize(this.getResourceColumn());
    }

    @Override
    public void update(XmlEntity entity) {
        this.entity = entity;
        this.update(this.getResourceColumn());
    }

    @Override
    protected void initialize(XmlDiscriminatorColumn column) {
        super.initialize(column);
        this.defaultDiscriminatorType = this.buildDefaultDiscriminatorType();
        this.defaultLength = this.buildDefaultLength();
        this.specifiedLength = this.getResourceLength(column);
        this.specifiedDiscriminatorType = this.getResourceDiscriminatorType(column);
    }

    @Override
    protected void update(XmlDiscriminatorColumn column) {
        this.setSpecifiedName_(this.getResourceColumnName(column));
        this.setColumnDefinition_(this.getResourceColumnDefinition(column));
        this.setSpecifiedLength_(this.getResourceLength(column));
        this.setSpecifiedDiscriminatorType_(this.getResourceDiscriminatorType(column));
    }

    @Override
    public void postUpdate() {
        super.postUpdate();
        this.setDefaultName(this.getOwnerDefaultColumnName());
        this.setDefaultDiscriminatorType(this.buildDefaultDiscriminatorType());
        this.setDefaultLength(this.buildDefaultLength());
    }

    protected Integer getResourceLength(XmlDiscriminatorColumn column) {
        return column == null ? null : column.getLength();
    }

    protected DiscriminatorType getResourceDiscriminatorType(XmlDiscriminatorColumn column) {
        return column == null ? null : DiscriminatorType.fromOrmResourceModel(column.getDiscriminatorType());
    }

    protected int buildDefaultLength() {
        return this.getOwner().getDefaultLength();
    }

    protected DiscriminatorType buildDefaultDiscriminatorType() {
        return this.getOwner().getDefaultDiscriminatorType();
    }

    @Override
    public void validate(List<IMessage> messages, IReporter reporter) {
        super.validate(messages, reporter);
        if (this.connectionProfileIsActive() && !this.isResolved()) {
            messages.add(DefaultJpaValidationMessages.buildMessage(1, "DISCRIMINATOR_COLUMN_UNRESOLVED_NAME", new String[]{this.getName()}, this, this.getNameTextRange()));
        }
    }
}

