/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jpt.core.internal.context.orm;

import java.util.ArrayList;
import java.util.Comparator;
import java.util.Iterator;
import java.util.List;
import java.util.ListIterator;
import org.eclipse.core.runtime.content.IContentType;
import org.eclipse.jpt.core.JpaStructureNode;
import org.eclipse.jpt.core.JptCorePlugin;
import org.eclipse.jpt.core.MappingKeys;
import org.eclipse.jpt.core.context.AccessType;
import org.eclipse.jpt.core.context.PersistentAttribute;
import org.eclipse.jpt.core.context.PersistentType;
import org.eclipse.jpt.core.context.java.JavaAttributeMapping;
import org.eclipse.jpt.core.context.java.JavaPersistentAttribute;
import org.eclipse.jpt.core.context.java.JavaPersistentType;
import org.eclipse.jpt.core.context.orm.EntityMappings;
import org.eclipse.jpt.core.context.orm.OrmAttributeMapping;
import org.eclipse.jpt.core.context.orm.OrmPersistentAttribute;
import org.eclipse.jpt.core.context.orm.OrmPersistentType;
import org.eclipse.jpt.core.context.orm.OrmTypeMapping;
import org.eclipse.jpt.core.internal.context.AbstractXmlContextNode;
import org.eclipse.jpt.core.internal.validation.DefaultJpaValidationMessages;
import org.eclipse.jpt.core.resource.java.JavaResourcePersistentAttribute;
import org.eclipse.jpt.core.resource.java.JavaResourcePersistentType;
import org.eclipse.jpt.core.resource.orm.Attributes;
import org.eclipse.jpt.core.resource.orm.XmlAttributeMapping;
import org.eclipse.jpt.core.resource.orm.XmlTypeMapping;
import org.eclipse.jpt.core.utility.TextRange;
import org.eclipse.jpt.utility.internal.ClassTools;
import org.eclipse.jpt.utility.internal.CollectionTools;
import org.eclipse.jpt.utility.internal.HashBag;
import org.eclipse.jpt.utility.internal.iterators.ChainIterator;
import org.eclipse.jpt.utility.internal.iterators.CloneListIterator;
import org.eclipse.jpt.utility.internal.iterators.CompositeIterator;
import org.eclipse.jpt.utility.internal.iterators.CompositeListIterator;
import org.eclipse.jpt.utility.internal.iterators.EmptyListIterator;
import org.eclipse.jpt.utility.internal.iterators.FilteringIterator;
import org.eclipse.jpt.utility.internal.iterators.TransformationIterator;
import org.eclipse.wst.validation.internal.provisional.core.IMessage;
import org.eclipse.wst.validation.internal.provisional.core.IReporter;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class AbstractOrmPersistentType
extends AbstractXmlContextNode
implements OrmPersistentType {
    protected final List<OrmPersistentAttribute> specifiedPersistentAttributes = new ArrayList<OrmPersistentAttribute>();
    protected final List<OrmPersistentAttribute> virtualPersistentAttributes = new ArrayList<OrmPersistentAttribute>();
    protected AccessType defaultAccess;
    protected AccessType specifiedAccess;
    protected OrmTypeMapping typeMapping;
    protected PersistentType parentPersistentType;
    protected JavaPersistentType javaPersistentType;

    protected AbstractOrmPersistentType(EntityMappings parent, XmlTypeMapping resourceMapping) {
        super(parent);
        this.typeMapping = this.buildTypeMapping(resourceMapping);
        this.specifiedAccess = this.getResourceAccess();
        this.defaultAccess = this.buildDefaultAccess();
        this.javaPersistentType = this.buildJavaPersistentType();
        this.parentPersistentType = this.buildParentPersistentType();
        this.initializePersistentAttributes();
    }

    @Override
    public EntityMappings getParent() {
        return (EntityMappings)super.getParent();
    }

    protected EntityMappings getEntityMappings() {
        return this.getParent();
    }

    @Override
    public IContentType getContentType() {
        return this.getEntityMappings().getContentType();
    }

    @Override
    public String getDefaultPackage() {
        return this.getEntityMappings().getDefaultPersistentTypePackage();
    }

    @Override
    public boolean isDefaultMetadataComplete() {
        return this.getEntityMappings().isDefaultPersistentTypeMetadataComplete();
    }

    @Override
    public String getId() {
        return "org.eclipse.jpt.core.orm.persistentType";
    }

    @Override
    public boolean isFor(String typeName) {
        String className = this.getName();
        if (className == null) {
            return false;
        }
        if (className.equals(typeName)) {
            return true;
        }
        String defaultPackage = this.getDefaultPackage();
        if (defaultPackage == null) {
            return false;
        }
        return (String.valueOf(defaultPackage) + '.' + className).equals(typeName);
    }

    protected OrmTypeMapping buildTypeMapping(XmlTypeMapping resourceMapping) {
        return this.getJpaPlatform().buildOrmTypeMappingFromMappingKey(this, resourceMapping);
    }

    @Override
    public OrmTypeMapping getMapping() {
        return this.typeMapping;
    }

    @Override
    public AccessType getOverridePersistentTypeAccess() {
        AccessType accessType;
        if (this.getSpecifiedAccess() != null) {
            return this.getSpecifiedAccess();
        }
        PersistentType ppt = this.getParentPersistentType();
        if (ppt instanceof OrmPersistentType && (accessType = ((OrmPersistentType)ppt).getSpecifiedAccess()) != null) {
            return accessType;
        }
        if (this.getMapping().isMetadataComplete() && (accessType = this.getOwnerDefaultAccess()) != null) {
            return accessType;
        }
        return null;
    }

    @Override
    public AccessType getDefaultPersistentTypeAccess() {
        AccessType accessType;
        PersistentType ppt = this.getParentPersistentType();
        if (ppt instanceof OrmPersistentType && (accessType = ((OrmPersistentType)ppt).getDefaultAccess()) != null) {
            return accessType;
        }
        return this.getOwnerDefaultAccess();
    }

    @Override
    public void setMappingKey(String newMappingKey) {
        if (this.getMappingKey() == newMappingKey) {
            return;
        }
        OrmTypeMapping oldMapping = this.getMapping();
        XmlTypeMapping resourceTypeMapping = this.getJpaPlatform().buildOrmResourceTypeMapping(newMappingKey, this.getContentType());
        this.typeMapping = this.buildTypeMapping(resourceTypeMapping);
        this.getEntityMappings().changeMapping(this, oldMapping, this.typeMapping);
        this.firePropertyChanged("mapping", oldMapping, this.typeMapping);
    }

    @Override
    public Iterator<PersistentType> inheritanceHierarchy() {
        return new ChainIterator<PersistentType>((PersistentType)this){

            protected PersistentType nextLink(PersistentType pt) {
                return pt.getParentPersistentType();
            }
        };
    }

    @Override
    public Iterator<PersistentType> ancestors() {
        return new ChainIterator<PersistentType>(this.getParentPersistentType()){

            protected PersistentType nextLink(PersistentType pt) {
                return pt.getParentPersistentType();
            }
        };
    }

    @Override
    public PersistentType getParentPersistentType() {
        return this.parentPersistentType;
    }

    public void setParentPersistentType(PersistentType newParentPersistentType) {
        if (this.attributeValueHasNotChanged(this.parentPersistentType, newParentPersistentType)) {
            return;
        }
        PersistentType oldParentPersistentType = this.parentPersistentType;
        this.parentPersistentType = newParentPersistentType;
        this.firePropertyChanged("parentPersistentType", oldParentPersistentType, newParentPersistentType);
    }

    @Override
    public AccessType getDefaultAccess() {
        return this.defaultAccess;
    }

    protected void setDefaultAccess(AccessType newDefaultAccess) {
        AccessType oldDefaultAccess = this.defaultAccess;
        this.defaultAccess = newDefaultAccess;
        this.firePropertyChanged("defaultAccess", (Object)oldDefaultAccess, (Object)newDefaultAccess);
    }

    @Override
    public AccessType getSpecifiedAccess() {
        return this.specifiedAccess;
    }

    @Override
    public void setSpecifiedAccess(AccessType newSpecifiedAccess) {
        AccessType oldSpecifiedAccess = this.specifiedAccess;
        this.specifiedAccess = newSpecifiedAccess;
        this.getResourceTypeMapping().setAccess(AccessType.toOrmResourceModel(newSpecifiedAccess));
        this.firePropertyChanged("specifiedAccess", (Object)oldSpecifiedAccess, (Object)newSpecifiedAccess);
    }

    @Override
    public AccessType getAccess() {
        return this.getSpecifiedAccess() == null ? this.getDefaultAccess() : this.getSpecifiedAccess();
    }

    @Override
    public AccessType getOwnerOverrideAccess() {
        return this.getEntityMappings().getOverridePersistentTypeAccess();
    }

    @Override
    public AccessType getOwnerDefaultAccess() {
        return this.getEntityMappings().getDefaultPersistentTypeAccess();
    }

    @Override
    public void changeMapping(OrmPersistentAttribute ormPersistentAttribute, OrmAttributeMapping oldMapping, OrmAttributeMapping newMapping) {
        int sourceIndex = this.specifiedPersistentAttributes.indexOf(ormPersistentAttribute);
        this.specifiedPersistentAttributes.remove(sourceIndex);
        oldMapping.removeFromResourceModel(this.getResourceAttributes());
        int targetIndex = this.insertionIndex(ormPersistentAttribute);
        this.specifiedPersistentAttributes.add(targetIndex, ormPersistentAttribute);
        newMapping.addToResourceModel(this.getResourceAttributes());
        oldMapping.initializeOn(newMapping);
        this.fireItemMoved("specifiedAttributes", targetIndex, sourceIndex);
    }

    @Override
    public void makePersistentAttributeVirtual(OrmPersistentAttribute ormPersistentAttribute) {
        if (ormPersistentAttribute.isVirtual()) {
            throw new IllegalStateException("Attribute is already virtual");
        }
        JavaPersistentAttribute javaPersistentAttribute = ormPersistentAttribute.getJavaPersistentAttribute();
        OrmPersistentAttribute virtualPersistentAttribute = null;
        if (javaPersistentAttribute != null) {
            virtualPersistentAttribute = this.addVirtualPersistentAttribute(javaPersistentAttribute.getResourcePersistentAttribute());
        }
        this.removeSpecifiedPersistentAttribute(ormPersistentAttribute);
        if (virtualPersistentAttribute != null) {
            this.fireItemAdded("virtualAttributes", this.virtualAttributesSize() - 1, virtualPersistentAttribute);
        }
    }

    @Override
    public void makePersistentAttributeSpecified(OrmPersistentAttribute ormPersistentAttribute) {
        this.makePersistentAttributeSpecified(ormPersistentAttribute, ormPersistentAttribute.getMappingKey());
    }

    @Override
    public void makePersistentAttributeSpecified(OrmPersistentAttribute ormPersistentAttribute, String mappingKey) {
        if (!ormPersistentAttribute.isVirtual()) {
            throw new IllegalStateException("Attribute is already specified");
        }
        if (mappingKey == MappingKeys.NULL_ATTRIBUTE_MAPPING_KEY) {
            throw new IllegalStateException("Use makePersistentAttributeSpecified(OrmPersistentAttribute, String) instead and specify a mapping type");
        }
        Attributes resourceAttributes = this.getResourceAttributes();
        if (resourceAttributes == null) {
            resourceAttributes = this.createResourceAttributes();
            this.getMapping().getResourceTypeMapping().setAttributes(resourceAttributes);
        }
        XmlAttributeMapping resourceMapping = this.getJpaPlatform().buildOrmResourceAttributeMapping(mappingKey, this.getContentType());
        OrmPersistentAttribute newPersistentAttribute = this.buildSpecifiedOrmPersistentAttribute(resourceMapping);
        int insertionIndex = this.insertionIndex(newPersistentAttribute);
        this.specifiedPersistentAttributes.add(insertionIndex, newPersistentAttribute);
        newPersistentAttribute.getMapping().addToResourceModel(resourceAttributes);
        int removalIndex = this.virtualPersistentAttributes.indexOf(ormPersistentAttribute);
        this.virtualPersistentAttributes.remove(ormPersistentAttribute);
        newPersistentAttribute.getSpecifiedMapping().setName(ormPersistentAttribute.getName());
        if (ormPersistentAttribute.getJavaPersistentAttribute().getSpecifiedAccess() != null) {
            newPersistentAttribute.setSpecifiedAccess(ormPersistentAttribute.getJavaPersistentAttribute().getSpecifiedAccess());
        }
        this.fireItemAdded("specifiedAttributes", insertionIndex, newPersistentAttribute);
        this.fireItemRemoved("virtualAttributes", removalIndex, ormPersistentAttribute);
    }

    protected XmlTypeMapping getResourceTypeMapping() {
        return this.typeMapping.getResourceTypeMapping();
    }

    protected Attributes getResourceAttributes() {
        return this.getResourceTypeMapping().getAttributes();
    }

    protected abstract Attributes createResourceAttributes();

    @Override
    public Iterator<String> allAttributeNames() {
        return this.attributeNames(this.allAttributes());
    }

    @Override
    public Iterator<PersistentAttribute> allAttributes() {
        return new CompositeIterator((Iterator)new TransformationIterator<PersistentType, Iterator<PersistentAttribute>>(this.inheritanceHierarchy()){

            protected Iterator<PersistentAttribute> transform(PersistentType pt) {
                return pt.attributes();
            }
        });
    }

    protected Iterator<OrmPersistentAttribute> attributesNamed(final String attributeName) {
        return new FilteringIterator<OrmPersistentAttribute, OrmPersistentAttribute>(this.attributes()){

            protected boolean accept(OrmPersistentAttribute o) {
                if (attributeName == null && o.getName() == null) {
                    return true;
                }
                return attributeName != null && attributeName.equals(o.getName());
            }
        };
    }

    @Override
    public OrmPersistentAttribute getAttributeNamed(String attributeName) {
        Iterator<OrmPersistentAttribute> stream = this.attributesNamed(attributeName);
        return stream.hasNext() ? stream.next() : null;
    }

    @Override
    public Iterator<String> attributeNames() {
        return this.attributeNames(this.attributes());
    }

    protected Iterator<String> attributeNames(Iterator<? extends PersistentAttribute> attrs) {
        return new TransformationIterator<PersistentAttribute, String>(attrs){

            protected String transform(PersistentAttribute attribute) {
                return attribute.getName();
            }
        };
    }

    protected OrmPersistentAttribute getSpecifiedAttributeFor(JavaResourcePersistentAttribute jrpa) {
        for (OrmPersistentAttribute persistentAttribute : CollectionTools.iterable(this.specifiedAttributes())) {
            if (persistentAttribute.getJavaPersistentAttribute() == null || !jrpa.equals(persistentAttribute.getJavaPersistentAttribute().getResourcePersistentAttribute())) continue;
            return persistentAttribute;
        }
        return null;
    }

    @Override
    public ListIterator<OrmPersistentAttribute> attributes() {
        return new CompositeListIterator(new ListIterator[]{this.specifiedAttributes(), this.virtualAttributes()});
    }

    @Override
    public int attributesSize() {
        return this.specifiedAttributesSize() + this.virtualAttributesSize();
    }

    @Override
    public ListIterator<OrmPersistentAttribute> specifiedAttributes() {
        return new CloneListIterator(this.specifiedPersistentAttributes);
    }

    @Override
    public int specifiedAttributesSize() {
        return this.specifiedPersistentAttributes.size();
    }

    @Override
    public ListIterator<OrmPersistentAttribute> virtualAttributes() {
        return new CloneListIterator(this.virtualPersistentAttributes);
    }

    @Override
    public int virtualAttributesSize() {
        return this.virtualPersistentAttributes.size();
    }

    protected void addVirtualPersistentAttribute(OrmPersistentAttribute ormPersistentAttribute) {
        this.addItemToList(ormPersistentAttribute, this.virtualPersistentAttributes, "virtualAttributes");
    }

    protected void removeVirtualPersistentAttribute(OrmPersistentAttribute ormPersistentAttribute) {
        this.removeItemFromList(ormPersistentAttribute, this.virtualPersistentAttributes, "virtualAttributes");
    }

    protected void moveVirtualPersistentAttribute_(int index, OrmPersistentAttribute attribute) {
        this.moveItemInList(index, this.virtualPersistentAttributes.indexOf(attribute), this.virtualPersistentAttributes, "virtualAttributes");
    }

    @Override
    public boolean containsVirtualPersistentAttribute(OrmPersistentAttribute ormPersistentAttribute) {
        return this.virtualPersistentAttributes.contains(ormPersistentAttribute);
    }

    @Override
    public OrmPersistentAttribute addSpecifiedPersistentAttribute(String mappingKey, String attributeName) {
        Attributes resourceAttributes = this.getResourceAttributes();
        if (resourceAttributes == null) {
            resourceAttributes = this.createResourceAttributes();
            this.getMapping().getResourceTypeMapping().setAttributes(resourceAttributes);
        }
        XmlAttributeMapping resourceMapping = this.getJpaPlatform().buildOrmResourceAttributeMapping(mappingKey, this.getContentType());
        OrmPersistentAttribute persistentAttribute = this.buildSpecifiedOrmPersistentAttribute(resourceMapping);
        int index = this.insertionIndex(persistentAttribute);
        this.specifiedPersistentAttributes.add(index, persistentAttribute);
        persistentAttribute.getMapping().addToResourceModel(resourceAttributes);
        persistentAttribute.getSpecifiedMapping().setName(attributeName);
        this.fireItemAdded("specifiedAttributes", index, persistentAttribute);
        return persistentAttribute;
    }

    protected int insertionIndex(OrmPersistentAttribute persistentAttribute) {
        return CollectionTools.insertionIndexOf(this.specifiedPersistentAttributes, (Object)persistentAttribute, this.buildMappingComparator());
    }

    protected Comparator<OrmPersistentAttribute> buildMappingComparator() {
        return new Comparator<OrmPersistentAttribute>(){

            @Override
            public int compare(OrmPersistentAttribute o1, OrmPersistentAttribute o2) {
                int o2Sequence;
                int o1Sequence = o1.getMapping().getXmlSequence();
                if (o1Sequence < (o2Sequence = o2.getMapping().getXmlSequence())) {
                    return -1;
                }
                if (o1Sequence == o2Sequence) {
                    return 0;
                }
                return 1;
            }
        };
    }

    protected void removeSpecifiedPersistentAttribute_(OrmPersistentAttribute ormPersistentAttribute) {
        this.removeItemFromList(ormPersistentAttribute, this.specifiedPersistentAttributes, "specifiedAttributes");
    }

    protected void moveSpecifiedPersistentAttribute_(int index, OrmPersistentAttribute attribute) {
        this.moveItemInList(index, this.specifiedPersistentAttributes.indexOf(attribute), this.specifiedPersistentAttributes, "specifiedAttributes");
    }

    @Override
    public void removeSpecifiedPersistentAttribute(OrmPersistentAttribute ormPersistentAttribute) {
        int index = this.specifiedPersistentAttributes.indexOf(ormPersistentAttribute);
        this.specifiedPersistentAttributes.remove(ormPersistentAttribute);
        ormPersistentAttribute.getMapping().removeFromResourceModel(this.getResourceAttributes());
        if (this.getResourceAttributes().isUnset()) {
            this.typeMapping.getResourceTypeMapping().setAttributes(null);
        }
        this.fireItemRemoved("specifiedAttributes", index, ormPersistentAttribute);
    }

    @Override
    public String getName() {
        return this.getMapping().getClass_();
    }

    @Override
    public String getShortName() {
        String className = this.getName();
        return className == null ? null : ClassTools.shortNameForClassNamed((String)className);
    }

    @Override
    public void classChanged(String oldClass, String newClass) {
        this.firePropertyChanged("name", oldClass, newClass);
    }

    @Override
    public boolean isMapped() {
        return true;
    }

    @Override
    public String getMappingKey() {
        return this.getMapping().getKey();
    }

    @Override
    public JavaPersistentType getJavaPersistentType() {
        return this.javaPersistentType;
    }

    protected void setJavaPersistentType(JavaPersistentType newJavaPersistentType) {
        JavaPersistentType oldJavaPersistentType = this.javaPersistentType;
        this.javaPersistentType = newJavaPersistentType;
        this.firePropertyChanged("javaPersistentType", oldJavaPersistentType, newJavaPersistentType);
    }

    protected AccessType getResourceAccess() {
        return AccessType.fromOrmResourceModel(this.getResourceTypeMapping().getAccess());
    }

    protected AccessType buildDefaultAccess() {
        AccessType access;
        if (!this.getMapping().isMetadataComplete() && this.javaPersistentType != null) {
            if (this.javaPersistentTypeHasSpecifiedAccess()) {
                return this.javaPersistentType.getAccess();
            }
            if (this.getParentPersistentType() != null) {
                return this.getParentPersistentType().getAccess();
            }
        }
        return (access = this.getMappingFileRoot().getAccess()) != null ? access : AccessType.FIELD;
    }

    protected boolean javaPersistentTypeHasSpecifiedAccess() {
        return this.javaPersistentType.getSpecifiedAccess() != null || this.javaPersistentType.hasAnyAttributePersistenceAnnotations();
    }

    protected JavaPersistentType buildJavaPersistentType() {
        JavaResourcePersistentType jrpt = this.getJavaResourcePersistentType();
        return jrpt == null ? null : this.buildJavaPersistentType(jrpt);
    }

    protected JavaResourcePersistentType getJavaResourcePersistentType() {
        String className = this.getName();
        if (className == null) {
            return null;
        }
        JavaResourcePersistentType jrpt = this.getJavaResourcePersistentType(className = className.replace('$', '.'));
        if (jrpt != null) {
            return jrpt;
        }
        String defaultPackage = this.getDefaultPackage();
        if (defaultPackage == null) {
            return null;
        }
        return this.getJavaResourcePersistentType(String.valueOf(defaultPackage) + '.' + className);
    }

    protected JavaResourcePersistentType getJavaResourcePersistentType(String className) {
        return this.getJpaProject().getJavaResourcePersistentType(className);
    }

    protected JavaPersistentType buildJavaPersistentType(JavaResourcePersistentType jrpt) {
        return this.getJpaFactory().buildJavaPersistentType(this, jrpt);
    }

    protected void initializePersistentAttributes() {
        this.initializeSpecifiedPersistentAttributes();
        this.initializeVirtualPersistentAttributes();
    }

    protected OrmPersistentAttribute buildSpecifiedOrmPersistentAttribute(XmlAttributeMapping resourceMapping) {
        return this.buildOrmPersistentAttribute(this.buildSpecifiedPersistentAttributeOwner(), resourceMapping);
    }

    protected OrmPersistentAttribute.Owner buildSpecifiedPersistentAttributeOwner() {
        return new SpecifiedPersistentAttributeOwner();
    }

    protected AccessType getAccess(OrmPersistentAttribute ormPersistentAttribute) {
        return this.getAccess();
    }

    protected JavaPersistentAttribute buildJavaPersistentAttribute(JavaResourcePersistentAttribute jrpa) {
        return this.getJpaFactory().buildJavaPersistentAttribute(this, jrpa);
    }

    protected OrmPersistentAttribute buildVirtualOrmPersistentAttribute(JavaAttributeMapping javaAttributeMapping, XmlAttributeMapping resourceMapping) {
        return this.buildOrmPersistentAttribute(this.buildVirtualPersistentAttributeOwner(javaAttributeMapping.getPersistentAttribute()), resourceMapping);
    }

    protected OrmPersistentAttribute buildOrmPersistentAttribute(OrmPersistentAttribute.Owner owner, XmlAttributeMapping resourceMapping) {
        return this.getJpaFactory().buildOrmPersistentAttribute(this, owner, resourceMapping);
    }

    protected OrmPersistentAttribute.Owner buildVirtualPersistentAttributeOwner(final JavaPersistentAttribute javaPersistentAttribute) {
        return new OrmPersistentAttribute.Owner(){

            public JavaPersistentAttribute findJavaPersistentAttribute(OrmPersistentAttribute ormPersistentAttribute) {
                return javaPersistentAttribute;
            }

            public void updateJavaPersistentAttribute() {
                javaPersistentAttribute.update();
            }
        };
    }

    protected void initializeSpecifiedPersistentAttributes() {
        Attributes attributes = this.getResourceAttributes();
        if (attributes == null) {
            return;
        }
        for (XmlAttributeMapping resourceMapping : attributes.getAttributeMappings()) {
            this.addSpecifiedPersistentAttribute(resourceMapping);
        }
    }

    protected void initializeVirtualPersistentAttributes() {
        Iterator<JavaResourcePersistentAttribute> javaResourceAttributes = this.javaPersistentAttributes();
        while (javaResourceAttributes.hasNext()) {
            JavaResourcePersistentAttribute javaResourceAttribute = javaResourceAttributes.next();
            if (this.getSpecifiedAttributeFor(javaResourceAttribute) != null) continue;
            this.addVirtualPersistentAttribute(javaResourceAttribute);
        }
    }

    protected Iterator<JavaResourcePersistentAttribute> javaPersistentAttributes() {
        return this.javaPersistentType == null ? EmptyListIterator.instance() : this.javaPersistentAttributes(this.javaPersistentType.getResourcePersistentType());
    }

    protected Iterator<JavaResourcePersistentAttribute> javaPersistentAttributes(JavaResourcePersistentType resourcePersistentType) {
        return this.getAccess() == AccessType.PROPERTY ? resourcePersistentType.persistableProperties() : resourcePersistentType.persistableFields();
    }

    protected PersistentType buildParentPersistentType() {
        return this.javaPersistentType == null ? null : this.javaPersistentType.getParentPersistentType();
    }

    @Override
    public void update() {
        this.setSpecifiedAccess(this.getResourceAccess());
        this.setDefaultAccess(this.buildDefaultAccess());
        this.getMapping().update();
        this.updateJavaPersistentType();
        this.updateParentPersistentType();
        this.updatePersistentAttributes();
    }

    protected void updateJavaPersistentType() {
        JavaResourcePersistentType jrpt = this.getJavaResourcePersistentType();
        if (jrpt == null) {
            this.setJavaPersistentType(null);
        } else if (this.javaPersistentType == null) {
            this.setJavaPersistentType(this.buildJavaPersistentType(jrpt));
        } else {
            this.javaPersistentType.update(jrpt);
        }
    }

    protected void updateParentPersistentType() {
        PersistentType ppt = this.buildParentPersistentType();
        if (ppt == null || CollectionTools.contains(ppt.inheritanceHierarchy(), (Object)this)) {
            this.setParentPersistentType(null);
        } else {
            this.setParentPersistentType(ppt);
        }
    }

    protected void updatePersistentAttributes() {
        this.updateSpecifiedPersistentAttributes();
        this.updateVirtualPersistentAttributes();
    }

    protected void updateSpecifiedPersistentAttributes() {
        Attributes attributes = this.getResourceAttributes();
        HashBag contextAttributesToRemove = CollectionTools.collection(this.specifiedAttributes());
        ArrayList<OrmPersistentAttribute> contextAttributesToUpdate = new ArrayList<OrmPersistentAttribute>();
        int resourceIndex = 0;
        if (attributes != null) {
            for (XmlAttributeMapping resourceMapping : attributes.getAttributeMappings()) {
                boolean contextAttributeFound = false;
                for (OrmPersistentAttribute contextAttribute : contextAttributesToRemove) {
                    if (contextAttribute.getMapping().getResourceAttributeMapping() != resourceMapping) continue;
                    this.moveSpecifiedPersistentAttribute_(resourceIndex, contextAttribute);
                    contextAttributesToRemove.remove(contextAttribute);
                    contextAttributesToUpdate.add(contextAttribute);
                    contextAttributeFound = true;
                    break;
                }
                if (!contextAttributeFound) {
                    OrmPersistentAttribute ormPersistentAttribute = this.addSpecifiedPersistentAttribute(resourceMapping);
                    this.fireItemAdded("specifiedAttributes", this.specifiedAttributesSize(), ormPersistentAttribute);
                }
                ++resourceIndex;
            }
        }
        for (OrmPersistentAttribute contextAttribute : contextAttributesToRemove) {
            this.removeSpecifiedPersistentAttribute_(contextAttribute);
        }
        for (OrmPersistentAttribute contextAttribute : contextAttributesToUpdate) {
            contextAttribute.update();
        }
    }

    protected OrmPersistentAttribute addSpecifiedPersistentAttribute(XmlAttributeMapping resourceMapping) {
        OrmPersistentAttribute ormPersistentAttribute = this.buildSpecifiedOrmPersistentAttribute(resourceMapping);
        this.specifiedPersistentAttributes.add(ormPersistentAttribute);
        return ormPersistentAttribute;
    }

    protected void updateVirtualPersistentAttributes() {
        HashBag contextAttributesToRemove = CollectionTools.collection(this.virtualAttributes());
        ArrayList<OrmPersistentAttribute> contextAttributesToUpdate = new ArrayList<OrmPersistentAttribute>();
        int resourceIndex = 0;
        Iterator<JavaResourcePersistentAttribute> javaResourceAttributes = this.javaPersistentAttributes();
        for (JavaResourcePersistentAttribute javaResourceAttribute : CollectionTools.iterable(javaResourceAttributes)) {
            OrmPersistentAttribute specifiedAttribute = this.getSpecifiedAttributeFor(javaResourceAttribute);
            if (specifiedAttribute != null) continue;
            JavaPersistentAttribute javaAttribute = this.getJpaFactory().buildJavaPersistentAttribute(this, javaResourceAttribute);
            JavaAttributeMapping javaAttributeMapping = javaAttribute.getMapping();
            if (this.getMapping().isMetadataComplete()) {
                javaAttributeMapping = javaAttribute.getDefaultMapping();
            }
            boolean contextAttributeFound = false;
            for (OrmPersistentAttribute contextAttribute : contextAttributesToRemove) {
                JavaPersistentAttribute javaPersistentAttribute = contextAttribute.getJavaPersistentAttribute();
                if (javaPersistentAttribute.getResourcePersistentAttribute() != javaResourceAttribute || contextAttribute.getMappingKey() != javaAttributeMapping.getKey()) continue;
                this.moveVirtualPersistentAttribute_(resourceIndex, contextAttribute);
                contextAttributesToRemove.remove(contextAttribute);
                contextAttributesToUpdate.add(contextAttribute);
                contextAttributeFound = true;
                break;
            }
            if (!contextAttributeFound) {
                OrmPersistentAttribute virtualPersistentAttribute = this.addVirtualPersistentAttribute(javaAttributeMapping);
                this.fireItemAdded("virtualAttributes", this.virtualAttributesSize() - 1, virtualPersistentAttribute);
            }
            ++resourceIndex;
        }
        for (OrmPersistentAttribute contextAttribute : contextAttributesToRemove) {
            this.removeVirtualPersistentAttribute(contextAttribute);
        }
        for (OrmPersistentAttribute contextAttribute : contextAttributesToUpdate) {
            contextAttribute.update();
        }
    }

    protected OrmPersistentAttribute addVirtualPersistentAttribute(JavaResourcePersistentAttribute resourceAttribute) {
        JavaPersistentAttribute javaAttribute = this.getJpaFactory().buildJavaPersistentAttribute(this, resourceAttribute);
        JavaAttributeMapping javaAttributeMapping = javaAttribute.getMapping();
        if (this.getMapping().isMetadataComplete()) {
            javaAttributeMapping = javaAttribute.getDefaultMapping();
        }
        return this.addVirtualPersistentAttribute(javaAttributeMapping);
    }

    protected OrmPersistentAttribute addVirtualPersistentAttribute(JavaAttributeMapping javaAttributeMapping) {
        XmlAttributeMapping resourceMapping = this.getJpaPlatform().buildVirtualOrmResourceMappingFromMappingKey(javaAttributeMapping.getKey(), this.getMapping(), javaAttributeMapping);
        OrmPersistentAttribute virtualPersistentAttribute = this.buildVirtualOrmPersistentAttribute(javaAttributeMapping, resourceMapping);
        this.virtualPersistentAttributes.add(virtualPersistentAttribute);
        return virtualPersistentAttribute;
    }

    @Override
    public PersistentAttribute resolveAttribute(String attributeName) {
        Iterator<OrmPersistentAttribute> attributes = this.attributesNamed(attributeName);
        if (attributes.hasNext()) {
            OrmPersistentAttribute attribute = attributes.next();
            return attributes.hasNext() ? null : attribute;
        }
        if (this.getParentPersistentType() != null) {
            return this.getParentPersistentType().resolveAttribute(attributeName);
        }
        return null;
    }

    @Override
    public void postUpdate() {
        super.postUpdate();
        if (this.javaPersistentType != null) {
            this.javaPersistentType.postUpdate();
        }
        this.getMapping().postUpdate();
    }

    @Override
    public JpaStructureNode getStructureNode(int textOffset) {
        for (OrmPersistentAttribute attribute : CollectionTools.iterable(this.specifiedAttributes())) {
            if (!attribute.contains(textOffset)) continue;
            return attribute;
        }
        return this;
    }

    @Override
    public boolean contains(int textOffset) {
        return this.typeMapping.containsOffset(textOffset);
    }

    @Override
    public TextRange getSelectionTextRange() {
        return this.typeMapping.getSelectionTextRange();
    }

    @Override
    public void validate(List<IMessage> messages, IReporter reporter) {
        super.validate(messages, reporter);
        this.validateClass(messages);
        this.validateMapping(messages, reporter);
        this.validateAttributes(messages, reporter);
    }

    protected void validateClass(List<IMessage> messages) {
        if (this.javaPersistentType == null) {
            messages.add(DefaultJpaValidationMessages.buildMessage(1, "PERSISTENT_TYPE_UNRESOLVED_CLASS", new String[]{this.getName()}, this, this.getMapping().getClassTextRange()));
        }
    }

    protected void validateMapping(List<IMessage> messages, IReporter reporter) {
        try {
            this.typeMapping.validate(messages, reporter);
        }
        catch (Throwable t) {
            JptCorePlugin.log(t);
        }
    }

    protected void validateAttributes(List<IMessage> messages, IReporter reporter) {
        ListIterator<OrmPersistentAttribute> stream = this.attributes();
        while (stream.hasNext()) {
            this.validateAttribute((OrmPersistentAttribute)stream.next(), messages, reporter);
        }
    }

    protected void validateAttribute(OrmPersistentAttribute attribute, List<IMessage> messages, IReporter reporter) {
        try {
            attribute.validate(messages, reporter);
        }
        catch (Throwable t) {
            JptCorePlugin.log(t);
        }
    }

    @Override
    public TextRange getValidationTextRange() {
        return this.typeMapping.getValidationTextRange();
    }

    @Override
    public void dispose() {
        if (this.javaPersistentType != null) {
            this.javaPersistentType.dispose();
        }
    }

    public void toString(StringBuilder sb) {
        sb.append(this.getName());
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    protected class SpecifiedPersistentAttributeOwner
    implements OrmPersistentAttribute.Owner {
        private JavaPersistentAttribute cachedJavaPersistentAttribute;

        protected SpecifiedPersistentAttributeOwner() {
        }

        @Override
        public JavaPersistentAttribute findJavaPersistentAttribute(OrmPersistentAttribute ormPersistentAttribute) {
            if (AbstractOrmPersistentType.this.javaPersistentType == null) {
                return null;
            }
            String ormName = ormPersistentAttribute.getName();
            if (ormName == null) {
                return null;
            }
            AccessType ormAccess = AbstractOrmPersistentType.this.getAccess(ormPersistentAttribute);
            JavaPersistentAttribute javaPersistentAttribute = this.findExistingJavaPersistentAttribute(ormName);
            if (javaPersistentAttribute != null && javaPersistentAttribute.getAccess() == ormAccess) {
                this.cachedJavaPersistentAttribute = null;
                return javaPersistentAttribute;
            }
            return this.buildJavaPersistentAttribute(ormName, ormAccess);
        }

        protected JavaPersistentAttribute findExistingJavaPersistentAttribute(String attributeName) {
            return AbstractOrmPersistentType.this.javaPersistentType.getAttributeNamed(attributeName);
        }

        protected JavaPersistentAttribute buildJavaPersistentAttribute(String ormName, AccessType ormAccess) {
            JavaResourcePersistentAttribute jrpa = this.getJavaResourcePersistentAttribute(this.getJavaResourcePersistentType(), ormName, ormAccess);
            if (this.cachedJavaPersistentAttribute != null && this.cachedJavaPersistentAttribute.getResourcePersistentAttribute() == jrpa) {
                return this.cachedJavaPersistentAttribute;
            }
            this.cachedJavaPersistentAttribute = jrpa == null ? null : AbstractOrmPersistentType.this.buildJavaPersistentAttribute(jrpa);
            return this.cachedJavaPersistentAttribute;
        }

        protected JavaResourcePersistentType getJavaResourcePersistentType() {
            return AbstractOrmPersistentType.this.javaPersistentType.getResourcePersistentType();
        }

        protected JavaResourcePersistentAttribute getJavaResourcePersistentAttribute(JavaResourcePersistentType javaResourcePersistentType, String ormName, AccessType ormAccess) {
            Iterator<JavaResourcePersistentAttribute> stream = this.attributes(javaResourcePersistentType, ormAccess);
            while (stream.hasNext()) {
                JavaResourcePersistentAttribute jrpa = stream.next();
                if (!jrpa.getName().equals(ormName)) continue;
                return jrpa;
            }
            String superclassName = javaResourcePersistentType.getSuperclassQualifiedName();
            if (superclassName == null) {
                return null;
            }
            JavaResourcePersistentType superclass = AbstractOrmPersistentType.this.getJavaResourcePersistentType(superclassName);
            if (superclass == null) {
                return null;
            }
            return this.getJavaResourcePersistentAttribute(superclass, ormName, ormAccess);
        }

        protected Iterator<JavaResourcePersistentAttribute> attributes(JavaResourcePersistentType javaResourcePersistentType, AccessType ormAccess) {
            return ormAccess == AccessType.PROPERTY ? javaResourcePersistentType.persistableProperties() : javaResourcePersistentType.persistableFields();
        }

        @Override
        public void updateJavaPersistentAttribute() {
            if (this.cachedJavaPersistentAttribute != null) {
                this.cachedJavaPersistentAttribute.update();
            }
        }
    }
}

