/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.server.ui.internal.viewers;

import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.jface.viewers.ViewerSorter;
import org.eclipse.wst.common.project.facet.core.IFacetedProject;
import org.eclipse.wst.common.project.facet.core.ProjectFacetsManager;
import org.eclipse.wst.common.project.facet.core.runtime.IRuntime;
import org.eclipse.wst.server.core.IRuntimeType;
import org.eclipse.wst.server.core.IServer;
import org.eclipse.wst.server.core.IServerType;
import org.eclipse.wst.server.core.internal.ResourceManager;
import org.eclipse.wst.server.core.internal.facets.FacetUtil;
import org.eclipse.wst.server.ui.internal.ServerUIPlugin;
import org.eclipse.wst.server.ui.internal.Trace;
import org.eclipse.wst.server.ui.internal.viewers.DefaultViewerSorter;

public class InitialSelectionProvider
extends ViewerSorter {
    public Object getInitialSelection(Object[] obj) {
        if (obj == null || obj.length == 0) {
            return null;
        }
        if (obj[0] instanceof IRuntimeType) {
            int size = obj.length;
            IRuntimeType[] rt = new IRuntimeType[size];
            int i = 0;
            while (i < size) {
                rt[i] = (IRuntimeType)obj[i];
                ++i;
            }
            return this.getInitialSelection(rt);
        }
        if (obj[0] instanceof IServerType) {
            int size = obj.length;
            IServerType[] st = new IServerType[size];
            int i = 0;
            while (i < size) {
                st[i] = (IServerType)obj[i];
                ++i;
            }
            return this.getInitialSelection(st);
        }
        if (obj[0] instanceof IServer) {
            int size = obj.length;
            IServer[] st = new IServer[size];
            int i = 0;
            while (i < size) {
                st[i] = (IServer)obj[i];
                ++i;
            }
            return this.getInitialSelection(st);
        }
        return null;
    }

    public IServerType getInitialSelection(IServerType[] serverTypes) {
        if (serverTypes == null) {
            return null;
        }
        int size = serverTypes.length;
        int i = 0;
        while (i < size) {
            if (this.hasRuntime(serverTypes[i])) {
                return serverTypes[i];
            }
            ++i;
        }
        return this.getDefaultServerType(serverTypes);
    }

    public IServer getInitialSelection(IServer[] servers) {
        return this.getInitialSelection(servers, (IProject)null);
    }

    public IServer getInitialSelection(IServer[] servers, IProject project) {
        IServer rval;
        block5: {
            if (servers == null) {
                return null;
            }
            rval = servers[0];
            if (project != null) {
                try {
                    org.eclipse.wst.server.core.IRuntime runtime;
                    IServer server;
                    IRuntime facetedRuntime;
                    IFacetedProject facetedProject = ProjectFacetsManager.create((IProject)project);
                    if (facetedProject != null && (facetedRuntime = facetedProject.getPrimaryRuntime()) != null && (server = InitialSelectionProvider.findServerFromRuntime((runtime = FacetUtil.getRuntime((IRuntime)facetedRuntime)).getId())) != null) {
                        rval = server;
                    }
                }
                catch (CoreException ce) {
                    if (!Trace.WARNING) break block5;
                    Trace.trace("/warning", "Could not create a faceted project", ce);
                }
            }
        }
        return rval;
    }

    public IRuntimeType getInitialSelection(IRuntimeType[] runtimeTypes) {
        if (runtimeTypes == null) {
            return null;
        }
        int size = runtimeTypes.length;
        int i = 0;
        while (i < size) {
            if (this.hasRuntime(runtimeTypes[i])) {
                return runtimeTypes[i];
            }
            ++i;
        }
        return this.getDefaultRuntimeType(runtimeTypes);
    }

    protected boolean hasRuntime(IServerType serverType) {
        return this.hasRuntime(serverType.getRuntimeType());
    }

    protected boolean hasRuntime(IRuntimeType runtimeType) {
        if (runtimeType == null) {
            return false;
        }
        org.eclipse.wst.server.core.IRuntime[] runtimes = ServerUIPlugin.getRuntimes(runtimeType);
        return runtimes != null && runtimes.length > 0;
    }

    protected IServerType getDefaultServerType(IServerType[] serverTypes) {
        if (serverTypes == null) {
            return null;
        }
        int size = serverTypes.length;
        if (size == 1) {
            return serverTypes[0];
        }
        IServerType first = serverTypes[0];
        int i = 1;
        while (i < size) {
            if (DefaultViewerSorter.compareServerTypes(first, serverTypes[i]) > 0) {
                first = serverTypes[i];
            }
            ++i;
        }
        return first;
    }

    protected IRuntimeType getDefaultRuntimeType(IRuntimeType[] runtimeTypes) {
        if (runtimeTypes == null) {
            return null;
        }
        int size = runtimeTypes.length;
        if (size == 1) {
            return runtimeTypes[0];
        }
        IRuntimeType first = runtimeTypes[0];
        int i = 1;
        while (i < size) {
            if (DefaultViewerSorter.compareRuntimeTypes(first, runtimeTypes[i]) > 0) {
                first = runtimeTypes[i];
            }
            ++i;
        }
        return first;
    }

    public Object getInitialSelection(Object[] obj, IProject project) {
        if (obj == null || obj.length == 0) {
            return null;
        }
        if (obj[0] instanceof IRuntimeType) {
            int size = obj.length;
            IRuntimeType[] rt = new IRuntimeType[size];
            int i = 0;
            while (i < size) {
                rt[i] = (IRuntimeType)obj[i];
                ++i;
            }
            return this.getInitialSelection(rt);
        }
        if (obj[0] instanceof IServerType) {
            int size = obj.length;
            IServerType[] st = new IServerType[size];
            int i = 0;
            while (i < size) {
                st[i] = (IServerType)obj[i];
                ++i;
            }
            return this.getInitialSelection(st);
        }
        if (obj[0] instanceof IServer) {
            int size = obj.length;
            IServer[] st = new IServer[size];
            int i = 0;
            while (i < size) {
                st[i] = (IServer)obj[i];
                ++i;
            }
            return this.getInitialSelection(st, project);
        }
        return null;
    }

    private static IServer findServerFromRuntime(String runtimeId) {
        IServer[] servers;
        if (runtimeId == null) {
            throw new IllegalArgumentException();
        }
        IServer[] iServerArray = servers = ResourceManager.getInstance().getServers();
        int n = servers.length;
        int n2 = 0;
        while (n2 < n) {
            IServer server = iServerArray[n2];
            if (runtimeId == server.getRuntime().getId()) {
                return server;
            }
            ++n2;
        }
        return null;
    }
}

