/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.server.ui.internal.viewers;

import org.eclipse.jface.viewers.ILabelDecorator;
import org.eclipse.jface.viewers.ITableLabelProvider;
import org.eclipse.swt.graphics.Image;
import org.eclipse.wst.server.core.IRuntime;
import org.eclipse.wst.server.core.IRuntimeType;
import org.eclipse.wst.server.ui.internal.ImageResource;
import org.eclipse.wst.server.ui.internal.viewers.BaseLabelProvider;
import org.eclipse.wst.server.ui.internal.viewers.ILockedLabelProvider;

public class RuntimeTableLabelProvider
extends BaseLabelProvider
implements ITableLabelProvider,
ILockedLabelProvider {
    public RuntimeTableLabelProvider() {
    }

    public RuntimeTableLabelProvider(ILabelDecorator decorator) {
        super(decorator);
    }

    public Image getColumnImage(Object element, int columnIndex) {
        IRuntime runtime;
        IRuntimeType runtimeType;
        if (columnIndex == 0 && (runtimeType = (runtime = (IRuntime)element).getRuntimeType()) != null) {
            Image dec;
            Image image = ImageResource.getImage(runtimeType.getId());
            if (this.decorator != null && (dec = this.decorator.decorateImage(image, element)) != null) {
                return dec;
            }
            return image;
        }
        return null;
    }

    public String getColumnText(Object element, int columnIndex) {
        IRuntime runtime = (IRuntime)element;
        if (columnIndex == 0) {
            String dec;
            String text = this.notNull(runtime.getName());
            if (this.decorator != null && (dec = this.decorator.decorateText(text, element)) != null) {
                return dec;
            }
            return text;
        }
        if (columnIndex == 1) {
            IRuntimeType runtimeType = runtime.getRuntimeType();
            if (runtimeType != null) {
                return this.notNull(runtimeType.getName());
            }
            return "";
        }
        return "";
    }

    public boolean isLocked(Object element) {
        IRuntime runtime = (IRuntime)element;
        return runtime.isReadOnly();
    }
}

