/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.server.ui.internal.view.servers;

import org.eclipse.wst.server.core.IModule;
import org.eclipse.wst.server.core.IServer;
import org.eclipse.wst.server.core.ServerUtil;
import org.eclipse.wst.server.ui.IServerModule;

public class ModuleServer
implements IServerModule {
    public IServer server;
    public IModule[] module;

    public ModuleServer(IServer server, IModule[] module) {
        this.server = server;
        this.module = module;
        if (module == null) {
            throw new IllegalArgumentException();
        }
    }

    public IServer getServer() {
        return this.server;
    }

    public IModule[] getModule() {
        return this.module;
    }

    public String getModuleDisplayName() {
        int size = this.module.length;
        if (size == 0) {
            return null;
        }
        return ServerUtil.getModuleDisplayName((IModule)this.module[size - 1]);
    }

    public boolean equals(Object obj) {
        if (!(obj instanceof ModuleServer)) {
            return false;
        }
        ModuleServer ms = (ModuleServer)obj;
        if (ms.server == null && this.server != null) {
            return false;
        }
        if (ms.server != null && !ms.server.equals(this.server)) {
            return false;
        }
        if (ms.module.length != this.module.length) {
            return false;
        }
        int size = this.module.length;
        int i = 0;
        while (i < size) {
            if (!this.module[i].equals(ms.module[i])) {
                return false;
            }
            ++i;
        }
        return true;
    }

    public String toString() {
        StringBuffer sb = new StringBuffer();
        if (this.server != null) {
            sb.append("Server-Module [" + this.server.getId() + "/" + this.server.getName() + ", (");
        } else {
            sb.append("Server-Module [null, (");
        }
        int size = this.module.length;
        int i = 0;
        while (i < size) {
            if (i > 0) {
                sb.append(", ");
            }
            sb.append(this.module[i].getName());
            ++i;
        }
        sb.append(")]");
        return sb.toString();
    }
}

