/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.common.componentcore.internal;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.jem.util.RegistryReader;
import org.eclipse.wst.common.componentcore.internal.IComponentProjectMigrator;

public class ProjectMigratorRegistry
extends RegistryReader {
    static final String EXTENSION_NAME = "ComponentProjectMigrator";
    static final String ELEMENT_MIGRATOR_EXTENSION = "migratorExtension";
    static final String MIGRATOR_CLASS = "class";
    private List projectMigrators = new ArrayList();
    private static ProjectMigratorRegistry INSTANCE = null;

    public ProjectMigratorRegistry() {
        super("org.eclipse.wst.common.modulecore", EXTENSION_NAME);
    }

    public static ProjectMigratorRegistry getInstance() {
        if (INSTANCE == null) {
            INSTANCE = new ProjectMigratorRegistry();
            INSTANCE.readRegistry();
        }
        return INSTANCE;
    }

    public boolean readElement(IConfigurationElement element) {
        if (!element.getName().equals(ELEMENT_MIGRATOR_EXTENSION)) {
            return false;
        }
        IComponentProjectMigrator migrator = null;
        try {
            migrator = (IComponentProjectMigrator)element.createExecutableExtension(MIGRATOR_CLASS);
        }
        catch (CoreException e) {
            e.printStackTrace();
        }
        if (migrator != null) {
            this.addModuleExtension(migrator);
        }
        return true;
    }

    public IComponentProjectMigrator[] getProjectMigrators() {
        return this.projectMigrators.toArray(new IComponentProjectMigrator[this.projectMigrators.size()]);
    }

    private void addModuleExtension(IComponentProjectMigrator ext) {
        this.projectMigrators.add(ext);
    }
}

