/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.server.ui.internal.wizard.page;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.jface.resource.JFaceResources;
import org.eclipse.jface.viewers.ColumnLayoutData;
import org.eclipse.jface.viewers.ColumnWeightData;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ILabelProviderListener;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.ITableLabelProvider;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.TableLayout;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableColumn;
import org.eclipse.wst.server.core.IServer;
import org.eclipse.wst.server.core.IServerAttributes;
import org.eclipse.wst.server.core.IServerWorkingCopy;
import org.eclipse.wst.server.ui.internal.SWTUtil;
import org.eclipse.wst.server.ui.internal.viewers.BaseContentProvider;

public class NewDetectServerComposite
extends Composite {
    protected String host;
    protected IServerWorkingCopy server;
    protected IServerSelectionListener listener;
    protected List servers = new ArrayList();
    protected Button detect;
    protected Table table;
    protected TableViewer tableViewer;
    protected Label hostLabel;

    public NewDetectServerComposite(Composite parent, IServerSelectionListener listener2) {
        super(parent, 0);
        this.listener = listener2;
        this.createControl();
    }

    protected Label createHeadingLabel(Composite parent, String text, int span) {
        Label label = this.createLabel(parent, text, span, true, false);
        label.setFont(JFaceResources.getBannerFont());
        return label;
    }

    protected Label createLabel(Composite parent, String text, int span, boolean alignTop, boolean indent) {
        Label label = new Label(parent, 64);
        label.setText(text);
        GridData data = new GridData(260);
        if (alignTop) {
            data.verticalAlignment = 1;
        }
        data.horizontalSpan = span;
        if (indent) {
            data.horizontalIndent = 10;
        }
        label.setLayoutData((Object)data);
        return label;
    }

    protected void createControl() {
        GridLayout layout = new GridLayout();
        layout.horizontalSpacing = SWTUtil.convertHorizontalDLUsToPixels(this, 4);
        layout.verticalSpacing = SWTUtil.convertVerticalDLUsToPixels(this, 4);
        layout.marginWidth = 0;
        layout.marginHeight = 0;
        layout.numColumns = 2;
        this.setLayout((Layout)layout);
        this.createHeadingLabel(this, "Select the Server", 2);
        this.table = new Table((Composite)this, 68356);
        GridData data = new GridData(1808);
        data.heightHint = 60;
        data.widthHint = 50;
        data.horizontalSpan = 2;
        data.horizontalIndent = 10;
        this.table.setLayoutData((Object)data);
        TableLayout tableLayout = new TableLayout();
        this.table.setHeaderVisible(true);
        tableLayout.addColumnData((ColumnLayoutData)new ColumnWeightData(50, 100, true));
        TableColumn col = new TableColumn(this.table, 0);
        col.setText("Server");
        tableLayout.addColumnData((ColumnLayoutData)new ColumnWeightData(40, 80, true));
        TableColumn col2 = new TableColumn(this.table, 0);
        col2.setText("Status");
        this.table.setLayout((Layout)tableLayout);
        this.tableViewer = new TableViewer(this.table);
        this.tableViewer.setContentProvider((IContentProvider)new ServerContentProvider());
        this.tableViewer.setLabelProvider((IBaseLabelProvider)new ServerLabelProvider());
        this.tableViewer.setColumnProperties(new String[]{"name", "status"});
        this.tableViewer.setInput((Object)"root");
        String date = "<now>";
        this.hostLabel = this.createLabel(this, "Last detected servers on " + this.host + " at " + date + ":", 1, false, true);
        this.detect = SWTUtil.createButton(this, "Refresh");
        this.detect.setEnabled(false);
        data = (GridData)this.detect.getLayoutData();
        data.horizontalAlignment = 128;
        this.detect.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
            }
        });
        this.tableViewer.addSelectionChangedListener(new ISelectionChangedListener(){

            public void selectionChanged(SelectionChangedEvent event) {
                IStructuredSelection sel = (IStructuredSelection)event.getSelection();
                Object obj = sel.getFirstElement();
                IServerWorkingCopy newServer = null;
                if (obj instanceof IServerWorkingCopy) {
                    newServer = (IServerWorkingCopy)obj;
                }
                if (newServer == null && NewDetectServerComposite.this.server != null || newServer != null && !newServer.equals(NewDetectServerComposite.this.server)) {
                    NewDetectServerComposite.this.server = newServer;
                    NewDetectServerComposite.this.listener.serverSelected((IServerAttributes)NewDetectServerComposite.this.server);
                }
            }
        });
        this.setHost(null);
        Dialog.applyDialogFont((Control)this);
    }

    public String getHost() {
        return this.host;
    }

    public void setHost(String host) {
        this.host = host;
        this.servers = new ArrayList();
        this.tableViewer.refresh();
        if (host != null) {
            this.hostLabel.setText("Detected servers on " + host + ":");
            this.detect.setEnabled(true);
            this.table.setEnabled(true);
        } else {
            this.hostLabel.setText("No host selected");
            this.detect.setEnabled(false);
            this.table.setEnabled(false);
        }
    }

    public IServerWorkingCopy getServer() {
        return this.server;
    }

    public static interface IServerSelectionListener {
        public void serverSelected(IServerAttributes var1);
    }

    public class ServerContentProvider
    extends BaseContentProvider {
        public Object[] getElements(Object inputElement) {
            return NewDetectServerComposite.this.servers.toArray();
        }
    }

    public class ServerLabelProvider
    implements ITableLabelProvider {
        public void addListener(ILabelProviderListener listener2) {
        }

        public void dispose() {
        }

        public Image getColumnImage(Object element, int columnIndex) {
            return null;
        }

        public String getColumnText(Object element, int columnIndex) {
            IServer server2 = (IServer)element;
            if (columnIndex == 0) {
                return server2.getName();
            }
            if (columnIndex == 0) {
                return "n/a";
            }
            return null;
        }

        public boolean isLabelProperty(Object element, String property) {
            return false;
        }

        public void removeListener(ILabelProviderListener listener2) {
        }
    }
}

