/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.xml.ui.internal.projection;

import org.eclipse.jface.text.Position;
import org.eclipse.wst.sse.core.internal.provisional.IndexedRegion;
import org.eclipse.wst.sse.core.internal.provisional.text.IStructuredDocumentRegion;
import org.eclipse.wst.sse.ui.internal.projection.AbstractStructuredFoldingStrategy;
import org.eclipse.wst.xml.core.internal.document.CommentImpl;
import org.eclipse.wst.xml.core.internal.provisional.document.IDOMNode;
import org.eclipse.wst.xml.core.internal.provisional.document.IDOMText;
import org.eclipse.wst.xml.ui.internal.projection.XMLCommentFoldingPosition;
import org.eclipse.wst.xml.ui.internal.projection.XMLElementFoldingPosition;

public class XMLFoldingStrategy
extends AbstractStructuredFoldingStrategy {
    protected Position calcNewFoldPosition(IndexedRegion indexedRegion) {
        Object retPos = null;
        if (indexedRegion.getStartOffset() >= 0 && indexedRegion.getLength() >= 0) {
            IDOMNode node = (IDOMNode)indexedRegion;
            IStructuredDocumentRegion startRegion = node.getStartStructuredDocumentRegion();
            IStructuredDocumentRegion endRegion = node.getEndStructuredDocumentRegion();
            if (startRegion != null && endRegion != null) {
                if (endRegion.getEndOffset() >= startRegion.getStartOffset()) {
                    retPos = new XMLElementFoldingPosition(startRegion, endRegion);
                }
            } else if (startRegion != null && indexedRegion instanceof CommentImpl) {
                retPos = new XMLCommentFoldingPosition(startRegion);
            }
        }
        return retPos;
    }

    protected boolean indexedRegionValidType(IndexedRegion indexedRegion) {
        return indexedRegion instanceof IDOMNode && !(indexedRegion instanceof IDOMText);
    }
}

