/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jst.ws.internal.consumption.ui.wsrt;

import java.util.ArrayList;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import java.util.Vector;
import org.eclipse.core.resources.IProject;
import org.eclipse.jem.util.emf.workbench.ProjectUtilities;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jst.server.core.FacetUtil;
import org.eclipse.jst.ws.internal.consumption.common.FacetMatcher;
import org.eclipse.jst.ws.internal.consumption.common.FacetUtils;
import org.eclipse.jst.ws.internal.consumption.common.RequiredFacetVersion;
import org.eclipse.jst.ws.internal.consumption.ui.ConsumptionUIMessages;
import org.eclipse.jst.ws.internal.consumption.ui.plugin.WebServiceConsumptionUIPlugin;
import org.eclipse.jst.ws.internal.consumption.ui.preferences.PersistentServerRuntimeContext;
import org.eclipse.jst.ws.internal.consumption.ui.wizard.TypeSelectionFilter2;
import org.eclipse.jst.ws.internal.consumption.ui.wsrt.ClientRuntimeDescriptor;
import org.eclipse.jst.ws.internal.consumption.ui.wsrt.FacetMatchCache;
import org.eclipse.jst.ws.internal.consumption.ui.wsrt.RuntimeDescriptor;
import org.eclipse.jst.ws.internal.consumption.ui.wsrt.ServiceRuntimeDescriptor;
import org.eclipse.jst.ws.internal.consumption.ui.wsrt.WebServiceClientImpl;
import org.eclipse.jst.ws.internal.consumption.ui.wsrt.WebServiceImpl;
import org.eclipse.jst.ws.internal.consumption.ui.wsrt.WebServiceRuntimeExtensionRegistry2;
import org.eclipse.jst.ws.internal.data.LabelsAndIds;
import org.eclipse.jst.ws.internal.data.TypeRuntimeServer;
import org.eclipse.osgi.util.NLS;
import org.eclipse.ui.PlatformUI;
import org.eclipse.wst.command.internal.env.core.selection.SelectionList;
import org.eclipse.wst.command.internal.env.core.selection.SelectionListChoices;
import org.eclipse.wst.common.project.facet.core.IFacetedProjectTemplate;
import org.eclipse.wst.common.project.facet.core.ProjectFacetsManager;
import org.eclipse.wst.server.core.IRuntime;
import org.eclipse.wst.server.core.IRuntimeType;
import org.eclipse.wst.server.core.IServer;
import org.eclipse.wst.server.core.IServerType;
import org.eclipse.wst.server.core.ServerCore;
import org.eclipse.wst.server.ui.ServerUICore;
import org.eclipse.wst.ws.internal.wsrt.IWebServiceRuntime;
import org.eclipse.wst.ws.internal.wsrt.IWebServiceRuntimeChecker;

public class WebServiceRuntimeExtensionUtils2 {
    private static WebServiceRuntimeExtensionRegistry2 registry = WebServiceRuntimeExtensionRegistry2.getInstance();
    private static SelectionListChoices serverToRuntimeToJ2EE_;
    private static Hashtable serverFactoryIdByLabel_;
    private static Hashtable runtimeIdByLabel_;

    public static RuntimeDescriptor getRuntimeById(String id) {
        Object result = WebServiceRuntimeExtensionUtils2.registry.runtimes_.get(id);
        if (result != null) {
            return (RuntimeDescriptor)result;
        }
        return null;
    }

    public static String[] getAllServiceProjectTypes() {
        ArrayList<String> finalTemplateIdList = new ArrayList<String>();
        for (ServiceRuntimeDescriptor desc : WebServiceRuntimeExtensionUtils2.registry.serviceRuntimes_.values()) {
            Set templates = FacetMatchCache.getInstance().getTemplatesForServiceRuntime(desc.getId());
            for (IFacetedProjectTemplate template : templates) {
                if (finalTemplateIdList.contains(template.getId())) continue;
                finalTemplateIdList.add(template.getId());
            }
        }
        WebServiceRuntimeExtensionUtils2.ensureWebProjectIsFirst(finalTemplateIdList);
        return finalTemplateIdList.toArray(new String[0]);
    }

    private static void ensureWebProjectIsFirst(List finalTemplateIdList) {
        int i = finalTemplateIdList.indexOf("template.jst.web");
        if (i > 0) {
            finalTemplateIdList.remove(i);
            finalTemplateIdList.add(0, "template.jst.web");
        }
    }

    public static String[] getAllClientProjectTypes() {
        ArrayList<String> finalTemplateIdList = new ArrayList<String>();
        for (ClientRuntimeDescriptor desc : WebServiceRuntimeExtensionUtils2.registry.clientRuntimes_.values()) {
            Set templates = FacetMatchCache.getInstance().getTemplatesForClientRuntime(desc.getId());
            for (IFacetedProjectTemplate template : templates) {
                if (finalTemplateIdList.contains(template.getId())) continue;
                finalTemplateIdList.add(template.getId());
            }
        }
        WebServiceRuntimeExtensionUtils2.ensureWebProjectIsFirst(finalTemplateIdList);
        return finalTemplateIdList.toArray(new String[0]);
    }

    public static String getRuntimeLabelById(String runtimeId) {
        RuntimeDescriptor desc = WebServiceRuntimeExtensionUtils2.getRuntimeById(runtimeId);
        if (desc == null) {
            return null;
        }
        return desc.getLabel();
    }

    public static RuntimeDescriptor getRuntimeByLabel(String label) {
        for (RuntimeDescriptor descriptor : WebServiceRuntimeExtensionUtils2.registry.runtimes_.values()) {
            if (descriptor == null || !label.equals(descriptor.getLabel())) continue;
            return descriptor;
        }
        return null;
    }

    public static String getServerLabelById(String serverFactoryId) {
        IServerType serverType = ServerCore.findServerType((String)serverFactoryId);
        if (serverType == null) {
            return null;
        }
        if (PlatformUI.isWorkbenchRunning()) {
            String serverLabel = ServerUICore.getLabelProvider().getText((Object)serverType);
            return serverLabel;
        }
        return serverType.getName();
    }

    public static String getServerInstanceLabelFromInstanceId(String instanceId) {
        IServer server = ServerCore.findServer((String)instanceId);
        return server.getName();
    }

    private static String[] getServerFactoryIdsByFacetRuntimes(Set facetRuntimes) {
        ArrayList<String> supportedServerFactoryIds = new ArrayList<String>();
        String[] serverTypeIds = WebServiceRuntimeExtensionUtils2.getAllServerFactoryIdsWithRuntimes();
        for (org.eclipse.wst.common.project.facet.core.runtime.IRuntime fRuntime : facetRuntimes) {
            IRuntime sRuntime = FacetUtil.getRuntime((org.eclipse.wst.common.project.facet.core.runtime.IRuntime)fRuntime);
            int i = 0;
            while (i < serverTypeIds.length) {
                IServerType serverType = ServerCore.findServerType((String)serverTypeIds[i]);
                IRuntimeType runtimeType = serverType.getRuntimeType();
                if (runtimeType != null) {
                    String runtimeTypeId = runtimeType.getId();
                    if (sRuntime != null && sRuntime.getRuntimeType() != null && runtimeTypeId.equals(sRuntime.getRuntimeType().getId())) {
                        supportedServerFactoryIds.add(serverTypeIds[i]);
                    }
                }
                ++i;
            }
        }
        return supportedServerFactoryIds.toArray(new String[0]);
    }

    public static WebServiceImpl getWebServiceImplById(String id) {
        Object result = WebServiceRuntimeExtensionUtils2.registry.webServiceImpls_.get(id);
        if (result != null) {
            return (WebServiceImpl)result;
        }
        return null;
    }

    public static ServiceRuntimeDescriptor getServiceRuntimeDescriptorById(String id) {
        Object result = WebServiceRuntimeExtensionUtils2.registry.serviceRuntimes_.get(id);
        if (result != null) {
            return (ServiceRuntimeDescriptor)result;
        }
        return null;
    }

    public static IWebServiceRuntime getServiceRuntime(String serviceRuntimeId) {
        ServiceRuntimeDescriptor descriptor = WebServiceRuntimeExtensionUtils2.getServiceRuntimeDescriptorById(serviceRuntimeId);
        IWebServiceRuntime webserviceRuntime = null;
        if (descriptor != null) {
            webserviceRuntime = descriptor.getWebServiceRuntime();
        }
        return webserviceRuntime;
    }

    public static String getServiceRuntimeId(TypeRuntimeServer trs, String projectName, String templateId) {
        boolean serverSelected = trs.getServerId() != null && trs.getServerId().length() > 0;
        String[] descs = WebServiceRuntimeExtensionUtils2.getServiceRuntimesByServiceType(trs.getTypeId(), trs.getServerId());
        int i = 0;
        while (i < descs.length) {
            IProject project;
            boolean supportsServer;
            ServiceRuntimeDescriptor desc = WebServiceRuntimeExtensionUtils2.getServiceRuntimeDescriptorById(descs[i]);
            if (desc.getRuntime().getId().equals(trs.getRuntimeId()) && (!serverSelected || (supportsServer = WebServiceRuntimeExtensionUtils2.doesServiceRuntimeSupportServer(desc.getId(), trs.getServerId()))) && ((project = ProjectUtilities.getProject((String)projectName)).exists() ? WebServiceRuntimeExtensionUtils2.doesServiceRuntimeSupportProject(desc.getId(), projectName) : WebServiceRuntimeExtensionUtils2.doesServiceRuntimeSupportTemplate(desc.getId(), templateId))) {
                return desc.getId();
            }
            ++i;
        }
        return "";
    }

    public static int getScenarioFromTypeId(String typeId) {
        return Integer.parseInt(typeId.substring(0, typeId.indexOf("/")));
    }

    public static String getWebServiceImplIdFromTypeId(String typeId) {
        return typeId.substring(typeId.indexOf("/") + 1);
    }

    public static String[] getRuntimesByServiceType(String typeId) {
        int scenario = WebServiceRuntimeExtensionUtils2.getScenarioFromTypeId(typeId);
        String implId = WebServiceRuntimeExtensionUtils2.getWebServiceImplIdFromTypeId(typeId);
        ArrayList<String> ids = new ArrayList<String>();
        block4: for (ServiceRuntimeDescriptor desc : WebServiceRuntimeExtensionUtils2.registry.serviceRuntimes_.values()) {
            if (!desc.getServiceImplementationType().getId().equals(implId)) continue;
            switch (scenario) {
                case 0: {
                    String runtimeId;
                    if (!desc.getBottomUp() || ids.contains(runtimeId = desc.getRuntime().getId())) continue block4;
                    ids.add(runtimeId);
                    break;
                }
                case 1: {
                    String runtimeId;
                    if (!desc.getTopDown() || ids.contains(runtimeId = desc.getRuntime().getId())) continue block4;
                    ids.add(runtimeId);
                }
            }
        }
        return ids.toArray(new String[0]);
    }

    public static String[] getServiceRuntimesByServiceType(String typeId) {
        int scenario = WebServiceRuntimeExtensionUtils2.getScenarioFromTypeId(typeId);
        String implId = WebServiceRuntimeExtensionUtils2.getWebServiceImplIdFromTypeId(typeId);
        ArrayList<String> ids = new ArrayList<String>();
        for (ServiceRuntimeDescriptor desc : WebServiceRuntimeExtensionUtils2.registry.serviceRuntimes_.values()) {
            if (!desc.getServiceImplementationType().getId().equals(implId)) continue;
            switch (scenario) {
                case 0: {
                    if (!desc.getBottomUp()) break;
                    String serviceRuntimeId = desc.getId();
                    ids.add(serviceRuntimeId);
                    break;
                }
                case 1: {
                    if (!desc.getTopDown()) break;
                    String serviceRuntimeId = desc.getId();
                    ids.add(serviceRuntimeId);
                }
            }
        }
        return ids.toArray(new String[0]);
    }

    public static String[] getServiceRuntimesByServiceType(String typeId, String preferredServerFactoryId) {
        int scenario = WebServiceRuntimeExtensionUtils2.getScenarioFromTypeId(typeId);
        String implId = WebServiceRuntimeExtensionUtils2.getWebServiceImplIdFromTypeId(typeId);
        ArrayList<String> ids = new ArrayList<String>();
        ArrayList<String> idsPreferredByServer = new ArrayList<String>();
        for (ServiceRuntimeDescriptor desc : WebServiceRuntimeExtensionUtils2.registry.serviceRuntimes_.values()) {
            if (!desc.getServiceImplementationType().getId().equals(implId)) continue;
            switch (scenario) {
                case 0: {
                    if (!desc.getBottomUp()) break;
                    String serviceRuntimeId = desc.getId();
                    if (desc.getRuntimePreferredServerType() != null && desc.getRuntimePreferredServerType().equals(preferredServerFactoryId)) {
                        idsPreferredByServer.add(serviceRuntimeId);
                        break;
                    }
                    ids.add(serviceRuntimeId);
                    break;
                }
                case 1: {
                    if (!desc.getTopDown()) break;
                    String serviceRuntimeId = desc.getId();
                    if (desc.getRuntimePreferredServerType() != null && desc.getRuntimePreferredServerType().equals(preferredServerFactoryId)) {
                        idsPreferredByServer.add(serviceRuntimeId);
                        break;
                    }
                    ids.add(serviceRuntimeId);
                }
            }
        }
        String[] preferredRuntimeIds = new String[idsPreferredByServer.size() + ids.size()];
        Iterator itr1 = idsPreferredByServer.iterator();
        int preferredRTCounter = 0;
        while (itr1.hasNext()) {
            String runtimeId = (String)itr1.next();
            preferredRuntimeIds[preferredRTCounter++] = runtimeId;
        }
        for (String runtimeId : ids) {
            preferredRuntimeIds[preferredRTCounter++] = runtimeId;
        }
        return preferredRuntimeIds;
    }

    public static boolean isRuntimeSupportedForServiceType(String typeId, String runtimeId) {
        String[] serviceRuntimeIds = WebServiceRuntimeExtensionUtils2.getServiceRuntimesByServiceType(typeId);
        if (serviceRuntimeIds != null) {
            int i = 0;
            while (i < serviceRuntimeIds.length) {
                ServiceRuntimeDescriptor desc = WebServiceRuntimeExtensionUtils2.getServiceRuntimeDescriptorById(serviceRuntimeIds[i]);
                if (desc.getRuntime().getId().equals(runtimeId)) {
                    return true;
                }
                ++i;
            }
        }
        return false;
    }

    public static String[] getServerFactoryIdsByServiceType(String typeId) {
        ArrayList<String> serverFactoryIds = new ArrayList<String>();
        String[] srts = WebServiceRuntimeExtensionUtils2.getServiceRuntimesByServiceType(typeId);
        if (srts != null) {
            int i = 0;
            while (i < srts.length) {
                String[] fIds = WebServiceRuntimeExtensionUtils2.getServerFactoryIdsByServiceRuntime(srts[i]);
                int j = 0;
                while (j < fIds.length) {
                    if (!serverFactoryIds.contains(fIds[j])) {
                        serverFactoryIds.add(fIds[j]);
                    }
                    ++j;
                }
                ++i;
            }
        }
        return serverFactoryIds.toArray(new String[0]);
    }

    public static boolean isServerSupportedForChosenServiceType(String typeId, String serverFactoryId) {
        String[] fIds = WebServiceRuntimeExtensionUtils2.getServerFactoryIdsByServiceType(typeId);
        if (fIds == null) {
            return false;
        }
        int i = 0;
        while (i < fIds.length) {
            if (serverFactoryId.equals(fIds[i])) {
                return true;
            }
            ++i;
        }
        return false;
    }

    public static String[] getServerFactoryIdsByServiceRuntime(String serviceRuntimeId) {
        ServiceRuntimeDescriptor desc = WebServiceRuntimeExtensionUtils2.getServiceRuntimeDescriptorById(serviceRuntimeId);
        Set facetRuntimes = WebServiceRuntimeExtensionUtils2.getRuntimes(desc.getRequiredFacetVersions());
        return WebServiceRuntimeExtensionUtils2.getServerFactoryIdsByFacetRuntimes(facetRuntimes);
    }

    public static boolean doesServiceRuntimeSupportServer(String serviceRuntimeId, String serverFactoryId) {
        String[] serverIds = WebServiceRuntimeExtensionUtils2.getServerFactoryIdsByServiceRuntime(serviceRuntimeId);
        int i = 0;
        while (i < serverIds.length) {
            if (serverIds[i].equals(serverFactoryId)) {
                return true;
            }
            ++i;
        }
        return false;
    }

    public static LabelsAndIds getServiceTypeLabels() {
        LabelsAndIds labelIds = new LabelsAndIds();
        Iterator iterator = WebServiceRuntimeExtensionUtils2.registry.webServiceTypesList_.iterator();
        int size = WebServiceRuntimeExtensionUtils2.registry.webServiceTypesList_.size();
        String[] labels = new String[size];
        String[] ids = new String[size];
        int index = 0;
        labelIds.setLabels_(labels);
        labelIds.setIds_(ids);
        while (iterator.hasNext()) {
            String wst = (String)iterator.next();
            int scenario = WebServiceRuntimeExtensionUtils2.getScenarioFromTypeId(wst);
            String implId = WebServiceRuntimeExtensionUtils2.getWebServiceImplIdFromTypeId(wst);
            WebServiceImpl wsimpl = WebServiceRuntimeExtensionUtils2.getWebServiceImplById(implId);
            String impllabel = wsimpl.getLabel();
            ids[index] = wst;
            String scenLabel = "";
            switch (scenario) {
                case 0: {
                    scenLabel = NLS.bind((String)ConsumptionUIMessages.BOTTOMUP_LABEL, (Object[])new String[0]);
                    break;
                }
                case 1: {
                    scenLabel = NLS.bind((String)ConsumptionUIMessages.TOPDOWN_LABEL, (Object[])new String[0]);
                }
            }
            labels[index] = NLS.bind((String)ConsumptionUIMessages.COMBINED_TYPE_AND_RUNTIME_LABEL, (Object[])new String[]{scenLabel, impllabel});
            ++index;
        }
        return labelIds;
    }

    public static String getDefaultRuntimeValueFor(String typeId) {
        String[] srIds = WebServiceRuntimeExtensionUtils2.getServiceRuntimesByServiceType(typeId);
        if (srIds == null) {
            return null;
        }
        PersistentServerRuntimeContext context = WebServiceConsumptionUIPlugin.getInstance().getServerRuntimeContext();
        String preferredRuntimeId = context.getRuntimeId();
        int i = 0;
        while (i < srIds.length) {
            String runtimeId = WebServiceRuntimeExtensionUtils2.getServiceRuntimeDescriptorById(srIds[i]).getRuntime().getId();
            if (runtimeId.equals(preferredRuntimeId)) {
                return runtimeId;
            }
            ++i;
        }
        ServiceRuntimeDescriptor desc = WebServiceRuntimeExtensionUtils2.getServiceRuntimeDescriptorById(srIds[0]);
        return desc.getRuntime().getId();
    }

    public static String getDefaultClientRuntimeValueFor(String typeId) {
        String[] crIds = WebServiceRuntimeExtensionUtils2.getClientRuntimesByType(typeId);
        if (crIds == null) {
            return null;
        }
        PersistentServerRuntimeContext context = WebServiceConsumptionUIPlugin.getInstance().getServerRuntimeContext();
        String preferredRuntimeId = context.getRuntimeId();
        int i = 0;
        while (i < crIds.length) {
            String runtimeId = WebServiceRuntimeExtensionUtils2.getClientRuntimeDescriptorById(crIds[i]).getRuntime().getId();
            if (runtimeId.equals(preferredRuntimeId)) {
                return runtimeId;
            }
            ++i;
        }
        ClientRuntimeDescriptor desc = WebServiceRuntimeExtensionUtils2.getClientRuntimeDescriptorById(crIds[0]);
        return desc.getRuntime().getId();
    }

    public static String getDefaultServerValueFor(String typeId) {
        String[] fIds = WebServiceRuntimeExtensionUtils2.getServerFactoryIdsByServiceType(typeId);
        if (fIds == null || fIds.length == 0) {
            return null;
        }
        PersistentServerRuntimeContext context = WebServiceConsumptionUIPlugin.getInstance().getServerRuntimeContext();
        String preferredServerFactoryId = context.getServerFactoryId();
        int i = 0;
        while (i < fIds.length) {
            String serverTypeId = fIds[i];
            if (serverTypeId.equals(preferredServerFactoryId)) {
                return serverTypeId;
            }
            ++i;
        }
        return fIds[0];
    }

    public static String getDefaultClientServerValueFor(String typeId) {
        PersistentServerRuntimeContext context = WebServiceConsumptionUIPlugin.getInstance().getServerRuntimeContext();
        String preferredServerFactoryId = context.getServerFactoryId();
        String first = null;
        String[] crts = WebServiceRuntimeExtensionUtils2.getClientRuntimesByType(typeId);
        if (crts != null) {
            int i = 0;
            while (i < crts.length) {
                String[] fIds = WebServiceRuntimeExtensionUtils2.getServerFactoryIdsByClientRuntime(crts[i]);
                int j = 0;
                while (j < fIds.length) {
                    if (first == null) {
                        first = fIds[j];
                    }
                    if (preferredServerFactoryId.equals(fIds[j])) {
                        return fIds[j];
                    }
                    ++j;
                }
                ++i;
            }
        }
        return first;
    }

    public static boolean isServerRuntimeTypeSupported(String serverFactoryId, String runtimeId, String typeId) {
        String[] serviceRuntimes = WebServiceRuntimeExtensionUtils2.getServiceRuntimesByServiceType(typeId);
        if (serviceRuntimes != null && serviceRuntimes.length > 0) {
            int i = 0;
            while (i < serviceRuntimes.length) {
                ServiceRuntimeDescriptor desc = WebServiceRuntimeExtensionUtils2.getServiceRuntimeDescriptorById(serviceRuntimes[i]);
                if (desc.getRuntime().getId().equals(runtimeId)) {
                    Set runtimes = WebServiceRuntimeExtensionUtils2.getRuntimes(desc.getRequiredFacetVersions());
                    String[] fIds = WebServiceRuntimeExtensionUtils2.getServerFactoryIdsByFacetRuntimes(runtimes);
                    int j = 0;
                    while (j < fIds.length) {
                        if (fIds[j].equals(serverFactoryId)) {
                            return true;
                        }
                        ++j;
                    }
                }
                ++i;
            }
        }
        return false;
    }

    public static String[] getWebServiceTypeBySelection(IStructuredSelection selection) {
        TypeSelectionFilter2 tsf = new TypeSelectionFilter2();
        String[] wst = tsf.getWebServiceTypeByInitialSelection(selection, WebServiceRuntimeExtensionUtils2.registry.webServiceTypesList_);
        return wst == null ? null : wst;
    }

    public static boolean doesRuntimeSupportServerForServiceSide(String runtimeId, String factoryId) {
        for (ServiceRuntimeDescriptor desc : WebServiceRuntimeExtensionUtils2.registry.serviceRuntimes_.values()) {
            String thisRuntimeId = desc.getRuntime().getId();
            if (!thisRuntimeId.equals(runtimeId)) continue;
            Set facetRuntimes = WebServiceRuntimeExtensionUtils2.getRuntimes(desc.getRequiredFacetVersions());
            String[] fIds = WebServiceRuntimeExtensionUtils2.getServerFactoryIdsByFacetRuntimes(facetRuntimes);
            int j = 0;
            while (j < fIds.length) {
                if (fIds[j].equals(factoryId)) {
                    return true;
                }
                ++j;
            }
        }
        return false;
    }

    public static String getFirstSupportedServerForServiceSide(String runtimeId) {
        for (ServiceRuntimeDescriptor desc : WebServiceRuntimeExtensionUtils2.registry.serviceRuntimes_.values()) {
            Set facetRuntimes;
            String[] factoryIds;
            String thisRuntimeId = desc.getRuntime().getId();
            if (!thisRuntimeId.equals(runtimeId) || (factoryIds = WebServiceRuntimeExtensionUtils2.getServerFactoryIdsByFacetRuntimes(facetRuntimes = WebServiceRuntimeExtensionUtils2.getRuntimes(desc.getRequiredFacetVersions()))) == null || factoryIds.length <= 0) continue;
            return factoryIds[0];
        }
        return null;
    }

    public static String[] getProjectsForServiceTypeAndRuntime(String typeId, String runtimeId) {
        IProject[] projects = FacetUtils.getAllProjects();
        ArrayList<String> validProjects = new ArrayList<String>();
        int i = 0;
        while (i < projects.length) {
            if (WebServiceRuntimeExtensionUtils2.doesServiceTypeAndRuntimeSupportProject(typeId, runtimeId, projects[i].getName())) {
                validProjects.add(projects[i].getName());
            }
            ++i;
        }
        return validProjects.toArray(new String[0]);
    }

    public static boolean doesServiceTypeAndRuntimeSupportProject(String typeId, String runtimeId, String projectName) {
        String[] descs = WebServiceRuntimeExtensionUtils2.getServiceRuntimesByServiceType(typeId);
        int j = 0;
        while (j < descs.length) {
            ServiceRuntimeDescriptor desc = WebServiceRuntimeExtensionUtils2.getServiceRuntimeDescriptorById(descs[j]);
            if (desc.getRuntime().getId().equals(runtimeId) && WebServiceRuntimeExtensionUtils2.doesServiceRuntimeSupportProject(descs[j], projectName)) {
                return true;
            }
            ++j;
        }
        return false;
    }

    public static boolean doesServiceRuntimeSupportProject(String serviceRuntimeId, String projectName) {
        FacetMatcher fm = FacetMatchCache.getInstance().getMatchForProject(false, serviceRuntimeId, projectName);
        if (fm != null) {
            return fm.isMatch();
        }
        return false;
    }

    public static String[] getServiceProjectTemplates(String typeId, String runtimeId) {
        return WebServiceRuntimeExtensionUtils2.getServiceProjectTemplates(typeId, runtimeId, null);
    }

    public static String[] getServiceProjectTemplates(String typeId, String runtimeId, String serverId) {
        String[] srIds = WebServiceRuntimeExtensionUtils2.getServiceRuntimesByServiceType(typeId);
        if (srIds == null) {
            return null;
        }
        ArrayList<String> templateIdList = new ArrayList<String>();
        int i = 0;
        while (i < srIds.length) {
            ServiceRuntimeDescriptor desc;
            String thisRuntimeId;
            if ((serverId == null || WebServiceRuntimeExtensionUtils2.doesServiceRuntimeSupportServer(srIds[i], serverId)) && (thisRuntimeId = (desc = WebServiceRuntimeExtensionUtils2.getServiceRuntimeDescriptorById(srIds[i])).getRuntime().getId()).equals(runtimeId)) {
                Set templates = FacetMatchCache.getInstance().getTemplatesForServiceRuntime(desc.getId());
                for (IFacetedProjectTemplate template : templates) {
                    if (templateIdList.contains(template.getId())) continue;
                    templateIdList.add(template.getId());
                }
            }
            ++i;
        }
        return templateIdList.toArray(new String[0]);
    }

    public static boolean doesServiceTypeAndRuntimeSupportTemplate(String typeId, String runtimeId, String templateId, String serverId) {
        String[] srIds = WebServiceRuntimeExtensionUtils2.getServiceRuntimesByServiceType(typeId);
        if (srIds == null) {
            return false;
        }
        int i = 0;
        while (i < srIds.length) {
            ServiceRuntimeDescriptor desc;
            String thisRuntimeId;
            if ((serverId == null || WebServiceRuntimeExtensionUtils2.doesServiceRuntimeSupportServer(srIds[i], serverId)) && (thisRuntimeId = (desc = WebServiceRuntimeExtensionUtils2.getServiceRuntimeDescriptorById(srIds[i])).getRuntime().getId()).equals(runtimeId)) {
                Set templates = FacetMatchCache.getInstance().getTemplatesForServiceRuntime(srIds[i]);
                for (IFacetedProjectTemplate template : templates) {
                    if (!template.getId().equals(templateId)) continue;
                    return true;
                }
            }
            ++i;
        }
        return false;
    }

    public static boolean doesServiceTypeAndRuntimeSupportTemplate(String typeId, String runtimeId, String templateId) {
        return WebServiceRuntimeExtensionUtils2.doesServiceTypeAndRuntimeSupportTemplate(typeId, runtimeId, templateId, null);
    }

    public static boolean doesServiceRuntimeSupportTemplate(String serviceRuntimeId, String templateId) {
        Set templates = FacetMatchCache.getInstance().getTemplatesForServiceRuntime(serviceRuntimeId);
        IFacetedProjectTemplate checkingTemplate = ProjectFacetsManager.getTemplate((String)templateId);
        return templates.contains(checkingTemplate);
    }

    public static WebServiceClientImpl getWebServiceClientImplById(String id) {
        Object result = WebServiceRuntimeExtensionUtils2.registry.webServiceClientImpls_.get(id);
        if (result != null) {
            return (WebServiceClientImpl)result;
        }
        return null;
    }

    public static ClientRuntimeDescriptor getClientRuntimeDescriptorById(String id) {
        Object result = WebServiceRuntimeExtensionUtils2.registry.clientRuntimes_.get(id);
        if (result != null) {
            return (ClientRuntimeDescriptor)result;
        }
        return null;
    }

    public static IWebServiceRuntime getClientRuntime(String clientRuntimeId) {
        ClientRuntimeDescriptor descriptor = WebServiceRuntimeExtensionUtils2.getClientRuntimeDescriptorById(clientRuntimeId);
        IWebServiceRuntime webserviceRuntime = null;
        if (descriptor != null) {
            webserviceRuntime = descriptor.getWebServiceRuntime();
        }
        return webserviceRuntime;
    }

    public static String getClientRuntimeId(TypeRuntimeServer trs, String projectName, String templateId) {
        boolean serverSelected = trs.getServerId() != null && trs.getServerId().length() > 0;
        String[] descs = WebServiceRuntimeExtensionUtils2.getClientRuntimesByType(trs.getTypeId(), trs.getServerId());
        int i = 0;
        while (i < descs.length) {
            IProject project;
            boolean supportsServer;
            ClientRuntimeDescriptor desc = WebServiceRuntimeExtensionUtils2.getClientRuntimeDescriptorById(descs[i]);
            if (desc.getRuntime().getId().equals(trs.getRuntimeId()) && (!serverSelected || (supportsServer = WebServiceRuntimeExtensionUtils2.doesClientRuntimeSupportServer(desc.getId(), trs.getServerId()))) && ((project = ProjectUtilities.getProject((String)projectName)).exists() ? WebServiceRuntimeExtensionUtils2.doesClientRuntimeSupportProject(desc.getId(), projectName) : WebServiceRuntimeExtensionUtils2.doesClientRuntimeSupportTemplate(desc.getId(), templateId))) {
                return desc.getId();
            }
            ++i;
        }
        return "";
    }

    public static String[] getAllRuntimesForClientSide() {
        ArrayList<String> runtimeIds = new ArrayList<String>();
        for (ClientRuntimeDescriptor desc : WebServiceRuntimeExtensionUtils2.registry.clientRuntimes_.values()) {
            String thisRuntimeId = desc.getRuntime().getId();
            if (runtimeIds.contains(thisRuntimeId)) continue;
            runtimeIds.add(thisRuntimeId);
        }
        return runtimeIds.toArray(new String[0]);
    }

    public static String[] getClientRuntimesByType(String clientImplId) {
        ArrayList<String> ids = new ArrayList<String>();
        for (ClientRuntimeDescriptor desc : WebServiceRuntimeExtensionUtils2.registry.clientRuntimes_.values()) {
            if (!desc.getClientImplementationType().getId().equals(clientImplId)) continue;
            ids.add(desc.getId());
        }
        return ids.toArray(new String[0]);
    }

    public static String[] getClientRuntimesByType(String clientImplId, String preferredServerFactoryId) {
        ArrayList<String> ids = new ArrayList<String>();
        ArrayList<String> idsPreferredByServer = new ArrayList<String>();
        for (ClientRuntimeDescriptor desc : WebServiceRuntimeExtensionUtils2.registry.clientRuntimes_.values()) {
            if (!desc.getClientImplementationType().getId().equals(clientImplId)) continue;
            String clientRuntimeId = desc.getId();
            if (desc.getRuntimePreferredServerType() != null && desc.getRuntimePreferredServerType().equals(preferredServerFactoryId)) {
                idsPreferredByServer.add(clientRuntimeId);
                continue;
            }
            ids.add(clientRuntimeId);
        }
        String[] preferredRuntimeIds = new String[idsPreferredByServer.size() + ids.size()];
        Iterator itr1 = idsPreferredByServer.iterator();
        int preferredRTCounter = 0;
        while (itr1.hasNext()) {
            String runtimeId = (String)itr1.next();
            preferredRuntimeIds[preferredRTCounter++] = runtimeId;
        }
        for (String runtimeId : ids) {
            preferredRuntimeIds[preferredRTCounter++] = runtimeId;
        }
        return preferredRuntimeIds;
    }

    public static String[] getRuntimesByClientType(String clientImplId) {
        ArrayList<String> runtimeIds = new ArrayList<String>();
        for (ClientRuntimeDescriptor desc : WebServiceRuntimeExtensionUtils2.registry.clientRuntimes_.values()) {
            if (!desc.getClientImplementationType().getId().equals(clientImplId) || runtimeIds.contains(desc.getRuntime().getId())) continue;
            runtimeIds.add(desc.getRuntime().getId());
        }
        return runtimeIds.toArray(new String[0]);
    }

    public static boolean isRuntimeSupportedForClientType(String clientImplId, String runtimeId) {
        String[] clientRuntimeIds = WebServiceRuntimeExtensionUtils2.getClientRuntimesByType(clientImplId);
        if (clientRuntimeIds != null) {
            int i = 0;
            while (i < clientRuntimeIds.length) {
                ClientRuntimeDescriptor desc = WebServiceRuntimeExtensionUtils2.getClientRuntimeDescriptorById(clientRuntimeIds[i]);
                if (desc.getRuntime().getId().equals(runtimeId)) {
                    return true;
                }
                ++i;
            }
        }
        return false;
    }

    public static String[] getAllClientServerFactoryIds() {
        return WebServiceRuntimeExtensionUtils2.getAllServerFactoryIdsWithRuntimes();
    }

    public static String[] getServerFactoryIdsByClientType(String clientImplId) {
        ArrayList<String> serverFactoryIds = new ArrayList<String>();
        String[] crts = WebServiceRuntimeExtensionUtils2.getClientRuntimesByType(clientImplId);
        if (crts != null) {
            int i = 0;
            while (i < crts.length) {
                String[] fIds = WebServiceRuntimeExtensionUtils2.getServerFactoryIdsByClientRuntime(crts[i]);
                int j = 0;
                while (j < fIds.length) {
                    if (!serverFactoryIds.contains(fIds[j])) {
                        serverFactoryIds.add(fIds[j]);
                    }
                    ++j;
                }
                ++i;
            }
        }
        return serverFactoryIds.toArray(new String[0]);
    }

    public static boolean isServerSupportedForChosenClientType(String clientImplId, String serverFactoryId) {
        String[] fIds = WebServiceRuntimeExtensionUtils2.getServerFactoryIdsByClientType(clientImplId);
        if (fIds == null) {
            return false;
        }
        int i = 0;
        while (i < fIds.length) {
            if (serverFactoryId.equals(fIds[i])) {
                return true;
            }
            ++i;
        }
        return false;
    }

    public static String[] getServerFactoryIdsByClientRuntime(String clientRuntimeId) {
        ClientRuntimeDescriptor desc = WebServiceRuntimeExtensionUtils2.getClientRuntimeDescriptorById(clientRuntimeId);
        Set facetRuntimes = WebServiceRuntimeExtensionUtils2.getRuntimes(desc.getRequiredFacetVersions());
        String[] fIds = WebServiceRuntimeExtensionUtils2.getServerFactoryIdsByFacetRuntimes(facetRuntimes);
        return fIds;
    }

    public static boolean doesClientRuntimeSupportServer(String clientRuntimeId, String serverFactoryId) {
        String[] serverIds = WebServiceRuntimeExtensionUtils2.getServerFactoryIdsByClientRuntime(clientRuntimeId);
        int i = 0;
        while (i < serverIds.length) {
            if (serverIds[i].equals(serverFactoryId)) {
                return true;
            }
            ++i;
        }
        return false;
    }

    public static boolean doesRuntimeSupportServerForClientSide(String runtimeId, String factoryId) {
        for (ClientRuntimeDescriptor desc : WebServiceRuntimeExtensionUtils2.registry.clientRuntimes_.values()) {
            String thisRuntimeId = desc.getRuntime().getId();
            if (!thisRuntimeId.equals(runtimeId)) continue;
            Set facetRuntimes = WebServiceRuntimeExtensionUtils2.getRuntimes(desc.getRequiredFacetVersions());
            String[] fIds = WebServiceRuntimeExtensionUtils2.getServerFactoryIdsByFacetRuntimes(facetRuntimes);
            int i = 0;
            while (i < fIds.length) {
                if (fIds[i].equals(factoryId)) {
                    return true;
                }
                ++i;
            }
        }
        return false;
    }

    public static String getFirstSupportedServerForClientSide(String runtimeId) {
        for (ClientRuntimeDescriptor desc : WebServiceRuntimeExtensionUtils2.registry.clientRuntimes_.values()) {
            Set facetRuntimes;
            String[] factoryIds;
            String thisRuntimeId = desc.getRuntime().getId();
            if (!thisRuntimeId.equals(runtimeId) || (factoryIds = WebServiceRuntimeExtensionUtils2.getServerFactoryIdsByFacetRuntimes(facetRuntimes = WebServiceRuntimeExtensionUtils2.getRuntimes(desc.getRequiredFacetVersions()))) == null || factoryIds.length <= 0) continue;
            return factoryIds[0];
        }
        return null;
    }

    public static boolean isServerClientRuntimeTypeSupported(String serverFactoryId, String runtimeId, String clientImplId) {
        String[] clientRuntimes = WebServiceRuntimeExtensionUtils2.getClientRuntimesByType(clientImplId);
        if (clientRuntimes != null && clientRuntimes.length > 0) {
            int i = 0;
            while (i < clientRuntimes.length) {
                ClientRuntimeDescriptor desc = WebServiceRuntimeExtensionUtils2.getClientRuntimeDescriptorById(clientRuntimes[i]);
                if (desc.getRuntime().getId().equals(runtimeId)) {
                    String[] factoryIds = WebServiceRuntimeExtensionUtils2.getServerFactoryIdsByClientRuntime(desc.getId());
                    int j = 0;
                    while (j < factoryIds.length) {
                        if (factoryIds[j].equals(serverFactoryId) && !desc.isUnsupportedServer(serverFactoryId)) {
                            return true;
                        }
                        ++j;
                    }
                }
                ++i;
            }
        }
        return false;
    }

    public static String[] getClientProjectTemplates(String clientImplId, String runtimeId, String serverId) {
        String[] crIds = WebServiceRuntimeExtensionUtils2.getClientRuntimesByType(clientImplId);
        if (crIds == null) {
            return null;
        }
        ArrayList<String> templateIdList = new ArrayList<String>();
        int i = 0;
        while (i < crIds.length) {
            ClientRuntimeDescriptor desc;
            String thisRuntimeId;
            if ((serverId == null || WebServiceRuntimeExtensionUtils2.doesClientRuntimeSupportServer(crIds[i], serverId)) && (thisRuntimeId = (desc = WebServiceRuntimeExtensionUtils2.getClientRuntimeDescriptorById(crIds[i])).getRuntime().getId()).equals(runtimeId) && !desc.isUnsupportedServer(serverId)) {
                Set templates = FacetMatchCache.getInstance().getTemplatesForClientRuntime(desc.getId());
                for (IFacetedProjectTemplate template : templates) {
                    if (templateIdList.contains(template.getId())) continue;
                    templateIdList.add(template.getId());
                }
            }
            ++i;
        }
        return templateIdList.toArray(new String[0]);
    }

    public static String[] getClientProjectTemplates(String clientImplId, String runtimeId) {
        return WebServiceRuntimeExtensionUtils2.getClientProjectTemplates(clientImplId, runtimeId, null);
    }

    public static boolean doesClientTypeAndRuntimeSupportTemplate(String clientImplId, String runtimeId, String templateId, String serverId) {
        String[] crIds = WebServiceRuntimeExtensionUtils2.getClientRuntimesByType(clientImplId);
        if (crIds == null) {
            return false;
        }
        int i = 0;
        while (i < crIds.length) {
            ClientRuntimeDescriptor desc;
            String thisRuntimeId;
            if ((serverId == null || WebServiceRuntimeExtensionUtils2.doesClientRuntimeSupportServer(crIds[i], serverId)) && (thisRuntimeId = (desc = WebServiceRuntimeExtensionUtils2.getClientRuntimeDescriptorById(crIds[i])).getRuntime().getId()).equals(runtimeId)) {
                Set templates = FacetMatchCache.getInstance().getTemplatesForClientRuntime(crIds[i]);
                for (IFacetedProjectTemplate template : templates) {
                    if (!template.getId().equals(templateId)) continue;
                    return true;
                }
            }
            ++i;
        }
        return false;
    }

    public static boolean doesClientTypeAndRuntimeSupportTemplate(String clientImplId, String runtimeId, String templateId) {
        return WebServiceRuntimeExtensionUtils2.doesClientTypeAndRuntimeSupportTemplate(clientImplId, runtimeId, templateId, null);
    }

    public static boolean doesClientRuntimeSupportTemplate(String clientRuntimeId, String templateId) {
        Set templates = FacetMatchCache.getInstance().getTemplatesForClientRuntime(clientRuntimeId);
        IFacetedProjectTemplate checkingTemplate = ProjectFacetsManager.getTemplate((String)templateId);
        return templates.contains(checkingTemplate);
    }

    public static LabelsAndIds getClientTypeLabels() {
        LabelsAndIds labelIds = new LabelsAndIds();
        String[] idsArray = new String[]{};
        String[] labelsArray = new String[]{};
        labelIds.setIds_(idsArray);
        labelIds.setLabels_(labelsArray);
        ArrayList<String> ids = new ArrayList<String>();
        ArrayList<String> labels = new ArrayList<String>();
        for (ClientRuntimeDescriptor desc : WebServiceRuntimeExtensionUtils2.registry.clientRuntimes_.values()) {
            WebServiceClientImpl thisClientImpl = desc.getClientImplementationType();
            if (ids.contains(thisClientImpl.getId())) continue;
            ids.add(thisClientImpl.getId());
            labels.add(thisClientImpl.getLabel());
        }
        if (ids.size() > 0) {
            idsArray = ids.toArray(new String[0]);
            labelsArray = labels.toArray(new String[0]);
            labelIds.setIds_(idsArray);
            labelIds.setLabels_(labelsArray);
        }
        return labelIds;
    }

    public static String[] getAllServerFactoryIdsWithRuntimes() {
        ArrayList<String> fids = new ArrayList<String>();
        IServerType[] sts = ServerCore.getServerTypes();
        IRuntime[] rts = ServerCore.getRuntimes();
        int i = 0;
        while (i < sts.length) {
            IServerType st = sts[i];
            int j = 0;
            while (j < rts.length) {
                String runtimeRuntimeTypeId;
                IRuntimeType rtType;
                if (st == null || st.getRuntimeType() == null) break;
                IRuntime rt = rts[j];
                String serverTypeRuntimeTypeId = st.getRuntimeType().getId();
                if (rt != null && (rtType = rt.getRuntimeType()) != null && serverTypeRuntimeTypeId.equals(runtimeRuntimeTypeId = rtType.getId()) && !fids.contains(st.getId())) {
                    fids.add(st.getId());
                }
                ++j;
            }
            ++i;
        }
        return fids.toArray(new String[0]);
    }

    public static String[] getProjectsForClientTypeAndRuntime(String typeId, String runtimeId) {
        return WebServiceRuntimeExtensionUtils2.getProjectsForClientTypeAndRuntime(typeId, runtimeId, null);
    }

    public static String[] getProjectsForClientTypeAndRuntime(String typeId, String runtimeId, String serverId) {
        IProject[] projects = FacetUtils.getAllProjects();
        ArrayList<String> validProjects = new ArrayList<String>();
        int i = 0;
        while (i < projects.length) {
            if (WebServiceRuntimeExtensionUtils2.doesClientTypeAndRuntimeSupportProject(typeId, runtimeId, projects[i].getName(), serverId)) {
                validProjects.add(projects[i].getName());
            }
            ++i;
        }
        return validProjects.toArray(new String[0]);
    }

    public static boolean doesClientTypeAndRuntimeSupportProject(String typeId, String runtimeId, String projectName) {
        return WebServiceRuntimeExtensionUtils2.doesClientTypeAndRuntimeSupportProject(typeId, runtimeId, projectName, null);
    }

    public static boolean doesClientTypeAndRuntimeSupportProject(String typeId, String runtimeId, String projectName, String serverId) {
        String[] descs = WebServiceRuntimeExtensionUtils2.getClientRuntimesByType(typeId);
        int j = 0;
        while (j < descs.length) {
            ClientRuntimeDescriptor desc = WebServiceRuntimeExtensionUtils2.getClientRuntimeDescriptorById(descs[j]);
            if (desc.getRuntime().getId().equals(runtimeId) && WebServiceRuntimeExtensionUtils2.doesClientRuntimeSupportProject(descs[j], projectName, serverId)) {
                return true;
            }
            ++j;
        }
        return false;
    }

    public static boolean doesClientRuntimeSupportProject(String clientRuntimeId, String projectName) {
        return WebServiceRuntimeExtensionUtils2.doesClientRuntimeSupportProject(clientRuntimeId, projectName, null);
    }

    public static boolean doesClientRuntimeSupportProject(String clientRuntimeId, String projectName, String serverId) {
        ClientRuntimeDescriptor desc;
        if (serverId != null && (desc = WebServiceRuntimeExtensionUtils2.getClientRuntimeDescriptorById(clientRuntimeId)).isUnsupportedServer(serverId)) {
            return false;
        }
        FacetMatcher fm = FacetMatchCache.getInstance().getMatchForProject(true, clientRuntimeId, projectName);
        if (fm != null) {
            return fm.isMatch();
        }
        return false;
    }

    public static SelectionListChoices getServerToRuntimeToJ2EE() {
        if (serverToRuntimeToJ2EE_ != null) {
            return serverToRuntimeToJ2EE_;
        }
        String[] servers = WebServiceRuntimeExtensionUtils2.getAllServerFactoryIds();
        SelectionList serversList = new SelectionList(servers, 0);
        Vector<SelectionListChoices> choices = new Vector<SelectionListChoices>();
        int i = 0;
        while (i < servers.length) {
            choices.add(WebServiceRuntimeExtensionUtils2.getRuntimeChoices(servers[i]));
            ++i;
        }
        serverToRuntimeToJ2EE_ = new SelectionListChoices(serversList, choices);
        return serverToRuntimeToJ2EE_;
    }

    private static SelectionListChoices getRuntimeChoices(String serverFactoryId) {
        Set runtimes = WebServiceRuntimeExtensionUtils2.registry.runtimes_.keySet();
        Iterator itr = WebServiceRuntimeExtensionUtils2.registry.runtimes_.keySet().iterator();
        String[] runtimeIds = new String[runtimes.size()];
        int i = 0;
        while (itr.hasNext()) {
            String runtimeId;
            runtimeIds[i] = runtimeId = (String)itr.next();
            ++i;
        }
        SelectionList runtimesList = new SelectionList(runtimeIds, 0);
        Vector<SelectionListChoices> choices = new Vector<SelectionListChoices>();
        int j = 0;
        while (j < runtimeIds.length) {
            choices.add(WebServiceRuntimeExtensionUtils2.getJ2EEChoices(runtimeIds[j]));
            ++j;
        }
        return new SelectionListChoices(runtimesList, choices);
    }

    private static SelectionListChoices getJ2EEChoices(String runtimeId) {
        String[] j2eeVersions = new String[]{"13", "14"};
        SelectionList j2eeVersionsList = new SelectionList(j2eeVersions, 0);
        return new SelectionListChoices(j2eeVersionsList, null);
    }

    private static String[] getAllServerFactoryIds() {
        ArrayList<String> ids = new ArrayList<String>();
        if (serverFactoryIdByLabel_ == null) {
            serverFactoryIdByLabel_ = new Hashtable();
            IServerType[] serverTypes = ServerCore.getServerTypes();
            int i = 0;
            while (i < serverTypes.length) {
                String id = serverTypes[i].getId();
                String label = WebServiceRuntimeExtensionUtils2.getServerLabelById(id);
                serverFactoryIdByLabel_.put(label, id);
                ids.add(id);
                ++i;
            }
        } else {
            for (String fid : serverFactoryIdByLabel_.values()) {
                ids.add(fid);
            }
        }
        if (ids.size() > 0) {
            String[] serverFactoryIds = ids.toArray(new String[0]);
            return serverFactoryIds;
        }
        return null;
    }

    public static String getServerFactoryId(String label) {
        if (label == null || label.length() == 0) {
            return null;
        }
        if (serverFactoryIdByLabel_ == null) {
            WebServiceRuntimeExtensionUtils2.getAllServerFactoryIds();
        }
        if (serverFactoryIdByLabel_.containsKey(label)) {
            return (String)serverFactoryIdByLabel_.get(label);
        }
        return null;
    }

    public static String getRuntimeId(String label) {
        if (label == null || label.length() == 0) {
            return null;
        }
        if (runtimeIdByLabel_ == null) {
            runtimeIdByLabel_ = new Hashtable();
            for (RuntimeDescriptor desc : WebServiceRuntimeExtensionUtils2.registry.runtimes_.values()) {
                runtimeIdByLabel_.put(desc.getLabel(), desc.getId());
            }
        }
        return (String)runtimeIdByLabel_.get(label);
    }

    private static Set getRuntimes(RequiredFacetVersion[] requiredFacetVersions) {
        return FacetUtils.getRuntimes((RequiredFacetVersion[])requiredFacetVersions);
    }

    public static IWebServiceRuntimeChecker getServiceRuntimeChecker(String serviceRuntimeId) {
        return WebServiceRuntimeExtensionUtils2.getServiceRuntimeDescriptorById(serviceRuntimeId).getServiceRuntimeChecker();
    }

    public static IWebServiceRuntimeChecker getClientRuntimeChecker(String clientRuntimeId) {
        return WebServiceRuntimeExtensionUtils2.getClientRuntimeDescriptorById(clientRuntimeId).getClientRuntimeChecker();
    }

    public static String getServicePreferredServerType(String serviceRuntimeId) {
        return WebServiceRuntimeExtensionUtils2.getServiceRuntimeDescriptorById(serviceRuntimeId).getRuntimePreferredServerType();
    }

    public static String getClientPreferredServerType(String clientRuntimeId) {
        return WebServiceRuntimeExtensionUtils2.getClientRuntimeDescriptorById(clientRuntimeId).getRuntimePreferredServerType();
    }
}

