/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jst.server.generic.core.internal.publishers;

import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.jst.server.core.IJ2EEModule;
import org.eclipse.jst.server.core.IWebModule;
import org.eclipse.jst.server.generic.core.internal.GenericServer;
import org.eclipse.jst.server.generic.core.internal.publishers.AbstractModuleAssembler;
import org.eclipse.wst.server.core.IModule;
import org.eclipse.wst.server.core.model.IModuleResource;
import org.eclipse.wst.server.core.util.ProjectModule;

public class WarModuleAssembler
extends AbstractModuleAssembler {
    protected WarModuleAssembler(IModule module, GenericServer server, IPath assembleRoot) {
        super(module, server, assembleRoot);
    }

    public IPath assemble(IProgressMonitor monitor) throws CoreException {
        IPath parent = this.copyModule(this.fModule, monitor);
        IWebModule webModule = (IWebModule)this.fModule.loadAdapter(IWebModule.class, monitor);
        IModule[] childModules = webModule.getModules();
        int i = 0;
        while (i < childModules.length) {
            IModule module = childModules[i];
            String uri = webModule.getURI(module);
            if (uri == null) {
                Status status = new Status(4, "org.eclipse.jst.server.generic.core", 0, "unable to assemble module null uri", null);
                throw new CoreException((IStatus)status);
            }
            IJ2EEModule jeeModule = (IJ2EEModule)module.loadAdapter(IJ2EEModule.class, monitor);
            if (jeeModule != null && jeeModule.isBinary()) {
                ProjectModule pm = (ProjectModule)module.loadAdapter(ProjectModule.class, null);
                IModuleResource[] resources = pm.members();
                this.publishHelper.publishToPath(resources, parent.append(uri), monitor);
            } else {
                this.packModule(module, uri, parent);
            }
            ++i;
        }
        return parent;
    }
}

