/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jst.ws.internal.jaxws.core.annotations.validation;

import com.sun.mirror.declaration.AnnotationMirror;
import com.sun.mirror.declaration.AnnotationTypeDeclaration;
import com.sun.mirror.declaration.Declaration;
import com.sun.mirror.declaration.MethodDeclaration;
import com.sun.mirror.declaration.ParameterDeclaration;
import com.sun.mirror.declaration.TypeDeclaration;
import com.sun.mirror.type.TypeMirror;
import java.util.Collection;
import javax.jws.WebParam;
import javax.jws.WebService;
import javax.xml.ws.Holder;
import org.eclipse.jst.ws.annotations.core.processor.AbstractAnnotationProcessor;
import org.eclipse.jst.ws.annotations.core.utils.AnnotationUtils;
import org.eclipse.jst.ws.internal.jaxws.core.JAXWSCoreMessages;

public class HolderTypeParametersRule
extends AbstractAnnotationProcessor {
    public void process() {
        AnnotationTypeDeclaration annotationDeclaration = (AnnotationTypeDeclaration)this.environment.getTypeDeclaration(WebService.class.getName());
        Collection annotatedTypes = this.environment.getDeclarationsAnnotatedWith(annotationDeclaration);
        for (Declaration declaration : annotatedTypes) {
            if (!(declaration instanceof TypeDeclaration)) continue;
            this.validateParameters((TypeDeclaration)declaration);
        }
    }

    private void validateParameters(TypeDeclaration typeDeclaration) {
        Collection methods = typeDeclaration.getMethods();
        for (MethodDeclaration methodDeclaration : methods) {
            Collection parameters = methodDeclaration.getParameters();
            for (ParameterDeclaration parameter : parameters) {
                TypeMirror typeMirror = this.environment.getTypeUtils().getErasure(parameter.getType());
                boolean isHolderParameter = typeMirror.toString().equals(Holder.class.getCanonicalName());
                if (this.isWebParamOutInoutMode(parameter) && !isHolderParameter) {
                    this.printError(parameter.getPosition(), JAXWSCoreMessages.WEBPARAM_MODE_OUT_INOUT_HOLDER_TYPE);
                    continue;
                }
                if (!isHolderParameter || !this.isWebParamInMode(parameter)) continue;
                this.printError(parameter.getPosition(), JAXWSCoreMessages.HOLDER_TYPE_MUST_BE_OUT_INOUT);
            }
        }
    }

    private boolean isWebParamInMode(ParameterDeclaration parameter) {
        String mode = this.getMode(parameter);
        if (mode != null) {
            return mode.equals(WebParam.Mode.IN.toString());
        }
        return false;
    }

    private boolean isWebParamOutInoutMode(ParameterDeclaration parameter) {
        String mode = this.getMode(parameter);
        if (mode != null) {
            return mode.equals(WebParam.Mode.OUT.name()) || mode.equals(WebParam.Mode.INOUT.name());
        }
        return false;
    }

    private String getMode(ParameterDeclaration parameter) {
        AnnotationMirror webParam = AnnotationUtils.getAnnotation((Declaration)parameter, WebParam.class);
        if (webParam != null) {
            return AnnotationUtils.getStringValue((AnnotationMirror)webParam, (String)"mode");
        }
        return null;
    }
}

