/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jst.ws.internal.consumption.ui.widgets;

import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Vector;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.jem.util.emf.workbench.ProjectUtilities;
import org.eclipse.jem.util.emf.workbench.WorkbenchResourceHelperBase;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jst.j2ee.applicationclient.componentcore.util.AppClientArtifactEdit;
import org.eclipse.jst.j2ee.client.ApplicationClient;
import org.eclipse.jst.j2ee.client.ApplicationClientResource;
import org.eclipse.jst.j2ee.ejb.EJBJar;
import org.eclipse.jst.j2ee.ejb.EJBResource;
import org.eclipse.jst.j2ee.ejb.internal.modulecore.util.EJBArtifactEditUtilities;
import org.eclipse.jst.j2ee.internal.webservice.WebServiceNavigatorGroupType;
import org.eclipse.jst.j2ee.web.componentcore.util.WebArtifactEdit;
import org.eclipse.jst.j2ee.webapplication.WebApp;
import org.eclipse.jst.j2ee.webapplication.WebAppResource;
import org.eclipse.jst.j2ee.webservice.wsclient.Handler;
import org.eclipse.jst.j2ee.webservice.wsclient.ServiceRef;
import org.eclipse.jst.j2ee.webservice.wsclient.WebServicesResource;
import org.eclipse.jst.ws.internal.common.J2EEUtils;
import org.eclipse.jst.ws.internal.consumption.ui.ConsumptionUIMessages;
import org.eclipse.jst.ws.internal.consumption.ui.common.HandlerServiceRefHolder;
import org.eclipse.jst.ws.internal.consumption.ui.helper.WebServicesManager;
import org.eclipse.jst.ws.internal.consumption.ui.widgets.AbstractHandlersWidgetDefaultingCmd;
import org.eclipse.jst.ws.internal.consumption.ui.widgets.object.HandlerTableItem;
import org.eclipse.wst.command.internal.env.core.common.StatusUtils;
import org.eclipse.wst.common.componentcore.ComponentCore;
import org.eclipse.wst.common.componentcore.resources.IVirtualComponent;
import org.eclipse.wst.common.environment.IEnvironment;

public class ClientHandlersWidgetDefaultingCommand
extends AbstractHandlersWidgetDefaultingCmd {
    private WebServicesManager webServicesManager_;
    private IProject project_;
    private String serviceRefName_ = null;
    private List wsServiceRefs_;
    private HandlerServiceRefHolder[] handlerServiceRefHolder_;
    private String errorStatusMsg_ = null;
    private boolean isMultipleSelection_;

    public IStatus execute(IProgressMonitor monitor, IAdaptable adaptable) {
        IEnvironment env = this.getEnvironment();
        IStatus status = Status.OK_STATUS;
        this.webServicesManager_ = WebServicesManager.getInstance();
        IStructuredSelection selection = this.getInitialSelection();
        if (selection == null) {
            status = StatusUtils.errorStatus((String)ConsumptionUIMessages.MSG_ERROR_TASK_EXCEPTED);
            env.getStatusHandler().reportError(status);
            return status;
        }
        if (selection.size() > 1) {
            status = this.processMultipleHandlers();
            return status;
        }
        status = this.processHandlers();
        return status;
    }

    public IStatus processHandlers() {
        try {
            Collection selectedServiceRefs = this.getWSServiceRefsFromSelection();
            if (selectedServiceRefs == null || selectedServiceRefs.isEmpty()) {
                return StatusUtils.errorStatus((String)ConsumptionUIMessages.MSG_ERROR_WEB_SERVICE_CLIENTS_NOT_FOUND);
            }
            this.wsServiceRefs_ = this.webServicesManager_.getAllWorkspaceServiceRefs();
            if (this.wsServiceRefs_ != null) {
                int numberOfServiceRefs = this.wsServiceRefs_.size();
                this.handlerServiceRefHolder_ = new HandlerServiceRefHolder[numberOfServiceRefs];
                int i = 0;
                while (i < numberOfServiceRefs) {
                    ServiceRef wsServiceRef = (ServiceRef)this.wsServiceRefs_.get(i);
                    Vector<HandlerTableItem> handlers = new Vector<HandlerTableItem>();
                    EList wsHandlers = wsServiceRef.getHandlers();
                    int k = 0;
                    while (k < wsHandlers.size()) {
                        Handler wsHandler = (Handler)wsHandlers.get(k);
                        HandlerTableItem handlerItem = new HandlerTableItem();
                        handlerItem.setHandler(wsHandler);
                        handlerItem.setHandlerName(wsHandler.getHandlerName());
                        handlerItem.setHandlerClassName(wsHandler.getHandlerClass().getQualifiedName());
                        handlerItem.setWsDescRef(wsServiceRef);
                        handlers.add(handlerItem);
                        ++k;
                    }
                    String wsServiceRefName = wsServiceRef.getServiceRefName();
                    this.handlerServiceRefHolder_[i] = new HandlerServiceRefHolder();
                    this.handlerServiceRefHolder_[i].setHandlerList(handlers);
                    this.handlerServiceRefHolder_[i].setServiceRef(wsServiceRef);
                    this.handlerServiceRefHolder_[i].setServiceRefName(wsServiceRefName);
                    ++i;
                }
            }
        }
        catch (Exception e) {
            return StatusUtils.errorStatus((String)ConsumptionUIMessages.MSG_ERROR_TASK_EXCEPTED, (Throwable)e);
        }
        return Status.OK_STATUS;
    }

    public IStatus processMultipleHandlers() {
        ServiceRef[] serviceRefs = this.getServiceRefs();
        if (this.errorStatusMsg_ != null) {
            return StatusUtils.errorStatus((String)this.errorStatusMsg_);
        }
        this.isMultipleSelection_ = true;
        this.handlerServiceRefHolder_ = new HandlerServiceRefHolder[serviceRefs.length];
        Vector handlers = new Vector();
        int i = 0;
        while (i < serviceRefs.length) {
            String refName = serviceRefs[i].getServiceRefName();
            this.handlerServiceRefHolder_[i] = new HandlerServiceRefHolder();
            this.handlerServiceRefHolder_[i].setHandlerList(handlers);
            this.handlerServiceRefHolder_[i].setServiceRefName(refName);
            this.handlerServiceRefHolder_[i].setServiceRef(serviceRefs[i]);
            ++i;
        }
        return Status.OK_STATUS;
    }

    public boolean getGenSkeletonEnabled() {
        return !this.isMultipleSelection_;
    }

    public String getServiceRefName() {
        return this.serviceRefName_;
    }

    public IProject getClientProject() {
        return this.project_;
    }

    private ServiceRef[] getServiceRefs() {
        IStructuredSelection initSel = this.getInitialSelection();
        ServiceRef[] serviceRefs = new ServiceRef[initSel.size()];
        Iterator iter = initSel.iterator();
        int i = 0;
        while (i < initSel.size()) {
            Object obj = iter.next();
            if (!(obj instanceof ServiceRef)) {
                this.errorStatusMsg_ = ConsumptionUIMessages.MSG_ERROR_INVALID_MULTIPLE_SERVICE_SELECT;
                return null;
            }
            serviceRefs[i] = (ServiceRef)obj;
            ++i;
        }
        return serviceRefs;
    }

    private Collection getWSServiceRefsFromSelection() {
        block31: {
            IStructuredSelection initSel = this.getInitialSelection();
            if (initSel != null && initSel.size() == 1) {
                IVirtualComponent vc;
                Object obj = initSel.getFirstElement();
                ServiceRef serviceRef = null;
                if (obj instanceof ServiceRef) {
                    serviceRef = (ServiceRef)obj;
                    this.serviceRefName_ = serviceRef.getServiceRefName();
                    this.project_ = ProjectUtilities.getProject((EObject)serviceRef);
                } else if (obj instanceof WebServiceNavigatorGroupType) {
                    WebServiceNavigatorGroupType wsngt = (WebServiceNavigatorGroupType)obj;
                    serviceRef = wsngt.getServiceRef();
                    this.serviceRefName_ = serviceRef.getServiceRefName();
                    this.project_ = ProjectUtilities.getProject((EObject)serviceRef);
                } else if (obj instanceof IFile) {
                    Resource res = WorkbenchResourceHelperBase.getResource((IFile)((IFile)obj), (boolean)true);
                    Object serviceRefs = null;
                    if (res instanceof WebServicesResource) {
                        WebServicesResource wsRes = (WebServicesResource)res;
                        serviceRefs = wsRes.getWebServicesClient().getServiceRefs();
                        if (!serviceRefs.isEmpty()) {
                            ServiceRef ref = (ServiceRef)((List)serviceRefs).get(0);
                            this.serviceRefName_ = ref.getServiceRefName();
                            this.project_ = ProjectUtilities.getProject((EObject)ref);
                            return serviceRefs;
                        }
                        return null;
                    }
                    if (res instanceof WebAppResource) {
                        WebAppResource webAppRes = (WebAppResource)res;
                        serviceRefs = webAppRes.getWebApp().getServiceRefs();
                    } else if (res instanceof EJBResource) {
                        EJBResource ejbRes = (EJBResource)res;
                        serviceRefs = this.webServicesManager_.getServiceRefs(ejbRes.getEJBJar());
                    } else if (res instanceof ApplicationClientResource) {
                        ApplicationClientResource appClientRes = (ApplicationClientResource)res;
                        serviceRefs = this.webServicesManager_.getServiceRefs(appClientRes.getApplicationClient());
                    }
                    if (serviceRefs != null && serviceRefs.size() > 0) {
                        ServiceRef ref = (ServiceRef)((List)serviceRefs).get(0);
                        this.serviceRefName_ = ref.getServiceRefName();
                        this.project_ = ProjectUtilities.getProject((EObject)ref);
                    }
                    return serviceRefs;
                }
                if (this.project_ == null) {
                    this.project_ = this.getProject();
                }
                if (this.project_ == null) {
                    return null;
                }
                if (J2EEUtils.isWebComponent((IProject)this.project_)) {
                    WebArtifactEdit webEdit = null;
                    try {
                        WebApp webApp;
                        IVirtualComponent vc2 = ComponentCore.createComponent((IProject)this.project_);
                        webEdit = WebArtifactEdit.getWebArtifactEditForRead((IVirtualComponent)vc2);
                        if (webEdit != null && (webApp = (WebApp)webEdit.getDeploymentDescriptorRoot()) != null) {
                            Collection collection = this.webServicesManager_.getServiceRefs(webApp);
                            return collection;
                        }
                        break block31;
                    }
                    finally {
                        if (webEdit != null) {
                            webEdit.dispose();
                        }
                    }
                }
                if (J2EEUtils.isEJBComponent((IProject)this.project_)) {
                    vc = ComponentCore.createComponent((IProject)this.project_);
                    EJBJar ejbJar = EJBArtifactEditUtilities.getEJBJar((IVirtualComponent)vc);
                    if (ejbJar != null) {
                        return this.webServicesManager_.getServiceRefs(ejbJar);
                    }
                } else if (J2EEUtils.isAppClientComponent((IProject)this.project_)) {
                    vc = ComponentCore.createComponent((IProject)this.project_);
                    AppClientArtifactEdit appEdit = null;
                    try {
                        ApplicationClient appClient;
                        appEdit = AppClientArtifactEdit.getAppClientArtifactEditForRead((IVirtualComponent)vc);
                        if (appEdit != null && (appClient = appEdit.getApplicationClient()) != null) {
                            Collection collection = this.webServicesManager_.getServiceRefs(appClient);
                            return collection;
                        }
                    }
                    finally {
                        if (appEdit != null) {
                            appEdit.dispose();
                        }
                    }
                }
            }
        }
        return null;
    }

    public Collection getWsServiceRefs() {
        return this.wsServiceRefs_;
    }

    public boolean getIsMultipleSelection() {
        return this.isMultipleSelection_;
    }

    public HandlerServiceRefHolder[] getHandlerServiceRefHolder() {
        return this.handlerServiceRefHolder_;
    }
}

