/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.server.ui.internal.view.servers;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import org.eclipse.swt.dnd.ByteArrayTransfer;
import org.eclipse.swt.dnd.DND;
import org.eclipse.swt.dnd.TransferData;
import org.eclipse.wst.server.core.IServer;
import org.eclipse.wst.server.core.internal.IMemento;
import org.eclipse.wst.server.core.internal.Server;
import org.eclipse.wst.server.core.internal.XMLMemento;

public class ServerTransfer
extends ByteArrayTransfer {
    private static final ServerTransfer instance = new ServerTransfer();
    private static final String TYPE_NAME = "server-transfer-format:" + System.currentTimeMillis() + ":" + ((Object)((Object)instance)).hashCode();
    private static final int TYPEID = ServerTransfer.registerType((String)TYPE_NAME);

    private ServerTransfer() {
    }

    public static ServerTransfer getInstance() {
        return instance;
    }

    protected int[] getTypeIds() {
        return new int[]{TYPEID};
    }

    protected String[] getTypeNames() {
        return new String[]{TYPE_NAME};
    }

    protected void javaToNative(Object data, TransferData transferData) {
        if (!(data instanceof IServer[])) {
            return;
        }
        IServer[] servers = (IServer[])data;
        try {
            ByteArrayOutputStream out = new ByteArrayOutputStream();
            XMLMemento memento = XMLMemento.createWriteRoot((String)"servers");
            int i = 0;
            while (i < servers.length) {
                IMemento child = memento.createChild("server");
                ((Server)servers[i]).serialize(child);
                ++i;
            }
            memento.save((OutputStream)out);
            out.close();
            byte[] bytes = out.toByteArray();
            super.javaToNative((Object)bytes, transferData);
        }
        catch (IOException iOException) {}
    }

    protected Object nativeToJava(TransferData transferData) {
        byte[] bytes = (byte[])super.nativeToJava(transferData);
        if (bytes == null) {
            return null;
        }
        ByteArrayInputStream in = new ByteArrayInputStream(bytes);
        try {
            IMemento memento = XMLMemento.loadMemento((InputStream)in);
            IMemento[] children = memento.getChildren("server");
            int count = children.length;
            IServer[] results = new IServer[count];
            int i = 0;
            while (i < count) {
                Server server = new Server(null);
                server.deserialize(children[i]);
                results[i] = server;
                ++i;
            }
            return results;
        }
        catch (Exception exception) {
            DND.error((int)2003);
            return null;
        }
    }
}

