/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jst.ws.internal.consumption.ui.widgets.object;

import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.IPath;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.jdt.core.ICompilationUnit;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jst.j2ee.webservice.wsdd.ServiceImplBean;
import org.eclipse.jst.j2ee.webservice.wsdd.ServletLink;
import org.eclipse.jst.j2ee.webservice.wsdd.internal.impl.PortComponentImpl;
import org.eclipse.jst.ws.internal.common.ResourceUtils;
import org.eclipse.wst.command.internal.env.core.data.Transformer;

public class JavaBeanSelectionTransformer
implements Transformer {
    public Object transform(Object value) {
        if (value instanceof IStructuredSelection) {
            Object sel = ((IStructuredSelection)value).getFirstElement();
            if (sel instanceof IFile) {
                return new StructuredSelection((Object)this.computeFullyQualifiedJavaName((IFile)sel));
            }
            if (sel instanceof ICompilationUnit) {
                IResource res = ((ICompilationUnit)sel).getResource();
                if (res instanceof IFile) {
                    return new StructuredSelection((Object)this.computeFullyQualifiedJavaName((IFile)res));
                }
            } else {
                if (sel instanceof ServiceImplBean) {
                    return new StructuredSelection((Object)this.getBeanName((ServiceImplBean)sel));
                }
                if (sel instanceof ServletLink) {
                    return new StructuredSelection((Object)this.getBeanName((ServletLink)sel));
                }
            }
        }
        return value;
    }

    private String computeFullyQualifiedJavaName(IFile resource) {
        IPath path = resource.getFullPath();
        String basename = path.lastSegment();
        String beanClass = "";
        if (basename != null && basename.length() > 0) {
            String beanPackage = ResourceUtils.getJavaResourcePackageName((IPath)path);
            String string = beanClass = beanPackage == null || beanPackage.length() == 0 ? basename : String.valueOf(beanPackage) + "." + basename;
            if (beanClass.toLowerCase().endsWith(".java") || beanClass.toLowerCase().endsWith(".class")) {
                beanClass = beanClass.substring(0, beanClass.lastIndexOf(46));
            }
        }
        return beanClass;
    }

    private String getBeanName(ServiceImplBean bean) {
        EObject eObject = bean.eContainer();
        if (eObject instanceof PortComponentImpl) {
            PortComponentImpl pci = (PortComponentImpl)eObject;
            return pci.getServiceEndpointInterface();
        }
        return "";
    }

    private String getBeanName(ServletLink link) {
        EObject eObject = link.eContainer();
        if (eObject instanceof ServiceImplBean) {
            return this.getBeanName((ServiceImplBean)eObject);
        }
        return "";
    }
}

