/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jpt.jpa.core.internal.resource.persistence;

import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.IPath;
import org.eclipse.jpt.jpa.core.JptJpaCorePlugin;
import org.eclipse.jpt.jpa.core.internal.operations.PersistenceFileCreationDataModelProperties;
import org.eclipse.jpt.jpa.core.resource.AbstractXmlResourceProvider;
import org.eclipse.jpt.jpa.core.resource.persistence.PersistenceFactory;
import org.eclipse.jpt.jpa.core.resource.persistence.XmlPersistence;
import org.eclipse.jpt.jpa.core.resource.persistence.XmlPersistenceUnit;
import org.eclipse.wst.common.frameworks.datamodel.IDataModel;

public class PersistenceXmlResourceProvider
extends AbstractXmlResourceProvider
implements PersistenceFileCreationDataModelProperties {
    public static PersistenceXmlResourceProvider getXmlResourceProvider(IFile file) {
        return PersistenceXmlResourceProvider.getXmlResourceProvider_(file.getProject(), file.getFullPath());
    }

    public static PersistenceXmlResourceProvider getXmlResourceProvider(IProject project, IPath runtimePath) {
        return PersistenceXmlResourceProvider.getXmlResourceProvider_(project, runtimePath);
    }

    public static PersistenceXmlResourceProvider getDefaultXmlResourceProvider(IProject project) {
        return PersistenceXmlResourceProvider.getXmlResourceProvider(project, JptJpaCorePlugin.DEFAULT_PERSISTENCE_XML_RUNTIME_PATH);
    }

    private static PersistenceXmlResourceProvider getXmlResourceProvider_(IProject project, IPath fullPath) {
        return new PersistenceXmlResourceProvider(project, fullPath);
    }

    public PersistenceXmlResourceProvider(IProject project) {
        this(project, JptJpaCorePlugin.DEFAULT_PERSISTENCE_XML_RUNTIME_PATH);
    }

    public PersistenceXmlResourceProvider(IProject project, IPath filePath) {
        super(project, filePath, JptJpaCorePlugin.PERSISTENCE_XML_CONTENT_TYPE);
    }

    protected void populateRoot(Object config) {
        IDataModel dataModel = (IDataModel)config;
        XmlPersistence persistence = PersistenceFactory.eINSTANCE.createXmlPersistence();
        persistence.setVersion(dataModel.getStringProperty("JpaFileCreationDataModelProperties.VERSION"));
        XmlPersistenceUnit persistenceUnit = PersistenceFactory.eINSTANCE.createXmlPersistenceUnit();
        persistenceUnit.setName(this.getProject().getName());
        persistence.getPersistenceUnits().add((Object)persistenceUnit);
        this.getResourceContents().add((Object)persistence);
    }
}

