/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jpt.jpa.core.internal.context.java;

import java.util.Iterator;
import org.eclipse.jdt.core.dom.CompilationUnit;
import org.eclipse.jpt.common.core.utility.TextRange;
import org.eclipse.jpt.common.utility.Filter;
import org.eclipse.jpt.common.utility.internal.StringTools;
import org.eclipse.jpt.common.utility.internal.iterators.FilteringIterator;
import org.eclipse.jpt.jpa.core.context.ReadOnlyBaseColumn;
import org.eclipse.jpt.jpa.core.context.java.JavaBaseColumn;
import org.eclipse.jpt.jpa.core.context.java.JavaJpaContextNode;
import org.eclipse.jpt.jpa.core.internal.context.NamedColumnTextRangeResolver;
import org.eclipse.jpt.jpa.core.internal.context.java.AbstractJavaNamedColumn;
import org.eclipse.jpt.jpa.core.internal.context.java.JavaBaseColumnTextRangeResolver;
import org.eclipse.jpt.jpa.core.resource.java.BaseColumnAnnotation;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class AbstractJavaBaseColumn<A extends BaseColumnAnnotation, O extends JavaBaseColumn.Owner>
extends AbstractJavaNamedColumn<A, O>
implements JavaBaseColumn {
    protected String specifiedTable = this.buildSpecifiedTable();
    protected String defaultTable;
    protected Boolean specifiedUnique = this.buildSpecifiedUnique();
    protected boolean defaultUnique;
    protected Boolean specifiedNullable = this.buildSpecifiedNullable();
    protected boolean defaultNullable;
    protected Boolean specifiedInsertable = this.buildSpecifiedInsertable();
    protected boolean defaultInsertable;
    protected Boolean specifiedUpdatable = this.buildSpecifiedUpdatable();
    protected boolean defaultUpdatable;

    protected AbstractJavaBaseColumn(JavaJpaContextNode parent, O owner) {
        this(parent, owner, null);
    }

    protected AbstractJavaBaseColumn(JavaJpaContextNode parent, O owner, A columnAnnotation) {
        super(parent, owner, columnAnnotation);
    }

    @Override
    public void synchronizeWithResourceModel() {
        super.synchronizeWithResourceModel();
        this.setSpecifiedTable_(this.buildSpecifiedTable());
        this.setSpecifiedUnique_(this.buildSpecifiedUnique());
        this.setSpecifiedNullable_(this.buildSpecifiedNullable());
        this.setSpecifiedInsertable_(this.buildSpecifiedInsertable());
        this.setSpecifiedUpdatable_(this.buildSpecifiedUpdatable());
    }

    @Override
    public void update() {
        super.update();
        this.setDefaultTable(this.buildDefaultTable());
        this.setDefaultUnique(this.buildDefaultUnique());
        this.setDefaultNullable(this.buildDefaultNullable());
        this.setDefaultInsertable(this.buildDefaultInsertable());
        this.setDefaultUpdatable(this.buildDefaultUpdatable());
    }

    @Override
    public String getTable() {
        return this.specifiedTable != null ? this.specifiedTable : this.defaultTable;
    }

    @Override
    public String getSpecifiedTable() {
        return this.specifiedTable;
    }

    @Override
    public void setSpecifiedTable(String table) {
        if (this.valuesAreDifferent(this.specifiedTable, table)) {
            ((BaseColumnAnnotation)this.getColumnAnnotation()).setTable(table);
            this.removeColumnAnnotationIfUnset();
            this.setSpecifiedTable_(table);
        }
    }

    protected void setSpecifiedTable_(String table) {
        String old = this.specifiedTable;
        this.specifiedTable = table;
        this.firePropertyChanged("specifiedTable", old, table);
    }

    protected String buildSpecifiedTable() {
        return ((BaseColumnAnnotation)this.getColumnAnnotation()).getTable();
    }

    @Override
    public String getDefaultTable() {
        return this.defaultTable;
    }

    protected void setDefaultTable(String table) {
        String old = this.defaultTable;
        this.defaultTable = table;
        this.firePropertyChanged("defaultTable", old, table);
    }

    protected String buildDefaultTable() {
        return ((JavaBaseColumn.Owner)this.owner).getDefaultTableName();
    }

    @Override
    public TextRange getTableTextRange(CompilationUnit astRoot) {
        return this.getValidationTextRange(((BaseColumnAnnotation)this.getColumnAnnotation()).getTableTextRange(astRoot), astRoot);
    }

    @Override
    public boolean isUnique() {
        return this.specifiedUnique != null ? this.specifiedUnique.booleanValue() : this.isDefaultUnique();
    }

    @Override
    public Boolean getSpecifiedUnique() {
        return this.specifiedUnique;
    }

    @Override
    public void setSpecifiedUnique(Boolean unique) {
        if (this.valuesAreDifferent(this.specifiedUnique, unique)) {
            ((BaseColumnAnnotation)this.getColumnAnnotation()).setUnique(unique);
            this.removeColumnAnnotationIfUnset();
            this.setSpecifiedUnique_(unique);
        }
    }

    protected void setSpecifiedUnique_(Boolean unique) {
        Boolean old = this.specifiedUnique;
        this.specifiedUnique = unique;
        this.firePropertyChanged("specifiedUnique", old, unique);
    }

    protected Boolean buildSpecifiedUnique() {
        return ((BaseColumnAnnotation)this.getColumnAnnotation()).getUnique();
    }

    @Override
    public boolean isDefaultUnique() {
        return this.defaultUnique;
    }

    protected void setDefaultUnique(boolean unique) {
        boolean old = this.defaultUnique;
        this.defaultUnique = unique;
        this.firePropertyChanged("defaultUnique", old, unique);
    }

    protected boolean buildDefaultUnique() {
        return false;
    }

    @Override
    public boolean isNullable() {
        return this.specifiedNullable != null ? this.specifiedNullable.booleanValue() : this.isDefaultNullable();
    }

    @Override
    public Boolean getSpecifiedNullable() {
        return this.specifiedNullable;
    }

    @Override
    public void setSpecifiedNullable(Boolean nullable) {
        if (this.valuesAreDifferent(this.specifiedNullable, nullable)) {
            ((BaseColumnAnnotation)this.getColumnAnnotation()).setNullable(nullable);
            this.removeColumnAnnotationIfUnset();
            this.setSpecifiedNullable_(nullable);
        }
    }

    protected void setSpecifiedNullable_(Boolean nullable) {
        Boolean old = this.specifiedNullable;
        this.specifiedNullable = nullable;
        this.firePropertyChanged("specifiedNullable", old, nullable);
    }

    protected Boolean buildSpecifiedNullable() {
        return ((BaseColumnAnnotation)this.getColumnAnnotation()).getNullable();
    }

    @Override
    public boolean isDefaultNullable() {
        return this.defaultNullable;
    }

    protected void setDefaultNullable(boolean nullable) {
        boolean old = this.defaultNullable;
        this.defaultNullable = nullable;
        this.firePropertyChanged("defaultNullable", old, nullable);
    }

    protected boolean buildDefaultNullable() {
        return true;
    }

    @Override
    public boolean isInsertable() {
        return this.specifiedInsertable != null ? this.specifiedInsertable.booleanValue() : this.isDefaultInsertable();
    }

    @Override
    public Boolean getSpecifiedInsertable() {
        return this.specifiedInsertable;
    }

    @Override
    public void setSpecifiedInsertable(Boolean insertable) {
        if (this.valuesAreDifferent(this.specifiedInsertable, insertable)) {
            ((BaseColumnAnnotation)this.getColumnAnnotation()).setInsertable(insertable);
            this.removeColumnAnnotationIfUnset();
            this.setSpecifiedInsertable_(insertable);
        }
    }

    protected void setSpecifiedInsertable_(Boolean insertable) {
        Boolean old = this.specifiedInsertable;
        this.specifiedInsertable = insertable;
        this.firePropertyChanged("specifiedInsertable", old, insertable);
    }

    protected Boolean buildSpecifiedInsertable() {
        return ((BaseColumnAnnotation)this.getColumnAnnotation()).getInsertable();
    }

    @Override
    public boolean isDefaultInsertable() {
        return this.defaultInsertable;
    }

    protected void setDefaultInsertable(boolean insertable) {
        boolean old = this.defaultInsertable;
        this.defaultInsertable = insertable;
        this.firePropertyChanged("defaultInsertable", old, insertable);
    }

    protected boolean buildDefaultInsertable() {
        return true;
    }

    @Override
    public boolean isUpdatable() {
        return this.specifiedUpdatable != null ? this.specifiedUpdatable.booleanValue() : this.isDefaultUpdatable();
    }

    @Override
    public Boolean getSpecifiedUpdatable() {
        return this.specifiedUpdatable;
    }

    @Override
    public void setSpecifiedUpdatable(Boolean updatable) {
        if (this.valuesAreDifferent(this.specifiedUpdatable, updatable)) {
            ((BaseColumnAnnotation)this.getColumnAnnotation()).setUpdatable(updatable);
            this.removeColumnAnnotationIfUnset();
            this.setSpecifiedUpdatable_(updatable);
        }
    }

    protected void setSpecifiedUpdatable_(Boolean updatable) {
        Boolean old = this.specifiedUpdatable;
        this.specifiedUpdatable = updatable;
        this.firePropertyChanged("specifiedUpdatable", old, updatable);
    }

    protected Boolean buildSpecifiedUpdatable() {
        return ((BaseColumnAnnotation)this.getColumnAnnotation()).getUpdatable();
    }

    @Override
    public boolean isDefaultUpdatable() {
        return this.defaultUpdatable;
    }

    protected void setDefaultUpdatable(boolean updatable) {
        boolean old = this.defaultUpdatable;
        this.defaultUpdatable = updatable;
        this.firePropertyChanged("defaultUpdatable", old, updatable);
    }

    protected boolean buildDefaultUpdatable() {
        return true;
    }

    protected void initializeFrom(ReadOnlyBaseColumn oldColumn) {
        super.initializeFrom(oldColumn);
        this.setSpecifiedTable(oldColumn.getSpecifiedTable());
        this.setSpecifiedUnique(oldColumn.getSpecifiedUnique());
        this.setSpecifiedNullable(oldColumn.getSpecifiedNullable());
        this.setSpecifiedInsertable(oldColumn.getSpecifiedInsertable());
        this.setSpecifiedUpdatable(oldColumn.getSpecifiedUpdatable());
    }

    protected void initializeFromVirtual(ReadOnlyBaseColumn virtualColumn) {
        super.initializeFromVirtual(virtualColumn);
        this.setSpecifiedTable(virtualColumn.getTable());
    }

    @Override
    public boolean tableNameIsInvalid() {
        return ((JavaBaseColumn.Owner)this.owner).tableNameIsInvalid(this.getTable());
    }

    @Override
    public Iterator<String> javaCompletionProposals(int pos, Filter<String> filter, CompilationUnit astRoot) {
        Iterator<String> result = super.javaCompletionProposals(pos, filter, astRoot);
        if (result != null) {
            return result;
        }
        if (this.tableTouches(pos, astRoot)) {
            return this.javaCandidateTableNames(filter);
        }
        return null;
    }

    protected boolean tableTouches(int pos, CompilationUnit astRoot) {
        return ((BaseColumnAnnotation)this.getColumnAnnotation()).tableTouches(pos, astRoot);
    }

    protected Iterator<String> javaCandidateTableNames(Filter<String> filter) {
        return StringTools.convertToJavaStringLiterals(this.candidateTableNames(filter));
    }

    protected Iterator<String> candidateTableNames(Filter<String> filter) {
        return new FilteringIterator(this.candidateTableNames(), filter);
    }

    @Override
    public Iterator<String> candidateTableNames() {
        return ((JavaBaseColumn.Owner)this.owner).candidateTableNames();
    }

    @Override
    protected NamedColumnTextRangeResolver buildTextRangeResolver(CompilationUnit astRoot) {
        return new JavaBaseColumnTextRangeResolver(this, astRoot);
    }
}

