/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jpt.jpa.core.internal.resource.java.source;

import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Vector;
import org.eclipse.jdt.core.IPackageFragment;
import org.eclipse.jdt.core.IPackageFragmentRoot;
import org.eclipse.jdt.core.dom.CompilationUnit;
import org.eclipse.jdt.core.dom.FieldDeclaration;
import org.eclipse.jdt.core.dom.IAnnotationBinding;
import org.eclipse.jdt.core.dom.IMethodBinding;
import org.eclipse.jdt.core.dom.ITypeBinding;
import org.eclipse.jdt.core.dom.MethodDeclaration;
import org.eclipse.jdt.core.dom.Modifier;
import org.eclipse.jdt.core.dom.TypeDeclaration;
import org.eclipse.jdt.core.dom.VariableDeclarationFragment;
import org.eclipse.jpt.common.core.internal.utility.jdt.ASTTools;
import org.eclipse.jpt.common.core.internal.utility.jdt.JDTType;
import org.eclipse.jpt.common.core.utility.jdt.Type;
import org.eclipse.jpt.common.utility.MethodSignature;
import org.eclipse.jpt.common.utility.internal.CollectionTools;
import org.eclipse.jpt.common.utility.internal.SimpleIntReference;
import org.eclipse.jpt.common.utility.internal.StringTools;
import org.eclipse.jpt.common.utility.internal.iterables.LiveCloneIterable;
import org.eclipse.jpt.common.utility.internal.iterators.CompositeIterator;
import org.eclipse.jpt.common.utility.internal.iterators.FilteringIterator;
import org.eclipse.jpt.common.utility.internal.iterators.TreeIterator;
import org.eclipse.jpt.jpa.core.internal.jpa2.resource.java.GeneratedAnnotationDefinition;
import org.eclipse.jpt.jpa.core.internal.jpa2.resource.java.StaticMetamodelAnnotationDefinition;
import org.eclipse.jpt.jpa.core.internal.resource.java.source.SourcePersistentAttribute;
import org.eclipse.jpt.jpa.core.internal.resource.java.source.SourcePersistentMember;
import org.eclipse.jpt.jpa.core.jpa2.resource.java.GeneratedAnnotation;
import org.eclipse.jpt.jpa.core.jpa2.resource.java.JavaResourcePersistentType2_0;
import org.eclipse.jpt.jpa.core.jpa2.resource.java.StaticMetamodelAnnotation;
import org.eclipse.jpt.jpa.core.resource.java.AccessType;
import org.eclipse.jpt.jpa.core.resource.java.Annotation;
import org.eclipse.jpt.jpa.core.resource.java.JavaResourceAnnotatedElement;
import org.eclipse.jpt.jpa.core.resource.java.JavaResourceCompilationUnit;
import org.eclipse.jpt.jpa.core.resource.java.JavaResourceNode;
import org.eclipse.jpt.jpa.core.resource.java.JavaResourcePersistentAttribute;
import org.eclipse.jpt.jpa.core.resource.java.JavaResourcePersistentType;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
final class SourcePersistentType
extends SourcePersistentMember<Type>
implements JavaResourcePersistentType2_0 {
    private String name;
    private String qualifiedName;
    private String packageName;
    private String superclassQualifiedName;
    private String declaringTypeName;
    private boolean abstract_;
    private boolean static_;
    private boolean memberType;
    private boolean hasPrivateNoArgConstructor;
    private boolean hasNoArgConstructor;
    private final Vector<JavaResourcePersistentType> types = new Vector();
    private final Vector<JavaResourcePersistentAttribute> fields = new Vector();
    private final Vector<JavaResourcePersistentAttribute> methods = new Vector();
    private StaticMetamodelAnnotation staticMetamodelAnnotation;
    public static final String STATIC_METAMODEL_ANNOTATION_PROPERTY = "staticMetamodelAnnotation";
    private GeneratedAnnotation generatedAnnotation;
    public static final String GENERATED_ANNOTATION_PROPERTY = "generatedAnnotation";
    private static final StaticMetamodelAnnotationDefinition STATIC_METAMODEL_ANNOTATION_DEFINITION = StaticMetamodelAnnotationDefinition.instance();
    private static final GeneratedAnnotationDefinition GENERATED_ANNOTATION_DEFINITION = GeneratedAnnotationDefinition.instance();

    static JavaResourcePersistentType newInstance(JavaResourceCompilationUnit javaResourceCompilationUnit, TypeDeclaration typeDeclaration, CompilationUnit astRoot) {
        JDTType type = new JDTType(typeDeclaration, javaResourceCompilationUnit.getCompilationUnit(), javaResourceCompilationUnit.getModifySharedDocumentCommandExecutor(), javaResourceCompilationUnit.getAnnotationEditFormatter());
        SourcePersistentType jrpt = new SourcePersistentType(javaResourceCompilationUnit, (Type)type);
        jrpt.initialize(astRoot);
        return jrpt;
    }

    private static JavaResourcePersistentType newInstance(JavaResourceCompilationUnit javaResourceCompilationUnit, Type declaringType, TypeDeclaration typeDeclaration, int occurrence, CompilationUnit astRoot) {
        JDTType type = new JDTType(declaringType, typeDeclaration, occurrence, javaResourceCompilationUnit.getCompilationUnit(), javaResourceCompilationUnit.getModifySharedDocumentCommandExecutor(), javaResourceCompilationUnit.getAnnotationEditFormatter());
        SourcePersistentType jrpt = new SourcePersistentType(javaResourceCompilationUnit, (Type)type);
        jrpt.initialize(astRoot);
        return jrpt;
    }

    private SourcePersistentType(JavaResourceCompilationUnit javaResourceCompilationUnit, Type type) {
        super((JavaResourceNode)javaResourceCompilationUnit, type);
    }

    @Override
    public void initialize(CompilationUnit astRoot) {
        super.initialize(astRoot);
        ITypeBinding binding = ((Type)this.annotatedElement).getBinding(astRoot);
        this.name = this.buildName(binding);
        this.qualifiedName = this.buildQualifiedName(binding);
        this.packageName = this.buildPackageName(binding);
        this.superclassQualifiedName = this.buildSuperclassQualifiedName(binding);
        this.declaringTypeName = this.buildDeclaringTypeName(binding);
        this.abstract_ = this.buildAbstract(binding);
        this.static_ = this.buildStatic(binding);
        this.memberType = this.buildMemberType(binding);
        this.hasNoArgConstructor = this.buildHasNoArgConstructor(binding);
        this.hasPrivateNoArgConstructor = this.buildHasPrivateNoArgConstructor(binding);
        this.initializeTypes(astRoot);
        this.initializeFields(astRoot);
        this.initializeMethods(astRoot);
    }

    @Override
    void addInitialAnnotation(String astAnnotationName, CompilationUnit astRoot) {
        if (astAnnotationName.equals(STATIC_METAMODEL_ANNOTATION_DEFINITION.getAnnotationName())) {
            this.addInitialStaticMetamodelAnnotation(astRoot);
        } else if (astAnnotationName.equals(GENERATED_ANNOTATION_DEFINITION.getAnnotationName())) {
            this.addInitialGeneratedAnnotation(astRoot);
        } else {
            super.addInitialAnnotation(astAnnotationName, astRoot);
        }
    }

    @Override
    public void synchronizeWith(CompilationUnit astRoot) {
        super.synchronizeWith(astRoot);
        ITypeBinding binding = ((Type)this.annotatedElement).getBinding(astRoot);
        this.syncName(this.buildName(binding));
        this.syncQualifiedName(this.buildQualifiedName(binding));
        this.syncPackageName(this.buildPackageName(binding));
        this.syncSuperclassQualifiedName(this.buildSuperclassQualifiedName(binding));
        this.syncDeclaringTypeName(this.buildDeclaringTypeName(binding));
        this.syncAbstract(this.buildAbstract(binding));
        this.syncStatic(this.buildStatic(binding));
        this.syncMemberType(this.buildMemberType(binding));
        this.syncHasNoArgConstructor(this.buildHasNoArgConstructor(binding));
        this.syncHasPrivateNoArgConstructor(this.buildHasPrivateNoArgConstructor(binding));
        this.syncTypes(astRoot);
        this.syncFields(astRoot);
        this.syncMethods(astRoot);
        this.syncMetamodelAnnotations(astRoot);
    }

    private void syncMetamodelAnnotations(CompilationUnit astRoot) {
        ITypeBinding binding = ((Type)this.annotatedElement).getBinding(astRoot);
        if (binding != null) {
            this.syncStaticMetamodelAnnotation(astRoot, binding);
            this.syncGeneratedAnnotation(astRoot, binding);
        }
    }

    @Override
    Iterator<String> validAnnotationNames() {
        return this.getAnnotationProvider().typeAnnotationNames();
    }

    @Override
    Annotation buildAnnotation(String annotationName) {
        return this.getAnnotationProvider().buildTypeAnnotation(this, (Type)this.annotatedElement, annotationName);
    }

    @Override
    Annotation buildNullAnnotation(String annotationName) {
        return this.getAnnotationProvider().buildNullTypeAnnotation(this, annotationName);
    }

    @Override
    public void resolveTypes(CompilationUnit astRoot) {
        super.resolveTypes(astRoot);
        this.syncSuperclassQualifiedName(this.buildSuperclassQualifiedName(((Type)this.annotatedElement).getBinding(astRoot)));
        for (JavaResourcePersistentAttribute field : this.getFields()) {
            field.resolveTypes(astRoot);
        }
        this.syncMethods(astRoot);
        for (JavaResourcePersistentAttribute method : this.getMethods()) {
            method.resolveTypes(astRoot);
        }
        for (JavaResourcePersistentType type : this.getTypes()) {
            type.resolveTypes(astRoot);
        }
    }

    public void toString(StringBuilder sb) {
        sb.append(this.name);
    }

    @Override
    public String getName() {
        return this.name;
    }

    private void syncName(String astName) {
        String old = this.name;
        this.name = astName;
        this.firePropertyChanged("name", old, astName);
    }

    private String buildName(ITypeBinding binding) {
        return binding == null ? null : binding.getName();
    }

    @Override
    public String getQualifiedName() {
        return this.qualifiedName;
    }

    private void syncQualifiedName(String astQualifiedName) {
        String old = this.qualifiedName;
        this.qualifiedName = astQualifiedName;
        this.firePropertyChanged("qualifiedName", old, astQualifiedName);
    }

    private String buildQualifiedName(ITypeBinding binding) {
        return binding == null ? null : binding.getQualifiedName();
    }

    @Override
    public String getPackageName() {
        return this.packageName;
    }

    private void syncPackageName(String astPackageName) {
        String old = this.packageName;
        this.packageName = astPackageName;
        this.firePropertyChanged("packageName", old, astPackageName);
    }

    private String buildPackageName(ITypeBinding binding) {
        return binding == null ? null : binding.getPackage().getName();
    }

    @Override
    public String getSuperclassQualifiedName() {
        return this.superclassQualifiedName;
    }

    private void syncSuperclassQualifiedName(String astSuperclassQualifiedName) {
        String old = this.superclassQualifiedName;
        this.superclassQualifiedName = astSuperclassQualifiedName;
        this.firePropertyChanged("superclassQualifiedName", old, astSuperclassQualifiedName);
    }

    private String buildSuperclassQualifiedName(ITypeBinding binding) {
        if (binding == null) {
            return null;
        }
        ITypeBinding superclass = binding.getSuperclass();
        return superclass == null ? null : superclass.getTypeDeclaration().getQualifiedName();
    }

    @Override
    public boolean isIn(IPackageFragment packageFragment) {
        return StringTools.stringsAreEqual((String)packageFragment.getElementName(), (String)this.packageName);
    }

    @Override
    public String getDeclaringTypeName() {
        return this.declaringTypeName;
    }

    private void syncDeclaringTypeName(String astDeclaringTypeName) {
        String old = this.declaringTypeName;
        this.declaringTypeName = astDeclaringTypeName;
        this.firePropertyChanged("declaringTypeName", old, astDeclaringTypeName);
    }

    private String buildDeclaringTypeName(ITypeBinding binding) {
        if (binding == null) {
            return null;
        }
        ITypeBinding declaringClass = binding.getDeclaringClass();
        return declaringClass == null ? null : declaringClass.getTypeDeclaration().getQualifiedName();
    }

    @Override
    public boolean isAbstract() {
        return this.abstract_;
    }

    private void syncAbstract(boolean astAbstract) {
        boolean old = this.abstract_;
        this.abstract_ = astAbstract;
        this.firePropertyChanged("abstract", old, astAbstract);
    }

    private boolean buildAbstract(ITypeBinding binding) {
        return binding == null ? false : Modifier.isAbstract((int)binding.getModifiers());
    }

    @Override
    public boolean isStatic() {
        return this.static_;
    }

    private void syncStatic(boolean astStatic_) {
        boolean old = this.static_;
        this.static_ = astStatic_;
        this.firePropertyChanged("static", old, astStatic_);
    }

    private boolean buildStatic(ITypeBinding binding) {
        return binding == null ? false : Modifier.isStatic((int)binding.getModifiers());
    }

    @Override
    public boolean isMemberType() {
        return this.memberType;
    }

    private void syncMemberType(boolean astMemberType) {
        boolean old = this.memberType;
        this.memberType = astMemberType;
        this.firePropertyChanged("memberType", old, astMemberType);
    }

    private boolean buildMemberType(ITypeBinding binding) {
        return binding == null ? false : binding.isMember();
    }

    @Override
    public boolean hasNoArgConstructor() {
        return this.hasNoArgConstructor;
    }

    private void syncHasNoArgConstructor(boolean astHasNoArgConstructor) {
        boolean old = this.hasNoArgConstructor;
        this.hasNoArgConstructor = astHasNoArgConstructor;
        this.firePropertyChanged("noArgConstructor", old, astHasNoArgConstructor);
    }

    private boolean buildHasNoArgConstructor(ITypeBinding binding) {
        return binding == null ? false : SourcePersistentType.typeHasNoArgConstructor(binding);
    }

    protected static boolean typeHasNoArgConstructor(ITypeBinding binding) {
        return SourcePersistentType.findNoArgConstructor(binding) != null;
    }

    protected static IMethodBinding findNoArgConstructor(ITypeBinding binding) {
        IMethodBinding[] iMethodBindingArray = binding.getDeclaredMethods();
        int n = iMethodBindingArray.length;
        int n2 = 0;
        while (n2 < n) {
            IMethodBinding method = iMethodBindingArray[n2];
            if (method.isConstructor() && method.getParameterTypes().length == 0) {
                return method;
            }
            ++n2;
        }
        return null;
    }

    @Override
    public boolean hasPrivateNoArgConstructor() {
        return this.hasPrivateNoArgConstructor;
    }

    private void syncHasPrivateNoArgConstructor(boolean astHasPrivateNoArgConstructor) {
        boolean old = this.hasPrivateNoArgConstructor;
        this.hasPrivateNoArgConstructor = astHasPrivateNoArgConstructor;
        this.firePropertyChanged("privateNoArgConstructor", old, astHasPrivateNoArgConstructor);
    }

    private boolean buildHasPrivateNoArgConstructor(ITypeBinding binding) {
        return binding == null ? false : SourcePersistentType.typeHasPrivateNoArgConstructor(binding);
    }

    protected static boolean typeHasPrivateNoArgConstructor(ITypeBinding binding) {
        IMethodBinding method = SourcePersistentType.findNoArgConstructor(binding);
        return method != null && Modifier.isPrivate((int)method.getModifiers());
    }

    @Override
    public boolean isMapped() {
        for (Annotation annotation : this.getAnnotations()) {
            if (!this.annotationIsMappingAnnotation(annotation)) continue;
            return true;
        }
        return false;
    }

    private boolean annotationIsMappingAnnotation(Annotation annotation) {
        return CollectionTools.contains(this.mappingAnnotationNames(), (Object)annotation.getAnnotationName());
    }

    private Iterator<String> mappingAnnotationNames() {
        return this.getAnnotationProvider().typeMappingAnnotationNames();
    }

    @Override
    public boolean hasAnyAnnotatedAttributes() {
        Iterator<JavaResourcePersistentAttribute> stream = this.persistableAttributes();
        while (stream.hasNext()) {
            if (!stream.next().isAnnotated()) continue;
            return true;
        }
        return false;
    }

    @Override
    public Iterator<JavaResourcePersistentType> types() {
        return this.getTypes().iterator();
    }

    private Iterable<JavaResourcePersistentType> getTypes() {
        return new LiveCloneIterable(this.types);
    }

    @Override
    public Iterator<JavaResourcePersistentType> allTypes() {
        return new TreeIterator<JavaResourcePersistentType>((JavaResourcePersistentType)this){

            protected Iterator<? extends JavaResourcePersistentType> children(JavaResourcePersistentType type) {
                return type.types();
            }
        };
    }

    @Override
    public Iterator<JavaResourcePersistentType> persistableTypes() {
        return this.persistableMembers(this.types());
    }

    private JavaResourcePersistentType getType(String typeName, int occurrence) {
        for (JavaResourcePersistentType type : this.getTypes()) {
            if (!type.isFor(typeName, occurrence)) continue;
            return type;
        }
        return null;
    }

    private void addType(JavaResourcePersistentType type) {
        this.addItemToCollection(type, this.types, "types");
    }

    private void removeTypes(Collection<JavaResourcePersistentType> remove) {
        this.removeItemsFromCollection(remove, this.types, "types");
    }

    private void initializeTypes(CompilationUnit astRoot) {
        TypeDeclaration[] typeDeclarations = ((Type)this.annotatedElement).getTypes(astRoot);
        CounterMap counters = new CounterMap(typeDeclarations.length);
        TypeDeclaration[] typeDeclarationArray = typeDeclarations;
        int n = typeDeclarations.length;
        int n2 = 0;
        while (n2 < n) {
            TypeDeclaration td = typeDeclarationArray[n2];
            String tdName = td.getName().getFullyQualifiedName();
            int occurrence = counters.increment(tdName);
            this.types.add(this.buildType(td, occurrence, astRoot));
            ++n2;
        }
    }

    private void syncTypes(CompilationUnit astRoot) {
        TypeDeclaration[] typeDeclarations = ((Type)this.annotatedElement).getTypes(astRoot);
        CounterMap counters = new CounterMap(typeDeclarations.length);
        HashSet<JavaResourcePersistentType> typesToRemove = new HashSet<JavaResourcePersistentType>(this.types);
        TypeDeclaration[] typeDeclarationArray = typeDeclarations;
        int n = typeDeclarations.length;
        int n2 = 0;
        while (n2 < n) {
            int occurrence;
            TypeDeclaration typeDeclaration = typeDeclarationArray[n2];
            String tdName = typeDeclaration.getName().getFullyQualifiedName();
            JavaResourcePersistentType type = this.getType(tdName, occurrence = counters.increment(tdName));
            if (type == null) {
                this.addType(this.buildType(typeDeclaration, occurrence, astRoot));
            } else {
                typesToRemove.remove(type);
                type.synchronizeWith(astRoot);
            }
            ++n2;
        }
        this.removeTypes(typesToRemove);
    }

    private JavaResourcePersistentType buildType(TypeDeclaration nestedTypeDeclaration, int occurrence, CompilationUnit astRoot) {
        return SourcePersistentType.newInstance(this.getJavaResourceCompilationUnit(), (Type)this.annotatedElement, nestedTypeDeclaration, occurrence, astRoot);
    }

    @Override
    public Iterator<JavaResourcePersistentAttribute> fields() {
        return this.getFields().iterator();
    }

    private Iterable<JavaResourcePersistentAttribute> getFields() {
        return new LiveCloneIterable(this.fields);
    }

    @Override
    public Iterator<JavaResourcePersistentAttribute> persistableFields() {
        return this.persistableMembers(this.fields());
    }

    @Override
    public Iterator<JavaResourcePersistentAttribute> persistableFieldsWithSpecifiedFieldAccess() {
        return new FilteringIterator(this.persistableFields(), FIELD_ACCESS_TYPE_FILTER);
    }

    private void addField(JavaResourcePersistentAttribute field) {
        this.addItemToCollection(field, this.fields, "fields");
    }

    private JavaResourcePersistentAttribute getField(String fieldName, int occurrence) {
        for (JavaResourcePersistentAttribute field : this.getFields()) {
            if (!field.isFor(fieldName, occurrence)) continue;
            return field;
        }
        return null;
    }

    private void removeFields(Collection<JavaResourcePersistentAttribute> remove) {
        this.removeItemsFromCollection(remove, this.fields, "fields");
    }

    private void initializeFields(CompilationUnit astRoot) {
        FieldDeclaration[] fieldDeclarations = ((Type)this.annotatedElement).getFields(astRoot);
        CounterMap counters = new CounterMap(fieldDeclarations.length);
        FieldDeclaration[] fieldDeclarationArray = fieldDeclarations;
        int n = fieldDeclarations.length;
        int n2 = 0;
        while (n2 < n) {
            FieldDeclaration fieldDeclaration = fieldDeclarationArray[n2];
            for (VariableDeclarationFragment fragment : SourcePersistentType.fragments(fieldDeclaration)) {
                String fieldName = fragment.getName().getFullyQualifiedName();
                int occurrence = counters.increment(fieldName);
                this.fields.add(this.buildField(fieldName, occurrence, astRoot));
            }
            ++n2;
        }
    }

    private void syncFields(CompilationUnit astRoot) {
        FieldDeclaration[] fieldDeclarations = ((Type)this.annotatedElement).getFields(astRoot);
        CounterMap counters = new CounterMap(fieldDeclarations.length);
        HashSet<JavaResourcePersistentAttribute> fieldsToRemove = new HashSet<JavaResourcePersistentAttribute>(this.fields);
        FieldDeclaration[] fieldDeclarationArray = fieldDeclarations;
        int n = fieldDeclarations.length;
        int n2 = 0;
        while (n2 < n) {
            FieldDeclaration fieldDeclaration = fieldDeclarationArray[n2];
            for (VariableDeclarationFragment fragment : SourcePersistentType.fragments(fieldDeclaration)) {
                int occurrence;
                String fieldName = fragment.getName().getFullyQualifiedName();
                JavaResourcePersistentAttribute field = this.getField(fieldName, occurrence = counters.increment(fieldName));
                if (field == null) {
                    this.addField(this.buildField(fieldName, occurrence, astRoot));
                    continue;
                }
                fieldsToRemove.remove(field);
                field.synchronizeWith(astRoot);
            }
            ++n2;
        }
        this.removeFields(fieldsToRemove);
    }

    private JavaResourcePersistentAttribute buildField(String fieldName, int occurrence, CompilationUnit astRoot) {
        return SourcePersistentAttribute.newInstance((JavaResourcePersistentType)this, (Type)this.annotatedElement, fieldName, occurrence, this.getJavaResourceCompilationUnit(), astRoot);
    }

    private static List<VariableDeclarationFragment> fragments(FieldDeclaration fd) {
        return fd.fragments();
    }

    @Override
    public Iterator<JavaResourcePersistentAttribute> methods() {
        return this.getMethods().iterator();
    }

    private Iterable<JavaResourcePersistentAttribute> getMethods() {
        return new LiveCloneIterable(this.methods);
    }

    @Override
    public Iterator<JavaResourcePersistentAttribute> persistableProperties() {
        return this.persistableMembers(this.methods());
    }

    @Override
    public Iterator<JavaResourcePersistentAttribute> persistablePropertiesWithSpecifiedPropertyAccess() {
        return new FilteringIterator(this.persistableProperties(), PROPERTY_ACCESS_TYPE_FILTER);
    }

    private JavaResourcePersistentAttribute getMethod(MethodSignature signature, int occurrence) {
        for (JavaResourcePersistentAttribute method : this.getMethods()) {
            if (!method.isFor(signature, occurrence)) continue;
            return method;
        }
        return null;
    }

    private void addMethod(JavaResourcePersistentAttribute method) {
        this.addItemToCollection(method, this.methods, "methods");
    }

    private void removeMethods(Collection<JavaResourcePersistentAttribute> remove) {
        this.removeItemsFromCollection(remove, this.methods, "methods");
    }

    private void initializeMethods(CompilationUnit astRoot) {
        MethodDeclaration[] methodDeclarations = ((Type)this.annotatedElement).getMethods(astRoot);
        CounterMap counters = new CounterMap(methodDeclarations.length);
        MethodDeclaration[] methodDeclarationArray = methodDeclarations;
        int n = methodDeclarations.length;
        int n2 = 0;
        while (n2 < n) {
            MethodDeclaration methodDeclaration = methodDeclarationArray[n2];
            MethodSignature signature = ASTTools.buildMethodSignature((MethodDeclaration)methodDeclaration);
            int occurrence = counters.increment(signature);
            this.methods.add(this.buildMethod(signature, occurrence, astRoot));
            ++n2;
        }
    }

    private void syncMethods(CompilationUnit astRoot) {
        MethodDeclaration[] methodDeclarations = ((Type)this.annotatedElement).getMethods(astRoot);
        CounterMap counters = new CounterMap(methodDeclarations.length);
        HashSet<JavaResourcePersistentAttribute> methodsToRemove = new HashSet<JavaResourcePersistentAttribute>(this.methods);
        MethodDeclaration[] methodDeclarationArray = methodDeclarations;
        int n = methodDeclarations.length;
        int n2 = 0;
        while (n2 < n) {
            int occurrence;
            MethodDeclaration methodDeclaration = methodDeclarationArray[n2];
            MethodSignature signature = ASTTools.buildMethodSignature((MethodDeclaration)methodDeclaration);
            JavaResourcePersistentAttribute method = this.getMethod(signature, occurrence = counters.increment(signature));
            if (method == null) {
                this.addMethod(this.buildMethod(signature, occurrence, astRoot));
            } else {
                methodsToRemove.remove(method);
                method.synchronizeWith(astRoot);
            }
            ++n2;
        }
        this.removeMethods(methodsToRemove);
    }

    private JavaResourcePersistentAttribute buildMethod(MethodSignature signature, int occurrence, CompilationUnit astRoot) {
        return SourcePersistentAttribute.newInstance((JavaResourcePersistentType)this, (Type)this.annotatedElement, signature, occurrence, this.getJavaResourceCompilationUnit(), astRoot);
    }

    @Override
    public Iterator<JavaResourcePersistentAttribute> persistableAttributes() {
        return new CompositeIterator(new Iterator[]{this.persistableFields(), this.persistableProperties()});
    }

    @Override
    public Iterator<JavaResourcePersistentAttribute> persistableAttributes(AccessType specifiedAccess) {
        switch (specifiedAccess) {
            case FIELD: {
                return this.persistableAttributesForFieldAccessType();
            }
            case PROPERTY: {
                return this.persistableAttributesForPropertyAccessType();
            }
        }
        throw new IllegalArgumentException("unknown access: " + (Object)((Object)specifiedAccess));
    }

    private Iterator<JavaResourcePersistentAttribute> persistableAttributesForFieldAccessType() {
        return new CompositeIterator(new Iterator[]{this.persistableFields(), this.persistablePropertiesWithSpecifiedPropertyAccess()});
    }

    private Iterator<JavaResourcePersistentAttribute> persistableAttributesForPropertyAccessType() {
        return new CompositeIterator(new Iterator[]{this.persistableProperties(), this.persistableFieldsWithSpecifiedFieldAccess()});
    }

    private void setStaticMetamodelAnnotation(StaticMetamodelAnnotation staticMetamodelAnnotation) {
        StaticMetamodelAnnotation old = this.staticMetamodelAnnotation;
        this.staticMetamodelAnnotation = staticMetamodelAnnotation;
        this.firePropertyChanged(STATIC_METAMODEL_ANNOTATION_PROPERTY, old, this.staticMetamodelAnnotation);
    }

    private void addInitialStaticMetamodelAnnotation(CompilationUnit astRoot) {
        if (this.staticMetamodelAnnotation == null) {
            this.staticMetamodelAnnotation = this.buildStaticMetamodelAnnotation(astRoot);
        }
    }

    private StaticMetamodelAnnotation buildStaticMetamodelAnnotation(CompilationUnit astRoot) {
        StaticMetamodelAnnotation annotation = STATIC_METAMODEL_ANNOTATION_DEFINITION.buildAnnotation((JavaResourceAnnotatedElement)this, this.annotatedElement);
        annotation.initialize(astRoot);
        return annotation;
    }

    private void syncStaticMetamodelAnnotation(CompilationUnit astRoot, ITypeBinding binding) {
        if (this.bindingContainsStaticMetamodelAnnotation(binding)) {
            if (this.staticMetamodelAnnotation != null) {
                this.staticMetamodelAnnotation.synchronizeWith(astRoot);
            } else {
                this.setStaticMetamodelAnnotation(this.buildStaticMetamodelAnnotation(astRoot));
            }
        } else {
            this.setStaticMetamodelAnnotation(null);
        }
    }

    private boolean bindingContainsStaticMetamodelAnnotation(ITypeBinding binding) {
        return this.bindingContainsAnnotation(binding, STATIC_METAMODEL_ANNOTATION_DEFINITION.getAnnotationName());
    }

    @Override
    public GeneratedAnnotation getGeneratedAnnotation() {
        return this.generatedAnnotation;
    }

    private void setGeneratedAnnotation(GeneratedAnnotation generatedAnnotation) {
        GeneratedAnnotation old = this.generatedAnnotation;
        this.generatedAnnotation = generatedAnnotation;
        this.firePropertyChanged(GENERATED_ANNOTATION_PROPERTY, old, this.generatedAnnotation);
    }

    private void addInitialGeneratedAnnotation(CompilationUnit astRoot) {
        if (this.generatedAnnotation == null) {
            this.generatedAnnotation = this.buildGeneratedAnnotation(astRoot);
        }
    }

    private GeneratedAnnotation buildGeneratedAnnotation(CompilationUnit astRoot) {
        GeneratedAnnotation annotation = GENERATED_ANNOTATION_DEFINITION.buildAnnotation((JavaResourceAnnotatedElement)this, this.annotatedElement);
        annotation.initialize(astRoot);
        return annotation;
    }

    private void syncGeneratedAnnotation(CompilationUnit astRoot, ITypeBinding binding) {
        if (this.bindingContainsGeneratedAnnotation(binding)) {
            if (this.generatedAnnotation != null) {
                this.generatedAnnotation.synchronizeWith(astRoot);
            } else {
                this.setGeneratedAnnotation(this.buildGeneratedAnnotation(astRoot));
            }
        } else {
            this.setGeneratedAnnotation(null);
        }
    }

    private boolean bindingContainsGeneratedAnnotation(ITypeBinding binding) {
        return this.bindingContainsAnnotation(binding, GENERATED_ANNOTATION_DEFINITION.getAnnotationName());
    }

    private boolean bindingContainsAnnotation(ITypeBinding binding, String annotationName) {
        IAnnotationBinding[] iAnnotationBindingArray = binding.getAnnotations();
        int n = iAnnotationBindingArray.length;
        int n2 = 0;
        while (n2 < n) {
            IAnnotationBinding annotationBinding = iAnnotationBindingArray[n2];
            ITypeBinding annotationTypeBinding = annotationBinding.getAnnotationType();
            if (annotationTypeBinding != null && annotationTypeBinding.getQualifiedName().equals(annotationName)) {
                return true;
            }
            ++n2;
        }
        return false;
    }

    @Override
    public boolean isGeneratedMetamodelTopLevelType(IPackageFragmentRoot sourceFolder) {
        if (!this.getSourceFolder().equals(sourceFolder)) {
            return false;
        }
        return this.isGeneratedMetamodelTopLevelType();
    }

    @Override
    public boolean isGeneratedMetamodelTopLevelType() {
        if (!this.isGenerated()) {
            return false;
        }
        Iterator<JavaResourcePersistentType> stream = this.allTypes();
        while (stream.hasNext()) {
            JavaResourcePersistentType2_0 type = (JavaResourcePersistentType2_0)stream.next();
            if (!type.isMetamodel()) continue;
            return true;
        }
        return false;
    }

    private boolean isGenerated() {
        if (this.generatedAnnotation == null) {
            return false;
        }
        if (this.generatedAnnotation.valuesSize() != 1) {
            return false;
        }
        if (!this.generatedAnnotation.getValue(0).equals("Dali")) {
            return false;
        }
        return !StringTools.stringIsEmpty((String)this.generatedAnnotation.getDate());
    }

    @Override
    public boolean isMetamodel() {
        return this.staticMetamodelAnnotation != null;
    }

    private IPackageFragmentRoot getSourceFolder() {
        return (IPackageFragmentRoot)this.getJavaResourceCompilationUnit().getCompilationUnit().getAncestor(3);
    }

    private static class CounterMap {
        private final HashMap<Object, SimpleIntReference> counters;

        protected CounterMap(int initialCapacity) {
            this.counters = new HashMap(initialCapacity);
        }

        int increment(Object o) {
            SimpleIntReference counter = this.counters.get(o);
            if (counter == null) {
                counter = new SimpleIntReference();
                this.counters.put(o, counter);
            }
            counter.increment();
            return counter.getValue();
        }
    }
}

