/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jpt.jpa.core.internal.context.java;

import java.util.ListIterator;
import java.util.Vector;
import org.eclipse.jdt.core.dom.CompilationUnit;
import org.eclipse.jpt.common.core.utility.TextRange;
import org.eclipse.jpt.common.utility.internal.CollectionTools;
import org.eclipse.jpt.common.utility.internal.NameTools;
import org.eclipse.jpt.common.utility.internal.iterables.ListIterable;
import org.eclipse.jpt.common.utility.internal.iterables.LiveCloneListIterable;
import org.eclipse.jpt.jpa.core.context.Table;
import org.eclipse.jpt.jpa.core.context.UniqueConstraint;
import org.eclipse.jpt.jpa.core.context.VirtualTable;
import org.eclipse.jpt.jpa.core.context.java.JavaJpaContextNode;
import org.eclipse.jpt.jpa.core.context.java.JavaVirtualUniqueConstraint;
import org.eclipse.jpt.jpa.core.internal.context.ContextContainerTools;
import org.eclipse.jpt.jpa.core.internal.context.java.AbstractJavaJpaContextNode;
import org.eclipse.jpt.jpa.db.Catalog;
import org.eclipse.jpt.jpa.db.Schema;
import org.eclipse.jpt.jpa.db.SchemaContainer;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class AbstractJavaVirtualTable<T extends Table>
extends AbstractJavaJpaContextNode
implements VirtualTable {
    protected String specifiedName;
    protected String defaultName;
    protected String specifiedSchema;
    protected String defaultSchema;
    protected String specifiedCatalog;
    protected String defaultCatalog;
    protected final Vector<JavaVirtualUniqueConstraint> uniqueConstraints = new Vector();
    protected final UniqueConstraintContainerAdapter uniqueConstraintContainerAdapter = new UniqueConstraintContainerAdapter();

    protected AbstractJavaVirtualTable(JavaJpaContextNode parent) {
        super(parent);
    }

    @Override
    public void update() {
        super.update();
        this.setSpecifiedName(this.buildSpecifiedName());
        this.setDefaultName(this.buildDefaultName());
        this.setSpecifiedSchema(this.buildSpecifiedSchema());
        this.setDefaultSchema(this.buildDefaultSchema());
        this.setSpecifiedCatalog(this.buildSpecifiedCatalog());
        this.setDefaultCatalog(this.buildDefaultCatalog());
        this.updateUniqueConstraints();
    }

    public abstract T getOverriddenTable();

    @Override
    public String getName() {
        return this.specifiedName != null ? this.specifiedName : this.defaultName;
    }

    @Override
    public String getSpecifiedName() {
        return this.specifiedName;
    }

    protected void setSpecifiedName(String name) {
        String old = this.specifiedName;
        this.specifiedName = name;
        this.firePropertyChanged("specifiedName", old, name);
    }

    protected String buildSpecifiedName() {
        return this.getOverriddenTable().getSpecifiedName();
    }

    @Override
    public String getDefaultName() {
        return this.defaultName;
    }

    protected void setDefaultName(String name) {
        String old = this.defaultName;
        this.defaultName = name;
        this.firePropertyChanged("defaultName", old, name);
    }

    protected abstract String buildDefaultName();

    @Override
    public String getSchema() {
        return this.specifiedSchema != null ? this.specifiedSchema : this.defaultSchema;
    }

    @Override
    public String getSpecifiedSchema() {
        return this.specifiedSchema;
    }

    protected void setSpecifiedSchema(String schema) {
        String old = this.specifiedSchema;
        this.specifiedSchema = schema;
        this.firePropertyChanged("specifiedSchema", old, schema);
    }

    protected String buildSpecifiedSchema() {
        return this.getOverriddenTable().getSchema();
    }

    @Override
    public String getDefaultSchema() {
        return this.defaultSchema;
    }

    protected void setDefaultSchema(String schema) {
        String old = this.defaultSchema;
        this.defaultSchema = schema;
        this.firePropertyChanged("defaultSchema", old, schema);
    }

    protected abstract String buildDefaultSchema();

    @Override
    public String getCatalog() {
        return this.specifiedCatalog != null ? this.specifiedCatalog : this.defaultCatalog;
    }

    @Override
    public String getSpecifiedCatalog() {
        return this.specifiedCatalog;
    }

    protected void setSpecifiedCatalog(String catalog) {
        String old = this.specifiedCatalog;
        this.specifiedCatalog = catalog;
        this.firePropertyChanged("specifiedCatalog", old, catalog);
    }

    protected String buildSpecifiedCatalog() {
        return this.getOverriddenTable().getCatalog();
    }

    @Override
    public String getDefaultCatalog() {
        return this.defaultCatalog;
    }

    protected void setDefaultCatalog(String catalog) {
        String old = this.defaultCatalog;
        this.defaultCatalog = catalog;
        this.firePropertyChanged("defaultCatalog", old, catalog);
    }

    protected abstract String buildDefaultCatalog();

    public ListIterator<JavaVirtualUniqueConstraint> uniqueConstraints() {
        return this.getUniqueConstraints().iterator();
    }

    protected ListIterable<JavaVirtualUniqueConstraint> getUniqueConstraints() {
        return new LiveCloneListIterable(this.uniqueConstraints);
    }

    @Override
    public int uniqueConstraintsSize() {
        return this.uniqueConstraints.size();
    }

    @Override
    public JavaVirtualUniqueConstraint getUniqueConstraint(int index) {
        return this.uniqueConstraints.get(index);
    }

    protected void updateUniqueConstraints() {
        ContextContainerTools.update(this.uniqueConstraintContainerAdapter);
    }

    protected Iterable<UniqueConstraint> getOverriddenUniqueConstraints() {
        return CollectionTools.iterable(this.getOverriddenTable().uniqueConstraints());
    }

    protected void moveUniqueConstraint(int index, JavaVirtualUniqueConstraint constraint) {
        this.moveItemInList(index, constraint, this.uniqueConstraints, "uniqueConstraints");
    }

    protected JavaVirtualUniqueConstraint addUniqueConstraint(int index, UniqueConstraint uniqueConstraint) {
        JavaVirtualUniqueConstraint virtualConstraint = this.buildUniqueConstraint(uniqueConstraint);
        this.addItemToList(index, virtualConstraint, this.uniqueConstraints, "uniqueConstraints");
        return virtualConstraint;
    }

    protected JavaVirtualUniqueConstraint buildUniqueConstraint(UniqueConstraint uniqueConstraint) {
        return this.getJpaFactory().buildJavaVirtualUniqueConstraint(this, uniqueConstraint);
    }

    protected void removeUniqueConstraint(JavaVirtualUniqueConstraint constraint) {
        this.removeItemFromList(constraint, this.uniqueConstraints, "uniqueConstraints");
    }

    @Override
    public org.eclipse.jpt.jpa.db.Table getDbTable() {
        Schema dbSchema = this.getDbSchema();
        return dbSchema == null ? null : dbSchema.getTableForIdentifier(this.getName());
    }

    @Override
    public Schema getDbSchema() {
        SchemaContainer dbSchemaContainer = this.getDbSchemaContainer();
        return dbSchemaContainer == null ? null : dbSchemaContainer.getSchemaForIdentifier(this.getSchema());
    }

    @Override
    public SchemaContainer getDbSchemaContainer() {
        String catalog = this.getCatalog();
        return catalog != null ? this.resolveDbCatalog(catalog) : this.getDatabase();
    }

    @Override
    public Catalog getDbCatalog() {
        String catalog = this.getCatalog();
        return catalog == null ? null : this.resolveDbCatalog(catalog);
    }

    protected boolean isResolved() {
        return this.getDbTable() != null;
    }

    protected boolean hasResolvedSchema() {
        return this.getDbSchema() != null;
    }

    protected boolean hasResolvedCatalog() {
        String catalog = this.getCatalog();
        return catalog == null || this.resolveDbCatalog(catalog) != null;
    }

    @Override
    public TextRange getValidationTextRange(CompilationUnit astRoot) {
        return this.getParent().getValidationTextRange(astRoot);
    }

    @Override
    public JavaJpaContextNode getParent() {
        return (JavaJpaContextNode)super.getParent();
    }

    public void toString(StringBuilder sb) {
        sb.append(this.buildQualifiedName());
    }

    protected String buildQualifiedName() {
        return NameTools.buildQualifiedDatabaseObjectName((String)this.getCatalog(), (String)this.getSchema(), (String)this.getName());
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    protected class UniqueConstraintContainerAdapter
    implements ContextContainerTools.Adapter<JavaVirtualUniqueConstraint, UniqueConstraint> {
        protected UniqueConstraintContainerAdapter() {
        }

        @Override
        public Iterable<JavaVirtualUniqueConstraint> getContextElements() {
            return AbstractJavaVirtualTable.this.getUniqueConstraints();
        }

        @Override
        public Iterable<UniqueConstraint> getResourceElements() {
            return AbstractJavaVirtualTable.this.getOverriddenUniqueConstraints();
        }

        @Override
        public UniqueConstraint getResourceElement(JavaVirtualUniqueConstraint contextElement) {
            return contextElement.getOverriddenUniqueConstraint();
        }

        @Override
        public void moveContextElement(int index, JavaVirtualUniqueConstraint element) {
            AbstractJavaVirtualTable.this.moveUniqueConstraint(index, element);
        }

        @Override
        public void addContextElement(int index, UniqueConstraint resourceElement) {
            AbstractJavaVirtualTable.this.addUniqueConstraint(index, resourceElement);
        }

        @Override
        public void removeContextElement(JavaVirtualUniqueConstraint element) {
            AbstractJavaVirtualTable.this.removeUniqueConstraint(element);
        }
    }
}

