/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jpt.jpa.core.internal.refactoring;

import java.util.HashMap;
import java.util.Map;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.mapping.IResourceChangeDescriptionFactory;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.OperationCanceledException;
import org.eclipse.core.runtime.SubMonitor;
import org.eclipse.jdt.core.IJavaElement;
import org.eclipse.jpt.common.utility.internal.CollectionTools;
import org.eclipse.jpt.common.utility.internal.iterables.EmptyIterable;
import org.eclipse.jpt.jpa.core.JpaProject;
import org.eclipse.jpt.jpa.core.JpaProjectManager;
import org.eclipse.jpt.jpa.core.JptJpaCorePlugin;
import org.eclipse.jpt.jpa.core.context.persistence.MappingFileRef;
import org.eclipse.jpt.jpa.core.context.persistence.Persistence;
import org.eclipse.jpt.jpa.core.context.persistence.PersistenceUnit;
import org.eclipse.jpt.jpa.core.context.persistence.PersistenceXml;
import org.eclipse.jpt.jpa.core.internal.refactoring.JpaCoreRefactoringMessages;
import org.eclipse.ltk.core.refactoring.Change;
import org.eclipse.ltk.core.refactoring.CompositeChange;
import org.eclipse.ltk.core.refactoring.RefactoringStatus;
import org.eclipse.ltk.core.refactoring.TextChange;
import org.eclipse.ltk.core.refactoring.TextFileChange;
import org.eclipse.ltk.core.refactoring.participants.CheckConditionsContext;
import org.eclipse.ltk.core.refactoring.participants.RenameParticipant;
import org.eclipse.ltk.core.refactoring.participants.ResourceChangeChecker;
import org.eclipse.text.edits.MalformedTreeException;
import org.eclipse.text.edits.MultiTextEdit;
import org.eclipse.text.edits.ReplaceEdit;
import org.eclipse.text.edits.TextEdit;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class AbstractJpaRenameJavaElementParticipant
extends RenameParticipant {
    protected IJavaElement originalJavaElement;
    protected final Map<IFile, Iterable<ReplaceEdit>> persistenceXmlReplaceEdits = new HashMap<IFile, Iterable<ReplaceEdit>>();
    protected final Map<IFile, Iterable<ReplaceEdit>> mappingFileReplaceEdits = new HashMap<IFile, Iterable<ReplaceEdit>>();

    protected AbstractJpaRenameJavaElementParticipant() {
    }

    protected boolean initialize(Object element) {
        if (!this.getArguments().getUpdateReferences()) {
            return false;
        }
        this.originalJavaElement = (IJavaElement)element;
        return true;
    }

    protected IJavaElement getOriginalJavaElement() {
        return this.originalJavaElement;
    }

    public RefactoringStatus checkConditions(IProgressMonitor monitor, CheckConditionsContext context) throws OperationCanceledException {
        monitor.subTask(JpaCoreRefactoringMessages.JPA_REFACORING_PARTICIPANT_LOADING_JPA_PROJECTS_SUB_TASK_NAME);
        JpaProjectManager jpaProjectManager = JptJpaCorePlugin.getJpaProjectManager();
        if (jpaProjectManager.getJpaProjectsSize() == 0) {
            return null;
        }
        SubMonitor sm = SubMonitor.convert((IProgressMonitor)monitor, (int)(jpaProjectManager.getJpaProjectsSize() * 10 + 2));
        sm.subTask(this.getCheckConditionsSubTaskName());
        ResourceChangeChecker checker = (ResourceChangeChecker)context.getChecker(ResourceChangeChecker.class);
        IResourceChangeDescriptionFactory deltaFactory = checker.getDeltaFactory();
        for (JpaProject jpaProject : jpaProjectManager.getJpaProjects()) {
            this.createReplaceEdits((IProgressMonitor)sm.newChild(10), jpaProject);
        }
        if (sm.isCanceled()) {
            throw new OperationCanceledException();
        }
        for (IFile file : this.persistenceXmlReplaceEdits.keySet()) {
            deltaFactory.change(file);
        }
        sm.worked(1);
        for (IFile file : this.mappingFileReplaceEdits.keySet()) {
            deltaFactory.change(file);
        }
        sm.worked(1);
        return null;
    }

    protected abstract String getCompositeChangeName();

    protected abstract String getCheckConditionsSubTaskName();

    public Change createChange(IProgressMonitor monitor) throws CoreException, OperationCanceledException {
        if (this.persistenceXmlReplaceEdits.isEmpty() && this.mappingFileReplaceEdits.isEmpty()) {
            return null;
        }
        SubMonitor sm = SubMonitor.convert((IProgressMonitor)monitor, (int)(this.persistenceXmlReplaceEdits.size() + this.mappingFileReplaceEdits.size()));
        sm.subTask(this.getCreateChangeSubTaskName());
        CompositeChange compositeChange = new CompositeChange(this.getCompositeChangeName());
        for (IFile persistenceXmlFile : this.persistenceXmlReplaceEdits.keySet()) {
            this.addPersistenceXmlRenameEdits(persistenceXmlFile, compositeChange);
            sm.worked(1);
        }
        for (IFile mappingFile : this.mappingFileReplaceEdits.keySet()) {
            if (sm.isCanceled()) {
                throw new OperationCanceledException();
            }
            this.addMappingFileRenameEdits(mappingFile, compositeChange);
            sm.worked(1);
        }
        return compositeChange.getChildren().length == 0 ? null : compositeChange;
    }

    protected abstract String getCreateChangeSubTaskName();

    protected void createReplaceEdits(IProgressMonitor monitor, JpaProject jpaProject) throws OperationCanceledException {
        PersistenceUnit persistenceUnit = this.getPersistenceUnit(jpaProject);
        if (persistenceUnit == null) {
            return;
        }
        SubMonitor sm = SubMonitor.convert((IProgressMonitor)monitor, (int)(1 + persistenceUnit.mappingFileRefsSize()));
        Iterable<ReplaceEdit> classRefDeleteEdits = this.createPersistenceXmlReplaceEditsCheckClasspath(persistenceUnit);
        sm.worked(1);
        if (!CollectionTools.isEmpty(classRefDeleteEdits)) {
            this.persistenceXmlReplaceEdits.put(jpaProject.getPersistenceXmlResource().getFile(), classRefDeleteEdits);
        }
        for (MappingFileRef mappingFileRef : CollectionTools.iterable(persistenceUnit.mappingFileRefs())) {
            if (sm.isCanceled()) {
                throw new OperationCanceledException();
            }
            Iterable<ReplaceEdit> mappingFileReplaceEdits = this.createMappingFileReplaceEditsCheckClasspath(mappingFileRef);
            if (!CollectionTools.isEmpty(mappingFileReplaceEdits)) {
                IFile file = (IFile)mappingFileRef.getMappingFile().getResource();
                this.mappingFileReplaceEdits.put(file, mappingFileReplaceEdits);
            }
            sm.worked(1);
        }
    }

    protected Iterable<ReplaceEdit> createPersistenceXmlReplaceEditsCheckClasspath(PersistenceUnit persistenceUnit) {
        if (persistenceUnit.getJpaProject().getJavaProject().isOnClasspath(this.originalJavaElement)) {
            return this.createPersistenceXmlReplaceEdits(persistenceUnit);
        }
        return EmptyIterable.instance();
    }

    protected abstract Iterable<ReplaceEdit> createPersistenceXmlReplaceEdits(PersistenceUnit var1);

    protected void addPersistenceXmlRenameEdits(IFile persistenceXmlFile, CompositeChange compositeChange) {
        Iterable<ReplaceEdit> replacePackageEdits = this.persistenceXmlReplaceEdits.get(persistenceXmlFile);
        TextChange textChange = this.getTextChange(persistenceXmlFile);
        if (textChange == null) {
            textChange = new TextFileChange(this.getPersistenceXmlChangeName(), persistenceXmlFile);
            MultiTextEdit multiTextEdit = new MultiTextEdit();
            textChange.setEdit((TextEdit)multiTextEdit);
            compositeChange.add((Change)textChange);
        }
        this.addEdits(textChange, replacePackageEdits);
    }

    protected abstract String getPersistenceXmlChangeName();

    protected Iterable<ReplaceEdit> createMappingFileReplaceEditsCheckClasspath(MappingFileRef mappingFileRef) {
        if (mappingFileRef.getJpaProject().getJavaProject().isOnClasspath(this.originalJavaElement)) {
            return this.createMappingFileReplaceEdits(mappingFileRef);
        }
        return EmptyIterable.instance();
    }

    protected abstract Iterable<ReplaceEdit> createMappingFileReplaceEdits(MappingFileRef var1);

    protected void addMappingFileRenameEdits(IFile mappingFile, CompositeChange compositeChange) {
        Iterable<ReplaceEdit> replacedTypeEdits = this.mappingFileReplaceEdits.get(mappingFile);
        TextChange textChange = this.getTextChange(mappingFile);
        if (textChange == null) {
            textChange = new TextFileChange(this.getMappingFileChangeName(), mappingFile);
            MultiTextEdit multiTextEdit = new MultiTextEdit();
            textChange.setEdit((TextEdit)multiTextEdit);
            compositeChange.add((Change)textChange);
        }
        this.addEdits(textChange, replacedTypeEdits);
    }

    protected abstract String getMappingFileChangeName();

    private PersistenceUnit getPersistenceUnit(JpaProject jpaProject) {
        PersistenceXml persistenceXml = jpaProject.getRootContextNode().getPersistenceXml();
        if (persistenceXml == null) {
            return null;
        }
        Persistence persistence = persistenceXml.getPersistence();
        if (persistence == null) {
            return null;
        }
        if (persistence.persistenceUnitsSize() != 1) {
            return null;
        }
        return persistence.persistenceUnits().next();
    }

    private void addEdits(TextChange textChange, Iterable<? extends TextEdit> textEdits) {
        for (TextEdit textEdit : textEdits) {
            try {
                textChange.addEdit(textEdit);
            }
            catch (MalformedTreeException ex) {
                JptJpaCorePlugin.log(ex);
            }
        }
    }
}

