/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jpt.jpa.core.internal.jpa1.context.java;

import java.util.Iterator;
import org.eclipse.jdt.core.dom.CompilationUnit;
import org.eclipse.jpt.common.core.utility.TextRange;
import org.eclipse.jpt.common.utility.Filter;
import org.eclipse.jpt.common.utility.internal.StringTools;
import org.eclipse.jpt.common.utility.internal.iterables.EmptyIterable;
import org.eclipse.jpt.common.utility.internal.iterables.FilteringIterable;
import org.eclipse.jpt.jpa.core.context.ReadOnlyJoinColumn;
import org.eclipse.jpt.jpa.core.context.java.JavaJoinColumn;
import org.eclipse.jpt.jpa.core.context.java.JavaJpaContextNode;
import org.eclipse.jpt.jpa.core.internal.context.MappingTools;
import org.eclipse.jpt.jpa.core.internal.context.NamedColumnTextRangeResolver;
import org.eclipse.jpt.jpa.core.internal.context.java.AbstractJavaBaseColumn;
import org.eclipse.jpt.jpa.core.internal.context.java.JavaJoinColumnTextRangeResolver;
import org.eclipse.jpt.jpa.core.resource.java.JoinColumnAnnotation;
import org.eclipse.jpt.jpa.db.Column;
import org.eclipse.jpt.jpa.db.Table;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class GenericJavaJoinColumn
extends AbstractJavaBaseColumn<JoinColumnAnnotation, JavaJoinColumn.Owner>
implements JavaJoinColumn {
    protected JoinColumnAnnotation columnAnnotation;
    protected String specifiedReferencedColumnName = this.buildSpecifiedReferencedColumnName();
    protected String defaultReferencedColumnName;

    public GenericJavaJoinColumn(JavaJpaContextNode parent, JavaJoinColumn.Owner owner) {
        this(parent, owner, null);
    }

    public GenericJavaJoinColumn(JavaJpaContextNode parent, JavaJoinColumn.Owner owner, JoinColumnAnnotation columnAnnotation) {
        super(parent, owner, columnAnnotation);
    }

    @Override
    public void synchronizeWithResourceModel() {
        super.synchronizeWithResourceModel();
        this.setSpecifiedReferencedColumnName_(this.buildSpecifiedReferencedColumnName());
    }

    @Override
    public void update() {
        super.update();
        this.setDefaultReferencedColumnName(this.buildDefaultReferencedColumnName());
    }

    @Override
    public JoinColumnAnnotation getColumnAnnotation() {
        return this.columnAnnotation;
    }

    @Override
    protected void setColumnAnnotation(JoinColumnAnnotation columnAnnotation) {
        this.columnAnnotation = columnAnnotation;
    }

    @Override
    protected void removeColumnAnnotation() {
    }

    @Override
    public String getReferencedColumnName() {
        return this.specifiedReferencedColumnName != null ? this.specifiedReferencedColumnName : this.defaultReferencedColumnName;
    }

    @Override
    public String getSpecifiedReferencedColumnName() {
        return this.specifiedReferencedColumnName;
    }

    @Override
    public void setSpecifiedReferencedColumnName(String name) {
        if (this.valuesAreDifferent(this.specifiedReferencedColumnName, name)) {
            this.getColumnAnnotation().setReferencedColumnName(name);
            this.removeColumnAnnotationIfUnset();
            this.setSpecifiedReferencedColumnName_(name);
        }
    }

    protected void setSpecifiedReferencedColumnName_(String name) {
        String old = this.specifiedReferencedColumnName;
        this.specifiedReferencedColumnName = name;
        this.firePropertyChanged("specifiedReferencedColumnName", old, name);
    }

    protected String buildSpecifiedReferencedColumnName() {
        return this.getColumnAnnotation().getReferencedColumnName();
    }

    @Override
    public String getDefaultReferencedColumnName() {
        return this.defaultReferencedColumnName;
    }

    protected void setDefaultReferencedColumnName(String name) {
        String old = this.defaultReferencedColumnName;
        this.defaultReferencedColumnName = name;
        this.firePropertyChanged("defaultReferencedColumnName", old, name);
    }

    protected String buildDefaultReferencedColumnName() {
        return MappingTools.buildJoinColumnDefaultReferencedColumnName((ReadOnlyJoinColumn.Owner)((Object)this.owner));
    }

    @Override
    public TextRange getReferencedColumnNameTextRange(CompilationUnit astRoot) {
        return this.getValidationTextRange(this.getColumnAnnotation().getReferencedColumnNameTextRange(astRoot), astRoot);
    }

    @Override
    public Table getReferencedColumnDbTable() {
        return ((JavaJoinColumn.Owner)this.owner).getReferencedColumnDbTable();
    }

    protected Column getReferencedDbColumn() {
        Table table = this.getReferencedColumnDbTable();
        return table == null ? null : table.getColumnForIdentifier(this.getReferencedColumnName());
    }

    @Override
    public boolean referencedColumnIsResolved() {
        return this.getReferencedDbColumn() != null;
    }

    @Override
    public void initializeFrom(ReadOnlyJoinColumn oldColumn) {
        super.initializeFrom(oldColumn);
        this.setSpecifiedReferencedColumnName(oldColumn.getSpecifiedReferencedColumnName());
    }

    @Override
    public void initializeFromVirtual(ReadOnlyJoinColumn virtualColumn) {
        super.initializeFromVirtual(virtualColumn);
        this.setSpecifiedReferencedColumnName(virtualColumn.getReferencedColumnName());
    }

    @Override
    public boolean isDefault() {
        return ((JavaJoinColumn.Owner)this.owner).joinColumnIsDefault(this);
    }

    @Override
    protected String buildDefaultName() {
        return MappingTools.buildJoinColumnDefaultName(this, (ReadOnlyJoinColumn.Owner)((Object)this.owner));
    }

    @Override
    protected Iterator<String> connectedJavaCompletionProposals(int pos, Filter<String> filter, CompilationUnit astRoot) {
        Iterator<String> result = super.connectedJavaCompletionProposals(pos, filter, astRoot);
        if (result != null) {
            return result;
        }
        if (this.referencedColumnNameTouches(pos, astRoot)) {
            return this.getJavaCandidateReferencedColumnNames(filter).iterator();
        }
        return null;
    }

    protected boolean referencedColumnNameTouches(int pos, CompilationUnit astRoot) {
        return this.getColumnAnnotation().referencedColumnNameTouches(pos, astRoot);
    }

    protected Iterable<String> getJavaCandidateReferencedColumnNames(Filter<String> filter) {
        return StringTools.convertToJavaStringLiterals(this.getCandidateReferencedColumnNames(filter));
    }

    protected Iterable<String> getCandidateReferencedColumnNames(Filter<String> filter) {
        return new FilteringIterable(this.getCandidateReferencedColumnNames(), filter);
    }

    protected Iterable<String> getCandidateReferencedColumnNames() {
        Table table = ((JavaJoinColumn.Owner)this.owner).getReferencedColumnDbTable();
        return table != null ? table.getSortedColumnIdentifiers() : EmptyIterable.instance();
    }

    @Override
    protected NamedColumnTextRangeResolver buildTextRangeResolver(CompilationUnit astRoot) {
        return new JavaJoinColumnTextRangeResolver(this, astRoot);
    }
}

