/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jst.common.project.facet.core.libprov.internal;

import java.lang.ref.WeakReference;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.jst.common.project.facet.core.internal.FacetedProjectFrameworkJavaPlugin;
import org.eclipse.jst.common.project.facet.core.libprov.ILibraryProvider;
import org.eclipse.jst.common.project.facet.core.libprov.LegacyLibraryProviderDetector;
import org.eclipse.wst.common.project.facet.core.IProjectFacet;
import org.eclipse.wst.common.project.facet.core.util.internal.PluginUtil;

public final class LegacyLibraryProviderDetectorsExtensionPoint {
    public static final String EXTENSION_POINT_ID = "legacyLibraryProviderDetectors";
    private static final String ATTR_CLASS = "class";
    private static final String EL_DETECTOR = "detector";
    private static List<DetectorExtension> extensions = null;

    public static synchronized ILibraryProvider detect(IProject project, IProjectFacet facet) {
        LegacyLibraryProviderDetectorsExtensionPoint.readExtensions();
        Iterator<DetectorExtension> itr = extensions.iterator();
        while (itr.hasNext()) {
            LegacyLibraryProviderDetector detector;
            DetectorExtension extension = itr.next();
            try {
                detector = extension.createDetector();
            }
            catch (PluginUtil.InvalidExtensionException invalidExtensionException) {
                itr.remove();
                continue;
            }
            try {
                ILibraryProvider provider = detector.detect(project, facet);
                if (provider == null) continue;
                return provider;
            }
            catch (Exception e) {
                FacetedProjectFrameworkJavaPlugin.log(e);
            }
        }
        return null;
    }

    private static synchronized void readExtensions() {
        if (extensions != null) {
            return;
        }
        extensions = new ArrayList<DetectorExtension>();
        for (IConfigurationElement element : PluginUtil.getTopLevelElements((Collection)PluginUtil.findExtensions((String)"org.eclipse.jst.common.project.facet.core", (String)EXTENSION_POINT_ID))) {
            if (!element.getName().equals(EL_DETECTOR)) continue;
            try {
                String pluginId = element.getContributor().getName();
                String className = PluginUtil.findRequiredAttribute((IConfigurationElement)element, (String)ATTR_CLASS);
                extensions.add(new DetectorExtension(pluginId, className));
            }
            catch (PluginUtil.InvalidExtensionException invalidExtensionException) {}
        }
    }

    private static final class DetectorExtension {
        private final String pluginId;
        private final String className;
        private WeakReference<Class<? extends LegacyLibraryProviderDetector>> classWeakReference;

        public DetectorExtension(String pluginId, String className) {
            this.pluginId = pluginId;
            this.className = className;
        }

        public synchronized LegacyLibraryProviderDetector createDetector() throws PluginUtil.InvalidExtensionException {
            LegacyLibraryProviderDetector detector;
            Class detectorClass;
            Class clazz = detectorClass = this.classWeakReference == null ? null : (Class)this.classWeakReference.get();
            if (detectorClass == null) {
                detectorClass = PluginUtil.loadClass((String)this.pluginId, (String)this.className, LegacyLibraryProviderDetector.class);
                if (detectorClass == null) {
                    throw new PluginUtil.InvalidExtensionException();
                }
                this.classWeakReference = new WeakReference<Class>(detectorClass);
            }
            if ((detector = (LegacyLibraryProviderDetector)PluginUtil.instantiate((String)this.pluginId, (Class)detectorClass)) == null) {
                throw new PluginUtil.InvalidExtensionException();
            }
            return detector;
        }
    }
}

