/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jpt.jpa.core.resource.java;

import java.util.Iterator;
import org.eclipse.jdt.core.IPackageFragment;
import org.eclipse.jpt.jpa.core.resource.java.AccessType;
import org.eclipse.jpt.jpa.core.resource.java.JavaResourcePersistentAttribute;
import org.eclipse.jpt.jpa.core.resource.java.JavaResourcePersistentMember;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public interface JavaResourcePersistentType
extends JavaResourcePersistentMember {
    public static final String NAME_PROPERTY = "name";
    public static final String QUALIFIED_NAME_PROPERTY = "qualifiedName";
    public static final String PACKAGE_NAME_PROPERTY = "packageName";
    public static final String SUPERCLASS_QUALIFIED_NAME_PROPERTY = "superclassQualifiedName";
    public static final String DECLARING_TYPE_NAME_PROPERTY = "declaringTypeName";
    public static final String ABSTRACT_PROPERTY = "abstract";
    public static final String MEMBER_TYPE_PROPERTY = "memberType";
    public static final String STATIC_PROPERTY = "static";
    public static final String NO_ARG_CONSTRUCTOR_PROPERTY = "noArgConstructor";
    public static final String PRIVATE_NO_ARG_CONSTRUCTOR_PROPERTY = "privateNoArgConstructor";
    public static final String TYPES_COLLECTION = "types";
    public static final String FIELDS_COLLECTION = "fields";
    public static final String METHODS_COLLECTION = "methods";

    public String getName();

    public String getQualifiedName();

    public String getPackageName();

    public String getSuperclassQualifiedName();

    public String getDeclaringTypeName();

    public boolean isAbstract();

    public boolean isMemberType();

    public boolean isStatic();

    public boolean hasNoArgConstructor();

    public boolean hasPrivateNoArgConstructor();

    public boolean isMapped();

    public boolean hasAnyAnnotatedAttributes();

    public boolean isIn(IPackageFragment var1);

    public Iterator<JavaResourcePersistentType> types();

    public Iterator<JavaResourcePersistentType> allTypes();

    public Iterator<JavaResourcePersistentType> persistableTypes();

    public Iterator<JavaResourcePersistentAttribute> fields();

    public Iterator<JavaResourcePersistentAttribute> persistableFields();

    public Iterator<JavaResourcePersistentAttribute> persistableFieldsWithSpecifiedFieldAccess();

    public Iterator<JavaResourcePersistentAttribute> methods();

    public Iterator<JavaResourcePersistentAttribute> persistableProperties();

    public Iterator<JavaResourcePersistentAttribute> persistablePropertiesWithSpecifiedPropertyAccess();

    public Iterator<JavaResourcePersistentAttribute> persistableAttributes();

    public Iterator<JavaResourcePersistentAttribute> persistableAttributes(AccessType var1);

    public static class Tools {
        public static AccessType buildAccess(JavaResourcePersistentType jrpType) {
            Iterator<JavaResourcePersistentAttribute> stream = jrpType.persistableFields();
            while (stream.hasNext()) {
                if (!stream.next().isAnnotated()) continue;
                return AccessType.FIELD;
            }
            stream = jrpType.persistableProperties();
            while (stream.hasNext()) {
                if (!stream.next().isAnnotated()) continue;
                return AccessType.PROPERTY;
            }
            return null;
        }
    }
}

