/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jpt.jpa.core.internal.context.orm;

import java.util.Iterator;
import java.util.List;
import java.util.ListIterator;
import java.util.Vector;
import org.eclipse.jpt.common.core.utility.TextRange;
import org.eclipse.jpt.common.utility.internal.CollectionTools;
import org.eclipse.jpt.common.utility.internal.NameTools;
import org.eclipse.jpt.common.utility.internal.iterables.EmptyIterable;
import org.eclipse.jpt.common.utility.internal.iterables.ListIterable;
import org.eclipse.jpt.common.utility.internal.iterables.LiveCloneIterable;
import org.eclipse.jpt.common.utility.internal.iterables.LiveCloneListIterable;
import org.eclipse.jpt.common.utility.internal.iterators.EmptyIterator;
import org.eclipse.jpt.jpa.core.context.JpaContextNode;
import org.eclipse.jpt.jpa.core.context.ReadOnlyTable;
import org.eclipse.jpt.jpa.core.context.ReadOnlyUniqueConstraint;
import org.eclipse.jpt.jpa.core.context.Table;
import org.eclipse.jpt.jpa.core.context.UniqueConstraint;
import org.eclipse.jpt.jpa.core.context.XmlContextNode;
import org.eclipse.jpt.jpa.core.context.orm.OrmTable;
import org.eclipse.jpt.jpa.core.context.orm.OrmUniqueConstraint;
import org.eclipse.jpt.jpa.core.internal.context.ContextContainerTools;
import org.eclipse.jpt.jpa.core.internal.context.JptValidator;
import org.eclipse.jpt.jpa.core.internal.context.TableTextRangeResolver;
import org.eclipse.jpt.jpa.core.internal.context.orm.AbstractOrmXmlContextNode;
import org.eclipse.jpt.jpa.core.internal.context.orm.OrmTableTextRangeResolver;
import org.eclipse.jpt.jpa.core.resource.orm.AbstractXmlTable;
import org.eclipse.jpt.jpa.core.resource.orm.OrmFactory;
import org.eclipse.jpt.jpa.core.resource.orm.XmlUniqueConstraint;
import org.eclipse.jpt.jpa.core.resource.xml.AbstractJpaEObject;
import org.eclipse.jpt.jpa.db.Catalog;
import org.eclipse.jpt.jpa.db.Schema;
import org.eclipse.jpt.jpa.db.SchemaContainer;
import org.eclipse.jpt.jpa.db.Table;
import org.eclipse.wst.validation.internal.provisional.core.IMessage;
import org.eclipse.wst.validation.internal.provisional.core.IReporter;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class AbstractOrmTable<X extends AbstractXmlTable>
extends AbstractOrmXmlContextNode
implements OrmTable,
UniqueConstraint.Owner {
    protected final Table.Owner owner;
    protected String specifiedName;
    protected String defaultName;
    protected String specifiedSchema;
    protected String defaultSchema;
    protected String specifiedCatalog;
    protected String defaultCatalog;
    protected final Vector<OrmUniqueConstraint> uniqueConstraints = new Vector();
    protected final UniqueConstraintContainerAdapter uniqueConstraintContainerAdapter = new UniqueConstraintContainerAdapter();

    protected AbstractOrmTable(XmlContextNode parent, Table.Owner owner) {
        this(parent, owner, null);
    }

    protected AbstractOrmTable(XmlContextNode parent, Table.Owner owner, X xmlTable) {
        super(parent);
        this.owner = owner;
        this.setXmlTable(xmlTable);
        this.specifiedName = this.buildSpecifiedName();
        this.specifiedSchema = this.buildSpecifiedSchema();
        this.specifiedCatalog = this.buildSpecifiedCatalog();
        this.initializeUniqueContraints();
    }

    @Override
    public void synchronizeWithResourceModel() {
        super.synchronizeWithResourceModel();
        this.setSpecifiedName_(this.buildSpecifiedName());
        this.setSpecifiedSchema_(this.buildSpecifiedSchema());
        this.setSpecifiedCatalog_(this.buildSpecifiedCatalog());
        this.syncUniqueConstraints();
    }

    @Override
    public void update() {
        super.update();
        this.setDefaultName(this.buildDefaultName());
        this.setDefaultSchema(this.buildDefaultSchema());
        this.setDefaultCatalog(this.buildDefaultCatalog());
        this.updateNodes((Iterable<? extends JpaContextNode>)this.getUniqueConstraints());
    }

    protected abstract X getXmlTable();

    protected void setXmlTable(X xmlTable) {
        if (xmlTable != null) {
            throw new IllegalArgumentException("this method must be overridden if the XML table is not null: " + xmlTable);
        }
    }

    protected X getXmlTableForUpdate() {
        X xmlTable = this.getXmlTable();
        return xmlTable != null ? xmlTable : this.buildXmlTable();
    }

    protected abstract X buildXmlTable();

    protected void removeXmlTableIfUnset() {
        if (((AbstractJpaEObject)this.getXmlTable()).isUnset()) {
            this.removeXmlTable();
        }
    }

    protected abstract void removeXmlTable();

    @Override
    public boolean isSpecifiedInResource() {
        return this.getXmlTable() != null;
    }

    @Override
    public String getName() {
        return this.specifiedName != null ? this.specifiedName : this.defaultName;
    }

    @Override
    public String getSpecifiedName() {
        return this.specifiedName;
    }

    @Override
    public void setSpecifiedName(String name) {
        if (this.valuesAreDifferent(this.specifiedName, name)) {
            X xmlTable = this.getXmlTableForUpdate();
            this.setSpecifiedName_(name);
            ((AbstractXmlTable)xmlTable).setName(name);
            this.removeXmlTableIfUnset();
        }
    }

    protected void setSpecifiedName_(String name) {
        String old = this.specifiedName;
        this.specifiedName = name;
        this.firePropertyChanged("specifiedName", old, name);
    }

    protected String buildSpecifiedName() {
        X xmlTable = this.getXmlTable();
        return xmlTable == null ? null : ((AbstractXmlTable)xmlTable).getName();
    }

    @Override
    public String getDefaultName() {
        return this.defaultName;
    }

    protected void setDefaultName(String name) {
        String old = this.defaultName;
        this.defaultName = name;
        this.firePropertyChanged("defaultName", old, name);
    }

    protected abstract String buildDefaultName();

    @Override
    public String getSchema() {
        return this.specifiedSchema != null ? this.specifiedSchema : this.defaultSchema;
    }

    @Override
    public String getSpecifiedSchema() {
        return this.specifiedSchema;
    }

    @Override
    public void setSpecifiedSchema(String schema) {
        if (this.valuesAreDifferent(this.specifiedSchema, schema)) {
            X xmlTable = this.getXmlTableForUpdate();
            this.setSpecifiedSchema_(schema);
            ((AbstractXmlTable)xmlTable).setSchema(schema);
            this.removeXmlTableIfUnset();
        }
    }

    protected void setSpecifiedSchema_(String schema) {
        String old = this.specifiedSchema;
        this.specifiedSchema = schema;
        this.firePropertyChanged("specifiedSchema", old, schema);
    }

    protected String buildSpecifiedSchema() {
        X xmlTable = this.getXmlTable();
        return xmlTable == null ? null : ((AbstractXmlTable)xmlTable).getSchema();
    }

    @Override
    public String getDefaultSchema() {
        return this.defaultSchema;
    }

    protected void setDefaultSchema(String schema) {
        String old = this.defaultSchema;
        this.defaultSchema = schema;
        this.firePropertyChanged("defaultSchema", old, schema);
    }

    protected abstract String buildDefaultSchema();

    @Override
    public String getCatalog() {
        return this.specifiedCatalog != null ? this.specifiedCatalog : this.defaultCatalog;
    }

    @Override
    public String getSpecifiedCatalog() {
        return this.specifiedCatalog;
    }

    @Override
    public void setSpecifiedCatalog(String catalog) {
        if (this.valuesAreDifferent(this.specifiedCatalog, catalog)) {
            X xmlTable = this.getXmlTableForUpdate();
            this.setSpecifiedCatalog_(catalog);
            ((AbstractXmlTable)xmlTable).setCatalog(catalog);
            this.removeXmlTableIfUnset();
        }
    }

    protected void setSpecifiedCatalog_(String catalog) {
        String old = this.specifiedCatalog;
        this.specifiedCatalog = catalog;
        this.firePropertyChanged("specifiedCatalog", old, catalog);
    }

    protected String buildSpecifiedCatalog() {
        X xmlTable = this.getXmlTable();
        return xmlTable == null ? null : ((AbstractXmlTable)xmlTable).getCatalog();
    }

    @Override
    public String getDefaultCatalog() {
        return this.defaultCatalog;
    }

    protected void setDefaultCatalog(String catalog) {
        String old = this.defaultCatalog;
        this.defaultCatalog = catalog;
        this.firePropertyChanged("defaultCatalog", old, catalog);
    }

    protected abstract String buildDefaultCatalog();

    @Override
    public ListIterator<OrmUniqueConstraint> uniqueConstraints() {
        return this.getUniqueConstraints().iterator();
    }

    protected ListIterable<OrmUniqueConstraint> getUniqueConstraints() {
        return new LiveCloneListIterable(this.uniqueConstraints);
    }

    @Override
    public int uniqueConstraintsSize() {
        return this.uniqueConstraints.size();
    }

    @Override
    public OrmUniqueConstraint getUniqueConstraint(int index) {
        return this.uniqueConstraints.get(index);
    }

    @Override
    public OrmUniqueConstraint addUniqueConstraint() {
        return this.addUniqueConstraint(this.uniqueConstraints.size());
    }

    @Override
    public OrmUniqueConstraint addUniqueConstraint(int index) {
        X xmlTable = this.getXmlTableForUpdate();
        XmlUniqueConstraint xmlConstraint = this.buildXmlUniqueConstraint();
        OrmUniqueConstraint constraint = this.addUniqueConstraint_(index, xmlConstraint);
        ((AbstractXmlTable)xmlTable).getUniqueConstraints().add(index, (Object)xmlConstraint);
        return constraint;
    }

    protected XmlUniqueConstraint buildXmlUniqueConstraint() {
        return OrmFactory.eINSTANCE.createXmlUniqueConstraint();
    }

    @Override
    public void removeUniqueConstraint(UniqueConstraint constraint) {
        this.removeUniqueConstraint(this.uniqueConstraints.indexOf(constraint));
    }

    @Override
    public void removeUniqueConstraint(int index) {
        this.removeUniqueConstraint_(index);
        ((AbstractXmlTable)this.getXmlTable()).getUniqueConstraints().remove(index);
        this.removeXmlTableIfUnset();
    }

    protected void removeUniqueConstraint_(int index) {
        this.removeItemFromList(index, this.uniqueConstraints, "uniqueConstraints");
    }

    @Override
    public void moveUniqueConstraint(int targetIndex, int sourceIndex) {
        this.moveItemInList(targetIndex, sourceIndex, this.uniqueConstraints, "uniqueConstraints");
        ((AbstractXmlTable)this.getXmlTable()).getUniqueConstraints().move(targetIndex, sourceIndex);
    }

    protected void initializeUniqueContraints() {
        for (XmlUniqueConstraint xmlConstraint : this.getXmlUniqueConstraints()) {
            this.uniqueConstraints.add(this.buildUniqueConstraint(xmlConstraint));
        }
    }

    protected OrmUniqueConstraint buildUniqueConstraint(XmlUniqueConstraint xmlConstraint) {
        return this.getContextNodeFactory().buildOrmUniqueConstraint(this, this, xmlConstraint);
    }

    protected void syncUniqueConstraints() {
        ContextContainerTools.synchronizeWithResourceModel(this.uniqueConstraintContainerAdapter);
    }

    protected Iterable<XmlUniqueConstraint> getXmlUniqueConstraints() {
        X xmlTable = this.getXmlTable();
        return xmlTable == null ? EmptyIterable.instance() : new LiveCloneIterable(((AbstractXmlTable)xmlTable).getUniqueConstraints());
    }

    protected void moveUniqueConstraint_(int index, OrmUniqueConstraint constraint) {
        this.moveItemInList(index, constraint, this.uniqueConstraints, "uniqueConstraints");
    }

    protected OrmUniqueConstraint addUniqueConstraint_(int index, XmlUniqueConstraint xmlConstraint) {
        OrmUniqueConstraint constraint = this.buildUniqueConstraint(xmlConstraint);
        this.addItemToList(index, constraint, this.uniqueConstraints, "uniqueConstraints");
        return constraint;
    }

    protected void removeUniqueConstraint_(OrmUniqueConstraint constraint) {
        this.removeUniqueConstraint_(this.uniqueConstraints.indexOf(constraint));
    }

    @Override
    public Table getDbTable() {
        Schema dbSchema = this.getDbSchema();
        return dbSchema == null ? null : dbSchema.getTableForIdentifier(this.getName());
    }

    @Override
    public Schema getDbSchema() {
        SchemaContainer dbSchemaContainer = this.getDbSchemaContainer();
        return dbSchemaContainer == null ? null : dbSchemaContainer.getSchemaForIdentifier(this.getSchema());
    }

    @Override
    public SchemaContainer getDbSchemaContainer() {
        String catalog = this.getCatalog();
        return catalog != null ? this.resolveDbCatalog(catalog) : this.getDatabase();
    }

    @Override
    public Catalog getDbCatalog() {
        String catalog = this.getCatalog();
        return catalog == null ? null : this.resolveDbCatalog(catalog);
    }

    @Override
    public boolean isResolved() {
        return this.getDbTable() != null;
    }

    @Override
    public boolean schemaIsResolved() {
        return this.getDbSchema() != null;
    }

    @Override
    public boolean catalogIsResolved() {
        String catalog = this.getCatalog();
        return catalog == null || this.resolveDbCatalog(catalog) != null;
    }

    @Override
    public Iterator<String> candidateUniqueConstraintColumnNames() {
        Table dbTable = this.getDbTable();
        return dbTable != null ? dbTable.getSortedColumnIdentifiers().iterator() : EmptyIterator.instance();
    }

    @Override
    public void validate(List<IMessage> messages, IReporter reporter) {
        super.validate(messages, reporter);
        this.buildTableValidator().validate(messages, reporter);
    }

    protected JptValidator buildTableValidator() {
        return this.owner.buildTableValidator(this, this.buildTextRangeResolver());
    }

    protected TableTextRangeResolver buildTextRangeResolver() {
        return new OrmTableTextRangeResolver(this);
    }

    @Override
    public TextRange getValidationTextRange() {
        TextRange textRange = this.getXmlTableValidationTextRange();
        return textRange != null ? textRange : this.getParent().getValidationTextRange();
    }

    protected TextRange getXmlTableValidationTextRange() {
        X xmlTable = this.getXmlTable();
        return xmlTable == null ? null : ((AbstractJpaEObject)xmlTable).getValidationTextRange();
    }

    @Override
    public TextRange getNameTextRange() {
        return this.getValidationTextRange(this.getXmlTableNameTextRange());
    }

    protected TextRange getXmlTableNameTextRange() {
        X xmlTable = this.getXmlTable();
        return xmlTable == null ? null : ((AbstractXmlTable)xmlTable).getNameTextRange();
    }

    @Override
    public TextRange getSchemaTextRange() {
        return this.getValidationTextRange(this.getXmlTableSchemaTextRange());
    }

    protected TextRange getXmlTableSchemaTextRange() {
        X xmlTable = this.getXmlTable();
        return xmlTable == null ? null : ((AbstractXmlTable)xmlTable).getSchemaTextRange();
    }

    @Override
    public TextRange getCatalogTextRange() {
        return this.getValidationTextRange(this.getXmlTableCatalogTextRange());
    }

    protected TextRange getXmlTableCatalogTextRange() {
        X xmlTable = this.getXmlTable();
        return xmlTable == null ? null : ((AbstractXmlTable)xmlTable).getCatalogTextRange();
    }

    @Override
    public XmlContextNode getParent() {
        return (XmlContextNode)super.getParent();
    }

    protected void initializeFrom(ReadOnlyTable oldTable) {
        this.setSpecifiedName(oldTable.getSpecifiedName());
        this.setSpecifiedCatalog(oldTable.getSpecifiedCatalog());
        this.setSpecifiedSchema(oldTable.getSpecifiedSchema());
        for (ReadOnlyUniqueConstraint constraint : CollectionTools.iterable(oldTable.uniqueConstraints())) {
            this.addUniqueConstraint().initializeFrom(constraint);
        }
    }

    protected void initializeFromVirtual(ReadOnlyTable virtualTable) {
        this.setSpecifiedName(virtualTable.getName());
    }

    public void toString(StringBuilder sb) {
        sb.append(this.buildQualifiedName());
    }

    protected String buildQualifiedName() {
        return NameTools.buildQualifiedDatabaseObjectName((String)this.getCatalog(), (String)this.getSchema(), (String)this.getName());
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    protected class UniqueConstraintContainerAdapter
    implements ContextContainerTools.Adapter<OrmUniqueConstraint, XmlUniqueConstraint> {
        protected UniqueConstraintContainerAdapter() {
        }

        @Override
        public Iterable<OrmUniqueConstraint> getContextElements() {
            return AbstractOrmTable.this.getUniqueConstraints();
        }

        @Override
        public Iterable<XmlUniqueConstraint> getResourceElements() {
            return AbstractOrmTable.this.getXmlUniqueConstraints();
        }

        @Override
        public XmlUniqueConstraint getResourceElement(OrmUniqueConstraint contextElement) {
            return contextElement.getXmlUniqueConstraint();
        }

        @Override
        public void moveContextElement(int index, OrmUniqueConstraint element) {
            AbstractOrmTable.this.moveUniqueConstraint_(index, element);
        }

        @Override
        public void addContextElement(int index, XmlUniqueConstraint resourceElement) {
            AbstractOrmTable.this.addUniqueConstraint_(index, resourceElement);
        }

        @Override
        public void removeContextElement(OrmUniqueConstraint element) {
            AbstractOrmTable.this.removeUniqueConstraint_(element);
        }
    }
}

