/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.jsdt.debug.internal.core;

import java.util.ArrayList;
import java.util.HashMap;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.core.runtime.preferences.IEclipsePreferences;
import org.eclipse.core.runtime.preferences.InstanceScope;
import org.eclipse.debug.core.DebugException;
import org.eclipse.debug.core.DebugPlugin;
import org.eclipse.debug.core.model.IDebugTarget;
import org.eclipse.wst.jsdt.debug.core.breakpoints.IJavaScriptBreakpoint;
import org.eclipse.wst.jsdt.debug.core.breakpoints.IJavaScriptLoadBreakpoint;
import org.eclipse.wst.jsdt.debug.core.model.JavaScriptDebugModel;
import org.eclipse.wst.jsdt.debug.internal.core.JavaScriptDebugPlugin;
import org.eclipse.wst.jsdt.debug.internal.core.breakpoints.JavaScriptExceptionBreakpoint;
import org.eclipse.wst.jsdt.debug.internal.core.model.JavaScriptDebugTarget;

public class JavaScriptPreferencesManager
implements IEclipsePreferences.IPreferenceChangeListener {
    private static IJavaScriptLoadBreakpoint allLoadsBreakpoint = null;
    private static JavaScriptExceptionBreakpoint allExceptions = null;

    public void start() {
        IEclipsePreferences node = new InstanceScope().getNode("org.eclipse.wst.jsdt.debug.core");
        node.addPreferenceChangeListener((IEclipsePreferences.IPreferenceChangeListener)this);
        StartJob job = new StartJob(node.getBoolean("org.eclipse.wst.jsdt.debug.core.suspend_on_all_script_loads", false), node.getBoolean("org.eclipse.wst.jsdt.debug.core.suspend_on_thrown_exceptions", true));
        job.setSystem(true);
        job.setPriority(10);
        job.schedule();
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Unable to fully structure code
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void stop() {
        node = new InstanceScope().getNode("org.eclipse.wst.jsdt.debug.core");
        if (node != null) {
            node.removePreferenceChangeListener((IEclipsePreferences.IPreferenceChangeListener)this);
        }
        try {
            try {
                if (JavaScriptPreferencesManager.allLoadsBreakpoint != null) {
                    JavaScriptPreferencesManager.allLoadsBreakpoint.delete();
                }
                if (JavaScriptPreferencesManager.allExceptions != null) {
                    JavaScriptPreferencesManager.allExceptions.delete();
                }
                ** GOTO lbl-1000
            }
            catch (CoreException e) {
                JavaScriptDebugPlugin.log(e);
            }
            ** GOTO lbl-1000
        }
        catch (Throwable var4_3) {
            var3_4 = null;
            try {
                markers = ResourcesPlugin.getWorkspace().getRoot().findMarkers("org.eclipse.wst.jsdt.debug.core.breakpoint.marker", true, 0);
                i = 0;
                while (true) {
                    if (i >= markers.length) {
                        throw var4_3;
                    }
                    markers[i].delete();
                    ++i;
                }
            }
            catch (CoreException ce) {
                JavaScriptDebugPlugin.log(ce);
            }
        }
        throw var4_3;
lbl-1000:
        // 3 sources

        {
            var3_5 = null;
        }
        ** try [egrp 2[TRYBLOCK] [3 : 70->119)] { 
lbl32:
        // 1 sources

        markers = ResourcesPlugin.getWorkspace().getRoot().findMarkers("org.eclipse.wst.jsdt.debug.core.breakpoint.marker", true, 0);
        i = 0;
        while (true) {
            if (i >= markers.length) {
                return;
            }
            markers[i].delete();
            ++i;
        }
lbl40:
        // 1 sources

        catch (CoreException ce) {
            JavaScriptDebugPlugin.log(ce);
            return;
        }
    }

    public void preferenceChange(IEclipsePreferences.PreferenceChangeEvent event) {
        if (event.getKey().equals("org.eclipse.wst.jsdt.debug.core.suspend_on_all_script_loads")) {
            Object newval = event.getNewValue();
            if (newval != null && newval.equals(Boolean.TRUE.toString()) && allLoadsBreakpoint == null) {
                allLoadsBreakpoint = this.createSuspendOnAllLoads();
            } else {
                this.deleteSuspendOnAllLoads();
            }
            return;
        }
        if (event.getKey().equals("org.eclipse.wst.jsdt.debug.core.suspend_on_thrown_exceptions")) {
            Object newval = event.getNewValue();
            if (newval != null && newval.equals(Boolean.TRUE.toString())) {
                allExceptions = this.createSuspendOnException();
            } else {
                this.deleteSuspendOnException();
            }
        }
    }

    private JavaScriptExceptionBreakpoint createSuspendOnException() {
        try {
            JavaScriptExceptionBreakpoint breakpoint = new JavaScriptExceptionBreakpoint(new HashMap());
            breakpoint.setPersisted(false);
            IDebugTarget[] targets = DebugPlugin.getDefault().getLaunchManager().getDebugTargets();
            int i = 0;
            while (i < targets.length) {
                if (targets[i] instanceof JavaScriptDebugTarget) {
                    ((JavaScriptDebugTarget)targets[i]).breakpointAdded(breakpoint);
                }
                ++i;
            }
            return breakpoint;
        }
        catch (DebugException de) {
            JavaScriptDebugPlugin.log(de);
        }
        catch (CoreException ce) {
            JavaScriptDebugPlugin.log(ce);
        }
        return null;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private void deleteSuspendOnException() {
        if (allExceptions == null) return;
        IDebugTarget[] targets = DebugPlugin.getDefault().getLaunchManager().getDebugTargets();
        int i = 0;
        while (i < targets.length) {
            if (targets[i] instanceof JavaScriptDebugTarget) {
                ((JavaScriptDebugTarget)targets[i]).breakpointRemoved(allExceptions, null);
            }
            ++i;
        }
        try {
            try {
                allExceptions.delete();
            }
            catch (CoreException e) {
                JavaScriptDebugPlugin.log(e);
            }
            Object var3_6 = null;
            allExceptions = null;
            return;
        }
        catch (Throwable throwable) {
            Object var3_5 = null;
            allExceptions = null;
            throw throwable;
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private void deleteSuspendOnAllLoads() {
        if (allLoadsBreakpoint == null) return;
        IDebugTarget[] targets = DebugPlugin.getDefault().getLaunchManager().getDebugTargets();
        int i = 0;
        while (i < targets.length) {
            if (targets[i] instanceof JavaScriptDebugTarget) {
                ((JavaScriptDebugTarget)targets[i]).breakpointRemoved(allLoadsBreakpoint, null);
            }
            ++i;
        }
        try {
            try {
                allLoadsBreakpoint.delete();
            }
            catch (CoreException e) {
                JavaScriptDebugPlugin.log(e);
            }
            Object var3_6 = null;
            allLoadsBreakpoint = null;
            return;
        }
        catch (Throwable throwable) {
            Object var3_5 = null;
            allLoadsBreakpoint = null;
            throw throwable;
        }
    }

    private IJavaScriptLoadBreakpoint createSuspendOnAllLoads() {
        try {
            IJavaScriptLoadBreakpoint breakpoint = null;
            try {
                HashMap<String, Boolean> map = new HashMap<String, Boolean>();
                map.put("org.eclipse.wst.jsdt.debug.core.global_suspend", Boolean.TRUE);
                breakpoint = JavaScriptDebugModel.createScriptLoadBreakpoint((IResource)ResourcesPlugin.getWorkspace().getRoot(), -1, -1, map, false);
                breakpoint.setPersisted(false);
            }
            catch (DebugException e) {
                JavaScriptDebugPlugin.log(e);
            }
            if (breakpoint != null) {
                IDebugTarget[] targets = DebugPlugin.getDefault().getLaunchManager().getDebugTargets();
                int i = 0;
                while (i < targets.length) {
                    if (targets[i] instanceof JavaScriptDebugTarget) {
                        ((JavaScriptDebugTarget)targets[i]).breakpointAdded(breakpoint);
                    }
                    ++i;
                }
            }
            return breakpoint;
        }
        catch (CoreException ce) {
            JavaScriptDebugPlugin.log(ce);
            return null;
        }
    }

    public static void setGlobalSuspendOn(String scriptpath) {
        if (allLoadsBreakpoint != null) {
            try {
                allLoadsBreakpoint.getMarker().setAttribute("org.eclipse.wst.jsdt.debug.core.script_path", (Object)scriptpath);
            }
            catch (CoreException e) {
                JavaScriptDebugPlugin.log(e);
            }
        }
    }

    public static IJavaScriptBreakpoint[] getAllManagedBreakpoints() {
        ArrayList<IJavaScriptBreakpoint> breakpoints = new ArrayList<IJavaScriptBreakpoint>();
        if (allLoadsBreakpoint != null) {
            breakpoints.add(allLoadsBreakpoint);
        }
        if (allExceptions != null) {
            breakpoints.add(allExceptions);
        }
        return breakpoints.toArray(new IJavaScriptBreakpoint[breakpoints.size()]);
    }

    class StartJob
    extends Job {
        private boolean loads = false;
        private boolean exceptions = false;

        public StartJob(boolean loads, boolean exceptions) {
            super("");
            this.loads = loads;
            this.exceptions = exceptions;
        }

        protected IStatus run(IProgressMonitor monitor) {
            if (this.loads) {
                allLoadsBreakpoint = JavaScriptPreferencesManager.this.createSuspendOnAllLoads();
            }
            if (this.exceptions) {
                allExceptions = JavaScriptPreferencesManager.this.createSuspendOnException();
            }
            return Status.OK_STATUS;
        }
    }
}

