/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.server.ui.internal.view.servers;

import org.eclipse.core.commands.AbstractHandler;
import org.eclipse.core.commands.ExecutionEvent;
import org.eclipse.core.commands.ExecutionException;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.ui.handlers.HandlerUtil;
import org.eclipse.wst.server.core.IServer;
import org.eclipse.wst.server.ui.internal.actions.RunOnServerActionDelegate;
import org.eclipse.wst.server.ui.internal.view.servers.PublishAction;
import org.eclipse.wst.server.ui.internal.view.servers.StartAction;
import org.eclipse.wst.server.ui.internal.view.servers.StopAction;

public class ServerActionHandler
extends AbstractHandler {
    public Object execute(ExecutionEvent event) throws ExecutionException {
        String id;
        ISelection sel = HandlerUtil.getCurrentSelectionChecked((ExecutionEvent)event);
        Object obj = null;
        if (sel instanceof IStructuredSelection) {
            IStructuredSelection select = (IStructuredSelection)sel;
            obj = select.getFirstElement();
        }
        if ((id = event.getCommand().getId()).endsWith("publish")) {
            if (!(obj instanceof IServer)) {
                throw new ExecutionException("No server selected");
            }
            PublishAction.publish((IServer)obj, HandlerUtil.getActiveShell((ExecutionEvent)event));
            return null;
        }
        String mode = "run";
        if (id.endsWith("debug")) {
            mode = "debug";
        } else if (id.endsWith("profile")) {
            mode = "profile";
        } else if (id.endsWith("stop")) {
            mode = null;
        }
        if (obj instanceof IServer) {
            IServer server = (IServer)obj;
            if (mode == null) {
                StopAction.stop(server, HandlerUtil.getActiveShell((ExecutionEvent)event));
            } else {
                StartAction.start(server, mode, HandlerUtil.getActiveShell((ExecutionEvent)event));
            }
            return null;
        }
        RunOnServerActionDelegate ros = new RunOnServerActionDelegate();
        ros.setLaunchMode(mode);
        Action action = new Action(){};
        ros.selectionChanged((IAction)action, sel);
        ros.run((IAction)action);
        return null;
    }
}

