/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.common.componentcore.internal.operation;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import org.eclipse.core.commands.ExecutionException;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.jem.util.emf.workbench.ProjectUtilities;
import org.eclipse.wst.common.componentcore.internal.ModulecorePlugin;
import org.eclipse.wst.common.componentcore.internal.resources.VirtualComponent;
import org.eclipse.wst.common.componentcore.resources.IVirtualComponent;
import org.eclipse.wst.common.componentcore.resources.IVirtualReference;
import org.eclipse.wst.common.frameworks.datamodel.AbstractDataModelOperation;
import org.eclipse.wst.common.frameworks.datamodel.IDataModel;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class RemoveReferenceOperation
extends AbstractDataModelOperation {
    public RemoveReferenceOperation() {
    }

    public RemoveReferenceOperation(IDataModel model) {
        super(model);
    }

    public IStatus execute(IProgressMonitor monitor, IAdaptable info) throws ExecutionException {
        this.removeReferences(monitor);
        return OK_STATUS;
    }

    protected List<IVirtualReference> getListFromModel(IDataModel model) {
        Object value = model.getProperty("IAddReferenceDataModelProperties.TARGET_REFERENCE_LIST");
        List<IVirtualReference> modList = value instanceof List ? (List<IVirtualReference>)value : Arrays.asList((IVirtualReference)value);
        return modList;
    }

    protected void removeReferences(IProgressMonitor monitor) {
        IVirtualComponent sourceComp = (IVirtualComponent)this.model.getProperty("IAddReferenceDataModelProperties.SOURCE_COMPONENT");
        if (sourceComp == null || !sourceComp.getProject().isAccessible() || sourceComp.isBinary()) {
            return;
        }
        HashMap<String, Object> options = new HashMap<String, Object>();
        options.put("REQUESTED_REFERENCE_TYPE", "DISPLAYABLE_REFERENCES_ALL");
        IVirtualReference[] existingReferencesArray = sourceComp.getReferences(options);
        if (existingReferencesArray == null || existingReferencesArray.length == 0) {
            return;
        }
        ArrayList<IVirtualReference> existingReferences = new ArrayList<IVirtualReference>();
        existingReferences.addAll(Arrays.asList(existingReferencesArray));
        List<IVirtualReference> modList = this.getListFromModel(this.model);
        ArrayList<IProject> targetprojectList = new ArrayList<IProject>();
        int i = 0;
        while (i < modList.size() && !existingReferences.isEmpty()) {
            IVirtualReference existing;
            IVirtualReference ref = modList.get(i);
            if (ref.getReferencedComponent() != null && (existing = this.findMatchingReference(existingReferences, ref.getReferencedComponent(), ref.getRuntimePath())) != null) {
                this.removeRefereneceInComponent(sourceComp, existing);
                existingReferences.remove(existing);
                existing = this.findMatchingReference(existingReferences, ref.getReferencedComponent());
                if (existing == null) {
                    IProject targetProject = ref.getReferencedComponent().getProject();
                    targetprojectList.add(targetProject);
                }
            }
            ++i;
        }
        try {
            ProjectUtilities.removeReferenceProjects((IProject)sourceComp.getProject(), targetprojectList);
        }
        catch (CoreException e) {
            ModulecorePlugin.logError(e);
        }
    }

    private IVirtualReference findMatchingReference(List existingReferences, IVirtualComponent comp, IPath path) {
        int i = 0;
        while (i < existingReferences.size()) {
            IVirtualReference ref = (IVirtualReference)existingReferences.get(i);
            IVirtualComponent c = ref.getReferencedComponent();
            if (c != null && c.getName().equals(comp.getName())) {
                if (path == null) {
                    return ref;
                }
                if (path.equals((Object)ref.getRuntimePath())) {
                    return ref;
                }
            }
            ++i;
        }
        return null;
    }

    private IVirtualReference findMatchingReference(List existingReferences, IVirtualComponent comp) {
        return this.findMatchingReference(existingReferences, comp, null);
    }

    protected void removeRefereneceInComponent(IVirtualComponent component, IVirtualReference reference) {
        ((VirtualComponent)component.getComponent()).removeReference(reference);
    }
}

