/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jst.common.project.facet.core.internal;

import java.util.ArrayList;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IWorkspace;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.wst.common.project.facet.core.FacetedProjectFrameworkException;
import org.eclipse.wst.common.project.facet.core.IDelegate;

public abstract class JavaFacetDelegate
implements IDelegate {
    protected static void validateEdit(IProject project) throws CoreException {
        JavaFacetDelegate.validateEdit(new RelevantFiles(project));
    }

    protected static void validateEdit(RelevantFiles files) throws CoreException {
        IWorkspace ws;
        IStatus validateEditStatus;
        ArrayList<IFile> list = new ArrayList<IFile>();
        list.add(files.dotProjectFile);
        if (files.dotClasspathFile.exists()) {
            list.add(files.dotClasspathFile);
        }
        if (files.jdtCorePrefsFile.exists()) {
            list.add(files.jdtCorePrefsFile);
        }
        if (files.jstFacetCorePrefsFile.exists()) {
            list.add(files.jstFacetCorePrefsFile);
        }
        if ((validateEditStatus = (ws = ResourcesPlugin.getWorkspace()).validateEdit(list.toArray(new IFile[list.size()]), IWorkspace.VALIDATE_PROMPT)).getSeverity() == 4) {
            FacetedProjectFrameworkException e = new FacetedProjectFrameworkException(validateEditStatus);
            e.setExpected(true);
            throw e;
        }
    }

    protected static final class RelevantFiles {
        public final IFile dotProjectFile;
        public final IFile dotClasspathFile;
        public final IFile jdtCorePrefsFile;
        public final IFile jstFacetCorePrefsFile;

        public RelevantFiles(IProject project) {
            this.dotProjectFile = project.getFile(".project");
            this.dotClasspathFile = project.getFile(".classpath");
            this.jdtCorePrefsFile = project.getFile(".settings/org.eclipse.jdt.core.prefs");
            this.jstFacetCorePrefsFile = project.getFile(".settings/org.eclipse.jst.common.project.facet.core.prefs");
        }
    }
}

