/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jst.j2ee.internal.validation;

import java.io.BufferedInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.List;

public class ManifestLineValidator {
    public static final int MAX_LINE_LENGTH = 72;
    protected int lineNumber;
    protected int currentByte;
    protected int byteCount;
    protected InputStream inputStream;
    protected List lineNumbers;
    protected boolean endsWithLineBreak = true;

    public ManifestLineValidator(InputStream in) {
        this.inputStream = new BufferedInputStream(in);
        this.lineNumber = 0;
    }

    protected List getLineNumbers() {
        if (this.lineNumbers == null) {
            this.lineNumbers = new ArrayList();
        }
        return this.lineNumbers;
    }

    public int[] getLineNumbersExceedingLimit() {
        if (this.lineNumbers == null) {
            return new int[0];
        }
        int[] result = new int[this.lineNumbers.size()];
        int i = 0;
        while (i < this.lineNumbers.size()) {
            Integer list_element = (Integer)this.lineNumbers.get(i);
            result[i] = list_element;
            ++i;
        }
        return result;
    }

    public void validate() throws IOException {
        this.readNext();
        while (this.currentByte != -1) {
            this.validateNextLine();
        }
    }

    public int getLineCount() {
        return this.lineNumber;
    }

    protected void readNext() throws IOException {
        this.currentByte = this.inputStream.read();
    }

    protected void validateNextLine() throws IOException {
        ++this.lineNumber;
        this.byteCount = 0;
        boolean eolReached = false;
        while (this.currentByte != -1) {
            if (this.currentByte == 13) {
                eolReached = true;
                this.readNext();
                if (this.currentByte != 10) break;
                this.readNext();
                break;
            }
            if (this.currentByte == 10) {
                eolReached = true;
                this.readNext();
                break;
            }
            ++this.byteCount;
            this.readNext();
        }
        if (this.currentByte == -1 && !eolReached && this.byteCount > 0) {
            this.endsWithLineBreak = false;
        }
        if (this.byteCount > 72) {
            this.getLineNumbers().add(new Integer(this.lineNumber));
        }
    }

    public boolean endsWithLineBreak() {
        return this.endsWithLineBreak;
    }

    public boolean hasErrors() {
        return !this.endsWithLineBreak || this.lineNumbers != null && !this.lineNumbers.isEmpty();
    }
}

