/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jst.javaee.ltk.core.participant;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.OperationCanceledException;
import org.eclipse.core.runtime.Status;
import org.eclipse.ltk.core.refactoring.Change;
import org.eclipse.ltk.core.refactoring.CompositeChange;
import org.eclipse.ltk.core.refactoring.RefactoringStatus;
import org.eclipse.ltk.core.refactoring.participants.CheckConditionsContext;
import org.eclipse.ltk.core.refactoring.participants.DeleteParticipant;
import org.eclipse.wst.server.core.IModule;
import org.eclipse.wst.server.core.IServer;
import org.eclipse.wst.server.core.IServerWorkingCopy;
import org.eclipse.wst.server.core.ServerCore;
import org.eclipse.wst.server.core.ServerUtil;

public class JavaEEServerRefRefactorParticipant
extends DeleteParticipant {
    private IProject projectToDelete = null;
    private static final String MODS_FROM_SERVERS = "Java EE Server Cleanup (Remove deleted project from server)";

    private IStatus updateServerRefs(IModule[] modulesToRemove, IServer affectedServer, IProgressMonitor monitor) throws CoreException {
        if (modulesToRemove == null || modulesToRemove.length == 0) {
            return Status.OK_STATUS;
        }
        monitor.beginTask(MODS_FROM_SERVERS, modulesToRemove.length * 100);
        int j = 0;
        while (j < modulesToRemove.length) {
            IServerWorkingCopy wc = null;
            try {
                wc = affectedServer.createWorkingCopy();
                List<IModule> list = Arrays.asList(affectedServer.getModules());
                if (list.contains(modulesToRemove[j])) {
                    ServerUtil.modifyModules((IServerWorkingCopy)wc, null, (IModule[])new IModule[]{modulesToRemove[j]}, null);
                }
            }
            finally {
                if (wc != null) {
                    IServer newServer = wc.saveAll(true, null);
                    newServer.publish(1, (IProgressMonitor)new NullProgressMonitor());
                }
            }
            ++j;
        }
        return Status.OK_STATUS;
    }

    protected boolean initialize(Object element) {
        if (!(element instanceof IProject)) {
            return false;
        }
        this.projectToDelete = (IProject)element;
        return true;
    }

    public String getName() {
        return MODS_FROM_SERVERS;
    }

    public RefactoringStatus checkConditions(IProgressMonitor pm, CheckConditionsContext context) throws OperationCanceledException {
        return new RefactoringStatus();
    }

    public Change createChange(IProgressMonitor pm) throws CoreException, OperationCanceledException {
        CompositeChange change = new CompositeChange(this.getName());
        IServer[] allServers = ServerCore.getServers();
        int i = 0;
        while (i < allServers.length) {
            IModule[] serversMods = allServers[i].getModules();
            ArrayList<IModule> tmpList = new ArrayList<IModule>();
            int j = 0;
            while (j < serversMods.length) {
                if (serversMods[j].getProject() != null && serversMods[j].getProject().equals((Object)this.projectToDelete)) {
                    tmpList.add(serversMods[j]);
                }
                ++j;
            }
            IModule[] modsToRemove = tmpList.toArray(new IModule[tmpList.size()]);
            if (modsToRemove.length > 0) {
                change.add((Change)new RemoveProjectFromServersChange(modsToRemove, allServers[i]));
            }
            ++i;
        }
        return change;
    }

    public class RemoveProjectFromServersChange
    extends Change {
        private IModule[] modules;
        private IServer server;

        public RemoveProjectFromServersChange(IModule[] changeMods, IServer changeServer) {
            this.modules = changeMods;
            this.server = changeServer;
        }

        public String getName() {
            return JavaEEServerRefRefactorParticipant.MODS_FROM_SERVERS;
        }

        public void initializeValidationData(IProgressMonitor pm) {
        }

        public RefactoringStatus isValid(IProgressMonitor pm) throws CoreException, OperationCanceledException {
            return null;
        }

        public Change perform(IProgressMonitor pm) throws CoreException {
            JavaEEServerRefRefactorParticipant.this.updateServerRefs(this.modules, this.server, pm);
            return null;
        }

        public Object getModifiedElement() {
            return this.server;
        }
    }
}

