/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jpt.jpa.core.internal.resource.java.source;

import java.util.Map;
import org.eclipse.jdt.core.dom.CompilationUnit;
import org.eclipse.jpt.common.core.internal.utility.jdt.ElementAnnotationAdapter;
import org.eclipse.jpt.common.core.utility.TextRange;
import org.eclipse.jpt.common.core.utility.jdt.AnnotatedElement;
import org.eclipse.jpt.common.core.utility.jdt.AnnotationAdapter;
import org.eclipse.jpt.common.core.utility.jdt.AnnotationElementAdapter;
import org.eclipse.jpt.common.core.utility.jdt.DeclarationAnnotationAdapter;
import org.eclipse.jpt.common.core.utility.jdt.DeclarationAnnotationElementAdapter;
import org.eclipse.jpt.common.core.utility.jdt.Member;
import org.eclipse.jpt.jpa.core.internal.resource.java.source.SourceAnnotation;
import org.eclipse.jpt.jpa.core.resource.java.JavaResourceNode;
import org.eclipse.jpt.jpa.core.resource.java.NamedColumnAnnotation;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class SourceNamedColumnAnnotation
extends SourceAnnotation<Member>
implements NamedColumnAnnotation {
    private DeclarationAnnotationElementAdapter<String> nameDeclarationAdapter = this.buildNameDeclarationAdapter();
    private AnnotationElementAdapter<String> nameAdapter = this.buildNameAdapter();
    private String name;
    private DeclarationAnnotationElementAdapter<String> columnDefinitionDeclarationAdapter = this.buildColumnDefinitionDeclarationAdapter();
    private AnnotationElementAdapter<String> columnDefinitionAdapter = this.buildColumnDefinitionAdapter();
    private String columnDefinition;

    protected SourceNamedColumnAnnotation(JavaResourceNode parent, Member member, DeclarationAnnotationAdapter daa) {
        this(parent, member, daa, (AnnotationAdapter)new ElementAnnotationAdapter((AnnotatedElement)member, daa));
    }

    protected SourceNamedColumnAnnotation(JavaResourceNode parent, Member member, DeclarationAnnotationAdapter daa, AnnotationAdapter annotationAdapter) {
        super(parent, member, daa, annotationAdapter);
    }

    @Override
    public void initialize(CompilationUnit astRoot) {
        this.name = this.buildName(astRoot);
        this.columnDefinition = this.buildColumnDefinition(astRoot);
    }

    @Override
    public void synchronizeWith(CompilationUnit astRoot) {
        this.syncName(this.buildName(astRoot));
        this.syncColumnDefinition(this.buildColumnDefinition(astRoot));
    }

    @Override
    public boolean isSpecified() {
        return true;
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public void setName(String name) {
        if (this.attributeValueHasChanged(this.name, name)) {
            this.name = name;
            this.nameAdapter.setValue((Object)name);
        }
    }

    private void syncName(String astName) {
        String old = this.name;
        this.name = astName;
        this.firePropertyChanged("name", old, astName);
    }

    private String buildName(CompilationUnit astRoot) {
        return (String)this.nameAdapter.getValue(astRoot);
    }

    @Override
    public TextRange getNameTextRange(CompilationUnit astRoot) {
        return this.getElementTextRange(this.nameDeclarationAdapter, astRoot);
    }

    @Override
    public boolean nameTouches(int pos, CompilationUnit astRoot) {
        return this.elementTouches(this.nameDeclarationAdapter, pos, astRoot);
    }

    private DeclarationAnnotationElementAdapter<String> buildNameDeclarationAdapter() {
        return this.buildStringElementAdapter(this.getNameElementName());
    }

    private AnnotationElementAdapter<String> buildNameAdapter() {
        return this.buildStringElementAdapter(this.nameDeclarationAdapter);
    }

    protected abstract String getNameElementName();

    @Override
    public String getColumnDefinition() {
        return this.columnDefinition;
    }

    @Override
    public void setColumnDefinition(String columnDefinition) {
        if (this.attributeValueHasChanged(this.columnDefinition, columnDefinition)) {
            this.columnDefinition = columnDefinition;
            this.columnDefinitionAdapter.setValue((Object)columnDefinition);
        }
    }

    private void syncColumnDefinition(String astColumnDefinition) {
        String old = this.columnDefinition;
        this.columnDefinition = astColumnDefinition;
        this.firePropertyChanged("columnDefinition", old, astColumnDefinition);
    }

    private String buildColumnDefinition(CompilationUnit astRoot) {
        return (String)this.columnDefinitionAdapter.getValue(astRoot);
    }

    @Override
    public TextRange getColumnDefinitionTextRange(CompilationUnit astRoot) {
        return this.getElementTextRange(this.columnDefinitionDeclarationAdapter, astRoot);
    }

    private DeclarationAnnotationElementAdapter<String> buildColumnDefinitionDeclarationAdapter() {
        return this.buildStringElementAdapter(this.getColumnDefinitionElementName());
    }

    private AnnotationElementAdapter<String> buildColumnDefinitionAdapter() {
        return this.buildStringElementAdapter(this.columnDefinitionDeclarationAdapter);
    }

    protected abstract String getColumnDefinitionElementName();

    @Override
    public boolean isUnset() {
        return super.isUnset() && this.name == null && this.columnDefinition == null;
    }

    @Override
    protected void rebuildAdapters() {
        super.rebuildAdapters();
        this.nameDeclarationAdapter = this.buildNameDeclarationAdapter();
        this.nameAdapter = this.buildNameAdapter();
        this.columnDefinitionDeclarationAdapter = this.buildColumnDefinitionDeclarationAdapter();
        this.columnDefinitionAdapter = this.buildColumnDefinitionAdapter();
    }

    @Override
    public void storeOn(Map<String, Object> map) {
        super.storeOn(map);
        map.put("name", this.name);
        this.name = null;
        map.put("columnDefinition", this.columnDefinition);
        this.columnDefinition = null;
    }

    @Override
    public void restoreFrom(Map<String, Object> map) {
        super.restoreFrom(map);
        this.setName((String)map.get("name"));
        this.setColumnDefinition((String)map.get("columnDefinition"));
    }

    public void toString(StringBuilder sb) {
        sb.append(this.name);
    }
}

