/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jpt.jpa.core.internal;

import java.util.Iterator;
import org.eclipse.jdt.core.IAnnotation;
import org.eclipse.jpt.common.core.utility.jdt.AnnotatedElement;
import org.eclipse.jpt.common.core.utility.jdt.AnnotatedPackage;
import org.eclipse.jpt.common.core.utility.jdt.Attribute;
import org.eclipse.jpt.common.core.utility.jdt.Type;
import org.eclipse.jpt.common.utility.internal.iterables.ArrayIterable;
import org.eclipse.jpt.common.utility.internal.iterables.CompositeIterable;
import org.eclipse.jpt.common.utility.internal.iterables.TransformationIterable;
import org.eclipse.jpt.jpa.core.JpaAnnotationDefinitionProvider;
import org.eclipse.jpt.jpa.core.JpaAnnotationProvider;
import org.eclipse.jpt.jpa.core.resource.java.Annotation;
import org.eclipse.jpt.jpa.core.resource.java.AnnotationDefinition;
import org.eclipse.jpt.jpa.core.resource.java.JavaResourceAnnotatedElement;
import org.eclipse.jpt.jpa.core.resource.java.JavaResourcePackage;
import org.eclipse.jpt.jpa.core.resource.java.JavaResourcePersistentAttribute;
import org.eclipse.jpt.jpa.core.resource.java.JavaResourcePersistentType;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class GenericJpaAnnotationProvider
implements JpaAnnotationProvider {
    private final Iterable<JpaAnnotationDefinitionProvider> annotationDefinitionProviders;

    public GenericJpaAnnotationProvider(JpaAnnotationDefinitionProvider ... annotationDefinitionProviders) {
        this.annotationDefinitionProviders = new ArrayIterable((Object[])annotationDefinitionProviders);
    }

    @Override
    public Iterator<String> typeAnnotationNames() {
        return this.convertToNames(this.getTypeAnnotationDefinitions()).iterator();
    }

    protected Iterable<AnnotationDefinition> getTypeAnnotationDefinitions() {
        return new CompositeIterable((Iterable)new TransformationIterable<JpaAnnotationDefinitionProvider, Iterable<AnnotationDefinition>>(this.annotationDefinitionProviders){

            protected Iterable<AnnotationDefinition> transform(JpaAnnotationDefinitionProvider annotationDefinitionProvider) {
                return annotationDefinitionProvider.getTypeAnnotationDefinitions();
            }
        });
    }

    @Override
    public Iterator<String> typeMappingAnnotationNames() {
        return this.convertToNames(this.getTypeMappingAnnotationDefinitions()).iterator();
    }

    protected Iterable<AnnotationDefinition> getTypeMappingAnnotationDefinitions() {
        return new CompositeIterable((Iterable)new TransformationIterable<JpaAnnotationDefinitionProvider, Iterable<AnnotationDefinition>>(this.annotationDefinitionProviders){

            protected Iterable<AnnotationDefinition> transform(JpaAnnotationDefinitionProvider annotationDefinitionProvider) {
                return annotationDefinitionProvider.getTypeMappingAnnotationDefinitions();
            }
        });
    }

    @Override
    public Annotation buildTypeAnnotation(JavaResourcePersistentType parent, Type type, String annotationName) {
        return this.getTypeAnnotationDefinition(annotationName).buildAnnotation((JavaResourceAnnotatedElement)parent, (AnnotatedElement)type);
    }

    @Override
    public Annotation buildTypeAnnotation(JavaResourcePersistentType parent, IAnnotation jdtAnnotation) {
        return this.getTypeAnnotationDefinition(jdtAnnotation.getElementName()).buildAnnotation((JavaResourceAnnotatedElement)parent, jdtAnnotation);
    }

    protected AnnotationDefinition getTypeAnnotationDefinition(String annotationName) {
        AnnotationDefinition annotationDefinition = this.selectAnnotationDefinition(this.getTypeAnnotationDefinitions(), annotationName);
        if (annotationDefinition == null) {
            throw new IllegalArgumentException("unsupported type annotation: " + annotationName);
        }
        return annotationDefinition;
    }

    @Override
    public Annotation buildNullTypeAnnotation(JavaResourcePersistentType parent, String annotationName) {
        return this.getTypeAnnotationDefinition(annotationName).buildNullAnnotation(parent);
    }

    @Override
    public Iterator<String> attributeAnnotationNames() {
        return this.convertToNames(this.getAttributeAnnotationDefinitions()).iterator();
    }

    protected Iterable<AnnotationDefinition> getAttributeAnnotationDefinitions() {
        return new CompositeIterable((Iterable)new TransformationIterable<JpaAnnotationDefinitionProvider, Iterable<AnnotationDefinition>>(this.annotationDefinitionProviders){

            protected Iterable<AnnotationDefinition> transform(JpaAnnotationDefinitionProvider annotationDefinitionProvider) {
                return annotationDefinitionProvider.getAttributeAnnotationDefinitions();
            }
        });
    }

    @Override
    public Annotation buildAttributeAnnotation(JavaResourcePersistentAttribute parent, Attribute attribute, String annotationName) {
        return this.getAttributeAnnotationDefinition(annotationName).buildAnnotation((JavaResourceAnnotatedElement)parent, (AnnotatedElement)attribute);
    }

    @Override
    public Annotation buildAttributeAnnotation(JavaResourcePersistentAttribute parent, IAnnotation jdtAnnotation) {
        return this.getAttributeAnnotationDefinition(jdtAnnotation.getElementName()).buildAnnotation((JavaResourceAnnotatedElement)parent, jdtAnnotation);
    }

    @Override
    public Annotation buildNullAttributeAnnotation(JavaResourcePersistentAttribute parent, String annotationName) {
        return this.getAttributeAnnotationDefinition(annotationName).buildNullAnnotation(parent);
    }

    protected AnnotationDefinition getAttributeAnnotationDefinition(String annotationName) {
        AnnotationDefinition annotationDefinition = this.selectAnnotationDefinition(this.getAttributeAnnotationDefinitions(), annotationName);
        if (annotationDefinition == null) {
            throw new IllegalArgumentException("unsupported attribute annotation: " + annotationName);
        }
        return annotationDefinition;
    }

    @Override
    public Iterator<String> packageAnnotationNames() {
        return this.convertToNames(this.getPackageAnnotationDefinitions()).iterator();
    }

    protected Iterable<AnnotationDefinition> getPackageAnnotationDefinitions() {
        return new CompositeIterable((Iterable)new TransformationIterable<JpaAnnotationDefinitionProvider, Iterable<AnnotationDefinition>>(this.annotationDefinitionProviders){

            protected Iterable<AnnotationDefinition> transform(JpaAnnotationDefinitionProvider annotationDefinitionProvider) {
                return annotationDefinitionProvider.getPackageAnnotationDefinitions();
            }
        });
    }

    @Override
    public Annotation buildPackageAnnotation(JavaResourcePackage parent, AnnotatedPackage pkg, String annotationName) {
        return this.getPackageAnnotationDefinition(annotationName).buildAnnotation((JavaResourceAnnotatedElement)parent, (AnnotatedElement)pkg);
    }

    @Override
    public Annotation buildPackageAnnotation(JavaResourcePackage parent, IAnnotation jdtAnnotation) {
        return this.getPackageAnnotationDefinition(jdtAnnotation.getElementName()).buildAnnotation((JavaResourceAnnotatedElement)parent, jdtAnnotation);
    }

    @Override
    public Annotation buildNullPackageAnnotation(JavaResourcePackage parent, String annotationName) {
        return this.getPackageAnnotationDefinition(annotationName).buildNullAnnotation(parent);
    }

    protected AnnotationDefinition getPackageAnnotationDefinition(String annotationName) {
        AnnotationDefinition annotationDefinition = this.selectAnnotationDefinition(this.getPackageAnnotationDefinitions(), annotationName);
        if (annotationDefinition == null) {
            throw new IllegalArgumentException("unsupported package annotation: " + annotationName);
        }
        return annotationDefinition;
    }

    protected Iterable<String> convertToNames(Iterable<AnnotationDefinition> annotationDefinitions) {
        return new TransformationIterable<AnnotationDefinition, String>(annotationDefinitions){

            protected String transform(AnnotationDefinition annotationDefinition) {
                return annotationDefinition.getAnnotationName();
            }
        };
    }

    protected AnnotationDefinition selectAnnotationDefinition(Iterable<AnnotationDefinition> annotationDefinitions, String annotationName) {
        for (AnnotationDefinition annotationDefinition : annotationDefinitions) {
            if (!annotationDefinition.getAnnotationName().equals(annotationName)) continue;
            return annotationDefinition;
        }
        return null;
    }
}

