/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jpt.jpa.core.internal.context.orm;

import java.util.ListIterator;
import java.util.Vector;
import org.eclipse.jpt.common.utility.internal.CollectionTools;
import org.eclipse.jpt.common.utility.internal.iterables.EmptyListIterable;
import org.eclipse.jpt.common.utility.internal.iterables.ListIterable;
import org.eclipse.jpt.common.utility.internal.iterables.LiveCloneListIterable;
import org.eclipse.jpt.common.utility.internal.iterables.SingleElementListIterable;
import org.eclipse.jpt.jpa.core.context.JoinColumn;
import org.eclipse.jpt.jpa.core.context.ReadOnlyJoinColumn;
import org.eclipse.jpt.jpa.core.context.ReferenceTable;
import org.eclipse.jpt.jpa.core.context.VirtualReferenceTable;
import org.eclipse.jpt.jpa.core.context.XmlContextNode;
import org.eclipse.jpt.jpa.core.context.orm.OrmVirtualJoinColumn;
import org.eclipse.jpt.jpa.core.internal.context.ContextContainerTools;
import org.eclipse.jpt.jpa.core.internal.context.orm.AbstractOrmVirtualTable;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class AbstractOrmVirtualReferenceTable<T extends ReferenceTable>
extends AbstractOrmVirtualTable<T>
implements VirtualReferenceTable {
    protected final Vector<OrmVirtualJoinColumn> specifiedJoinColumns = new Vector();
    protected final SpecifiedJoinColumnContainerAdapter specifiedJoinColumnContainerAdapter = new SpecifiedJoinColumnContainerAdapter();
    protected final ReadOnlyJoinColumn.Owner joinColumnOwner = this.buildJoinColumnOwner();
    protected OrmVirtualJoinColumn defaultJoinColumn;

    protected AbstractOrmVirtualReferenceTable(XmlContextNode parent) {
        super(parent);
    }

    @Override
    public void update() {
        super.update();
        this.updateSpecifiedJoinColumns();
        this.updateDefaultJoinColumn();
    }

    public ListIterator<OrmVirtualJoinColumn> joinColumns() {
        return this.getJoinColumns().iterator();
    }

    protected ListIterable<OrmVirtualJoinColumn> getJoinColumns() {
        return this.hasSpecifiedJoinColumns() ? this.getSpecifiedJoinColumns() : this.getDefaultJoinColumns();
    }

    @Override
    public int joinColumnsSize() {
        return this.hasSpecifiedJoinColumns() ? this.specifiedJoinColumnsSize() : this.getDefaultJoinColumnsSize();
    }

    public ListIterator<OrmVirtualJoinColumn> specifiedJoinColumns() {
        return this.getSpecifiedJoinColumns().iterator();
    }

    protected ListIterable<OrmVirtualJoinColumn> getSpecifiedJoinColumns() {
        return new LiveCloneListIterable(this.specifiedJoinColumns);
    }

    @Override
    public int specifiedJoinColumnsSize() {
        return this.specifiedJoinColumns.size();
    }

    @Override
    public boolean hasSpecifiedJoinColumns() {
        return this.specifiedJoinColumns.size() != 0;
    }

    @Override
    public OrmVirtualJoinColumn getSpecifiedJoinColumn(int index) {
        return this.specifiedJoinColumns.get(index);
    }

    protected void updateSpecifiedJoinColumns() {
        ContextContainerTools.update(this.specifiedJoinColumnContainerAdapter);
    }

    protected Iterable<JoinColumn> getOverriddenJoinColumns() {
        return CollectionTools.iterable(((ReferenceTable)this.getOverriddenTable()).specifiedJoinColumns());
    }

    protected void moveSpecifiedJoinColumn(int index, OrmVirtualJoinColumn joinColumn) {
        this.moveItemInList(index, joinColumn, this.specifiedJoinColumns, "specifiedJoinColumns");
    }

    protected OrmVirtualJoinColumn addSpecifiedJoinColumn(int index, JoinColumn joinColumn) {
        OrmVirtualJoinColumn virtualJoinColumn = this.buildJoinColumn(joinColumn);
        this.addItemToList(index, virtualJoinColumn, this.specifiedJoinColumns, "specifiedJoinColumns");
        return virtualJoinColumn;
    }

    protected void removeSpecifiedJoinColumn(OrmVirtualJoinColumn joinColumn) {
        this.removeItemFromList(joinColumn, this.specifiedJoinColumns, "specifiedJoinColumns");
    }

    @Override
    public OrmVirtualJoinColumn getDefaultJoinColumn() {
        return this.defaultJoinColumn;
    }

    protected void setDefaultJoinColumn(OrmVirtualJoinColumn joinColumn) {
        OrmVirtualJoinColumn old = this.defaultJoinColumn;
        this.defaultJoinColumn = joinColumn;
        this.firePropertyChanged("defaultJoinColumn", old, joinColumn);
    }

    protected ListIterable<OrmVirtualJoinColumn> getDefaultJoinColumns() {
        return this.defaultJoinColumn != null ? new SingleElementListIterable((Object)this.defaultJoinColumn) : EmptyListIterable.instance();
    }

    protected int getDefaultJoinColumnsSize() {
        return this.defaultJoinColumn == null ? 0 : 1;
    }

    protected void updateDefaultJoinColumn() {
        if (this.buildsDefaultJoinColumn()) {
            if (this.defaultJoinColumn == null) {
                this.setDefaultJoinColumn(this.buildJoinColumn(((ReferenceTable)this.getOverriddenTable()).getDefaultJoinColumn()));
            } else {
                this.defaultJoinColumn.update();
            }
        } else {
            this.setDefaultJoinColumn(null);
        }
    }

    protected boolean buildsDefaultJoinColumn() {
        return !this.hasSpecifiedJoinColumns();
    }

    protected OrmVirtualJoinColumn buildJoinColumn(JoinColumn joinColumn) {
        return this.buildJoinColumn(this.joinColumnOwner, joinColumn);
    }

    protected OrmVirtualJoinColumn buildJoinColumn(ReadOnlyJoinColumn.Owner owner, JoinColumn joinColumn) {
        return this.getContextNodeFactory().buildOrmVirtualJoinColumn(this, owner, joinColumn);
    }

    protected abstract ReadOnlyJoinColumn.Owner buildJoinColumnOwner();

    @Override
    protected String buildDefaultSchema() {
        return this.getContextDefaultSchema();
    }

    @Override
    protected String buildDefaultCatalog() {
        return this.getContextDefaultCatalog();
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    protected class SpecifiedJoinColumnContainerAdapter
    implements ContextContainerTools.Adapter<OrmVirtualJoinColumn, JoinColumn> {
        protected SpecifiedJoinColumnContainerAdapter() {
        }

        @Override
        public Iterable<OrmVirtualJoinColumn> getContextElements() {
            return AbstractOrmVirtualReferenceTable.this.getSpecifiedJoinColumns();
        }

        @Override
        public Iterable<JoinColumn> getResourceElements() {
            return AbstractOrmVirtualReferenceTable.this.getOverriddenJoinColumns();
        }

        @Override
        public JoinColumn getResourceElement(OrmVirtualJoinColumn contextElement) {
            return contextElement.getOverriddenColumn();
        }

        @Override
        public void moveContextElement(int index, OrmVirtualJoinColumn element) {
            AbstractOrmVirtualReferenceTable.this.moveSpecifiedJoinColumn(index, element);
        }

        @Override
        public void addContextElement(int index, JoinColumn element) {
            AbstractOrmVirtualReferenceTable.this.addSpecifiedJoinColumn(index, element);
        }

        @Override
        public void removeContextElement(OrmVirtualJoinColumn element) {
            AbstractOrmVirtualReferenceTable.this.removeSpecifiedJoinColumn(element);
        }
    }
}

