/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jpt.jpa.core.internal.context;

import java.util.Iterator;
import org.eclipse.jpt.common.utility.internal.Transformer;
import org.eclipse.jpt.common.utility.internal.iterables.CompositeIterable;
import org.eclipse.jpt.common.utility.internal.iterables.FilteringIterable;
import org.eclipse.jpt.common.utility.internal.iterables.SubIterableWrapper;
import org.eclipse.jpt.common.utility.internal.iterables.TransformationIterable;
import org.eclipse.jpt.jpa.core.context.AttributeMapping;
import org.eclipse.jpt.jpa.core.context.ReadOnlyTable;
import org.eclipse.jpt.jpa.core.context.TypeMapping;
import org.eclipse.jpt.jpa.core.jpa2.context.SingleRelationshipMapping2_0;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class TypeMappingTools {
    public static final Transformer<TypeMapping, Iterator<AttributeMapping>> ATTRIBUTE_MAPPINGS_TRANSFORMER = new AttributeMappingsTransformer();
    public static final Transformer<TypeMapping, Iterator<ReadOnlyTable>> ASSOCIATED_TABLES_TRANSFORMER = new AssociatedTablesTransformer();
    public static final Transformer<TypeMapping, Iterator<String>> OVERRIDABLE_ATTRIBUTE_NAMES_TRANSFORMER = new OverridableAttributeNamesTransformer();
    public static final Transformer<TypeMapping, Iterator<String>> OVERRIDABLE_ASSOCIATION_NAMES_TRANSFORMER = new OverridableAssociationNamesTransformer();

    public static Iterable<String> getMappedByRelationshipAttributeNames(TypeMapping typeMapping) {
        return new TransformationIterable<SingleRelationshipMapping2_0, String>(TypeMappingTools.getMapsIdRelationshipMappings(typeMapping)){

            protected String transform(SingleRelationshipMapping2_0 attributeMapping) {
                return attributeMapping.getDerivedIdentity().getMapsIdDerivedIdentityStrategy().getValue();
            }
        };
    }

    public static Iterable<SingleRelationshipMapping2_0> getMapsIdRelationshipMappings(TypeMapping typeMapping) {
        return new FilteringIterable<SingleRelationshipMapping2_0>(TypeMappingTools.getSingleRelationshipMappings(typeMapping)){

            protected boolean accept(SingleRelationshipMapping2_0 attributeMapping) {
                return attributeMapping.getDerivedIdentity().usesMapsIdDerivedIdentityStrategy();
            }
        };
    }

    protected static Iterable<SingleRelationshipMapping2_0> getSingleRelationshipMappings(TypeMapping typeMapping) {
        return new SubIterableWrapper(TypeMappingTools.getSingleRelationshipMappings_(typeMapping));
    }

    protected static Iterable<AttributeMapping> getSingleRelationshipMappings_(TypeMapping typeMapping) {
        return new CompositeIterable(new Iterable[]{typeMapping.getAllAttributeMappings("oneToOne"), typeMapping.getAllAttributeMappings("manyToOne")});
    }

    private TypeMappingTools() {
        throw new UnsupportedOperationException();
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    static class AssociatedTablesTransformer
    implements Transformer<TypeMapping, Iterator<ReadOnlyTable>> {
        AssociatedTablesTransformer() {
        }

        public Iterator<ReadOnlyTable> transform(TypeMapping mapping) {
            return mapping.associatedTables();
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    static class AttributeMappingsTransformer
    implements Transformer<TypeMapping, Iterator<AttributeMapping>> {
        AttributeMappingsTransformer() {
        }

        public Iterator<AttributeMapping> transform(TypeMapping mapping) {
            return mapping.attributeMappings();
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    static class OverridableAssociationNamesTransformer
    implements Transformer<TypeMapping, Iterator<String>> {
        OverridableAssociationNamesTransformer() {
        }

        public Iterator<String> transform(TypeMapping mapping) {
            return mapping.overridableAssociationNames();
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    static class OverridableAttributeNamesTransformer
    implements Transformer<TypeMapping, Iterator<String>> {
        OverridableAttributeNamesTransformer() {
        }

        public Iterator<String> transform(TypeMapping mapping) {
            return mapping.overridableAttributeNames();
        }
    }
}

