/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jpt.core.internal.validation;

import java.util.Iterator;
import org.eclipse.core.resources.IMarker;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.jpt.core.IResourcePart;
import org.eclipse.jpt.core.JpaProject;
import org.eclipse.jpt.core.JptCorePlugin;
import org.eclipse.jpt.core.internal.validation.DefaultJpaValidationMessages;
import org.eclipse.jpt.core.internal.validation.JpaValidationPreferences;
import org.eclipse.jpt.utility.internal.iterators.SingleElementIterator;
import org.eclipse.wst.validation.AbstractValidator;
import org.eclipse.wst.validation.ValidationResult;
import org.eclipse.wst.validation.ValidationState;
import org.eclipse.wst.validation.internal.provisional.core.IMessage;
import org.eclipse.wst.validation.internal.provisional.core.IProjectValidationContext;
import org.eclipse.wst.validation.internal.provisional.core.IReporter;
import org.eclipse.wst.validation.internal.provisional.core.IValidationContext;
import org.eclipse.wst.validation.internal.provisional.core.IValidator;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class JpaValidator
extends AbstractValidator
implements IValidator {
    public void validate(IValidationContext context, IReporter reporter) {
        this.validate(reporter, this.project(context));
    }

    public void cleanup(IReporter reporter) {
    }

    public ValidationResult validate(IResource resource, int kind, ValidationState state, IProgressMonitor monitor) {
        if (resource.getType() != 1) {
            return null;
        }
        ValidationResult result = new ValidationResult();
        IReporter reporter = result.getReporter(monitor);
        IProject project = resource.getProject();
        try {
            this.clearMarkers(project);
        }
        catch (CoreException ce) {
            JptCorePlugin.log(ce);
        }
        result.setSuspendValidation(project);
        this.validate(reporter, project);
        return result;
    }

    private void clearMarkers(IProject project) throws CoreException {
        IMarker[] markers = project.findMarkers("org.eclipse.wst.validation.problemmarker2", true, 2);
        String valId = "org.eclipse.jpt.core.jpaValidator";
        IMarker[] iMarkerArray = markers;
        int n = markers.length;
        int n2 = 0;
        while (n2 < n) {
            IMarker marker = iMarkerArray[n2];
            String id = marker.getAttribute("ValidationId", null);
            if (valId.equals(id)) {
                marker.delete();
            }
            ++n2;
        }
    }

    private void validate(IReporter reporter, IProject project) {
        reporter.removeAllMessages((IValidator)this);
        Iterator<IMessage> stream = this.validationMessages(reporter, project);
        while (stream.hasNext()) {
            IMessage message = stream.next();
            if (JpaValidationPreferences.isProblemIgnored(project, message.getId())) continue;
            reporter.addMessage((IValidator)this, this.adjustMessage(message));
        }
    }

    private IProject project(IValidationContext context) {
        return ((IProjectValidationContext)context).getProject();
    }

    private Iterator<IMessage> validationMessages(IReporter reporter, IProject project) {
        JpaProject jpaProject = JptCorePlugin.getJpaProject(project);
        if (jpaProject != null) {
            return jpaProject.validationMessages(reporter);
        }
        return new SingleElementIterator((Object)DefaultJpaValidationMessages.buildMessage(1, "NO_JPA_PROJECT", project));
    }

    private IMessage adjustMessage(IMessage message) {
        IAdaptable targetObject = (IAdaptable)message.getTargetObject();
        IResource targetResource = ((IResourcePart)targetObject.getAdapter(IResourcePart.class)).getResource();
        message.setTargetObject((Object)targetResource);
        if (message.getLineNumber() == 0) {
            message.setAttribute("location", (Object)" ");
        }
        return message;
    }
}

