/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jpt.core.internal.context.orm;

import org.eclipse.jpt.core.context.Entity;
import org.eclipse.jpt.core.context.TypeMapping;
import org.eclipse.jpt.core.context.orm.OrmJoinColumnEnabledRelationshipReference;
import org.eclipse.jpt.core.context.orm.OrmJoinTableEnabledRelationshipReference;
import org.eclipse.jpt.core.context.orm.OrmJoiningStrategy;
import org.eclipse.jpt.core.context.orm.OrmOwnableRelationshipReference;
import org.eclipse.jpt.core.context.orm.OrmRelationshipMapping;
import org.eclipse.jpt.core.context.orm.OrmRelationshipReference;
import org.eclipse.jpt.core.internal.context.orm.AbstractOrmXmlContextNode;
import org.eclipse.jpt.core.resource.orm.AbstractXmlRelationshipMapping;
import org.eclipse.jpt.core.utility.TextRange;

public abstract class AbstractOrmRelationshipReference
extends AbstractOrmXmlContextNode
implements OrmRelationshipReference {
    protected AbstractXmlRelationshipMapping resourceMapping;
    protected OrmJoiningStrategy cachedPredominantJoiningStrategy;

    protected AbstractOrmRelationshipReference(OrmRelationshipMapping parent, AbstractXmlRelationshipMapping resourceMapping) {
        super(parent);
        this.resourceMapping = resourceMapping;
        this.initialize();
    }

    public void initializeFromOwnableRelationshipReference(OrmOwnableRelationshipReference oldRelationshipReference) {
    }

    public void initializeFromJoinColumnEnabledRelationshipReference(OrmJoinColumnEnabledRelationshipReference oldRelationshipReference) {
    }

    public void initializeFromJoinTableEnabledRelationshipReference(OrmJoinTableEnabledRelationshipReference oldRelationshipReference) {
    }

    public OrmRelationshipMapping getRelationshipMapping() {
        return (OrmRelationshipMapping)this.getParent();
    }

    public TypeMapping getTypeMapping() {
        return this.getRelationshipMapping().getTypeMapping();
    }

    public Entity getEntity() {
        TypeMapping typeMapping = this.getTypeMapping();
        return typeMapping instanceof Entity ? (Entity)typeMapping : null;
    }

    public boolean isOverridableAssociation() {
        return this.getPredominantJoiningStrategy().isOverridableAssociation();
    }

    public boolean isParentVirtual() {
        return this.getRelationshipMapping().getPersistentAttribute().isVirtual();
    }

    public boolean isTargetForeignKeyRelationship() {
        return false;
    }

    public OrmJoiningStrategy getPredominantJoiningStrategy() {
        return this.cachedPredominantJoiningStrategy;
    }

    protected void setPredominantJoiningStrategy() {
        this.setPredominantJoiningStrategy(this.calculatePredominantJoiningStrategy());
    }

    protected void setPredominantJoiningStrategy(OrmJoiningStrategy newJoiningStrategy) {
        OrmJoiningStrategy oldJoiningStrategy = this.cachedPredominantJoiningStrategy;
        this.cachedPredominantJoiningStrategy = newJoiningStrategy;
        this.firePropertyChanged("predominantStrategy", oldJoiningStrategy, newJoiningStrategy);
    }

    protected void initialize() {
        this.initializeJoiningStrategies();
        this.cachedPredominantJoiningStrategy = this.calculatePredominantJoiningStrategy();
    }

    protected abstract void initializeJoiningStrategies();

    public void update() {
        this.updateJoiningStrategies();
        this.setPredominantJoiningStrategy();
    }

    protected abstract void updateJoiningStrategies();

    protected abstract OrmJoiningStrategy calculatePredominantJoiningStrategy();

    public TextRange getValidationTextRange() {
        return this.getRelationshipMapping().getValidationTextRange();
    }
}

