/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jpt.ui.internal.details;

import java.util.ArrayList;
import java.util.ListIterator;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.jpt.core.context.AssociationOverride;
import org.eclipse.jpt.core.context.AssociationOverrideContainer;
import org.eclipse.jpt.core.context.AttributeOverride;
import org.eclipse.jpt.core.context.AttributeOverrideContainer;
import org.eclipse.jpt.core.context.BaseOverride;
import org.eclipse.jpt.core.context.JpaContextNode;
import org.eclipse.jpt.ui.internal.details.AssociationOverrideComposite;
import org.eclipse.jpt.ui.internal.details.AttributeOverrideComposite;
import org.eclipse.jpt.ui.internal.details.JptUiDetailsMessages;
import org.eclipse.jpt.ui.internal.util.ControlSwitcher;
import org.eclipse.jpt.ui.internal.util.PaneEnabler;
import org.eclipse.jpt.ui.internal.utility.swt.SWTTools;
import org.eclipse.jpt.ui.internal.widgets.AddRemoveListPane;
import org.eclipse.jpt.ui.internal.widgets.AddRemovePane;
import org.eclipse.jpt.ui.internal.widgets.Pane;
import org.eclipse.jpt.utility.internal.StringTools;
import org.eclipse.jpt.utility.internal.Transformer;
import org.eclipse.jpt.utility.internal.model.value.CachingTransformationPropertyValueModel;
import org.eclipse.jpt.utility.internal.model.value.CachingTransformationWritablePropertyValueModel;
import org.eclipse.jpt.utility.internal.model.value.CompositeListValueModel;
import org.eclipse.jpt.utility.internal.model.value.ItemPropertyListValueModelAdapter;
import org.eclipse.jpt.utility.internal.model.value.ListAspectAdapter;
import org.eclipse.jpt.utility.internal.model.value.SimplePropertyValueModel;
import org.eclipse.jpt.utility.internal.model.value.TransformationPropertyValueModel;
import org.eclipse.jpt.utility.internal.model.value.TransformationWritablePropertyValueModel;
import org.eclipse.jpt.utility.internal.model.value.swing.ObjectListSelectionModel;
import org.eclipse.jpt.utility.model.value.ListValueModel;
import org.eclipse.jpt.utility.model.value.PropertyValueModel;
import org.eclipse.jpt.utility.model.value.WritablePropertyValueModel;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.ui.part.PageBook;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class AbstractOverridesComposite<T extends JpaContextNode>
extends Pane<T> {
    private Pane<AttributeOverride> attributeOverridePane;
    private Pane<AssociationOverride> associationOverridePane;
    private WritablePropertyValueModel<BaseOverride> selectedOverrideHolder;
    private WritablePropertyValueModel<Boolean> overrideVirtualOverrideHolder;

    protected AbstractOverridesComposite(Pane<? extends T> parentPane, Composite parent) {
        super(parentPane, parent, false);
    }

    @Override
    protected void initialize() {
        super.initialize();
        this.selectedOverrideHolder = this.buildSelectedOverrideHolder();
    }

    private WritablePropertyValueModel<BaseOverride> buildSelectedOverrideHolder() {
        return new SimplePropertyValueModel();
    }

    protected abstract boolean supportsAssociationOverrides();

    @Override
    protected void initializeLayout(Composite container) {
        container = this.addTitledGroup(container, JptUiDetailsMessages.OverridesComposite_attributeOverridesGroup);
        this.initializeOverridesList(container);
        int groupBoxMargin = this.getGroupBoxMargin();
        Button overrideCheckBox = this.addCheckBox(this.addSubPane(container, 0, groupBoxMargin, 0, groupBoxMargin), JptUiDetailsMessages.OverridesComposite_overrideDefault, this.getOverrideVirtualOverrideHolder(), null);
        SWTTools.controlVisibleState(this.buildSelectedOverrideBooleanHolder(), new Control[]{overrideCheckBox});
        PageBook pageBook = this.addPageBook(container);
        this.initializeOverridePanes(pageBook);
        this.installOverrideControlSwitcher((PropertyValueModel<BaseOverride>)this.selectedOverrideHolder, pageBook);
    }

    protected void initializeOverridePanes(PageBook pageBook) {
        this.initializeAttributeOverridePane(pageBook);
        if (this.supportsAssociationOverrides()) {
            this.initializeAssociationOverridePane(pageBook);
        }
    }

    private PropertyValueModel<Boolean> buildSelectedOverrideBooleanHolder() {
        return new TransformationPropertyValueModel<BaseOverride, Boolean>(this.selectedOverrideHolder){

            protected Boolean transform(BaseOverride value) {
                return value != null;
            }
        };
    }

    private void initializeOverridesList(Composite container) {
        new AddRemoveListPane<T>(this, this.addSubPane(container, 8), this.buildOverridesAdapter(), this.buildOverridesListModel(), this.selectedOverrideHolder, this.buildOverrideLabelProvider(), "org.eclipse.jpt.ui.entity_attributeOverrides"){

            @Override
            protected void initializeButtonPane(Composite container, String helpId) {
            }

            @Override
            protected void updateButtons() {
            }
        };
    }

    protected void initializeAttributeOverridePane(PageBook pageBook) {
        WritablePropertyValueModel<AttributeOverride> attributeOverrideHolder = this.buildAttributeOverrideHolder();
        this.attributeOverridePane = this.buildAttributeOverridePane(pageBook, (PropertyValueModel<AttributeOverride>)attributeOverrideHolder);
        this.installAttributeOverridePaneEnabler(this.attributeOverridePane, (PropertyValueModel<AttributeOverride>)attributeOverrideHolder);
    }

    protected Pane<AttributeOverride> buildAttributeOverridePane(PageBook pageBook, PropertyValueModel<AttributeOverride> attributeOverrideHolder) {
        return new AttributeOverrideComposite((Pane<?>)this, (PropertyValueModel<? extends AttributeOverride>)attributeOverrideHolder, (Composite)pageBook);
    }

    private void installAttributeOverridePaneEnabler(Pane<AttributeOverride> pane, PropertyValueModel<AttributeOverride> overrideHolder) {
        new PaneEnabler(this.buildOverrideBooleanHolder(overrideHolder), (Pane<?>)pane);
    }

    private PropertyValueModel<Boolean> buildOverrideBooleanHolder(PropertyValueModel<? extends BaseOverride> overrideHolder) {
        return new CachingTransformationPropertyValueModel<BaseOverride, Boolean>(overrideHolder){

            protected Boolean transform_(BaseOverride value) {
                return !value.isVirtual();
            }
        };
    }

    protected void initializeAssociationOverridePane(PageBook pageBook) {
        WritablePropertyValueModel<AssociationOverride> associationOverrideHolder = this.buildAssociationOverrideHolder();
        this.associationOverridePane = this.buildAssociationOverridePane(pageBook, (PropertyValueModel<AssociationOverride>)associationOverrideHolder);
        this.installAssociationOverridePaneEnabler(this.associationOverridePane, (PropertyValueModel<AssociationOverride>)associationOverrideHolder);
    }

    protected Pane<AssociationOverride> buildAssociationOverridePane(PageBook pageBook, PropertyValueModel<AssociationOverride> associationOverrideHolder) {
        return new AssociationOverrideComposite((Pane<?>)this, (PropertyValueModel<? extends AssociationOverride>)associationOverrideHolder, (Composite)pageBook);
    }

    private void installAssociationOverridePaneEnabler(Pane<AssociationOverride> pane, PropertyValueModel<AssociationOverride> overrideHolder) {
        new PaneEnabler(this.buildOverrideBooleanHolder(overrideHolder), (Pane<?>)pane);
    }

    private void installOverrideControlSwitcher(PropertyValueModel<BaseOverride> overrideHolder, PageBook pageBook) {
        new ControlSwitcher(overrideHolder, this.buildPaneTransformer(), pageBook);
    }

    private WritablePropertyValueModel<AssociationOverride> buildAssociationOverrideHolder() {
        return new TransformationWritablePropertyValueModel<BaseOverride, AssociationOverride>(this.selectedOverrideHolder){

            protected AssociationOverride transform_(BaseOverride value) {
                return value instanceof AssociationOverride ? (AssociationOverride)value : null;
            }
        };
    }

    private WritablePropertyValueModel<AttributeOverride> buildAttributeOverrideHolder() {
        return new TransformationWritablePropertyValueModel<BaseOverride, AttributeOverride>(this.selectedOverrideHolder){

            protected AttributeOverride transform_(BaseOverride value) {
                return value instanceof AttributeOverride ? (AttributeOverride)value : null;
            }
        };
    }

    private ListValueModel<AssociationOverride> buildDefaultAssociationOverridesListHolder(PropertyValueModel<AssociationOverrideContainer> containerHolder) {
        return new ListAspectAdapter<AssociationOverrideContainer, AssociationOverride>(containerHolder, new String[]{"virtualAssociationOverrides"}){

            protected ListIterator<AssociationOverride> listIterator_() {
                return ((AssociationOverrideContainer)this.subject).virtualAssociationOverrides();
            }

            protected int size_() {
                return ((AssociationOverrideContainer)this.subject).virtualAssociationOverridesSize();
            }
        };
    }

    private ListValueModel<AttributeOverride> buildDefaultAttributeOverridesListHolder(PropertyValueModel<AttributeOverrideContainer> containerHolder) {
        return new ListAspectAdapter<AttributeOverrideContainer, AttributeOverride>(containerHolder, new String[]{"virtualAttributeOverrides"}){

            protected ListIterator<AttributeOverride> listIterator_() {
                return ((AttributeOverrideContainer)this.subject).virtualAttributeOverrides();
            }

            protected int size_() {
                return ((AttributeOverrideContainer)this.subject).virtualAttributeOverridesSize();
            }
        };
    }

    protected WritablePropertyValueModel<Boolean> getOverrideVirtualOverrideHolder() {
        if (this.overrideVirtualOverrideHolder == null) {
            this.overrideVirtualOverrideHolder = this.buildOverrideVirtualOverrideHolder();
        }
        return this.overrideVirtualOverrideHolder;
    }

    private WritablePropertyValueModel<Boolean> buildOverrideVirtualOverrideHolder() {
        return new CachingTransformationWritablePropertyValueModel<BaseOverride, Boolean>(this.selectedOverrideHolder){

            public void setValue(Boolean value) {
                AbstractOverridesComposite.this.updateOverride(value);
            }

            protected Boolean transform_(BaseOverride value) {
                return !value.isVirtual();
            }
        };
    }

    private String buildOverrideDisplayString(BaseOverride override) {
        String overrideType = override instanceof AssociationOverride ? JptUiDetailsMessages.OverridesComposite_association : JptUiDetailsMessages.OverridesComposite_attribute;
        String name = override.getName();
        if (StringTools.stringIsEmpty((String)name)) {
            name = JptUiDetailsMessages.OverridesComposite_noName;
        }
        StringBuilder sb = new StringBuilder();
        sb.append(name);
        sb.append(" (");
        sb.append(overrideType);
        sb.append(") ");
        return sb.toString();
    }

    protected ILabelProvider buildOverrideLabelProvider() {
        return new LabelProvider(){

            public String getText(Object element) {
                return AbstractOverridesComposite.this.buildOverrideDisplayString((BaseOverride)element);
            }
        };
    }

    protected AddRemovePane.Adapter buildOverridesAdapter() {
        return new AddRemovePane.AbstractAdapter(){

            @Override
            public void addNewItem(ObjectListSelectionModel listSelectionModel) {
            }

            @Override
            public void removeSelectedItems(ObjectListSelectionModel listSelectionModel) {
            }
        };
    }

    protected ListValueModel<BaseOverride> buildOverridesListHolder() {
        PropertyValueModel<AttributeOverrideContainer> attributeOverrideContainerHolder = this.buildAttributeOverrideContainerHolder();
        ArrayList<Object> list = new ArrayList<Object>();
        list.add(this.buildSpecifiedAttributeOverridesListHolder(attributeOverrideContainerHolder));
        list.add(this.buildDefaultAttributeOverridesListHolder(attributeOverrideContainerHolder));
        if (this.supportsAssociationOverrides()) {
            PropertyValueModel<AssociationOverrideContainer> associationOverrideContainerHolder = this.buildAssociationOverrideContainerHolder();
            list.add(this.buildSpecifiedAssociationOverridesListHolder(associationOverrideContainerHolder));
            list.add(this.buildDefaultAssociationOverridesListHolder(associationOverrideContainerHolder));
        }
        return new CompositeListValueModel(list);
    }

    protected abstract PropertyValueModel<AttributeOverrideContainer> buildAttributeOverrideContainerHolder();

    protected abstract PropertyValueModel<AssociationOverrideContainer> buildAssociationOverrideContainerHolder();

    private ListValueModel<BaseOverride> buildOverridesListModel() {
        return new ItemPropertyListValueModelAdapter(this.buildOverridesListHolder(), new String[]{"name"});
    }

    private Transformer<BaseOverride, Control> buildPaneTransformer() {
        return new Transformer<BaseOverride, Control>(){

            public Control transform(BaseOverride override) {
                return AbstractOverridesComposite.this.transformSelectedOverride(override);
            }
        };
    }

    protected Control transformSelectedOverride(BaseOverride selectedOverride) {
        if (selectedOverride instanceof AttributeOverride) {
            return this.attributeOverridePane.getControl();
        }
        if (selectedOverride instanceof AssociationOverride) {
            return this.associationOverridePane.getControl();
        }
        return null;
    }

    private ListValueModel<AssociationOverride> buildSpecifiedAssociationOverridesListHolder(PropertyValueModel<AssociationOverrideContainer> containerHolder) {
        return new ListAspectAdapter<AssociationOverrideContainer, AssociationOverride>(containerHolder, new String[]{"specifiedAssociationOverrides"}){

            protected ListIterator<AssociationOverride> listIterator_() {
                return ((AssociationOverrideContainer)this.subject).specifiedAssociationOverrides();
            }

            protected int size_() {
                return ((AssociationOverrideContainer)this.subject).specifiedAssociationOverridesSize();
            }
        };
    }

    private ListValueModel<AttributeOverride> buildSpecifiedAttributeOverridesListHolder(PropertyValueModel<AttributeOverrideContainer> containerHolder) {
        return new ListAspectAdapter<AttributeOverrideContainer, AttributeOverride>(containerHolder, new String[]{"specifiedAttributeOverrides"}){

            protected ListIterator<AttributeOverride> listIterator_() {
                return ((AttributeOverrideContainer)this.subject).specifiedAttributeOverrides();
            }

            protected int size_() {
                return ((AttributeOverrideContainer)this.subject).specifiedAttributeOverridesSize();
            }
        };
    }

    private void updateOverride(boolean selected) {
        if (this.isPopulating()) {
            return;
        }
        this.setPopulating(true);
        try {
            BaseOverride override = (BaseOverride)this.selectedOverrideHolder.getValue();
            BaseOverride newOverride = override.setVirtual(!selected);
            this.selectedOverrideHolder.setValue((Object)newOverride);
        }
        finally {
            this.setPopulating(false);
        }
    }
}

