/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.jsdt.debug.internal.crossfire.jsdi;

import java.util.Map;
import org.eclipse.wst.jsdt.debug.core.jsdi.StackFrame;
import org.eclipse.wst.jsdt.debug.core.jsdi.Value;
import org.eclipse.wst.jsdt.debug.core.jsdi.Variable;
import org.eclipse.wst.jsdt.debug.core.jsdi.VirtualMachine;
import org.eclipse.wst.jsdt.debug.internal.crossfire.jsdi.CFBooleanValue;
import org.eclipse.wst.jsdt.debug.internal.crossfire.jsdi.CFNumberValue;
import org.eclipse.wst.jsdt.debug.internal.crossfire.jsdi.CFObjectReference;
import org.eclipse.wst.jsdt.debug.internal.crossfire.jsdi.CFProperty;
import org.eclipse.wst.jsdt.debug.internal.crossfire.jsdi.CFStackFrame;
import org.eclipse.wst.jsdt.debug.internal.crossfire.jsdi.CFStringValue;
import org.eclipse.wst.jsdt.debug.internal.crossfire.jsdi.CFVirtualMachine;

public class CFVariable
extends CFProperty
implements Variable {
    public CFVariable(CFVirtualMachine vm, CFStackFrame frame, String name, Number ref, Map values) {
        super(vm, frame, name, ref);
        Object value = null;
        try {
            if (values != null) {
                Object o;
                String kind = (String)values.get("type");
                if ("string".equals(kind)) {
                    value = new CFStringValue(vm, (String)values.get("value"));
                } else if ("number".equals(kind)) {
                    o = values.get("value");
                    if (o instanceof Number) {
                        value = new CFNumberValue((VirtualMachine)vm, (Number)o);
                    } else if (o instanceof String) {
                        value = new CFNumberValue((VirtualMachine)vm, (String)o);
                    }
                } else if ("boolean".equals(kind)) {
                    value = new CFBooleanValue(vm, (Boolean)values.get("value"));
                }
                if ("undefined".equals(kind)) {
                    value = this.crossfire().mirrorOfUndefined();
                } else if ("object".equals(kind)) {
                    if ("this".equals(name)) {
                        value = new CFObjectReference(this.crossfire(), frame, values);
                    } else if (ref == null && "null".equals(o = values.get("value"))) {
                        value = this.crossfire().mirrorOfNull();
                    }
                }
            } else {
                value = this.crossfire().mirrorOfNull();
            }
        }
        catch (Exception exception) {
            value = this.crossfire().mirrorOfUndefined();
        }
        if (value != null) {
            this.setValue((Value)value);
        }
    }

    public boolean isArgument() {
        return false;
    }

    public boolean isVisible(StackFrame frame) {
        if (frame instanceof CFStackFrame) {
            return ((CFStackFrame)frame).isVisible(this);
        }
        return false;
    }
}

