/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jst.j2ee.internal.plugin;

import java.io.IOException;
import java.net.URL;
import org.eclipse.core.internal.boot.PlatformURLConnection;
import org.eclipse.core.resources.IWorkspace;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.MultiStatus;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.Status;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.resource.ImageRegistry;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jst.j2ee.internal.plugin.J2EEPlugin;
import org.eclipse.jst.j2ee.internal.plugin.J2EEPluginResourceHandler;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.plugin.AbstractUIPlugin;
import org.osgi.framework.Bundle;

public class J2EEUIPlugin
extends AbstractUIPlugin {
    public static final String PLUGIN_ID = "org.eclipse.jst.j2ee.ui";
    private static J2EEUIPlugin plugin;
    private static IPath location;

    public J2EEUIPlugin() {
        plugin = this;
    }

    public static J2EEUIPlugin getDefault() {
        return plugin;
    }

    public static IWorkspace getWorkspace() {
        return ResourcesPlugin.getWorkspace();
    }

    public static IPath getInstallLocation() {
        if (location == null) {
            URL url = J2EEUIPlugin.getInstallURL();
            try {
                String installLocation = ((PlatformURLConnection)url.openConnection()).getURLAsLocal().getFile();
                location = new Path(installLocation);
            }
            catch (IOException e) {
                J2EEUIPlugin.logWarning(String.valueOf(J2EEPluginResourceHandler.getString((String)"Install_Location_Error_", (Object[])new Object[]{url})) + e);
            }
        }
        return location;
    }

    public static URL getInstallURL() {
        return J2EEUIPlugin.getDefault().getBundle().getEntry("/");
    }

    public Image getImage(String key) {
        ImageDescriptor descriptor;
        ImageRegistry imageRegistry = this.getImageRegistry();
        Image image = imageRegistry.get(key);
        if ((image == null || image.isDisposed()) && (descriptor = this.getImageDescriptor(key)) != null) {
            image = descriptor.createImage();
            imageRegistry.put(key, image);
        }
        return image;
    }

    public ImageDescriptor getImageDescriptor(String key) {
        ImageDescriptor imageDescriptor = null;
        URL gifImageURL = this.getImageURL(key);
        if (gifImageURL != null) {
            imageDescriptor = ImageDescriptor.createFromURL((URL)gifImageURL);
        }
        return imageDescriptor;
    }

    private URL getImageURL(String key) {
        return J2EEPlugin.getImageURL((String)key, (Bundle)this.getBundle());
    }

    public static IWorkbenchWindow getActiveWorkbenchWindow() {
        return J2EEUIPlugin.getPluginWorkbench().getActiveWorkbenchWindow();
    }

    public static IWorkbench getPluginWorkbench() {
        return J2EEUIPlugin.getDefault().getWorkbench();
    }

    public static Shell getActiveWorkbenchShell() {
        IWorkbenchWindow window = J2EEUIPlugin.getActiveWorkbenchWindow();
        if (window != null) {
            return window.getShell();
        }
        return null;
    }

    public static IStructuredSelection getCurrentSelection() {
        ISelection selection;
        IWorkbenchWindow window = J2EEUIPlugin.getActiveWorkbenchWindow();
        if (window != null && (selection = window.getSelectionService().getSelection()) instanceof IStructuredSelection) {
            return (IStructuredSelection)selection;
        }
        return null;
    }

    public static void logError(int aCode, String aMessage, Throwable anException) {
        J2EEUIPlugin.getDefault().getLog().log(J2EEUIPlugin.createErrorStatus(aCode, aMessage, anException));
    }

    public static void log(int severity, int aCode, String aMessage, Throwable exception) {
        J2EEUIPlugin.log(J2EEUIPlugin.createStatus(severity, aCode, aMessage, exception));
    }

    public static void log(IStatus aStatus) {
        J2EEUIPlugin.getDefault().getLog().log(aStatus);
    }

    public static IStatus createStatus(int severity, int aCode, String aMessage, Throwable exception) {
        return new Status(severity, PLUGIN_ID, aCode, aMessage != null ? aMessage : "No message.", exception);
    }

    public static IStatus createErrorStatus(int aCode, String aMessage, Throwable exception) {
        return J2EEUIPlugin.createStatus(4, aCode, aMessage, exception);
    }

    public static IStatus createStatus(int severity, String message, Throwable exception) {
        return new Status(severity, PLUGIN_ID, message, exception);
    }

    public static IStatus createStatus(int severity, String message) {
        return J2EEUIPlugin.createStatus(severity, message, null);
    }

    public static void logError(Throwable exception) {
        Platform.getLog((Bundle)Platform.getBundle((String)PLUGIN_ID)).log(J2EEUIPlugin.createStatus(4, exception.getMessage(), exception));
    }

    public static void logError(CoreException exception) {
        Platform.getLog((Bundle)Platform.getBundle((String)PLUGIN_ID)).log(exception.getStatus());
    }

    public static void logError(String message, Throwable exception) {
        Platform.getLog((Bundle)Platform.getBundle((String)PLUGIN_ID)).log(J2EEUIPlugin.createStatus(4, message, exception));
    }

    public static void logError(String message, CoreException exception) {
        MultiStatus status = new MultiStatus(PLUGIN_ID, 4, new IStatus[]{exception.getStatus()}, message, (Throwable)exception);
        Platform.getLog((Bundle)Platform.getBundle((String)PLUGIN_ID)).log((IStatus)status);
    }

    public static void logWarning(String message) {
        Platform.getLog((Bundle)Platform.getBundle((String)PLUGIN_ID)).log(J2EEUIPlugin.createStatus(2, message));
    }
}

